/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.jaxws.san.ep;

import com.cisco.dcbu.jaxws.ep.ObjectNotFoundException;
import com.cisco.dcbu.jaxws.san.ep.StorageSEI;
import com.cisco.dcbu.jaxws.san.wo.CallResultDO;
import com.cisco.dcbu.jaxws.san.wo.SMISComponentDO;
import com.cisco.dcbu.jaxws.san.wo.SMISDiskDO;
import com.cisco.dcbu.jaxws.san.wo.SMISDiskLunMappingDO;
import com.cisco.dcbu.jaxws.san.wo.SMISDiskPoolMappingDO;
import com.cisco.dcbu.jaxws.san.wo.SMISDiskRowDO;
import com.cisco.dcbu.jaxws.san.wo.SMISFilerVolumeDO;
import com.cisco.dcbu.jaxws.san.wo.SMISHostDO;
import com.cisco.dcbu.jaxws.san.wo.SMISHostLunMappingDO;
import com.cisco.dcbu.jaxws.san.wo.SMISHostPortDO;
import com.cisco.dcbu.jaxws.san.wo.SMISLunDO;
import com.cisco.dcbu.jaxws.san.wo.SMISNavItemDO;
import com.cisco.dcbu.jaxws.san.wo.SMISPoolDO;
import com.cisco.dcbu.jaxws.san.wo.SMISPoolListDO;
import com.cisco.dcbu.jaxws.san.wo.SMISPortDO;
import com.cisco.dcbu.jaxws.san.wo.SMISProcessorDO;
import com.cisco.dcbu.jaxws.san.wo.SMISProviderDO;
import com.cisco.dcbu.jaxws.san.wo.SMISProviderListDO;
import com.cisco.dcbu.jaxws.san.wo.SMISSystemNavDO;
import com.cisco.dcbu.jaxws.wo.CapacitySmisDO;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.sm.common.type.ProviderPK;
import com.cisco.dcbu.sm.server.db.ClusterMapping;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.licmgr.FileLicensingHelper;
import com.cisco.dcbu.sm.server.model.EndPortImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.web.dashboard.CapacityMgrHandler;
import com.cisco.dcbu.storage.db.ComponentSystemHelper;
import com.cisco.dcbu.storage.db.DiskHelper;
import com.cisco.dcbu.storage.db.DiskLunMapHelper;
import com.cisco.dcbu.storage.db.DiskPoolMapHelper;
import com.cisco.dcbu.storage.db.FilerVolumeHelper;
import com.cisco.dcbu.storage.db.HostHelper;
import com.cisco.dcbu.storage.db.HostLunMapHelper;
import com.cisco.dcbu.storage.db.HostPortHelper;
import com.cisco.dcbu.storage.db.LunHelper;
import com.cisco.dcbu.storage.db.PoolHelper;
import com.cisco.dcbu.storage.db.ProviderHelper;
import com.cisco.dcbu.storage.db.SMISHandler;
import com.cisco.dcbu.storage.db.SMISHelper;
import com.cisco.dcbu.storage.db.StoragePortHelper;
import com.cisco.dcbu.storage.db.StorageProcessorHelper;
import com.cisco.dcbu.storage.db.StorageSystemHelper;
import com.cisco.dcbu.storage.discovery.SSLHandler;
import com.cisco.dcbu.storage.discovery.StorageImpl;
import com.cisco.dcbu.storage.model.Provider;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import javax.annotation.Resource;
import javax.ejb.Stateless;
import javax.jws.HandlerChain;
import javax.jws.WebMethod;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.ws.WebServiceContext;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jboss.ws.api.annotation.EndpointConfig;
import org.jboss.ws.api.annotation.WebContext;

@SOAPBinding(style=SOAPBinding.Style.RPC, use=SOAPBinding.Use.LITERAL)
@HandlerChain(file="../../ep/fms-jaxws-handlers.xml")
@WebContext(contextRoot="/StorageWSService", urlPattern="/StorageWS")
@EndpointConfig(configName="Standard WSSecurity Endpoint")
@WebService(name="Storage", serviceName="StorageService", endpointInterface="com.cisco.dcbu.jaxws.san.ep.StorageSEI")
@Stateless
public class StorageWS
implements StorageSEI {
    static Logger logger = LogManager.getLogger((String)"fms.ws");
    @Resource
    private WebServiceContext context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WebMethod(operationName="getSmisProviders")
    @WebResult(name="result", partName="result")
    public SMISProviderListDO getSmisProviders() {
        SMISProviderDO[] alist = null;
        Connection con = null;
        logger.info((Object)"getSmisProviders - req");
        try {
            con = ConnectionManager.getConnection();
            alist = ProviderHelper.getList(con);
        }
        catch (SQLException e) {
        }
        finally {
            DbUtil.close(con);
        }
        for (SMISProviderDO prov : alist) {
            try {
                String serverIp = ClusterMapping.getInstance().qIPStrfromFID(prov.getProvId());
                prov.setFmServer(serverIp);
            }
            catch (UnknownHostException e) {
                prov.setStatus("Unknown");
            }
            catch (SQLException e) {
                prov.setStatus("Unknown");
            }
        }
        SMISProviderListDO res = new SMISProviderListDO();
        res.setProviderList(alist);
        return res;
    }

    @Override
    @WebMethod(operationName="getWorkerStatus")
    @WebResult(name="result", partName="result")
    public CallResultDO getWorkerStatus(SMISProviderDO provider, String fmServer) {
        CallResultDO res = new CallResultDO(-1, "Unknown");
        Provider obj = new Provider(new ProviderPK(provider.getProvId()), provider.getNs(), provider.getInteropns(), provider.getUrl(), provider.getUsername(), "", provider.getPort(), provider.isSecure(), provider.getVendor());
        obj.setDBID(provider.getDbId());
        StorageImpl impl = SMISHandler.getInstance().getStorageImplForProvider(obj);
        if (impl != null && impl.getWorker() != null) {
            res.setResultMessage(impl.getWorker().getStatusDescr());
            res.setResultStatus(0);
        } else {
            res.setResultMessage("Offline");
            res.setResultStatus(-1);
        }
        logger.debug((Object)("getWorkerStatus - " + provider.getUrl() + " status " + res.getResultMessage()));
        return res;
    }

    @Override
    @WebMethod(operationName="demandDiscoverProvider")
    @WebResult(name="result", partName="result")
    public CallResultDO demandDiscoverSmisProvider(SMISProviderDO provider, String fmServer) {
        Provider obj = new Provider(new ProviderPK(provider.getProvId()), provider.getNs(), provider.getInteropns(), provider.getUrl(), provider.getUsername(), "", provider.getPort(), provider.isSecure(), provider.getVendor());
        obj.setDBID(provider.getDbId());
        CallResultDO res = SMISHandler.getInstance().demandDiscoverProvider(obj);
        return res;
    }

    @Override
    @WebMethod(operationName="secureCheckSmisProvider")
    @WebResult(name="result", partName="result")
    public CallResultDO secureCheckSmisProvider(SMISProviderDO provider, String password, String fmServer) {
        CallResultDO check = SSLHandler.getInstance().check(provider.getUrl(), provider.getPort());
        return check;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WebMethod(operationName="addSmisProvider")
    @WebResult(name="result", partName="result")
    public CallResultDO addSmisProvider(SMISProviderDO provider, String password, String fmServer) {
        FabricImpl[] fabrics;
        Connection con = null;
        CallResultDO res = new CallResultDO();
        logger.info((Object)"addSmisProvider - req ");
        if (provider.isSecure() && (res = SSLHandler.getInstance().check(provider.getUrl(), provider.getPort())).getResultStatus() != 0) {
            return res;
        }
        boolean licenseFound = FileLicensingHelper.getInstance().hasAtLeastOneLicenseFileInstalled();
        if (!licenseFound && (fabrics = SanManager.getInstance().getFabrics()) != null) {
            for (int i = 0; i < fabrics.length; ++i) {
                if (fabrics[i] == null || !fabrics[i].isLicensed()) continue;
                licenseFound = true;
                break;
            }
        }
        if (!licenseFound) {
            res.setResultStatus(-1);
            res.setResultMessage("You must have at least one valid license to use SMI-S discovery.");
            return res;
        }
        Provider obj = new Provider(new ProviderPK(provider.getProvId()), provider.getNs(), provider.getInteropns(), provider.getUrl(), provider.getUsername(), password, provider.getPort(), provider.isSecure(), provider.getVendor());
        try {
            con = ConnectionManager.getConnection();
            res = SMISHandler.getInstance().addProvider(con, obj);
        }
        catch (SQLException e) {
            logger.error((Object)"SQL Exception", (Throwable)e);
            res.setResultStatus(-1);
            res.setResultMessage(e.getMessage());
        }
        finally {
            if (con != null) {
                DbUtil.close(con);
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WebMethod(operationName="updateSmisProvider")
    @WebResult(name="result", partName="result")
    public CallResultDO updateSmisProvider(SMISProviderDO provider, String password, String fmServer) {
        Connection con = null;
        CallResultDO res = new CallResultDO();
        logger.info((Object)"updateSmisProvider - req");
        Provider obj = new Provider(new ProviderPK(provider.getProvId()), provider.getNs(), provider.getInteropns(), provider.getUrl(), provider.getUsername(), password, provider.getPort(), provider.isSecure(), provider.getVendor());
        obj.setDBID(provider.getDbId());
        try {
            con = ConnectionManager.getConnection();
            res = SMISHandler.getInstance().updateProvider(con, obj, fmServer);
        }
        catch (SQLException e) {
            logger.error((Object)"SQL Exception", (Throwable)e);
            res.setResultStatus(-1);
            res.setResultMessage(e.getMessage());
        }
        finally {
            if (con != null) {
                DbUtil.close(con);
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WebMethod(operationName="removeSmisProvider")
    @WebResult(name="result", partName="result")
    public CallResultDO removeSmisProvider(SMISProviderDO provider, String fmServer) {
        Connection con = null;
        CallResultDO res = new CallResultDO();
        logger.info((Object)"removeSmisProvider - req");
        Provider obj = new Provider(new ProviderPK(provider.getProvId()), provider.getNs(), provider.getInteropns(), provider.getUrl(), provider.getUsername(), "blank", provider.getPort(), provider.isSecure(), provider.getVendor());
        obj.setDBID(provider.getDbId());
        try {
            con = ConnectionManager.getConnection();
            res = SMISHandler.getInstance().removeProvider(con, obj);
        }
        catch (SQLException e) {
            logger.error((Object)"SQL Exception", (Throwable)e);
            res.setResultStatus(-1);
            res.setResultMessage(e.getMessage());
        }
        finally {
            if (con != null) {
                DbUtil.close(con);
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WebMethod(operationName="cleanupSmisProvider")
    @WebResult(name="result", partName="result")
    public CallResultDO cleanupSmisProvider(SMISProviderDO provider, String fmServer) {
        Connection con = null;
        CallResultDO res = new CallResultDO();
        logger.info((Object)"cleanupSmisProvider - req");
        Provider obj = new Provider(new ProviderPK(provider.getProvId()), provider.getNs(), provider.getInteropns(), provider.getUrl(), provider.getUsername(), "blank", provider.getPort(), provider.isSecure(), provider.getVendor());
        obj.setDBID(provider.getDbId());
        try {
            con = ConnectionManager.getConnection();
            res = SMISHandler.getInstance().cleanupProvider(con, obj);
        }
        catch (SQLException e) {
            logger.error((Object)"SQL Exception", (Throwable)e);
            res.setResultStatus(-1);
            res.setResultMessage(e.getMessage());
        }
        finally {
            if (con != null) {
                DbUtil.close(con);
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WebMethod(operationName="getStorageSystemNav")
    @WebResult(name="result", partName="result")
    public SMISSystemNavDO getStorageSystemNav(String navType, long dbid) {
        SMISSystemNavDO sysNav = new SMISSystemNavDO();
        boolean isLicensed = FileLicensingHelper.getInstance().areAllFabricsLicensed();
        sysNav.setLicensed(isLicensed);
        if (navType == null) {
            navType = "NONE";
        }
        sysNav.setNavType(navType);
        Connection con = null;
        try {
            con = ConnectionManager.getConnection();
            SMISNavItemDO[] sysList = SMISHandler.getInstance().getStorageSystemList(con);
            sysNav.setSystemList(sysList);
            if (dbid == 0L && sysList != null && sysList.length > 0) {
                dbid = sysList[0].getDbid();
            }
            sysNav.setSystem(SMISHandler.getInstance().getStorageSystemSummary(con, dbid));
            sysNav.setNavList(SMISHandler.getInstance().getStorageSystemNav(con, navType, dbid));
        }
        catch (SQLException e) {
            logger.error((Object)"SQL Exception", (Throwable)e);
        }
        finally {
            if (con != null) {
                DbUtil.close(con);
            }
        }
        sysNav.setServerTimeNow(System.currentTimeMillis());
        return sysNav;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WebMethod(operationName="getStorageSystemElement")
    @WebResult(name="result", partName="result")
    public SMISSystemNavDO getStorageSystemElement(String navType, long dbid) {
        SMISSystemNavDO sysNav = new SMISSystemNavDO();
        boolean isLicensed = FileLicensingHelper.getInstance().areAllFabricsLicensed();
        sysNav.setLicensed(isLicensed);
        if (navType == null) {
            navType = "NONE";
        }
        sysNav.setNavType(navType);
        Connection con = null;
        try {
            con = ConnectionManager.getConnection();
            SMISNavItemDO[] sysList = SMISHandler.getInstance().getStorageSystemList(con);
            sysNav.setSystemList(sysList);
            if (dbid == 0L && sysList != null && sysList.length > 0) {
                dbid = sysList[0].getDbid();
            }
            sysNav.setNavList(SMISHandler.getInstance().getStorageSystemNav(con, navType, dbid));
        }
        catch (SQLException e) {
            logger.error((Object)"SQL Exception", (Throwable)e);
        }
        finally {
            if (con != null) {
                DbUtil.close(con);
            }
        }
        logger.info((Object)("getStorageSystemElement - returning list of " + sysNav.getNavList().length));
        sysNav.setServerTimeNow(System.currentTimeMillis());
        return sysNav;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WebMethod(operationName="getComponent")
    @WebResult(name="result", partName="result")
    public SMISComponentDO getComponent(long systemDbId, long dbid) throws ObjectNotFoundException {
        Connection con = null;
        SMISComponentDO obj = null;
        try {
            con = ConnectionManager.getConnection();
            Timestamp systemTime = StorageSystemHelper.getTime(con, systemDbId);
            obj = ComponentSystemHelper.get(con, dbid, systemTime);
            if (obj != null) {
                obj.setDiskList(DiskHelper.getDiskList(con, dbid, systemTime));
            }
        }
        catch (SQLException e) {
            logger.error((Object)"SQL Exception", (Throwable)e);
        }
        finally {
            if (con != null) {
                DbUtil.close(con);
            }
        }
        if (obj == null) {
            logger.warn((Object)("Cannot get component by dbid: " + dbid + " for systemDbId: " + systemDbId));
            throw new ObjectNotFoundException("Component lookup failed.");
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WebMethod(operationName="getDisk")
    @WebResult(name="result", partName="result")
    public SMISDiskDO getDisk(long systemDbId, long dbid) throws ObjectNotFoundException {
        Connection con = null;
        SMISDiskDO obj = null;
        try {
            con = ConnectionManager.getConnection();
            Timestamp systemTime = StorageSystemHelper.getTime(con, systemDbId);
            obj = DiskHelper.get(con, dbid, systemTime);
            if (obj != null) {
                ArrayList<SMISDiskLunMappingDO> mapList = DiskLunMapHelper.getListByDisk(con, systemDbId, dbid, systemTime);
                SMISDiskPoolMappingDO[] poolList = DiskPoolMapHelper.getListByDisk(con, systemDbId, dbid, systemTime);
                if (poolList != null) {
                    for (SMISDiskPoolMappingDO pool : poolList) {
                        boolean marked = false;
                        for (SMISDiskLunMappingDO map : mapList) {
                            if (!SMISHelper.equals(pool.getPoolName(), map.getPoolName())) continue;
                            map.setPoolDbId(pool.getPoolDbId());
                            marked = true;
                        }
                        if (marked) continue;
                        SMISDiskLunMappingDO poolOnly = new SMISDiskLunMappingDO();
                        poolOnly.setLastSeen(pool.getLastSeen());
                        poolOnly.setPoolDbId(pool.getPoolDbId());
                        poolOnly.setPoolName(pool.getPoolName());
                        poolOnly.setPresent(pool.isPresent());
                        mapList.add(poolOnly);
                    }
                    obj.setLunList(mapList.toArray(new SMISDiskLunMappingDO[0]));
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)"SQL Exception", (Throwable)e);
        }
        finally {
            if (con != null) {
                DbUtil.close(con);
            }
        }
        if (obj == null) {
            logger.error((Object)("Cannot get disk by dbid: " + dbid + " for systemDbId: " + systemDbId));
            throw new ObjectNotFoundException("Disk lookup failed.");
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WebMethod(operationName="getLun")
    @WebResult(name="result", partName="result")
    public SMISLunDO getLun(long systemDbId, long dbid) throws ObjectNotFoundException {
        Connection con = null;
        SMISLunDO obj = null;
        try {
            con = ConnectionManager.getConnection();
            Timestamp systemTime = StorageSystemHelper.getTime(con, systemDbId);
            obj = LunHelper.get(con, dbid, systemTime);
            if (obj != null) {
                SMISHostLunMappingDO[] hlm = HostLunMapHelper.getListByLun(con, systemDbId, dbid, systemTime);
                obj.setHostLunMappingList(hlm);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"SQL Exception", (Throwable)e);
        }
        finally {
            if (con != null) {
                DbUtil.close(con);
            }
        }
        if (obj == null) {
            logger.error((Object)("Cannot get Lun by dbid: " + dbid + " for systemDbId: " + systemDbId));
            throw new ObjectNotFoundException("Lun lookup failed.");
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WebMethod(operationName="getHost")
    @WebResult(name="result", partName="result")
    public SMISHostDO getHost(long systemDbId, long dbid) throws ObjectNotFoundException {
        SMISHostDO obj;
        block11: {
            Connection con = null;
            obj = null;
            try {
                boolean isLicensed;
                con = ConnectionManager.getConnection();
                Timestamp systemTime = StorageSystemHelper.getTime(con, systemDbId);
                obj = HostHelper.get(con, dbid, systemTime);
                if (obj == null) break block11;
                SMISHostLunMappingDO[] hlmList = HostLunMapHelper.getListByHost(con, systemDbId, dbid, systemTime);
                obj.setHostLunMappingList(hlmList);
                SMISHostPortDO[] hostPortList = HostPortHelper.getList(con, systemDbId, dbid, systemTime);
                if (hostPortList != null && (isLicensed = FileLicensingHelper.getInstance().areAllFabricsLicensed())) {
                    for (SMISHostPortDO hp : hostPortList) {
                        EndPortImpl hImpl;
                        Wwn hwwn = null;
                        try {
                            hwwn = new Wwn(hp.getHostWwn());
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                        if (hwwn == null || (hImpl = SanManager.getInstance().findEndPort(hwwn)) == null || hImpl.getFabricPK() == null) continue;
                        hp.setFabric(hImpl.getFabricPK().getName());
                        hp.setHostInterface(hImpl.getSwitch().getName() + "-" + hImpl.getIfName());
                        hp.setHostSwitchDbId(hImpl.getSwitch().getDBID());
                        if (hImpl.getEnclosure() == null) continue;
                        hp.setHostEnclosureDbId(hImpl.getEnclosure().getDBID());
                        hp.setHostName(hImpl.getEnclosure().getEnclosureName());
                    }
                }
                obj.setPortList(hostPortList);
            }
            catch (SQLException e) {
                logger.error((Object)"SQL Exception", (Throwable)e);
            }
            finally {
                if (con != null) {
                    DbUtil.close(con);
                }
            }
        }
        if (obj == null) {
            logger.error((Object)("Cannot get Host by dbid:" + dbid));
            throw new ObjectNotFoundException("Host lookup failed.");
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WebMethod(operationName="getFilerVolume")
    @WebResult(name="result", partName="result")
    public SMISFilerVolumeDO getFilerVolume(long systemDbId, long dbid) throws ObjectNotFoundException {
        Connection con = null;
        SMISFilerVolumeDO obj = null;
        try {
            con = ConnectionManager.getConnection();
            Timestamp systemTime = StorageSystemHelper.getTime(con, systemDbId);
            obj = FilerVolumeHelper.get(con, dbid, systemTime);
        }
        catch (SQLException e) {
            logger.error((Object)"SQL Exception", (Throwable)e);
        }
        finally {
            if (con != null) {
                DbUtil.close(con);
            }
        }
        if (obj == null) {
            logger.error((Object)("Cannot get FilerVolume by dbid: " + dbid + " for systemDbId: " + systemDbId));
            throw new ObjectNotFoundException("Filer Volume lookup failed.");
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WebMethod(operationName="getPool")
    @WebResult(name="result", partName="result")
    public SMISPoolDO getPool(long systemDbId, long dbid) throws ObjectNotFoundException {
        Connection con = null;
        SMISPoolDO obj = null;
        try {
            con = ConnectionManager.getConnection();
            Timestamp systemTime = StorageSystemHelper.getTime(con, systemDbId);
            obj = PoolHelper.get(con, dbid, systemTime);
            if (obj != null) {
                SMISLunDO[] lunList = LunHelper.getListByPool(con, systemDbId, obj.getName(), systemTime);
                obj.setLunList(lunList);
                SMISDiskRowDO[] diskList = DiskHelper.getDiskListByPool(con, systemDbId, obj.getDbId(), systemTime);
                obj.setDiskList(diskList);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"SQL Exception", (Throwable)e);
        }
        finally {
            if (con != null) {
                DbUtil.close(con);
            }
        }
        if (obj == null) {
            logger.error((Object)("Cannot get Pool by dbid:" + dbid + " for systemDbId: " + systemDbId));
            throw new ObjectNotFoundException("Pool Lookup Failed.");
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WebMethod(operationName="getPoolList")
    @WebResult(name="result", partName="result")
    public SMISPoolListDO getPoolList(long systemDbId) {
        Connection con = null;
        SMISPoolListDO obj = new SMISPoolListDO();
        try {
            con = ConnectionManager.getConnection();
            Timestamp systemTime = StorageSystemHelper.getTime(con, systemDbId);
            obj.setpoolList(PoolHelper.getList(con, systemDbId, systemTime));
        }
        catch (SQLException e) {
            logger.error((Object)"SQL Exception", (Throwable)e);
        }
        finally {
            if (con != null) {
                DbUtil.close(con);
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WebMethod(operationName="getProcessor")
    @WebResult(name="result", partName="result")
    public SMISProcessorDO getProcessor(long systemDbId, long dbid) throws ObjectNotFoundException {
        Connection con = null;
        SMISProcessorDO obj = null;
        try {
            con = ConnectionManager.getConnection();
            Timestamp systemTime = StorageSystemHelper.getTime(con, systemDbId);
            obj = StorageProcessorHelper.get(con, dbid, systemTime);
            if (obj != null) {
                obj.setPortList(StoragePortHelper.getListByProcessor(con, systemDbId, dbid, systemTime));
            }
        }
        catch (SQLException e) {
            logger.error((Object)"SQL Exception", (Throwable)e);
        }
        finally {
            if (con != null) {
                DbUtil.close(con);
            }
        }
        if (obj == null) {
            logger.error((Object)("Cannot get processor by dbid: " + dbid + " for systemDbId: " + systemDbId));
            throw new ObjectNotFoundException("Processor lookup failed.");
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WebMethod(operationName="getPort")
    @WebResult(name="result", partName="result")
    public SMISPortDO getPort(long systemDbId, long dbid) throws ObjectNotFoundException {
        Connection con = null;
        SMISPortDO obj = null;
        try {
            con = ConnectionManager.getConnection();
            Timestamp systemTime = StorageSystemHelper.getTime(con, systemDbId);
            obj = StoragePortHelper.get(con, dbid, systemTime);
            if (obj != null && obj.getNetworkAddress() != null && obj.getNetworkAddress().length() > 0) {
                SMISHostLunMappingDO[] hostLunMappingList = HostLunMapHelper.getListByStoragePort(con, systemDbId, obj.getPermAddress(), systemTime);
                obj.setHostLunMappingList(hostLunMappingList);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"SQL Exception", (Throwable)e);
        }
        finally {
            if (con != null) {
                DbUtil.close(con);
            }
        }
        if (obj == null) {
            logger.error((Object)("Cannot get port by dbid: " + dbid + " for systemDbId: " + systemDbId));
            throw new ObjectNotFoundException("Port lookup failed.");
        }
        return obj;
    }

    @Override
    @WebMethod(operationName="getCapacitySmisById")
    @WebResult(name="result", partName="result")
    public CapacitySmisDO[] getCapacitySmisById(long dbId, int type) {
        ArrayList<CapacitySmisDO> capstats = CapacityMgrHandler.getInstance().getCapacitySmisById(dbId, type);
        CapacitySmisDO[] result = capstats.size() != 0 ? capstats.toArray(new CapacitySmisDO[capstats.size()]) : new CapacitySmisDO[]{};
        return result;
    }
}

