/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.jaxws.san.ep;

import com.cisco.dcbu.jaxws.ep.InvalidArgumentException;
import com.cisco.dcbu.jaxws.ep.SanServiceException;
import com.cisco.dcbu.jaxws.san.ep.WebZoneManagerSEI;
import com.cisco.dcbu.jaxws.san.ep.ZoneManagerWSBase;
import com.cisco.dcbu.jaxws.san.wo.AliasDO;
import com.cisco.dcbu.jaxws.san.wo.OperationStatusDO;
import com.cisco.dcbu.jaxws.san.wo.WwnDO;
import com.cisco.dcbu.jaxws.san.wo.ZoneDO;
import com.cisco.dcbu.jaxws.san.wo.ZoneMemberDO;
import com.cisco.dcbu.jaxws.san.wo.ZoneSetDO;
import com.cisco.dcbu.jaxws.san.wo.zone.WebConfEndDeviceDO;
import com.cisco.dcbu.jaxws.san.wo.zone.WebConfSwitchZoneModeDO;
import com.cisco.dcbu.jaxws.san.wo.zone.WebConfZnZoneMemberDO;
import com.cisco.dcbu.jaxws.san.wo.zone.WebZnEnclosureDO;
import com.cisco.dcbu.jaxws.san.wo.zone.WebZnEndPortDataDO;
import com.cisco.dcbu.jaxws.san.wo.zone.WebZnHstPortStgPortListDO;
import com.cisco.dcbu.jaxws.san.wo.zone.WebZnSwitchDO;
import com.cisco.dcbu.jaxws.san.wo.zone.WebZnVsanDO;
import com.cisco.dcbu.jaxws.san.wo.zone.WebZnVsancliDO;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.mds.zm.Zone;
import com.cisco.dcbu.lib.mds.zm.ZoneAlias;
import com.cisco.dcbu.lib.mds.zm.ZoneMember;
import com.cisco.dcbu.lib.mds.zm.ZoneSet;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.sm.common.rif.WebZoneRif;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.facade.WebZoneManagerImpl;
import com.cisco.dcbu.sm.server.zone.PolicyBasedZoning;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.ejb.Stateless;
import javax.jws.HandlerChain;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jboss.ws.api.annotation.WebContext;

@SOAPBinding(style=SOAPBinding.Style.RPC, use=SOAPBinding.Use.LITERAL)
@HandlerChain(file="../../ep/fms-jaxws-handlers.xml")
@WebContext(contextRoot="/WebZoneManagerWSService", urlPattern="/WebZoneManagerWS")
@WebService(name="WebZoneManager", serviceName="WebZoneManagerService", endpointInterface="com.cisco.dcbu.jaxws.san.ep.WebZoneManagerSEI")
@Stateless
public class WebZoneManagerWS
extends ZoneManagerWSBase
implements WebZoneManagerSEI {
    static Logger _Logger = LogManager.getLogger((String)"fms.ws");
    static String vsanFabQuery = "select v.id, v.name, v.vsan_id, v.PRINCIPAL_SW_ID,v.is_up,v.ENF_ZONESET_NAME,v.ENF_ZONESET_ACTIVATE_TIME ,sw.sys_name, v.is_disjoint FROM VSAN v, SWITCH sw WHERE sw.id=v.PRINCIPAL_SW_ID AND v.fabric_id=? ORDER BY v.vsan_id";
    static String switchForVsan = "select DISTINCT sw.id, sw.sys_name, sw.is_managable, sw.is_mds, sw.ip_address, sw.wwn FROM  vsan_domain_info vd, switch sw where vd.vsan_id=? AND sw.id=vd.switch_id ORDER BY sw.sys_name";

    @Override
    @WebMethod(operationName="createEmptyDataCahe")
    @WebResult(name="result", partName="result")
    public int createEmptyDataCahe(@WebParam(name="fabricDBID", partName="fabricDBID") long fabricDBID, @WebParam(name="vsanId", partName="vsanId") int vsanId, @WebParam(name="switchWWN", partName="switchWWN") String switchWWN) throws SanServiceException {
        int dbKey = -1;
        try {
            WebZoneRif rif = WebZoneManagerImpl.getRemoteWebZoneRif(fabricDBID);
            dbKey = rif.createEmptyCache(switchWWN, vsanId);
        }
        catch (Exception ex) {
            _Logger.error((Object)ex.getMessage());
            throw new SanServiceException(ex.getMessage());
        }
        return dbKey;
    }

    @Override
    @WebMethod(operationName="clearCacheKey")
    @WebResult(name="result", partName="result")
    public void clearCacheKey(@WebParam(name="cacheKey", partName="cacheKey") int cacheKey, @WebParam(name="fabricDBID", partName="fabricDBID") long fabricDBID) throws SanServiceException {
        try {
            WebZoneRif rif = WebZoneManagerImpl.getRemoteWebZoneRif(fabricDBID);
            rif.removeCachedObject(cacheKey);
        }
        catch (Exception ex) {
            _Logger.error((Object)ex.getMessage());
            throw new SanServiceException(ex.getMessage());
        }
    }

    @Override
    @WebMethod(operationName="showAllCache")
    @WebResult(name="result", partName="result")
    public OperationStatusDO showAllCache(@WebParam(name="fabricDBID", partName="fabricDBID") long fabricDBID) throws SanServiceException {
        OperationStatusDO retV = new OperationStatusDO();
        try {
            WebZoneRif rif = WebZoneManagerImpl.getRemoteWebZoneRif(fabricDBID);
            retV.setStatus(true);
            retV.setDescription(rif.showAllCache());
        }
        catch (Exception ex) {
            _Logger.error((Object)ex.getMessage());
            retV.setStatus(true);
            retV.setStatus(false);
            retV.setDescription(ex.getMessage());
        }
        return retV;
    }

    @Override
    @WebMethod(operationName="isLocalActiveZonesetModified")
    @WebResult(name="result", partName="result")
    public Object[] isLocalActiveZonesetModified(@WebParam(name="cacheKey", partName="cacheKey") int cacheKey, @WebParam(name="fabricDBID", partName="fabricDBID") long fabricDBID) throws SanServiceException {
        OperationStatusDO retV = new OperationStatusDO();
        boolean isMod = false;
        try {
            WebZoneRif rif = WebZoneManagerImpl.getRemoteWebZoneRif(fabricDBID);
            isMod = rif.isLocalActiveZonesetModified(cacheKey);
        }
        catch (Exception ex) {
            _Logger.error((Object)ex.getMessage());
            retV.setStatus(false);
            retV.setDescription(ex.getMessage());
        }
        return new Object[]{retV, isMod};
    }

    @WebMethod(operationName="populateZoneDB")
    @WebResult(name="result", partName="result")
    public Object[] populateZoneDB(@WebParam(name="cacheKey", partName="cacheKey") int cacheKey, @WebParam(name="fabricDBID", partName="fabricDBID") long fabricDBID, @WebParam(name="vsanId", partName="vsanId") int vsanId, @WebParam(name="switchWWN", partName="switchWWN") String switchWWN) throws SanServiceException {
        OperationStatusDO retV = new OperationStatusDO();
        int dbKey = -1;
        try {
            WebZoneRif rif = WebZoneManagerImpl.getRemoteWebZoneRif(fabricDBID);
            dbKey = rif.populateZoneSetData(cacheKey, switchWWN, vsanId);
            rif.populateZoneData(dbKey, switchWWN, vsanId);
            rif.populatefcAliasData(dbKey, switchWWN, vsanId);
            rif.refreshZoningMode(dbKey);
            retV.setStatus(true);
        }
        catch (Exception ex) {
            _Logger.error((Object)ex.getMessage());
            retV.setStatus(false);
            retV.setDescription(ex.getMessage());
        }
        return new Object[]{retV, dbKey};
    }

    @Override
    @WebMethod(operationName="populateZoneSets")
    @WebResult(name="result", partName="result")
    public Object[] populateZoneSets(@WebParam(name="cacheKey", partName="cacheKey") int cacheKey, @WebParam(name="fabricDBID", partName="fabricDBID") long fabricDBID, @WebParam(name="vsanId", partName="vsanId") int vsanId, @WebParam(name="switchWWN", partName="switchWWN") String switchWWN) throws SanServiceException {
        OperationStatusDO retV = new OperationStatusDO();
        int dbKey = -1;
        try {
            WebZoneRif rif = WebZoneManagerImpl.getRemoteWebZoneRif(fabricDBID);
            dbKey = rif.populateZoneSetData(cacheKey, switchWWN, vsanId);
            retV.setStatus(true);
            retV.setAdditionalState(rif.isLocalActiveZonesetModified(cacheKey) ? 1 : 2);
        }
        catch (Exception ex) {
            _Logger.error((Object)ex.getMessage());
            retV.setStatus(false);
            retV.setDescription(ex.getMessage());
        }
        return new Object[]{retV, dbKey};
    }

    @Override
    @WebMethod(operationName="populateZones")
    @WebResult(name="result", partName="result")
    public Object[] populateZones(@WebParam(name="cacheKey", partName="cacheKey") int cacheKey, @WebParam(name="fabricDBID", partName="fabricDBID") long fabricDBID, @WebParam(name="vsanId", partName="vsanId") int vsanId, @WebParam(name="switchWWN", partName="switchWWN") String switchWWN) throws SanServiceException {
        OperationStatusDO retV = new OperationStatusDO();
        int dbKey = -1;
        try {
            WebZoneRif rif = WebZoneManagerImpl.getRemoteWebZoneRif(fabricDBID);
            dbKey = rif.populateZoneData(cacheKey, switchWWN, vsanId);
            retV.setStatus(true);
        }
        catch (Exception ex) {
            _Logger.error((Object)ex.getMessage());
            retV.setStatus(false);
            retV.setDescription(ex.getMessage());
        }
        return new Object[]{retV, dbKey};
    }

    @Override
    @WebMethod(operationName="populateFcAliases")
    @WebResult(name="result", partName="result")
    public Object[] populateFcAliases(@WebParam(name="cacheKey", partName="cacheKey") int cacheKey, @WebParam(name="fabricDBID", partName="fabricDBID") long fabricDBID, @WebParam(name="vsanId", partName="vsanId") int vsanId, @WebParam(name="switchWWN", partName="switchWWN") String switchWWN) throws SanServiceException {
        OperationStatusDO retV = new OperationStatusDO();
        int dbKey = -1;
        try {
            WebZoneRif rif = WebZoneManagerImpl.getRemoteWebZoneRif(fabricDBID);
            dbKey = rif.populatefcAliasData(cacheKey, switchWWN, vsanId);
            retV.setStatus(true);
        }
        catch (Exception ex) {
            _Logger.error((Object)ex.getMessage());
            retV.setStatus(false);
            retV.setDescription(ex.getMessage());
        }
        return new Object[]{retV, dbKey};
    }

    @Override
    @WebMethod(operationName="updateZoneMode")
    @WebResult(name="result", partName="result")
    public Object[] updateZoneMode(@WebParam(name="cacheKey", partName="cacheKey") int cacheKey, @WebParam(name="fabricDBID", partName="fabricDBID") long fabricDBID) throws SanServiceException {
        OperationStatusDO retV = new OperationStatusDO();
        WebConfSwitchZoneModeDO mode = new WebConfSwitchZoneModeDO();
        try {
            WebZoneRif rif = WebZoneManagerImpl.getRemoteWebZoneRif(fabricDBID);
            mode = rif.refreshZoningMode(cacheKey);
            retV.setStatus(true);
            retV.setDescription("");
        }
        catch (Exception ex) {
            _Logger.error((Object)ex.getMessage());
            retV.setStatus(false);
            retV.setDescription(ex.getMessage());
        }
        return new Object[]{retV, mode};
    }

    @Override
    @WebMethod(operationName="getZoneMode")
    @WebResult(name="result", partName="result")
    public WebConfSwitchZoneModeDO getZoneMode(@WebParam(name="cacheKey", partName="cacheKey") int cacheKey, @WebParam(name="fabricDBID", partName="fabricDBID") long fabricDBID) throws SanServiceException {
        OperationStatusDO retV = new OperationStatusDO();
        WebConfSwitchZoneModeDO mode = new WebConfSwitchZoneModeDO();
        try {
            WebZoneRif rif = WebZoneManagerImpl.getRemoteWebZoneRif(fabricDBID);
            mode = rif.refreshZoningMode(cacheKey);
            retV.setStatus(true);
            retV.setDescription("");
        }
        catch (Exception ex) {
            _Logger.error((Object)ex.getMessage());
            retV.setStatus(false);
            retV.setDescription(ex.getMessage());
        }
        return mode;
    }

    @Override
    @WebMethod(operationName="getVsans")
    @WebResult(name="result", partName="result")
    public WebZnVsanDO[] getVsans(@WebParam(name="fabricDBID", partName="fabricDBID") long fabricDBID) throws SanServiceException, InvalidArgumentException {
        Connection con = null;
        ResultSet rs = null;
        PreparedStatement stat = null;
        ArrayList<WebZnVsanDO> vDoLst = new ArrayList<WebZnVsanDO>();
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(vsanFabQuery);
            stat.setLong(1, fabricDBID);
            rs = stat.executeQuery();
            while (rs.next()) {
                WebZnVsanDO vDo = new WebZnVsanDO();
                vDo.DBID = rs.getLong(1);
                vDo.actZnst = rs.getString(6);
                vDo.name = rs.getString(2);
                vDo.vsanIndex = rs.getInt(3);
                vDo.principalSwDBID = rs.getLong(4);
                vDo.prinswName = rs.getString(8);
                vDo.isSegmented = rs.getBoolean(9);
                vDo.name = rs.getString(2) + (vDo.isSegmented ? "(segmented@" + vDo.prinswName + ")" : "");
                vDoLst.add(vDo);
            }
        }
        catch (SQLException e) {
            try {
                _Logger.warn((Object)"WebZoneManagerWS getVsans: caught exception", (Throwable)e);
                throw new SanServiceException(e.getMessage());
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return vDoLst.toArray(new WebZnVsanDO[vDoLst.size()]);
    }

    @Override
    @WebMethod(operationName="getSwitchesInVSAN")
    @WebResult(name="result", partName="result")
    public WebZnSwitchDO[] getSwitchesInVSAN(@WebParam(name="fabricDBID", partName="fabricDBID") long fabricDBID, @WebParam(name="vsanDBID", partName="vsanDBID") long vsanDBID) throws SanServiceException, InvalidArgumentException {
        Connection con = null;
        ResultSet rs = null;
        PreparedStatement stat = null;
        ArrayList<WebZnSwitchDO> vDoLst = new ArrayList<WebZnSwitchDO>();
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(switchForVsan);
            stat.setLong(1, vsanDBID);
            rs = stat.executeQuery();
            while (rs.next()) {
                WebZnSwitchDO vDo = new WebZnSwitchDO();
                vDo.DBID = rs.getLong(1);
                byte[] sWWN = rs.getBytes(6);
                vDo.swWWN = sWWN != null ? new Wwn(sWWN).toHexString(true) : "";
                vDo.sys_name = rs.getString(2);
                byte[] ipAdd = rs.getBytes(5);
                vDo.ipAddress = ipAdd != null ? new SnmpIpAddress(ipAdd).toString() : "";
                boolean isManageble = rs.getBoolean(3);
                boolean isMDS = rs.getBoolean(4);
                if (!isMDS || !isManageble) continue;
                vDoLst.add(vDo);
            }
        }
        catch (SQLException e) {
            try {
                _Logger.warn((Object)"WebZoneManagerWS getSwitchesInVSAN: caught exception", (Throwable)e);
                throw new SanServiceException(e.getMessage());
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return vDoLst.toArray(new WebZnSwitchDO[vDoLst.size()]);
    }

    @Override
    @WebMethod(operationName="getZoneSets")
    @WebResult(name="result", partName="result")
    public ZoneSetDO[] getZoneSets(@WebParam(name="cacheKey", partName="cacheKey") int cacheKey, @WebParam(name="fabricDBID", partName="fabricDBID") long fabricDBID) throws SanServiceException {
        Object[] zonesetDo = new ZoneSetDO[]{};
        try {
            WebZoneRif rif = WebZoneManagerImpl.getRemoteWebZoneRif(fabricDBID);
            ArrayList zonesets = rif.getZoneSets(cacheKey);
            if (zonesets != null && zonesets.size() > 0) {
                zonesetDo = new ZoneSetDO[zonesets.size()];
            }
            for (int i = 0; i < zonesets.size(); ++i) {
                ZoneSet zn = (ZoneSet)zonesets.get(i);
                ZoneSetDO znDo = new ZoneSetDO();
                znDo.setIndex(zn.getZoneIndex());
                znDo.setName(zn.getZoneName());
                znDo.setZoneLastModtime(zn.getLastModifiedAsLong());
                zonesetDo[i] = znDo;
            }
            if (zonesetDo.length > 1) {
                Arrays.sort(zonesetDo);
            }
        }
        catch (Exception ex) {
            _Logger.error((Object)ex.getMessage());
            throw new SanServiceException(ex.getMessage());
        }
        return zonesetDo;
    }

    @Override
    @WebMethod(operationName="getFCAliasesOfZone")
    @WebResult(name="result", partName="result")
    public AliasDO[] getFCAliasesOfZone(@WebParam(name="cacheKey", partName="cacheKey") int cacheKey, @WebParam(name="fabricDBID", partName="fabricDBID") long fabricDBID, @WebParam(name="fcaliasName", partName="fcaliasName") String fcaliasName) throws SanServiceException {
        AliasDO[] aliasDo = new AliasDO[]{};
        try {
            WebZoneRif rif = WebZoneManagerImpl.getRemoteWebZoneRif(fabricDBID);
            ArrayList aliases = rif.getFCAliasesOfZone(cacheKey, fabricDBID, fcaliasName);
            if (aliases != null && aliases.size() > 0) {
                aliasDo = new AliasDO[aliases.size()];
            }
            for (int i = 0; i < aliases.size(); ++i) {
                ZoneAlias zn = (ZoneAlias)aliases.get(i);
                AliasDO znDo = new AliasDO();
                znDo.setIndex(zn.getZoneIndex());
                znDo.setName(zn.getZoneName());
                znDo.setZoneLastModtime(zn.getLastModifiedAsLong());
                aliasDo[i] = znDo;
            }
        }
        catch (Exception ex) {
            _Logger.error((Object)ex.getMessage());
            throw new SanServiceException(ex.getMessage());
        }
        return aliasDo;
    }

    @Override
    @WebMethod(operationName="getMembersOfZone")
    @WebResult(name="result", partName="result")
    public WebConfZnZoneMemberDO[] getMembersOfZone(@WebParam(name="cacheKey", partName="cacheKey") int cacheKey, @WebParam(name="fabricDBID", partName="fabricDBID") long fabricDBID, @WebParam(name="zoneName", partName="zoneName") String zoneName) throws SanServiceException {
        try {
            WebZoneRif rif = WebZoneManagerImpl.getRemoteWebZoneRif(fabricDBID);
            ArrayList zonemems = rif.getMemberOfZone(cacheKey, fabricDBID, zoneName);
            return zonemems.toArray(new WebConfZnZoneMemberDO[zonemems.size()]);
        }
        catch (Exception ex) {
            _Logger.error((Object)ex.getMessage());
            throw new SanServiceException(ex.getMessage());
        }
    }

    @Override
    @WebMethod(operationName="getMembersOfFCAlias")
    @WebResult(name="result", partName="result")
    public WebConfZnZoneMemberDO[] getMembersOfFCAlias(@WebParam(name="cacheKey", partName="cacheKey") int cacheKey, @WebParam(name="fabricDBID", partName="fabricDBID") long fabricDBID, @WebParam(name="fcaliasName", partName="fcaliasName") String fcaliasName) throws SanServiceException {
        ArrayList zoneMemDoLst = new ArrayList();
        try {
            WebZoneRif rif = WebZoneManagerImpl.getRemoteWebZoneRif(fabricDBID);
            ArrayList zonemems = rif.getMemberOfFCAlias(cacheKey, fabricDBID, fcaliasName);
            return zonemems.toArray(new WebConfZnZoneMemberDO[zonemems.size()]);
        }
        catch (Exception ex) {
            _Logger.error((Object)ex.getMessage());
            throw new SanServiceException(ex.getMessage());
        }
    }

    private ArrayList buildZoneMemberDOList(ArrayList zonemems) {
        ArrayList<ZoneMemberDO> zoneMemDoLst = new ArrayList<ZoneMemberDO>();
        for (int i = 0; i < zonemems.size(); ++i) {
            ZoneMember zm = (ZoneMember)zonemems.get(i);
            if (zm.getParentType() != 2) continue;
            ZoneMemberDO znDo = new ZoneMemberDO();
            znDo.setId(zm.getMemId());
            znDo.setAfid(zm.getAfid());
            znDo.setIvrVid(zm.getIvrVsanIndex());
            znDo.setParentIndex(zm.getParentIndex());
            znDo.setParentType(zm.getParentType());
            znDo.setMemLunId(zm.getMemLunId());
            znDo.setType(zm.getMemFormat());
            if (zm.getMemFormat() == 1) {
                znDo.setpWwn(new WwnDO(zm.getMemId()));
            }
            znDo.setIndex(zm.getZoneIndex());
            zoneMemDoLst.add(znDo);
        }
        return zoneMemDoLst;
    }

    @Override
    @WebMethod(operationName="getZoneSetZones")
    @WebResult(name="result", partName="result")
    public ZoneDO[] getZoneSetZones(@WebParam(name="cacheKey", partName="cacheKey") int cacheKey, @WebParam(name="fabricDBID", partName="fabricDBID") long fabricDBID, @WebParam(name="zonesetName", partName="zonesetName") String zonesetName) throws SanServiceException {
        Object[] zoneDo = new ZoneDO[]{};
        try {
            WebZoneRif rif = WebZoneManagerImpl.getRemoteWebZoneRif(fabricDBID);
            ArrayList zones = rif.getZoneSetZones(cacheKey, zonesetName);
            if (zones != null && zones.size() > 0) {
                zoneDo = new ZoneDO[zones.size()];
                for (int i = 0; i < zones.size(); ++i) {
                    Zone zn = (Zone)zones.get(i);
                    ZoneDO ret = new ZoneDO();
                    ret.setIndex(zn.getZoneIndex());
                    ret.setName(zn.getZoneName());
                    ret.setZoneLastModtime(zn.getLastModifiedAsLong());
                    ret.setReadonly(zn.isReadOnly());
                    ret.setBroadcast(zn.isBroadcast());
                    ret.setQos(zn.isQos());
                    ret.setQosPriority(zn.getQosPriority());
                    ret.setVsanId(zn.getZoneVsanId());
                    zoneDo[i] = ret;
                }
                if (zoneDo.length > 1) {
                    Arrays.sort(zoneDo);
                }
            }
        }
        catch (Exception ex) {
            _Logger.error((Object)ex.getMessage());
            throw new SanServiceException(ex.getMessage());
        }
        return zoneDo;
    }

    @Override
    @WebMethod(operationName="getZones")
    @WebResult(name="result", partName="result")
    public ZoneDO[] getZones(@WebParam(name="cacheKey", partName="cacheKey") int cacheKey, @WebParam(name="fabricDBID", partName="fabricDBID") long fabricDBID) throws SanServiceException {
        Object[] zoneDo = new ZoneDO[]{};
        try {
            WebZoneRif rif = WebZoneManagerImpl.getRemoteWebZoneRif(fabricDBID);
            ArrayList zones = rif.getZones(cacheKey);
            if (zones != null && zones.size() > 0) {
                zoneDo = new ZoneDO[zones.size()];
                for (int i = 0; i < zones.size(); ++i) {
                    Zone zn = (Zone)zones.get(i);
                    ZoneDO ret = new ZoneDO();
                    ret.setIndex(zn.getZoneIndex());
                    ret.setName(zn.getZoneName());
                    ret.setZoneLastModtime(zn.getLastModifiedAsLong());
                    ret.setReadonly(zn.isReadOnly());
                    ret.setBroadcast(zn.isBroadcast());
                    ret.setQos(zn.isQos());
                    ret.setQosPriority(zn.getQosPriority());
                    ret.setVsanId(zn.getZoneVsanId());
                    zoneDo[i] = ret;
                }
                if (zoneDo.length > 1) {
                    Arrays.sort(zoneDo);
                }
            }
        }
        catch (Exception ex) {
            _Logger.error((Object)ex.getMessage());
            throw new SanServiceException(ex.getMessage());
        }
        return zoneDo;
    }

    @Override
    @WebMethod(operationName="getFcAliases")
    @WebResult(name="result", partName="result")
    public AliasDO[] getFcAliases(@WebParam(name="cacheKey", partName="cacheKey") int cacheKey, @WebParam(name="fabricDBID", partName="fabricDBID") long fabricDBID) throws SanServiceException {
        AliasDO[] aliasDo = null;
        try {
            WebZoneRif rif = WebZoneManagerImpl.getRemoteWebZoneRif(fabricDBID);
            ArrayList aliases = rif.getFcAliases(cacheKey);
            if (aliases != null && aliases.size() > 0) {
                aliasDo = new AliasDO[aliases.size()];
            }
            for (int i = 0; i < aliases.size(); ++i) {
                ZoneAlias zn = (ZoneAlias)aliases.get(i);
                AliasDO znDo = new AliasDO();
                znDo.setIndex(zn.getZoneIndex());
                znDo.setName(zn.getZoneName());
                znDo.setZoneLastModtime(zn.getLastModifiedAsLong());
                aliasDo[i] = znDo;
            }
        }
        catch (Exception ex) {
            _Logger.error((Object)ex.getMessage());
            throw new SanServiceException(ex.getMessage());
        }
        return aliasDo;
    }

    @Override
    @WebMethod(operationName="getAliasMembers")
    @WebResult(name="result", partName="result")
    public ZoneMemberDO[] getAliasMembers(@WebParam(name="cacheKey", partName="cacheKey") int cacheKey, @WebParam(name="aliasName", partName="aliasName") String aliasName, @WebParam(name="fabricDBID", partName="fabricDBID") long fabricDBID) throws SanServiceException {
        try {
            WebZoneRif rif = WebZoneManagerImpl.getRemoteWebZoneRif(fabricDBID);
            ArrayList zonemems = rif.getZoneOrAliasMembers(cacheKey, aliasName, false);
            return this.buildZoneMembersList(zonemems);
        }
        catch (Exception ex) {
            _Logger.error((Object)ex.getMessage());
            throw new SanServiceException(ex.getMessage());
        }
    }

    private ZoneMemberDO[] buildZoneMembersList(ArrayList zonemems) throws SanServiceException {
        ArrayList<ZoneMemberDO> zoneMemDoLst = new ArrayList<ZoneMemberDO>();
        try {
            if (zonemems != null) {
                for (int i = 0; i < zonemems.size(); ++i) {
                    ZoneMember zm = (ZoneMember)zonemems.get(i);
                    if (zm.getParentType() != 2) continue;
                    ZoneMemberDO znDo = new ZoneMemberDO();
                    znDo.setId(zm.getMemId());
                    znDo.setAfid(zm.getAfid());
                    znDo.setIvrVid(zm.getIvrVsanIndex());
                    znDo.setParentIndex(zm.getParentIndex());
                    znDo.setParentType(zm.getParentType());
                    znDo.setMemLunId(zm.getMemLunId());
                    znDo.setType(zm.getMemFormat());
                    if (zm.getMemFormat() == 1) {
                        znDo.setpWwn(new WwnDO(zm.getMemId()));
                    }
                    znDo.setIndex(zm.getZoneIndex());
                    znDo.setDisplayName(zm.toString());
                    zoneMemDoLst.add(znDo);
                }
            }
        }
        catch (Exception ex) {
            _Logger.error((Object)ex.getMessage());
            throw new SanServiceException(ex.getMessage());
        }
        return zoneMemDoLst.toArray(new ZoneMemberDO[zoneMemDoLst.size()]);
    }

    @Override
    @WebMethod(operationName="getZoneMembers")
    @WebResult(name="result", partName="result")
    public ZoneMemberDO[] getZoneMembers(@WebParam(name="cacheKey", partName="cacheKey") int cacheKey, @WebParam(name="zoneName", partName="zoneName") String zoneName, @WebParam(name="fabricDBID", partName="fabricDBID") long fabricDBID) throws SanServiceException {
        try {
            WebZoneRif rif = WebZoneManagerImpl.getRemoteWebZoneRif(fabricDBID);
            ArrayList zonemems = rif.getZoneOrAliasMembers(cacheKey, zoneName, true);
            return this.buildZoneMembersList(zonemems);
        }
        catch (Exception ex) {
            _Logger.error((Object)ex.getMessage());
            throw new SanServiceException(ex.getMessage());
        }
    }

    @Override
    @WebMethod(operationName="getAvailableZonesToAddToZoneset")
    @WebResult(name="result", partName="result")
    public Object[] getAvailableZonesToAddToZoneset(@WebParam(name="cacheKey", partName="cacheKey") int cacheKey, @WebParam(name="zoneSetName", partName="zoneSetName") String zoneSetName, @WebParam(name="fabricDBID", partName="fabricDBID") long fabricDBID) throws SanServiceException {
        OperationStatusDO retV = new OperationStatusDO();
        ZoneDO[] zoneDo = null;
        String[] zoneNames = null;
        try {
            WebZoneRif rif = WebZoneManagerImpl.getRemoteWebZoneRif(fabricDBID);
            Object[] zones = rif.getAvailableZonesToAddToZoneset(cacheKey, zoneSetName);
            if (zones != null && zones.length > 0) {
                Arrays.sort(zones);
                zoneDo = new ZoneDO[zones.length];
                zoneNames = new String[zones.length];
                for (int i = 0; i < zones.length; ++i) {
                    Zone zn = (Zone)zones[i];
                    ZoneDO ret = new ZoneDO();
                    ret.setIndex(zn.getZoneIndex());
                    ret.setName(zn.getZoneName());
                    ret.setZoneLastModtime(zn.getLastModifiedAsLong());
                    ret.setReadonly(zn.isReadOnly());
                    ret.setBroadcast(zn.isBroadcast());
                    ret.setQos(zn.isQos());
                    ret.setQosPriority(zn.getQosPriority());
                    ret.setVsanId(zn.getZoneVsanId());
                    zoneDo[i] = ret;
                    zoneNames[i] = zn.getZoneName();
                }
            }
            retV.setStatus(true);
            retV.setDescription("Created Zoneset " + zoneSetName + " successfully");
        }
        catch (Exception ex) {
            _Logger.error((Object)ex.getMessage());
            retV.setStatus(false);
            retV.setDescription(ex.getMessage());
        }
        return new Object[]{retV, zoneNames};
    }

    @Override
    @WebMethod(operationName="getCommitStatus")
    @WebResult(name="result", partName="result")
    public int getCommitStatus(@WebParam(name="cacheKey", partName="cacheKey") int cacheKey, @WebParam(name="fabricDBID", partName="fabricDBID") long fabricDBID) throws SanServiceException {
        try {
            WebZoneRif rif = WebZoneManagerImpl.getRemoteWebZoneRif(fabricDBID);
            return rif.getCommitStatus(cacheKey);
        }
        catch (Exception ex) {
            _Logger.error((Object)ex.getMessage());
            return 2;
        }
    }

    @Override
    @WebMethod(operationName="getActivationDeactivationStatus")
    @WebResult(name="result", partName="result")
    public Object[] getActivationDeactivationStatus(@WebParam(name="cacheKey", partName="cacheKey") int cacheKey, @WebParam(name="activate", partName="activate") boolean activate, @WebParam(name="fabricDBID", partName="fabricDBID") long fabricDBID) throws SanServiceException {
        try {
            WebZoneRif rif = WebZoneManagerImpl.getRemoteWebZoneRif(fabricDBID);
            return rif.getActivationDeactivationStatus(cacheKey, activate);
        }
        catch (Exception ex) {
            _Logger.error((Object)ex.getMessage());
            return new Object[]{2, ex.getMessage()};
        }
    }

    @Override
    @WebMethod(operationName="commitData")
    @WebResult(name="result", partName="result")
    public OperationStatusDO commitData(@WebParam(name="cacheKey", partName="cacheKey") int cacheKey, @WebParam(name="fabricDBID", partName="fabricDBID") long fabricDBID) throws SanServiceException {
        OperationStatusDO ret = new OperationStatusDO();
        boolean zsDo = false;
        try {
            WebZoneRif rif = WebZoneManagerImpl.getRemoteWebZoneRif(fabricDBID);
            zsDo = rif.commitZoneData(cacheKey);
            ret.setStatus(true);
            ret.setDescription("Commit Action initiated Please check status.");
        }
        catch (Exception ex) {
            _Logger.error((Object)ex.getMessage());
            ret.setStatus(false);
            ret.setDescription(ex.getMessage());
        }
        return ret;
    }

    @Override
    @WebMethod(operationName="activateDeactivateZoneSet")
    @WebResult(name="result", partName="result")
    public OperationStatusDO activateDeactivateZoneSet(@WebParam(name="cacheKey", partName="cacheKey") int cacheKey, @WebParam(name="activate", partName="activate") boolean activate, @WebParam(name="zoneSetName", partName="zoneSetName") String zoneSetName, @WebParam(name="fabricDBID", partName="fabricDBID") long fabricDBID) throws SanServiceException {
        OperationStatusDO ret = new OperationStatusDO();
        boolean zsDo = false;
        try {
            WebZoneRif rif = WebZoneManagerImpl.getRemoteWebZoneRif(fabricDBID);
            zsDo = rif.activateDeactivateZoneSet(cacheKey, zoneSetName, activate);
            ret.setStatus(true);
            ret.setDescription("Zoneset " + zoneSetName + (activate ? " Activation" : " Deactivation") + "started. Please check status.");
        }
        catch (Exception ex) {
            _Logger.error((Object)ex.getMessage());
            ret.setStatus(false);
            ret.setDescription(ex.getMessage());
        }
        return ret;
    }

    @Override
    @WebMethod(operationName="createZoneSet")
    @WebResult(name="result", partName="result")
    public Object[] createZoneSet(@WebParam(name="cacheKey", partName="cacheKey") int cacheKey, @WebParam(name="zoneSetName", partName="zoneSetName") String zoneSetName, @WebParam(name="fabricDBID", partName="fabricDBID") long fabricDBID) throws SanServiceException {
        OperationStatusDO ret = new OperationStatusDO();
        ZoneSetDO zsDo = null;
        try {
            WebZoneRif rif = WebZoneManagerImpl.getRemoteWebZoneRif(fabricDBID);
            zsDo = rif.createZoneSet(cacheKey, zoneSetName);
            ret.setStatus(true);
            ret.setDescription("Created Zoneset " + zoneSetName + " successfully");
            ret.setAdditionalState(rif.isLocalActiveZonesetModified(cacheKey) ? 1 : 2);
        }
        catch (Exception ex) {
            _Logger.error((Object)ex.getMessage());
            ret.setStatus(false);
            ret.setDescription(ex.getMessage());
        }
        return new Object[]{ret, zsDo};
    }

    @Override
    @WebMethod(operationName="createZone")
    @WebResult(name="result", partName="result")
    public Object[] createZone(@WebParam(name="cacheKey", partName="cacheKey") int cacheKey, @WebParam(name="zoneName", partName="zoneName") String zoneName, @WebParam(name="fabricDBID", partName="fabricDBID") long fabricDBID) throws SanServiceException {
        OperationStatusDO ret = new OperationStatusDO();
        ZoneDO zsDo = null;
        try {
            WebZoneRif rif = WebZoneManagerImpl.getRemoteWebZoneRif(fabricDBID);
            zsDo = rif.createZone(cacheKey, zoneName);
            ret.setStatus(true);
            ret.setDescription("Created Zoneset " + zoneName + " successfully");
            ret.setAdditionalState(rif.isLocalActiveZonesetModified(cacheKey) ? 1 : 2);
        }
        catch (Exception ex) {
            _Logger.error((Object)ex.getMessage());
            ret.setStatus(false);
            ret.setDescription(ex.getMessage());
        }
        return new Object[]{ret, zsDo};
    }

    @Override
    @WebMethod(operationName="createFcAlias")
    @WebResult(name="result", partName="result")
    public Object[] createFcAlias(@WebParam(name="cacheKey", partName="cacheKey") int cacheKey, @WebParam(name="fcAliasName", partName="fcAliasName") String fcAliasName, @WebParam(name="fabricDBID", partName="fabricDBID") long fabricDBID) throws SanServiceException {
        OperationStatusDO ret = new OperationStatusDO();
        AliasDO zsDo = null;
        try {
            WebZoneRif rif = WebZoneManagerImpl.getRemoteWebZoneRif(fabricDBID);
            zsDo = rif.createFcAlias(cacheKey, fcAliasName);
            ret.setStatus(true);
            ret.setDescription("Created Zoneset " + fcAliasName + " successfully");
            ret.setAdditionalState(rif.isLocalActiveZonesetModified(cacheKey) ? 1 : 2);
        }
        catch (Exception ex) {
            _Logger.error((Object)ex.getMessage());
            ret.setStatus(false);
            ret.setDescription(ex.getMessage());
        }
        return new Object[]{ret, zsDo};
    }

    @Override
    @WebMethod(operationName="deleteZonesets")
    @WebResult(name="result", partName="result")
    public OperationStatusDO deleteZonesets(@WebParam(name="cacheKey", partName="cacheKey") int cacheKey, @WebParam(name="zoneSetName", partName="zoneSetName") String[] zoneSetNames, @WebParam(name="fabricDBID", partName="fabricDBID") long fabricDBID) throws SanServiceException {
        OperationStatusDO ret = new OperationStatusDO();
        try {
            WebZoneRif rif = WebZoneManagerImpl.getRemoteWebZoneRif(fabricDBID);
            this.buildOperDO(rif.deleteZoneSets(cacheKey, zoneSetNames), ret);
            ret.setAdditionalState(rif.isLocalActiveZonesetModified(cacheKey) ? 1 : 2);
        }
        catch (Exception ex) {
            _Logger.error((Object)ex.getMessage());
            ret.setStatus(false);
            ret.setDescription(ex.getMessage());
        }
        return ret;
    }

    @Override
    @WebMethod(operationName="deleteZones")
    @WebResult(name="result", partName="result")
    public OperationStatusDO deleteZones(@WebParam(name="cacheKey", partName="cacheKey") int cacheKey, @WebParam(name="zone", partName="zone") String[] zones, @WebParam(name="fabricDBID", partName="fabricDBID") long fabricDBID) throws SanServiceException {
        OperationStatusDO ret = new OperationStatusDO();
        try {
            WebZoneRif rif = WebZoneManagerImpl.getRemoteWebZoneRif(fabricDBID);
            this.buildOperDO(rif.deleteZones(cacheKey, zones), ret);
            ret.setAdditionalState(rif.isLocalActiveZonesetModified(cacheKey) ? 1 : 2);
        }
        catch (Exception ex) {
            _Logger.error((Object)ex.getMessage());
            ret.setStatus(false);
            ret.setDescription(ex.getMessage());
        }
        return ret;
    }

    @Override
    @WebMethod(operationName="deleteFcAliases")
    @WebResult(name="result", partName="result")
    public OperationStatusDO deleteFcAliases(@WebParam(name="cacheKey", partName="cacheKey") int cacheKey, @WebParam(name="fcAlias", partName="fcAlias") String[] fcAlias, @WebParam(name="fabricDBID", partName="fabricDBID") long fabricDBID) throws SanServiceException {
        OperationStatusDO ret = new OperationStatusDO();
        try {
            WebZoneRif rif = WebZoneManagerImpl.getRemoteWebZoneRif(fabricDBID);
            this.buildOperDO(rif.deletefcAliases(cacheKey, fcAlias), ret);
            ret.setAdditionalState(rif.isLocalActiveZonesetModified(cacheKey) ? 1 : 2);
        }
        catch (Exception ex) {
            _Logger.error((Object)ex.getMessage());
            ret.setStatus(false);
            ret.setDescription(ex.getMessage());
        }
        return ret;
    }

    @Override
    @WebMethod(operationName="deleteAliasAndZoneMember")
    @WebResult(name="result", partName="result")
    public OperationStatusDO deleteAliasAndZoneMember(@WebParam(name="cacheKey", partName="cacheKey") int cacheKey, @WebParam(name="memberIndex", partName="memberIndex") int[] memberIndex, @WebParam(name="fcaliases", partName="fcaliases") String[] fcaliases, @WebParam(name="zoneName", partName="zoneName") String zoneName, @WebParam(name="fabricDBID", partName="fabricDBID") long fabricDBID) throws SanServiceException {
        OperationStatusDO ret = new OperationStatusDO();
        try {
            WebZoneRif rif = WebZoneManagerImpl.getRemoteWebZoneRif(fabricDBID);
            if (memberIndex != null && memberIndex.length > 0) {
                this.buildOperDO(rif.deleteMemberFromZone(cacheKey, memberIndex, zoneName), ret);
            }
            if (fcaliases != null && fcaliases.length > 0) {
                this.buildOperDO(rif.deleteFCAliasFromZone(cacheKey, fcaliases, zoneName), ret);
            }
        }
        catch (Exception ex) {
            _Logger.error((Object)ex.getMessage());
            ret.setStatus(false);
            ret.setDescription(ex.getMessage());
        }
        return ret;
    }

    @Override
    @WebMethod(operationName="deleteZoneMember")
    @WebResult(name="result", partName="result")
    public OperationStatusDO deleteZoneMember(@WebParam(name="cacheKey", partName="cacheKey") int cacheKey, @WebParam(name="memberIndex", partName="memberIndex") int[] memberIndex, @WebParam(name="zoneName", partName="zoneName") String zoneName, @WebParam(name="fabricDBID", partName="fabricDBID") long fabricDBID) throws SanServiceException {
        OperationStatusDO ret = new OperationStatusDO();
        try {
            WebZoneRif rif = WebZoneManagerImpl.getRemoteWebZoneRif(fabricDBID);
            this.buildOperDO(rif.deleteMemberFromZone(cacheKey, memberIndex, zoneName), ret);
        }
        catch (Exception ex) {
            _Logger.error((Object)ex.getMessage());
            ret.setStatus(false);
            ret.setDescription(ex.getMessage());
        }
        return ret;
    }

    @Override
    @WebMethod(operationName="deleteAliasMember")
    @WebResult(name="result", partName="result")
    public OperationStatusDO deleteAliasMember(@WebParam(name="cacheKey", partName="cacheKey") int cacheKey, @WebParam(name="memberIndex", partName="memberIndex") int[] memberIndex, @WebParam(name="alias", partName="alias") String alias, @WebParam(name="fabricDBID", partName="fabricDBID") long fabricDBID) throws SanServiceException {
        OperationStatusDO ret = new OperationStatusDO();
        try {
            WebZoneRif rif = WebZoneManagerImpl.getRemoteWebZoneRif(fabricDBID);
            this.buildOperDO(rif.deleteMemberFromAlias(cacheKey, memberIndex, alias), ret);
            ret.setAdditionalState(rif.isLocalActiveZonesetModified(cacheKey) ? 1 : 2);
        }
        catch (Exception ex) {
            _Logger.error((Object)ex.getMessage());
            ret.setStatus(false);
            ret.setDescription(ex.getMessage());
        }
        return ret;
    }

    @Override
    @WebMethod(operationName="deleteZoneFromZoneset")
    @WebResult(name="result", partName="result")
    public OperationStatusDO deleteZoneFromZoneset(@WebParam(name="cacheKey", partName="cacheKey") int cacheKey, @WebParam(name="zoneName", partName="zoneName") String[] zoneName, @WebParam(name="zonesetName", partName="zonesetName") String zonesetName, @WebParam(name="fabricDBID", partName="fabricDBID") long fabricDBID) throws SanServiceException {
        OperationStatusDO ret = new OperationStatusDO();
        try {
            WebZoneRif rif = WebZoneManagerImpl.getRemoteWebZoneRif(fabricDBID);
            this.buildOperDO(rif.deleteZoneFromZoneset(cacheKey, zoneName, zonesetName), ret);
            ret.setAdditionalState(rif.isLocalActiveZonesetModified(cacheKey) ? 1 : 2);
        }
        catch (Exception ex) {
            _Logger.error((Object)ex.getMessage());
            ret.setStatus(false);
            ret.setDescription(ex.getMessage());
        }
        return ret;
    }

    @Override
    @WebMethod(operationName="getAvailableEndPorts")
    @WebResult(name="result", partName="result")
    public WebConfEndDeviceDO[] getAvailableEndPorts(@WebParam(name="cacheKey", partName="cacheKey") int cacheKey, @WebParam(name="vsanId", partName="vsanId") int vsanId, @WebParam(name="filterType", partName="filterType") int filterType, @WebParam(name="filterPattern", partName="filterPattern") String filterPattern, @WebParam(name="startIndex", partName="startIndex") int startIndex, @WebParam(name="recordSize", partName="recordSize") int recordSize, @WebParam(name="fabricDBID", partName="fabricDBID") long fabricDBID) throws SanServiceException {
        WebConfEndDeviceDO[] eDo = new WebConfEndDeviceDO[]{};
        try {
            WebZoneRif rif = WebZoneManagerImpl.getRemoteWebZoneRif(fabricDBID);
            eDo = rif.getAvailableEndPorts(cacheKey, fabricDBID, vsanId, filterType, filterPattern, startIndex, recordSize);
        }
        catch (Exception ex) {
            _Logger.error((Object)ex.getMessage());
        }
        return eDo;
    }

    @Override
    @WebMethod(operationName="getAvailableDeviceAliase")
    @WebResult(name="result", partName="result")
    public WebConfEndDeviceDO[] getAvailableDeviceAliase(@WebParam(name="cacheKey", partName="cacheKey") int cacheKey, @WebParam(name="vsanId", partName="vsanId") int vsanId, @WebParam(name="filterType", partName="filterType") int filterType, @WebParam(name="filterPattern", partName="filterPattern") String filterPattern, @WebParam(name="startIndex", partName="startIndex") int startIndex, @WebParam(name="recordSize", partName="recordSize") int recordSize, @WebParam(name="fabricDBID", partName="fabricDBID") long fabricDBID) throws SanServiceException {
        WebConfEndDeviceDO[] eDo = new WebConfEndDeviceDO[]{};
        try {
            WebZoneRif rif = WebZoneManagerImpl.getRemoteWebZoneRif(fabricDBID);
            eDo = rif.getAvailableDeviceAlias(cacheKey, fabricDBID, vsanId, filterType, filterPattern, startIndex, recordSize);
        }
        catch (Exception ex) {
            _Logger.error((Object)ex.getMessage());
        }
        return eDo;
    }

    @Override
    @WebMethod(operationName="addMemberIdsToAbstratZone")
    @WebResult(name="result", partName="result")
    public Object[] addMemberIdsToAbstratZone(@WebParam(name="cacheKey", partName="cacheKey") int cacheKey, @WebParam(name="devType", partName="devType") int[] devType, @WebParam(name="parentType", partName="parentType") int parentType, @WebParam(name="memType", partName="memType") int[] memType, @WebParam(name="memId", partName="memId") String[] memId, @WebParam(name="parent", partName="parent") String parent, @WebParam(name="fabricDBID", partName="fabricDBID") long fabricDBID) throws SanServiceException {
        OperationStatusDO ret = new OperationStatusDO();
        WebConfZnZoneMemberDO[] zndo = new WebConfZnZoneMemberDO[]{};
        try {
            WebZoneRif rif = WebZoneManagerImpl.getRemoteWebZoneRif(fabricDBID);
            Object[] obb = rif.addMemberIdsToAbstratZone(cacheKey, devType, parentType, memType, memId, parent, fabricDBID);
            this.buildOperDO(obb, ret);
            ret.setAdditionalState(rif.isLocalActiveZonesetModified(cacheKey) ? 1 : 2);
            if (obb[3] != null) {
                zndo = (WebConfZnZoneMemberDO[])obb[2];
            }
        }
        catch (Exception ex) {
            _Logger.error((Object)ex.getMessage());
            ret.setStatus(false);
            ret.setDescription(ex.getMessage());
        }
        return new Object[]{ret, zndo};
    }

    @Override
    @WebMethod(operationName="addDevicesToAbstratZone")
    @WebResult(name="result", partName="result")
    public Object[] addDevicesToAbstratZone(@WebParam(name="cacheKey", partName="cacheKey") int cacheKey, @WebParam(name="devType", partName="devType") int[] devType, @WebParam(name="parentType", partName="parentType") int parentType, @WebParam(name="memType", partName="memType") int memType, @WebParam(name="memId", partName="memId") String[] memId, @WebParam(name="parent", partName="parent") String parent, @WebParam(name="fabricDBID", partName="fabricDBID") long fabricDBID) throws SanServiceException {
        OperationStatusDO ret = new OperationStatusDO();
        WebConfZnZoneMemberDO[] zndo = new WebConfZnZoneMemberDO[]{};
        try {
            WebZoneRif rif = WebZoneManagerImpl.getRemoteWebZoneRif(fabricDBID);
            Object[] obb = rif.addDevicesToAbstratZone(cacheKey, devType, parentType, memType, memId, parent, fabricDBID);
            this.buildOperDO(obb, ret);
            ret.setAdditionalState(rif.isLocalActiveZonesetModified(cacheKey) ? 1 : 2);
            if (obb[3] != null) {
                zndo = (WebConfZnZoneMemberDO[])obb[2];
            }
        }
        catch (Exception ex) {
            _Logger.error((Object)ex.getMessage());
            ret.setStatus(false);
            ret.setDescription(ex.getMessage());
        }
        return new Object[]{ret, zndo};
    }

    @Override
    @WebMethod(operationName="addZonesToZoneset")
    @WebResult(name="result", partName="result")
    public Object[] addZonesToZoneset(@WebParam(name="cacheKey", partName="cacheKey") int cacheKey, @WebParam(name="zoneName", partName="zoneName") String[] zoneName, @WebParam(name="zonesetName", partName="zonesetName") String zonesetName, @WebParam(name="fabricDBID", partName="fabricDBID") long fabricDBID) throws SanServiceException {
        OperationStatusDO ret = new OperationStatusDO();
        ZoneDO[] zndo = null;
        try {
            WebZoneRif rif = WebZoneManagerImpl.getRemoteWebZoneRif(fabricDBID);
            Object[] obb = rif.addZonesToZoneset(cacheKey, zoneName, zonesetName);
            this.buildOperDO(obb, ret);
            ret.setAdditionalState(rif.isLocalActiveZonesetModified(cacheKey) ? 1 : 2);
            if (obb[3] == null) {
                zndo = new ZoneDO[]{};
            } else {
                Zone[] zs = (Zone[])obb[2];
                zndo = new ZoneDO[zs.length];
                for (int i = 0; i < zs.length; ++i) {
                    ZoneDO zd = new ZoneDO();
                    zd.setIndex(zs[i].getZoneIndex());
                    zd.setName(zs[i].getZoneName());
                    zd.setZoneLastModtime(zs[i].getLastModifiedAsLong());
                    zd.setReadonly(zs[i].isReadOnly());
                    zd.setBroadcast(zs[i].isBroadcast());
                    zd.setQos(zs[i].isQos());
                    zd.setQosPriority(zs[i].getQosPriority());
                    zd.setVsanId(zs[i].getZoneVsanId());
                    zndo[i] = zd;
                }
            }
        }
        catch (Exception ex) {
            _Logger.error((Object)ex.getMessage());
            ret.setStatus(false);
            ret.setDescription(ex.getMessage());
        }
        return new Object[]{ret, zndo};
    }

    @Override
    @WebMethod(operationName="deleteFCAliasFromZone")
    @WebResult(name="result", partName="result")
    public OperationStatusDO deleteFCAliasFromZone(@WebParam(name="cacheKey", partName="cacheKey") int cacheKey, @WebParam(name="alias", partName="alias") String[] alias, @WebParam(name="zoneName", partName="zoneName") String zoneName, @WebParam(name="fabricDBID", partName="fabricDBID") long fabricDBID) throws SanServiceException {
        OperationStatusDO ret = new OperationStatusDO();
        try {
            WebZoneRif rif = WebZoneManagerImpl.getRemoteWebZoneRif(fabricDBID);
            this.buildOperDO(rif.deleteFCAliasFromZone(cacheKey, alias, zoneName), ret);
            ret.setAdditionalState(rif.isLocalActiveZonesetModified(cacheKey) ? 1 : 2);
        }
        catch (Exception ex) {
            _Logger.error((Object)ex.getMessage());
            ret.setStatus(false);
            ret.setDescription(ex.getMessage());
        }
        return ret;
    }

    @Override
    @WebMethod(operationName="getUnzonedEnclosureHosts")
    @WebResult(name="result", partName="result")
    public WebZnEnclosureDO[] getUnzonedEnclosureHosts() throws SanServiceException {
        OperationStatusDO ret = new OperationStatusDO();
        WebZnEnclosureDO[] encs = new WebZnEnclosureDO[]{};
        try {
            encs = PolicyBasedZoning.getUnzonedHostEnclosures();
            if (encs == null) {
                encs = new WebZnEnclosureDO[]{};
            }
            ret.setStatus(true);
        }
        catch (Exception ex) {
            ret.setStatus(false);
            ret.setDescription(ex.getMessage());
            _Logger.error((Object)ex.getMessage());
        }
        return encs;
    }

    @Override
    @WebMethod(operationName="getEligibleStorageEnclosuresForHostEnclosure")
    @WebResult(name="result", partName="result")
    public WebZnEnclosureDO[] getEligibleStorageEnclosuresForHostEnclosure(@WebParam(name="hostDBID", partName="hostDBID") long hostDBID) throws SanServiceException {
        OperationStatusDO ret = new OperationStatusDO();
        WebZnEnclosureDO[] encs = new WebZnEnclosureDO[]{};
        try {
            encs = PolicyBasedZoning.getEligibleStorageEnclosuresForHostEnclosure(hostDBID);
            if (encs == null) {
                encs = new WebZnEnclosureDO[]{};
            }
            ret.setStatus(true);
        }
        catch (Exception ex) {
            ret.setStatus(false);
            ret.setDescription(ex.getMessage());
            _Logger.error((Object)ex.getMessage());
        }
        return encs;
    }

    @Override
    @WebMethod(operationName="generateCLICmds")
    @WebResult(name="result", partName="result")
    public WebZnVsancliDO[] generateCLICmds(@WebParam(name="portPairData", partName="portPairData") WebZnEndPortDataDO[][] portPairData) throws SanServiceException {
        ArrayList<Object> vsanLst = new ArrayList();
        try {
            vsanLst = PolicyBasedZoning.generateCLICmds(portPairData);
        }
        catch (Exception e) {
            e.printStackTrace();
            _Logger.error((Object)e.getMessage());
            throw new SanServiceException(e.getMessage());
        }
        return vsanLst.toArray(new WebZnVsancliDO[0]);
    }

    @Override
    @WebMethod(operationName="runCLIForZoning")
    @WebResult(name="result", partName="result")
    public int runCLIForZoning(@WebParam(name="cliData", partName="cliData") WebZnVsancliDO cliData) throws SanServiceException {
        try {
            WebZoneRif rif = WebZoneManagerImpl.getRemoteWebZoneRif(cliData.fabricDBID);
            return rif.createRunCLIForZoning(cliData);
        }
        catch (Exception e) {
            _Logger.error((Object)e.getMessage());
            throw new SanServiceException(e.getMessage());
        }
    }

    @Override
    @WebMethod(operationName="runActivationCommitCmds")
    @WebResult(name="result", partName="result")
    public int runActivationCommitCmds(@WebParam(name="cliData", partName="cliData") WebZnVsancliDO cliData) throws SanServiceException {
        try {
            WebZoneRif rif = WebZoneManagerImpl.getRemoteWebZoneRif(cliData.fabricDBID);
            return rif.runActivationCommitCmds(cliData);
        }
        catch (Exception e) {
            _Logger.error((Object)e.getMessage());
            throw new SanServiceException(e.getMessage());
        }
    }

    @Override
    @WebMethod(operationName="cleanupCliRunID")
    @WebResult(name="result", partName="result")
    public boolean cleanupCliRunID(@WebParam(name="id", partName="id") int id, @WebParam(name="fabricDBID", partName="fabricDBID") long fabricDBID) throws SanServiceException {
        try {
            WebZoneRif rif = WebZoneManagerImpl.getRemoteWebZoneRif(fabricDBID);
            return rif.cleanupCliRunID(id);
        }
        catch (Exception e) {
            _Logger.error((Object)e.getMessage());
            return false;
        }
    }

    @Override
    @WebMethod(operationName="getCLIResultForZoning")
    @WebResult(name="result", partName="result")
    public Object[] getCLIResultForZoning(@WebParam(name="id", partName="id") int id, @WebParam(name="fabricDBID", partName="fabricDBID") long fabricDBID) throws SanServiceException {
        Object[] out = new Object[]{true, true, ""};
        try {
            WebZoneRif rif = WebZoneManagerImpl.getRemoteWebZoneRif(fabricDBID);
            boolean isInitFinished = rif.isCliCmdFinished(id, fabricDBID);
            out[0] = isInitFinished;
            out[2] = rif.getCLIResultForZoning(id, fabricDBID);
        }
        catch (Exception e) {
            _Logger.error((Object)e.getMessage());
            out[0] = true;
            out[1] = false;
            out[2] = e.getMessage();
        }
        return out;
    }

    @Override
    @WebMethod(operationName="getZoneActDeact")
    @WebResult(name="result", partName="result")
    public Object[] getZoneActDeact(@WebParam(name="id", partName="id") int id, @WebParam(name="fabricDBID", partName="fabricDBID") long fabricDBID) throws SanServiceException {
        Object[] out = new Object[]{false, true, ""};
        try {
            WebZoneRif rif = WebZoneManagerImpl.getRemoteWebZoneRif(fabricDBID);
            boolean isInitFinished = rif.isCliCmdFinished(id, fabricDBID);
            out[0] = isInitFinished;
            String cliout = rif.getCLIResultForZoning(id, fabricDBID);
            out[2] = !isInitFinished ? cliout : cliout + rif.getZoneActDeact(id, fabricDBID);
        }
        catch (Exception e) {
            _Logger.error((Object)e.getMessage());
            out[0] = true;
            out[1] = false;
            out[2] = e.getMessage();
        }
        return out;
    }

    @Override
    @WebMethod(operationName="getHost2StoragePortsMapping")
    @WebResult(name="result", partName="result")
    public WebZnHstPortStgPortListDO[] getHost2StoragePortsMapping(@WebParam(name="hostDBID", partName="hostDBID") long hostDBID, @WebParam(name="stgDBID", partName="stgDBID") long stgDBID) throws SanServiceException {
        OperationStatusDO ret = new OperationStatusDO();
        WebZnHstPortStgPortListDO[] encs = new WebZnHstPortStgPortListDO[]{};
        try {
            encs = PolicyBasedZoning.getHost2StoragePortsMapping(hostDBID, stgDBID);
            if (encs == null) {
                encs = new WebZnHstPortStgPortListDO[]{};
            }
            ret.setStatus(true);
        }
        catch (Exception ex) {
            ret.setStatus(false);
            ret.setDescription(ex.getMessage());
        }
        return encs;
    }

    public static void main(String[] arg) {
    }
}

