/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.jaxws.san.helper;

import com.cisco.dcbu.jaxws.ep.SanServiceException;
import com.cisco.dcbu.jaxws.san.wo.JobDO;
import com.cisco.dcbu.jaxws.san.wo.JobKeyDO;
import com.cisco.dcbu.jaxws.san.wo.JobStatusDO;
import com.cisco.dcbu.jaxws.san.wo.JobStatusTypeDO;
import com.cisco.dcbu.jaxws.san.wo.JobTypeDO;
import com.cisco.dcbu.jaxws.san.wo.OperationStatusDO;
import com.cisco.dcbu.jaxws.san.wo.VsanKeyDO;
import com.cisco.dcbu.jaxws.san.wo.WwnDO;
import com.cisco.dcbu.jaxws.san.wo.WwnKeyDO;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class ZoneJobHelper {
    static final String ADDJOB = "INSERT INTO ZONE_JOB(ID, JOB_TYPE, VSAN_ID, VSAN_WWN, WWN, ZONESET_NAME, JOB_STATUS, JOB_CREATE_TIME, JOB_FINISH_TIME,JOB_DEL_ON_COMPLETION,JOB_TIME_BEFORE_REMOVAL,JOB_STATUS_DESC,OLD_ZONESET_NAME,OLD_ZONESET_ACTIVATION_TIME) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?)";
    static final String UPDATEJOB = "UPDATE ZONE_JOB SET JOB_STATUS=?, JOB_FINISH_TIME=?  WHERE ID=? AND VSAN_ID=? AND VSAN_WWN=?";
    static final String DELETEJOB = "DELETE FROM ZONE_JOB WHERE ID=?";
    static final String MAX_JOB_ID = "SELECT MAX (ID) FROM ZONE_JOB";
    static final String GETJOB = "SELECT ID, JOB_TYPE, VSAN_ID, VSAN_WWN, WWN, ZONESET_NAME, JOB_STATUS, JOB_CREATE_TIME, JOB_FINISH_TIME,JOB_DEL_ON_COMPLETION,JOB_TIME_BEFORE_REMOVAL,JOB_STATUS_DESC,OLD_ZONESET_NAME,OLD_ZONESET_ACTIVATION_TIME FROM ZONE_JOB WHERE ID=?";
    static final String GETJOBS = "SELECT ID, JOB_TYPE, VSAN_ID, VSAN_WWN, WWN, ZONESET_NAME, JOB_STATUS, JOB_CREATE_TIME, JOB_FINISH_TIME,JOB_DEL_ON_COMPLETION,JOB_TIME_BEFORE_REMOVAL,JOB_STATUS_DESC,OLD_ZONESET_NAME,OLD_ZONESET_ACTIVATION_TIME FROM ZONE_JOB WHERE VSAN_ID=? AND VSAN_WWN=?";
    static final String GETJOBWITHVSAN = "SELECT ID, JOB_TYPE, VSAN_ID, VSAN_WWN, WWN, ZONESET_NAME, JOB_STATUS, JOB_CREATE_TIME, JOB_FINISH_TIME ,JOB_DEL_ON_COMPLETION,JOB_TIME_BEFORE_REMOVAL,JOB_STATUS_DESC,OLD_ZONESET_NAME,OLD_ZONESET_ACTIVATION_TIME FROM ZONE_JOB WHERE ID=? AND VSAN_ID=? AND VSAN_WWN=?";
    static final String GETFINISHEDJOBS = "SELECT ID, JOB_TYPE, VSAN_ID, VSAN_WWN, WWN, ZONESET_NAME, JOB_STATUS, JOB_CREATE_TIME, JOB_FINISH_TIME,JOB_DEL_ON_COMPLETION,JOB_TIME_BEFORE_REMOVAL,JOB_STATUS_DESC,OLD_ZONESET_NAME,OLD_ZONESET_ACTIVATION_TIME FROM ZONE_JOB WHERE JOB_STATUS=? OR JOB_STATUS=?";
    static Logger logger = LogManager.getLogger((String)"fms.ws");

    public static long addJob(JobTypeDO type, VsanKeyDO vsanKey, WwnKeyDO switchKey, String ZonesetName, String statusDesc, String OldZonesetName, long OldZonesetActTime) throws SanServiceException {
        long lastJobId = ZoneJobHelper.getJobID();
        if (lastJobId == -1L) {
            logger.warn((Object)"DB Error: could not generate job id");
            return -1L;
        }
        Connection con = null;
        PreparedStatement stat = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(ADDJOB);
            stat.setLong(1, ++lastJobId);
            stat.setInt(2, type.getValue());
            stat.setLong(3, vsanKey.getVsanID());
            stat.setBytes(4, vsanKey.getPSwitchWwn().toWwn().getValue());
            stat.setBytes(5, switchKey.getWwn().toWwn().getValue());
            stat.setString(6, ZonesetName);
            stat.setInt(7, JobStatusTypeDO.STARTED.getValue());
            stat.setTimestamp(8, new Timestamp(System.currentTimeMillis()));
            stat.setTimestamp(9, new Timestamp(System.currentTimeMillis()));
            stat.setBoolean(10, true);
            stat.setLong(11, new Long(1440L));
            stat.setString(12, statusDesc);
            stat.setString(13, OldZonesetName);
            stat.setTimestamp(14, new Timestamp(OldZonesetActTime));
            stat.executeUpdate();
            stat.close();
            stat = null;
            logger.debug((Object)("create smis job id " + lastJobId));
        }
        catch (Exception e1) {
            try {
                logger.warn((Object)("DB Error:" + e1.getMessage()));
                throw new SanServiceException("Failed to Add Job :" + lastJobId + " Error: " + e1.getMessage());
            }
            catch (Throwable throwable) {
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(stat);
        DbUtil.close(con);
        return lastJobId;
    }

    public static OperationStatusDO updateJob(VsanKeyDO vsanKey, JobKeyDO jobKey, JobStatusTypeDO requestedStatus) throws SanServiceException {
        OperationStatusDO operationStatusDO;
        OperationStatusDO ret = new OperationStatusDO();
        Connection con = null;
        PreparedStatement stat = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(UPDATEJOB);
            stat.setInt(1, requestedStatus.getValue());
            stat.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
            stat.setLong(3, jobKey.getJobId());
            stat.setLong(4, vsanKey.getVsanID());
            stat.setBytes(5, vsanKey.getPSwitchWwn().toWwn().getValue());
            stat.executeUpdate();
            stat.close();
            ret.setStatus(true);
            operationStatusDO = ret;
        }
        catch (Exception e1) {
            try {
                logger.warn((Object)("DB Error:" + e1.getMessage()));
                throw new SanServiceException("Failed to Update Job :" + jobKey.getJobId() + " Error: " + e1.getMessage());
            }
            catch (Throwable throwable) {
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(stat);
        DbUtil.close(con);
        return operationStatusDO;
    }

    public static OperationStatusDO deleteJob(long jobId) throws SanServiceException {
        OperationStatusDO operationStatusDO;
        OperationStatusDO ret = new OperationStatusDO();
        Connection con = null;
        PreparedStatement stat = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(DELETEJOB);
            stat.setLong(1, jobId);
            stat.execute();
            stat.close();
            ret.setStatus(true);
            logger.debug((Object)("deleted smis job id " + jobId));
            operationStatusDO = ret;
        }
        catch (Exception e1) {
            try {
                logger.warn((Object)("DB Error:" + e1.getMessage()));
                throw new SanServiceException("Failed to Delete Job :" + jobId + " Error: " + e1.getMessage());
            }
            catch (Throwable throwable) {
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(stat);
        DbUtil.close(con);
        return operationStatusDO;
    }

    public static void removeJobs() throws SanServiceException {
        long currentTime = System.currentTimeMillis();
        JobDO[] jobs = ZoneJobHelper.getFinshedJobs();
        if (jobs != null && jobs.length > 0) {
            for (JobDO job : jobs) {
                if (!job.getDelOnCompletion().booleanValue() || currentTime <= job.getFinishTime().getTime() + job.getTimeBeforeRemoval() * 60L) continue;
                ZoneJobHelper.deleteJob(job.getJobKey().getJobId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getJobID() {
        long l;
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(MAX_JOB_ID);
            rs = stat.executeQuery();
            rs.next();
            l = rs.getLong(1);
        }
        catch (SQLException ex) {
            long l2;
            try {
                logger.error((Object)"DB error", (Throwable)ex);
                l2 = -1L;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
            return l2;
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return l;
    }

    public static JobDO getJob(VsanKeyDO vsanKey, JobKeyDO jobKey) throws SanServiceException {
        Serializable jKey;
        JobDO job = null;
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(GETJOBWITHVSAN);
            stat.setLong(1, jobKey.getJobId());
            stat.setLong(2, vsanKey.getVsanID());
            stat.setBytes(3, vsanKey.getPSwitchWwn().toWwn().getValue());
            rs = stat.executeQuery();
            if (rs.next()) {
                job = new JobDO();
                jKey = new JobKeyDO(rs.getLong(1));
                job.setJobKey((JobKeyDO)jKey);
                job.setJobtype(JobTypeDO.valueOf(rs.getInt(2)));
                VsanKeyDO vKey = new VsanKeyDO((int)rs.getLong(3), new WwnDO(rs.getBytes(4)));
                job.setVsankey(vKey);
                WwnKeyDO switchKey = new WwnKeyDO(new WwnDO(rs.getBytes(5)));
                job.setSwitchKey(switchKey);
                job.setZoneSetName(rs.getString(6));
                JobStatusDO jobStatus = new JobStatusDO();
                jobStatus.setStatus(JobStatusTypeDO.valueOf(rs.getInt(7)));
                jobStatus.setDescription(rs.getString(12));
                job.setJobStatus(jobStatus);
                job.setCreateTime(rs.getTimestamp(8));
                job.setFinishTime(rs.getTimestamp(9));
                job.setDelOnCompletion(rs.getBoolean(10));
                job.setTimeBeforeRemoval(rs.getLong(11));
                job.setOldZonesetName(rs.getString(13));
                job.setOldZonesetActTime(rs.getTimestamp(14));
            }
            jKey = job;
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"DB error", (Throwable)ex);
                throw new SanServiceException("Failed to get job with jobid " + jobKey.getJobId(), ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return jKey;
    }

    public static JobDO getJob(JobKeyDO jobKey) throws SanServiceException {
        Serializable jKey;
        JobDO job = null;
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(GETJOB);
            stat.setLong(1, jobKey.getJobId());
            rs = stat.executeQuery();
            if (rs.next()) {
                job = new JobDO();
                jKey = new JobKeyDO(rs.getLong(1));
                job.setJobKey((JobKeyDO)jKey);
                job.setJobtype(JobTypeDO.valueOf(rs.getInt(2)));
                VsanKeyDO vKey = new VsanKeyDO((int)rs.getLong(3), new WwnDO(rs.getBytes(4)));
                job.setVsankey(vKey);
                WwnKeyDO switchKey = new WwnKeyDO(new WwnDO(rs.getBytes(5)));
                job.setSwitchKey(switchKey);
                job.setZoneSetName(rs.getString(6));
                JobStatusDO jobStatus = new JobStatusDO();
                jobStatus.setStatus(JobStatusTypeDO.valueOf(rs.getInt(7)));
                jobStatus.setDescription(rs.getString(12));
                job.setJobStatus(jobStatus);
                job.setCreateTime(rs.getTimestamp(8));
                job.setFinishTime(rs.getTimestamp(9));
                job.setDelOnCompletion(rs.getBoolean(10));
                job.setTimeBeforeRemoval(rs.getLong(11));
                job.setOldZonesetName(rs.getString(13));
                job.setOldZonesetActTime(rs.getTimestamp(14));
            }
            jKey = job;
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"DB error", (Throwable)ex);
                throw new SanServiceException("Failed to get job with jobid " + jobKey.getJobId(), ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return jKey;
    }

    public static JobDO[] getJobs(VsanKeyDO vsanKey) throws SanServiceException {
        JobDO[] job;
        ArrayList<JobDO[]> jobs = new ArrayList<JobDO[]>();
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(GETJOBS);
            stat.setLong(1, vsanKey.getVsanID());
            stat.setBytes(2, vsanKey.getPSwitchWwn().toWwn().getValue());
            rs = stat.executeQuery();
            while (rs.next()) {
                job = new JobDO();
                JobKeyDO jKey = new JobKeyDO(rs.getLong(1));
                job.setJobKey(jKey);
                job.setJobtype(JobTypeDO.valueOf(rs.getInt(2)));
                VsanKeyDO vKey = new VsanKeyDO((int)rs.getLong(3), new WwnDO(rs.getBytes(4)));
                job.setVsankey(vKey);
                WwnKeyDO switchKey = new WwnKeyDO(new WwnDO(rs.getBytes(5)));
                job.setSwitchKey(switchKey);
                job.setZoneSetName(rs.getString(6));
                JobStatusDO jobStatus = new JobStatusDO();
                jobStatus.setStatus(JobStatusTypeDO.valueOf(rs.getInt(7)));
                jobStatus.setDescription(rs.getString(12));
                job.setJobStatus(jobStatus);
                job.setCreateTime(rs.getTimestamp(8));
                job.setFinishTime(rs.getTimestamp(9));
                job.setDelOnCompletion(rs.getBoolean(10));
                job.setTimeBeforeRemoval(rs.getLong(11));
                job.setOldZonesetName(rs.getString(13));
                job.setOldZonesetActTime(rs.getTimestamp(14));
                jobs.add(job);
            }
            job = jobs.toArray(new JobDO[0]);
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"DB error", (Throwable)ex);
                throw new SanServiceException("Failed to get job with vsanid " + vsanKey.getVsanID(), ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return job;
    }

    public static JobDO[] getFinshedJobs() throws SanServiceException {
        JobDO[] job;
        ArrayList<JobDO[]> jobs = new ArrayList<JobDO[]>();
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(GETFINISHEDJOBS);
            stat.setInt(1, JobStatusTypeDO.ENDED.getValue());
            stat.setInt(2, JobStatusTypeDO.TERMINATED.getValue());
            rs = stat.executeQuery();
            while (rs.next()) {
                job = new JobDO();
                JobKeyDO jKey = new JobKeyDO(rs.getLong(1));
                job.setJobKey(jKey);
                job.setJobtype(JobTypeDO.valueOf(rs.getInt(2)));
                VsanKeyDO vKey = new VsanKeyDO((int)rs.getLong(3), new WwnDO(rs.getBytes(4)));
                job.setVsankey(vKey);
                WwnKeyDO switchKey = new WwnKeyDO(new WwnDO(rs.getBytes(5)));
                job.setSwitchKey(switchKey);
                job.setZoneSetName(rs.getString(6));
                JobStatusDO jobStatus = new JobStatusDO();
                jobStatus.setStatus(JobStatusTypeDO.valueOf(rs.getInt(7)));
                jobStatus.setDescription(rs.getString(12));
                job.setJobStatus(jobStatus);
                job.setCreateTime(rs.getTimestamp(8));
                job.setFinishTime(rs.getTimestamp(9));
                job.setDelOnCompletion(rs.getBoolean(10));
                job.setTimeBeforeRemoval(rs.getLong(11));
                job.setOldZonesetName(rs.getString(13));
                job.setOldZonesetActTime(rs.getTimestamp(14));
                jobs.add(job);
            }
            job = jobs.toArray(new JobDO[0]);
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"DB error", (Throwable)ex);
                throw new SanServiceException("Failed to get finished jobs ", ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return job;
    }
}

