/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.jaxws.san.helper.cluster;

import com.cisco.dcbu.jaxws.san.wo.FabricKeyDO;
import com.cisco.dcbu.jaxws.san.wo.NameKeyDO;
import com.cisco.dcbu.jaxws.san.wo.SerialNumKeyDO;
import com.cisco.dcbu.jaxws.san.wo.VsanKeyDO;
import com.cisco.dcbu.jaxws.san.wo.WwnDO;
import com.cisco.dcbu.jaxws.san.wo.WwnKeyDO;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.sm.server.db.ClusterMapping;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.entity.EntityHelper;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;

public class KeyResolver {
    private static final KeyResolver self = new KeyResolver();
    protected EntityManager em = EntityHelper.createEntityManager();
    protected ClusterMapping map = ClusterMapping.getInstance();

    protected KeyResolver() {
    }

    public static KeyResolver getInstance() {
        return self;
    }

    public String get(FabricKeyDO key) throws Exception {
        String server = this.map.qIPStrfromFID(key.getFid());
        return server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(WwnKeyDO key) throws Exception {
        Wwn wwn = key.getWwn().toWwn();
        Connection con = ConnectionManager.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        int fid = -1;
        try {
            String sql = "SELECT FID FROM FABRIC f, SWITCH s WHERE s.FABRIC_ID=f.id AND s.WWN = ?";
            stmt = con.prepareStatement(sql);
            stmt.setBytes(1, wwn.getValue());
            rs = stmt.executeQuery();
            if (rs.next()) {
                fid = rs.getInt("FID");
            }
        }
        catch (Throwable throwable) {
            DbUtil.close(stmt);
            DbUtil.close(rs);
            DbUtil.close(con);
            throw throwable;
        }
        DbUtil.close(stmt);
        DbUtil.close(rs);
        DbUtil.close(con);
        String server = null;
        if (fid > 0) {
            server = this.map.qIPStrfromFID(fid);
        }
        return server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(SerialNumKeyDO key) throws Exception {
        String serialNum = key.getSerialNum();
        Connection con = ConnectionManager.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        int fid = -1;
        try {
            String sql = "SELECT LAN_ID FROM LANSWITCH_MAP map, SWITCH sw WHERE map.id=sw.id AND sw.serial_number=?";
            stmt = con.prepareStatement(sql);
            rs = stmt.executeQuery();
            if (rs.next()) {
                fid = rs.getInt("LAN_ID");
            }
        }
        catch (Throwable throwable) {
            DbUtil.close(stmt);
            DbUtil.close(rs);
            DbUtil.close(con);
            throw throwable;
        }
        DbUtil.close(stmt);
        DbUtil.close(rs);
        DbUtil.close(con);
        String server = null;
        if (fid > 0) {
            server = this.map.qIPStrfromFID(fid);
        }
        return server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WwnKeyDO[] getSwitchesByFabricKey(FabricKeyDO key) throws SQLException {
        Vector<WwnKeyDO> keys;
        block10: {
            if (key == null) {
                return null;
            }
            String sql = "Select WWN FROM SWITCH s, FABRIC f WHERE s.FABRIC_ID = f.id and f.FID=?";
            PreparedStatement stmt = null;
            ResultSet rs = null;
            Connection con = null;
            keys = new Vector<WwnKeyDO>();
            try {
                con = this.connection();
                if (con == null) break block10;
                try {
                    stmt = con.prepareStatement(sql);
                    stmt.setInt(1, key.getFid());
                    rs = stmt.executeQuery();
                    if (rs.next()) {
                        byte[] wwn = rs.getBytes("WWN");
                        WwnKeyDO k = new WwnKeyDO(new WwnDO(wwn));
                        keys.add(k);
                    }
                    DbUtil.close(stmt);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    break block10;
                }
                finally {
                    DbUtil.close(stmt);
                    DbUtil.close(rs);
                }
                DbUtil.close(rs);
            }
            finally {
                DbUtil.close(con);
            }
        }
        return keys.toArray(new WwnKeyDO[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FabricKeyDO[] getFabricsByServer(String ip) throws UnknownHostException, SQLException {
        if (ip == null) {
            return null;
        }
        String sql = "Select NAME FROM FABRIC WHERE FID = ?";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Connection con = this.connection();
        InetAddress addr = InetAddress.getByName(ip);
        List<Integer> fids = this.map.qFIdsFromIP(addr);
        FabricKeyDO[] keys = new FabricKeyDO[fids.size()];
        try {
            for (int i = 0; i < keys.length; ++i) {
                String name;
                block12: {
                    name = null;
                    if (con != null) {
                        try {
                            stmt = con.prepareStatement(sql);
                            stmt.setInt(1, fids.get(i));
                            rs = stmt.executeQuery();
                            if (rs.next()) {
                                name = rs.getString("NAME");
                            }
                            DbUtil.close(stmt);
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                            break block12;
                        }
                        finally {
                            DbUtil.close(stmt);
                            DbUtil.close(rs);
                        }
                        DbUtil.close(rs);
                    }
                }
                keys[i] = new FabricKeyDO(fids.get(i), name);
            }
        }
        finally {
            DbUtil.close(con);
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FabricKeyDO getFabricByEnclosureKey(NameKeyDO key) throws SQLException {
        if (key == null) {
            return null;
        }
        String sql = "SELECT f.FID, f.NAME FROM FABRIC f, END_PORT ep, ENCLOSURE en where ep.enclosure_id=en.id and f.id=ep.fabric_id and en.name = ?";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Connection con = null;
        FabricKeyDO fab = null;
        try {
            con = this.connection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, key.getName());
            rs = stmt.executeQuery();
            if (rs.next()) {
                int fid = rs.getInt("FID");
                String name = rs.getString("NAME");
                fab = new FabricKeyDO(fid, name);
            }
        }
        catch (Throwable throwable) {
            DbUtil.close(stmt);
            DbUtil.close(rs);
            DbUtil.close(con);
            throw throwable;
        }
        DbUtil.close(stmt);
        DbUtil.close(rs);
        DbUtil.close(con);
        return fab;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FabricKeyDO getFabricByEnclosurePWwn(WwnDO key) throws SQLException {
        if (key == null) {
            return null;
        }
        String sql = "SELECT f.FID, f.NAME FROM FABRIC f, END_PORT ep, ENCLOSURE en where ep.enclosure_id=en.id and f.id=ep.fabric_id en.wwn = ?";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Connection con = null;
        FabricKeyDO fab = null;
        Wwn wwn = new Wwn(key.getValue());
        try {
            con = this.connection();
            stmt = con.prepareStatement(sql);
            stmt.setBytes(1, wwn.getValue());
            rs = stmt.executeQuery();
            if (rs.next()) {
                int fid = rs.getInt("FID");
                String name = rs.getString("NAME");
                fab = new FabricKeyDO(fid, name);
            }
        }
        catch (Throwable throwable) {
            DbUtil.close(stmt);
            DbUtil.close(rs);
            DbUtil.close(con);
            throw throwable;
        }
        DbUtil.close(stmt);
        DbUtil.close(rs);
        DbUtil.close(con);
        return fab;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FabricKeyDO getFabricByHbaHWwn(WwnDO key) throws SQLException {
        if (key == null) {
            return null;
        }
        String sql = "SELECT f.FID, f.NAME FROM FABRIC f, END_PORT ep, ENCLOSURE en, HBA h where ep.enclosure_id=en.id and f.id=ep.fabric_id and h.enclosure_id=en.id and h.wwn = ?";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Connection con = null;
        FabricKeyDO fab = null;
        Wwn wwn = new Wwn(key.getValue());
        try {
            con = this.connection();
            stmt = con.prepareStatement(sql);
            stmt.setBytes(1, wwn.getValue());
            rs = stmt.executeQuery();
            if (rs.next()) {
                int fid = rs.getInt("FID");
                String name = rs.getString("NAME");
                fab = new FabricKeyDO(fid, name);
            }
        }
        catch (Throwable throwable) {
            DbUtil.close(stmt);
            DbUtil.close(rs);
            DbUtil.close(con);
            throw throwable;
        }
        DbUtil.close(stmt);
        DbUtil.close(rs);
        DbUtil.close(con);
        return fab;
    }

    public String getServerIpByEnclosureKey(NameKeyDO key) throws SQLException, UnknownHostException {
        if (key == null) {
            return null;
        }
        FabricKeyDO fab = this.getFabricByEnclosureKey(key);
        if (fab != null) {
            return ClusterMapping.getInstance().qIPStrfromFID(fab.getFid());
        }
        return null;
    }

    public String getServerIpByEnclosurePWwn(WwnDO key) throws SQLException, UnknownHostException {
        if (key == null) {
            return null;
        }
        FabricKeyDO fab = this.getFabricByEnclosurePWwn(key);
        if (fab != null) {
            return ClusterMapping.getInstance().qIPStrfromFID(fab.getFid());
        }
        return null;
    }

    public String getServerIpByHbaHWwn(WwnDO key) throws SQLException, UnknownHostException {
        if (key == null) {
            return null;
        }
        FabricKeyDO fab = this.getFabricByHbaHWwn(key);
        if (fab != null) {
            return ClusterMapping.getInstance().qIPStrfromFID(fab.getFid());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getServerIpByVsanKey(VsanKeyDO key) throws SQLException, UnknownHostException {
        if (key == null) {
            return null;
        }
        String sql = "SELECT FID FROM FABRIC f, VSAN v WHERE f.ID=v.FABRIC_ID AND v.VSAN_ID=? and v.PRINCIPAL_SWWN=?";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Connection con = null;
        int fid = -1;
        try {
            Wwn wwn = new Wwn(key.getPSwitchWwn().getValue());
            con = this.connection();
            stmt = con.prepareStatement(sql);
            stmt.setInt(1, key.getVsanID());
            stmt.setBytes(2, wwn.getValue());
            rs = stmt.executeQuery();
            if (rs.next()) {
                fid = rs.getInt("FID");
            }
        }
        catch (Throwable throwable) {
            DbUtil.close(stmt);
            DbUtil.close(rs);
            DbUtil.close(con);
            throw throwable;
        }
        DbUtil.close(stmt);
        DbUtil.close(rs);
        DbUtil.close(con);
        String server = null;
        if (fid >= 0) {
            server = ClusterMapping.getInstance().qIPStrfromFID(fid);
        }
        return server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getServerBySwitchIP(String ip) throws UnknownHostException, SQLException {
        String sql = "SELECT FID FROM SWITCH s, FABRIC f WHERE s.FABRIC_ID=F.ID AND IP_ADDRESS=?";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Connection con = null;
        String server = null;
        try {
            con = this.connection();
            InetAddress addr = InetAddress.getByName(ip);
            int fid = -1;
            stmt = con.prepareStatement(sql);
            stmt.setBytes(1, addr.getAddress());
            rs = stmt.executeQuery();
            if (rs.next()) {
                fid = rs.getInt("FID");
            }
            if (fid > 0) {
                server = this.map.qIPStrfromFID(fid);
            }
        }
        catch (Throwable throwable) {
            DbUtil.close(stmt);
            DbUtil.close(rs);
            DbUtil.close(con);
            throw throwable;
        }
        DbUtil.close(stmt);
        DbUtil.close(rs);
        DbUtil.close(con);
        return server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getServerByTaskId(long taskId) throws UnknownHostException, SQLException {
        String sql = "SELECT l.LAN_ID FROM LAN l, CDP_SEED c WHERE c.LAN_ID=l.ID and c.ID=?";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Connection con = null;
        String server = null;
        try {
            con = this.connection();
            long lanId = -1L;
            stmt = con.prepareStatement(sql);
            stmt.setLong(1, taskId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                lanId = rs.getLong(1);
            }
            if (lanId > 0L) {
                server = this.map.qIPStrfromFID(lanId);
            }
        }
        catch (Throwable throwable) {
            DbUtil.close(stmt);
            DbUtil.close(rs);
            DbUtil.close(con);
            throw throwable;
        }
        DbUtil.close(stmt);
        DbUtil.close(rs);
        DbUtil.close(con);
        return server;
    }

    public void close(Statement stmt, ResultSet rs, Connection con) {
        DbUtil.close(stmt);
        DbUtil.close(rs);
        DbUtil.close(con);
    }

    public Connection connection() throws SQLException {
        return ConnectionManager.getConnection();
    }
}

