/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.jaxws.san.helper.cluster;

import com.cisco.dcbu.jaxws.san.helper.cluster.DiscoveryWSResolver;
import com.cisco.dcbu.jaxws.san.helper.cluster.EventWSResolver;
import com.cisco.dcbu.jaxws.san.helper.cluster.InventoryWSResolver;
import com.cisco.dcbu.jaxws.san.helper.cluster.ProtocolWSResolver;
import com.cisco.dcbu.jaxws.san.helper.cluster.SanWSResolver;
import com.cisco.dcbu.jaxws.san.helper.cluster.SecurityWSResolver;
import com.cisco.dcbu.jaxws.san.helper.cluster.StorageWSResolver;
import com.cisco.dcbu.jaxws.san.helper.cluster.WSResolverBase;
import com.cisco.dcbu.jaxws.san.helper.cluster.WebAnalysisWSResolver;
import com.cisco.dcbu.jaxws.san.helper.cluster.WebZoneResolver;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.jboss.ws.core.EndpointInvocation;

public class ServerResolver {
    public static Vector<String> getServer(EndpointInvocation epInv, String epName) throws IllegalAccessException, InvocationTargetException {
        WSResolverBase resolver = null;
        if (epName.equals("SanWS")) {
            resolver = new SanWSResolver();
        } else if (epName.equals("DiscoveryWS")) {
            resolver = new DiscoveryWSResolver();
        } else if (epName.equals("SecurityWS")) {
            resolver = new SecurityWSResolver();
        } else if (epName.equals("EventWS")) {
            resolver = new EventWSResolver();
        } else if (epName.equals("ProtocolWS")) {
            resolver = new ProtocolWSResolver();
        } else if (epName.equals("InventoryWS")) {
            resolver = new InventoryWSResolver();
        } else if (epName.equals("WebAnalysisWS")) {
            resolver = new WebAnalysisWSResolver();
        } else if (epName.equals("StorageWS")) {
            resolver = new StorageWSResolver();
        } else if (epName.equals("WebZoneManagerWS")) {
            resolver = new WebZoneResolver();
        } else {
            return null;
        }
        Method m = epInv.getJavaMethod();
        Object[] args = epInv.getRequestPayload();
        m.invoke((Object)resolver, args);
        Vector<String> server = resolver.getServer();
        return server;
    }

    public static Vector<String> getServer(QName service, QName operation) {
        WSResolverBase resolver = null;
        String serviceName = service.getLocalPart();
        if (serviceName.equals("SanService")) {
            resolver = new SanWSResolver();
        } else if (serviceName.equals("DiscoveryService")) {
            resolver = new DiscoveryWSResolver();
        } else if (serviceName.equals("SecurityService")) {
            resolver = new SecurityWSResolver();
        } else if (serviceName.equals("EventService")) {
            resolver = new EventWSResolver();
        } else if (serviceName.equals("ProtocolService")) {
            resolver = new ProtocolWSResolver();
        } else if (serviceName.equals("InventoryService")) {
            resolver = new InventoryWSResolver();
        } else if (serviceName.equals("WebAnalysisService")) {
            resolver = new WebAnalysisWSResolver();
        } else if (serviceName.equals("StorageService")) {
            resolver = new StorageWSResolver();
        } else {
            return null;
        }
        try {
            Method[] ms;
            for (Method m : ms = resolver.getClass().getDeclaredMethods()) {
                if (!m.getName().equals(operation.getLocalPart())) continue;
                Class<?>[] types = m.getParameterTypes();
                Object[] params = new Object[types.length];
                for (int i = 0; i < types.length; ++i) {
                    if (!types[i].isPrimitive()) continue;
                    if (types[i].toString().equals("short")) {
                        params[i] = new Short(-1);
                        continue;
                    }
                    if (types[i].toString().equals("int")) {
                        params[i] = new Integer(-1);
                        continue;
                    }
                    if (types[i].toString().equals("long")) {
                        params[i] = new Long(-1L);
                        continue;
                    }
                    if (!types[i].toString().equals("boolean")) continue;
                    params[i] = new Boolean(false);
                }
                m.invoke((Object)resolver, params);
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Vector<String> server = resolver.getServer();
        return server;
    }
}

