/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.jaxws.san.wo;

import com.cisco.dcbu.jaxws.san.wo.FabricKeyDO;
import com.cisco.dcbu.jaxws.san.wo.InventoryBaseDO;
import com.cisco.dcbu.jaxws.san.wo.NameKeyDO;
import com.cisco.dcbu.jaxws.san.wo.SwitchIndexDO;
import com.cisco.dcbu.jaxws.san.wo.VsanFcIDDO;
import com.cisco.dcbu.jaxws.san.wo.VsanFportKeyDO;
import com.cisco.dcbu.jaxws.san.wo.WwnDO;
import com.cisco.dcbu.jaxws.san.wo.WwnKeyDO;
import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.mds.MibVariableFormat;
import com.cisco.dcbu.sm.common.model.EndPortBase;
import com.cisco.dcbu.sm.common.model.FcPortBase;
import com.cisco.dcbu.sm.common.type.VsanFcIdKey;
import com.cisco.dcbu.sm.common.type.VsanFportKey;
import com.cisco.dcbu.sm.server.model.EndPortImpl;
import com.cisco.dcbu.sm.server.web.util.DisplayUtil;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="EndPort")
public class EndPortDO
extends InventoryBaseDO
implements Serializable {
    private WwnKeyDO key;
    protected WwnDO nWwn;
    protected boolean isLoop;
    protected int index;
    protected String symPortName;
    protected String symNodeName;
    protected String nodeIpAddress;
    protected NameKeyDO enclosurePK;
    protected String enclosure;
    protected String autoAlias;
    protected long enclDbId;
    protected FabricKeyDO fabricKey;
    protected SwitchIndexDO fPortKey;
    protected int ifType;
    protected int fcIfAdminMode;
    protected int ifAdminStatus;
    protected int operMode;
    protected int ifOperStatus;
    protected String ifName;
    protected WwnDO fWwn;
    protected String portWwn;
    protected String fcIdStr = "";
    protected String portDesc = "";
    protected String network;
    protected String scope;
    protected long speed;
    protected String speedStr;
    protected String operStatusCause;
    protected List<VsanFcIDDO> vsanFcIds = new ArrayList<VsanFcIDDO>();
    protected List<VsanFportKeyDO> vsanFports = new ArrayList<VsanFportKeyDO>();
    protected InetAddress enclosureIp;
    protected String alias;
    protected String deviceAlias;
    protected String rawFcid;
    protected String switchInterface;
    protected String linkStatus;
    protected String displayName;
    protected String fabricName;
    protected String endDeviceType;
    protected String vsanId;
    protected String[] displayHdrs = null;
    protected String[] displayValues = null;
    protected boolean host;
    protected boolean target;

    public int getIfAdminStatus() {
        return this.ifAdminStatus;
    }

    public void setIfAdminStatus(int ifAdminStatus) {
        this.ifAdminStatus = ifAdminStatus;
    }

    public String getLinkStatus() {
        return this.linkStatus;
    }

    public void setLinkStatus(String linkStatus) {
        this.linkStatus = linkStatus;
    }

    public String getSwitchInterface() {
        return this.switchInterface;
    }

    public void setSwitchInterface(String switchInterface) {
        this.switchInterface = switchInterface;
    }

    public String getRawFcid() {
        return this.rawFcid;
    }

    public void setRawFcid(String rawFcid) {
        this.rawFcid = rawFcid;
    }

    public String getDeviceAlias() {
        return this.deviceAlias;
    }

    public void setDeviceAlias(String deviceAlias) {
        this.deviceAlias = deviceAlias;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public EndPortDO() {
    }

    public EndPortDO(EndPortBase ep) {
        this.key = new WwnKeyDO(ep.getEndPortPK());
        this.nWwn = new WwnDO(ep.getNodeWwn());
        this.portWwn = this.nWwn.value;
        this.symPortName = ep.getSymPortName();
        this.symNodeName = ep.getSymNodeName();
        this.nodeIpAddress = ep.getNodeIpAddress();
        this.enclosurePK = new NameKeyDO(ep.getEnclosurePK());
        this.enclosure = this.enclosurePK.getName();
        this.autoAlias = ep.getAutoAlias();
        this.fPortKey = new SwitchIndexDO(ep.getFPortPK());
        this.fabricKey = new FabricKeyDO(ep.getFabricPK());
        this.ifName = ep.getIfName();
        if (this.ifName == null) {
            this.ifName = IfIndexUtil.ifIndexToName(this.fPortKey.getIndex());
        }
        this.fWwn = new WwnDO(ep.getfWwn());
        this.speed = ep.getSpeed();
        this.operStatusCause = MibVariableFormat.toCauseString(ep.getOperStatusCause());
        this.setFcIds(ep.getVsanFcIds());
        this.setVsanFports(ep.getVsanFports());
        this.displayName = ep.getName();
        this.lastScanTime = ep.getLastScanTime();
        this.displayHdrs = new String[]{"Name", "Enclosure", "Port WWN", "FcId", "Switch Interface", "If Speed", "Link Staus"};
        this.displayValues = new String[]{this.displayName, this.enclosure, this.portWwn, this.fcIdStr, this.ifName, this.speedStr, this.operStatusCause};
        this.host = ep.isIntiator();
        this.target = ep.isTarget();
    }

    public EndPortDO(EndPortBase ep, FcPortBase fcp) {
        this(ep);
        if (fcp != null) {
            this.ifOperStatus = fcp.getIfOPerStatus();
            this.fcIfAdminMode = fcp.getFcifAdminMode();
            this.ifAdminStatus = fcp.getIfAdminStatus();
            this.operMode = fcp.getIfOperMode();
            this.ifType = fcp.getIfType();
        }
    }

    public EndPortDO(EndPortImpl ep) {
        this((EndPortBase)ep.getBaseObject());
    }

    public EndPortDO(EndPortImpl ep, FcPortBase fcp) {
        this((EndPortBase)ep.getBaseObject(), fcp);
    }

    public void setupMapping() {
        this.displayHdrs = new String[]{"Name", "Enclosure", "Port WWN", "FcId", "Switch Interface", "I/F Speed", "Link Status"};
        this.displayValues = new String[]{this.displayName, this.enclosure, this.portWwn, this.fcIdStr, this.ifName, this.speedStr, this.operStatusCause};
    }

    private void setFcIds(VsanFcIdKey[] keys) {
        if (keys == null) {
            return;
        }
        for (VsanFcIdKey key : keys) {
            VsanFcIDDO fcId = new VsanFcIDDO(key);
            this.fcIdStr = this.fcIdStr + "0x" + Integer.toHexString(fcId.fcID) + " ";
            this.vsanFcIds.add(fcId);
        }
    }

    private void setVsanFports(VsanFportKey[] keys) {
        if (keys == null) {
            return;
        }
        for (VsanFportKey key : keys) {
            VsanFportKeyDO fprKey = new VsanFportKeyDO(key);
            this.vsanFports.add(fprKey);
        }
    }

    public String getFcIdStr() {
        return this.fcIdStr;
    }

    public void setFcIdStr(String fcIdStr) {
        this.fcIdStr = fcIdStr;
    }

    public WwnKeyDO getKey() {
        return this.key;
    }

    public void setKey(WwnKeyDO key) {
        this.key = key;
    }

    public WwnDO getNWwn() {
        return this.nWwn;
    }

    public void setNWwn(WwnDO wwn) {
        this.nWwn = wwn;
    }

    public boolean isLoop() {
        return this.isLoop;
    }

    public void setLoop(boolean isLoop) {
        this.isLoop = isLoop;
    }

    public String getSymPortName() {
        return this.symPortName;
    }

    public void setSymPortName(String symPortName) {
        this.symPortName = symPortName;
    }

    public String getSymNodeName() {
        return this.symNodeName;
    }

    public void setSymNodeName(String symNodeName) {
        this.symNodeName = symNodeName;
    }

    public String getNodeIpAddress() {
        return this.nodeIpAddress;
    }

    public void setNodeIpAddress(String nodeIpAddress) {
        this.nodeIpAddress = nodeIpAddress;
    }

    public NameKeyDO getEnclosurePK() {
        return this.enclosurePK;
    }

    public String getEnclosure() {
        if (this.enclosure != null) {
            return this.enclosure;
        }
        return this.enclosurePK.getName();
    }

    public String setEnclosure(String enc) {
        this.enclosure = enc;
        return this.enclosure;
    }

    public void setEnclosurePK(NameKeyDO enclosurePK) {
        this.enclosurePK = enclosurePK;
    }

    public String getAutoAlias() {
        return this.autoAlias;
    }

    public void setAutoAlias(String autoAlias) {
        this.autoAlias = autoAlias;
    }

    public FabricKeyDO getFabricKey() {
        return this.fabricKey;
    }

    public void setFabricKey(FabricKeyDO fabricKey) {
        this.fabricKey = fabricKey;
    }

    public String getIfName() {
        return this.ifName;
    }

    public void setIfName(String ifName) {
        this.ifName = ifName;
    }

    public WwnDO getFWwn() {
        return this.fWwn;
    }

    public void setFWwn(WwnDO wwn) {
        this.fWwn = wwn;
    }

    public long getSpeed() {
        return this.speed;
    }

    public void setSpeed(long speed) {
        this.speed = speed;
    }

    public String getOperStatusCause() {
        return this.operStatusCause;
    }

    public void setOperStatusCause(String operStatusCause) {
        this.operStatusCause = operStatusCause;
    }

    public List<VsanFcIDDO> getVsanFcIds() {
        return this.vsanFcIds;
    }

    public void setVsanFcIds(List<VsanFcIDDO> vsanFcIds) {
        this.vsanFcIds = vsanFcIds;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String name) {
        this.displayName = name;
    }

    public static EndPortDO[] clone(List<EndPortImpl> eps) {
        EndPortDO[] endports = new EndPortDO[eps.size()];
        int i = 0;
        for (EndPortImpl ep : eps) {
            endports[i] = new EndPortDO(ep);
            ++i;
        }
        return endports;
    }

    public String[] getDisplayHdrs() {
        return this.displayHdrs;
    }

    public void setDisplayHdrs(String[] displayHdrs) {
        this.displayHdrs = displayHdrs;
    }

    public String[] getDisplayValues() {
        return this.displayValues;
    }

    public void setDisplayValues(String[] displayValues) {
        this.displayValues = displayValues;
    }

    public String getFabricName() {
        return this.fabricName;
    }

    public void setFabricName(String fabricName) {
        this.fabricName = fabricName;
    }

    public String getVsanId() {
        return this.vsanId;
    }

    public void setVsanId(String vsanId) {
        this.vsanId = vsanId;
    }

    public String getPortWwn() {
        return this.portWwn;
    }

    public void setPortWwn(String portWwn) {
        this.portWwn = portWwn;
    }

    public String getEndDeviceType() {
        return this.endDeviceType;
    }

    public void setEndDeviceType(String endDeviceType) {
        this.endDeviceType = endDeviceType;
    }

    public String getPortDesc() {
        return this.portDesc;
    }

    public void setPortDesc(String portDesc) {
        this.portDesc = portDesc;
    }

    public String getSpeedStr() {
        return this.speedStr;
    }

    public void setSpeedStr(String speedStr) {
        this.speedStr = speedStr;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public WwnDO getnWwn() {
        return this.nWwn;
    }

    public void setnWwn(WwnDO nWwn) {
        this.nWwn = nWwn;
    }

    public SwitchIndexDO getfPortKey() {
        return this.fPortKey;
    }

    public void setfPortKey(SwitchIndexDO fPortKey) {
        this.fPortKey = fPortKey;
    }

    public WwnDO getfWwn() {
        return this.fWwn;
    }

    public void setfWwn(WwnDO fWwn) {
        this.fWwn = fWwn;
    }

    public List<VsanFportKeyDO> getVsanFports() {
        return this.vsanFports;
    }

    public void setVsanFports(List<VsanFportKeyDO> vsanFports) {
        this.vsanFports = vsanFports;
    }

    public InetAddress getEnclosureIp() {
        return this.enclosureIp;
    }

    public void setEnclosureIp(InetAddress enclosureIp) {
        this.enclosureIp = enclosureIp;
    }

    public static EndPortDO getDeviceByAlias(Collection in, String aliases) {
        if (in == null || in.size() == 0) {
            return null;
        }
        for (Object device : in) {
            String alias;
            if (device == null || (alias = ((EndPortDO)device).getDeviceAlias()) == null || !alias.equals(aliases)) continue;
            return (EndPortDO)device;
        }
        return null;
    }

    public static EndPortDO getDeviceByWwn(Collection in, byte[] wwn) {
        if (in == null || in.size() == 0 || wwn == null || wwn.length == 0) {
            return null;
        }
        String theWwn = DisplayUtil.getWwn(wwn).toString();
        for (Object device : in) {
            String pWwn;
            if (device == null || !theWwn.equals(pWwn = ((EndPortDO)device).getPortWwn())) continue;
            return (EndPortDO)device;
        }
        return null;
    }

    public boolean isHost() {
        return this.host;
    }

    public void setHost(boolean host) {
        this.host = host;
    }

    public boolean isTarget() {
        return this.target;
    }

    public void setTarget(boolean target) {
        this.target = target;
    }

    public String getNetwork() {
        return this.network;
    }

    public void setNetwork(String network) {
        this.network = network;
    }

    public int getIfType() {
        return this.ifType;
    }

    public void setIfType(int ifType) {
        this.ifType = ifType;
    }

    public int getFcIfAdminMode() {
        return this.fcIfAdminMode;
    }

    public void setFcIfAdminMode(int fcIfAdminMode) {
        this.fcIfAdminMode = fcIfAdminMode;
    }

    public int getIfOperStatus() {
        return this.ifOperStatus;
    }

    public void setIfOperStatus(int ifOperStatus) {
        this.ifOperStatus = ifOperStatus;
    }

    public int getOperMode() {
        return this.operMode;
    }

    public void setOperMode(int operMode) {
        this.operMode = operMode;
    }

    public String getScope() {
        if (this.network != null && this.network.equalsIgnoreCase("SAN")) {
            return this.fabricName;
        }
        return this.network;
    }

    public long getEnclDbId() {
        return this.enclDbId;
    }

    public void setEnclDbId(long enclDbId) {
        this.enclDbId = enclDbId;
    }
}

