/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.jaxws.san.wo;

import com.cisco.dcbu.jaxws.san.wo.HwInventoryTypeDO;
import com.cisco.dcbu.jaxws.san.wo.InventoryBaseDO;
import com.cisco.dcbu.jaxws.san.wo.SwitchIntKeyDO;
import com.cisco.dcbu.sm.common.model.HwInventoryComponent;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.SerialNumKey;
import com.cisco.dcbu.sm.common.type.WwnKey;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="HwInventoryComponent")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class HwInventoryComponentDO
extends InventoryBaseDO {
    protected String swKey;
    protected SwitchKeyType swKeyType;
    protected int physicalIndex;
    protected String name;
    protected int[] vendorType;
    protected HwInventoryTypeDO hardwareType = HwInventoryTypeDO.UNKNOWN;
    protected int relativePosition;
    protected String hardwareRevision;
    protected String firmwareRevision;
    protected String softwareRevision;
    protected String serialNumber;
    protected String secSerialNumber;
    protected String manufacturer;
    protected String modelName;
    protected String assetId;
    protected String statusDescr;
    protected SwitchIntKeyDO key;

    protected HwInventoryComponentDO() {
    }

    public HwInventoryComponentDO(PKIf swPK, int phyIndex, String name, int[] vendorType, int hwType, int relPos, String hwRev, String fwRev, String swRev, String serialNum, String manufacturer, String modelName, String assetId, String status, String secSerialNum, long lastScanTime) {
        if (swPK instanceof SerialNumKey) {
            this.swKey = ((SerialNumKey)swPK)._serialNum;
            this.swKeyType = SwitchKeyType.SerialNum;
        } else if (swPK instanceof WwnKey) {
            this.swKey = ((WwnKey)swPK)._wwn.toString();
            this.swKeyType = SwitchKeyType.Wwn;
        } else {
            this.swKey = String.valueOf(swPK);
            this.swKeyType = SwitchKeyType.Other;
        }
        this.physicalIndex = phyIndex;
        this.name = name;
        if (vendorType != null) {
            this.vendorType = new int[vendorType.length];
            System.arraycopy(vendorType, 0, this.vendorType, 0, vendorType.length);
        }
        this.hardwareType = HwInventoryTypeDO.getType(hwType);
        this.relativePosition = relPos;
        this.hardwareRevision = hwRev;
        this.firmwareRevision = fwRev;
        this.softwareRevision = swRev;
        this.serialNumber = serialNum;
        this.secSerialNumber = secSerialNum;
        this.manufacturer = manufacturer;
        this.modelName = modelName;
        this.assetId = assetId;
        this.statusDescr = status;
        this.key = new SwitchIntKeyDO(this.swKey, this.physicalIndex);
        this.lastScanTime = lastScanTime;
    }

    public HwInventoryComponentDO(HwInventoryComponent hw) {
        this((PKIf)hw.getSwitchPK(), hw.getPhysicalIndex(), hw.getName(), hw.getVendorType(), hw.getHardwareType().value(), hw.getSlotId(), hw.getHardwareRevision(), hw.getFirmwareRevision(), hw.getSoftwareRevision(), hw.getSerialNumber(), hw.getManufacturer(), hw.getModelName(), hw.getAssetId(), hw.getStatusDescr(), hw.getSecSerialNumber(), hw.getLastScanTime());
    }

    public String toString() {
        return "HwInventoryComponent=" + this.key.toString() + ", type=" + this.hardwareType;
    }

    public String getAssetId() {
        return this.assetId;
    }

    public void setAssetId(String assetId) {
        this.assetId = assetId;
    }

    public String getFirmwareRevision() {
        return this.firmwareRevision;
    }

    public void setFirmwareRevision(String firmwareRevision) {
        this.firmwareRevision = firmwareRevision;
    }

    public String getHardwareRevision() {
        return this.hardwareRevision;
    }

    public void setHardwareRevision(String hardwareRevision) {
        this.hardwareRevision = hardwareRevision;
    }

    public HwInventoryTypeDO getHardwareType() {
        return this.hardwareType;
    }

    public void setHardwareType(HwInventoryTypeDO hardwareType) {
        this.hardwareType = hardwareType;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getPhysicalIndex() {
        return this.physicalIndex;
    }

    public void setPhysicalIndex(int physicalIndex) {
        if (this.physicalIndex != physicalIndex) {
            this.physicalIndex = physicalIndex;
            this.key = new SwitchIntKeyDO(this.swKey, physicalIndex);
        }
    }

    public int getRelativePosition() {
        return this.relativePosition;
    }

    public void setRelativePosition(int relativePosition) {
        this.relativePosition = relativePosition;
    }

    public String getSecSerialNumber() {
        return this.secSerialNumber;
    }

    public void setSecSerialNumber(String secSerialNumber) {
        this.secSerialNumber = secSerialNumber;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public String getSoftwareRevision() {
        return this.softwareRevision;
    }

    public void setSoftwareRevision(String softwareRevision) {
        this.softwareRevision = softwareRevision;
    }

    public String getStatusDescr() {
        return this.statusDescr;
    }

    public void setStatusDescr(String statusDescr) {
        this.statusDescr = statusDescr;
    }

    public String getSwKey() {
        return this.swKey;
    }

    public void setSwKey(PKIf swPK) {
        String newPK = String.valueOf(swPK);
        if (!newPK.equals(this.swKey)) {
            this.swKey = newPK;
            this.key = new SwitchIntKeyDO(this.swKey, this.physicalIndex);
        }
    }

    public int[] getVendorType() {
        return this.vendorType;
    }

    public void setVendorType(int[] vendorType) {
        this.vendorType = vendorType;
    }

    public int getSlotId() {
        return this.relativePosition;
    }

    public SwitchIntKeyDO getKey() {
        return this.key;
    }

    public void setKey(SwitchIntKeyDO key) {
        this.key = key;
    }

    public static enum SwitchKeyType {
        Wwn(0),
        SerialNum(1),
        Other(2);

        private int value;

        private SwitchKeyType(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public static final SwitchKeyType getType(int value) {
            for (SwitchKeyType t : SwitchKeyType.values()) {
                if (t.value != value) continue;
                return t;
            }
            throw new IllegalArgumentException("Invalid type value:" + value);
        }

        public static final SwitchKeyType getType(String typeName) {
            for (SwitchKeyType t : SwitchKeyType.values()) {
                if (!t.name().equalsIgnoreCase(typeName)) continue;
                return t;
            }
            throw new IllegalArgumentException("Invalid type name:" + typeName);
        }
    }
}

