/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.jaxws.san.wo;

import com.cisco.dcbu.jaxws.san.wo.InventoryBaseDO;
import com.cisco.dcbu.jaxws.san.wo.LicenseFlagDO;
import com.cisco.dcbu.jaxws.san.wo.SwitchNameKeyDO;
import com.cisco.dcbu.sm.common.model.LicenseInfo;
import com.cisco.dcbu.sm.common.type.WwnKey;
import java.io.Serializable;
import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="LicenseInfo")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class LicenseInfoDO
extends InventoryBaseDO
implements Serializable {
    protected SwitchNameKeyDO licKey;
    private byte flags;
    private int currentUsage;
    private int maxUsage;
    private int missingUsage;
    private long expireDate;
    private int gracePeriod;

    protected LicenseInfoDO() {
    }

    public LicenseInfoDO(SwitchNameKeyDO licKey, byte flags, int curUsage, int maxUsage, int misUsage, long expireDate, int gracePeriod, long lastScanTime) {
        this.licKey = licKey;
        this.flags = flags;
        this.currentUsage = curUsage;
        this.maxUsage = maxUsage;
        this.missingUsage = misUsage;
        this.expireDate = expireDate;
        if (LicenseFlagDO.isEval(flags)) {
            // empty if block
        }
        this.lastScanTime = lastScanTime;
    }

    public LicenseInfoDO(WwnKey swPK, String name, byte flags, int curUsage, int maxUsage, int misUsage, long expireTime, int gracePeriod, long lastScanTime) {
        this(new SwitchNameKeyDO(swPK, name), flags, curUsage, maxUsage, misUsage, expireTime, gracePeriod, lastScanTime);
    }

    public LicenseInfoDO(LicenseInfo licInfo) {
        this(new SwitchNameKeyDO(licInfo._pkey), licInfo.getFlags(), licInfo.getCurrentUsage(), licInfo.getMaxUsage(), licInfo.getMissingUsage(), licInfo.getExpDate() == null ? 0L : licInfo.getExpDate().getTimeInMillis(), licInfo.getGracePeriod(), licInfo.getLastScanTime());
    }

    public boolean isCheckedout() {
        return this.currentUsage != 0;
    }

    public long timeLeft() {
        long left;
        if (LicenseFlagDO.isPermanent(this.flags)) {
            return 1L;
        }
        if (LicenseFlagDO.isEval(this.flags) && this.gracePeriod > 0) {
            left = (long)this.gracePeriod - (System.currentTimeMillis() - this.getLastScanTime()) / 1000L;
            if (left > 0L) {
                return left;
            }
            this.gracePeriod = 0;
        }
        if (LicenseFlagDO.isDemo(this.flags) && this.expireDate > 0L) {
            left = this.expireDate - System.currentTimeMillis();
            if (left > 0L) {
                return left / 1000L;
            }
            this.expireDate = 0L;
        }
        return 0L;
    }

    public boolean canCheckout() {
        return LicenseFlagDO.isPermanent(this.flags) || LicenseFlagDO.isDemo(this.flags) && this.timeLeft() > 0L || LicenseFlagDO.isEval(this.flags) && this.timeLeft() > 0L;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.licKey)).append(" - ");
        if (LicenseFlagDO.isDemo(this.flags)) {
            sb.append("Demo License ");
            if (this.expireDate >= 0L) {
                sb.append("Expires on ").append(new Date(this.expireDate));
            } else {
                sb.append("Expired");
            }
        }
        if (LicenseFlagDO.isPermanent(this.flags)) {
            sb.append("Permanent License ");
        }
        if (!LicenseFlagDO.isUnlicensed(this.flags)) {
            sb.append("Eval License ");
        }
        if (LicenseFlagDO.isEval(this.flags)) {
            int left = (int)this.timeLeft();
            if (left <= 0) {
                this.gracePeriod = 0;
                sb.append("Grace Period Expired");
            } else {
                sb.append("Grace Period: ");
                int secs = left % 60;
                int mins = left / 60;
                int hours = mins / 60;
                int days = hours / 24;
                sb.append(days > 0 ? days + " days " : "").append(hours > 0 ? (hours %= 24) + " hours " : "").append(mins > 0 ? (mins %= 60) + " mins " : "").append(secs > 0 ? secs + " seconds " : "");
            }
        }
        if (this.canCheckout()) {
            if (!this.isCheckedout()) {
                sb.append(", not ");
            }
            sb.append("checked out");
        }
        sb.append(", current usage: ").append(this.currentUsage).append(", max usage: ").append(this.maxUsage).append(", missing usage: ").append(this.missingUsage);
        return sb.toString();
    }

    public int getCurrentUsage() {
        return this.currentUsage;
    }

    public void setCurrentUsage(int currentUsage) {
        this.currentUsage = currentUsage;
    }

    public long getExpireDate() {
        return this.expireDate;
    }

    public void setExpireDate(long expireDate) {
        this.expireDate = expireDate;
    }

    public byte getFlags() {
        return this.flags;
    }

    public void setFlags(byte flags) {
        this.flags = flags;
    }

    public int getGracePeriod() {
        return this.gracePeriod;
    }

    public void setGracePeriod(int gracePeriod) {
        this.gracePeriod = gracePeriod;
    }

    public SwitchNameKeyDO getLicKey() {
        return this.licKey;
    }

    public void setLicKey(SwitchNameKeyDO licKey) {
        this.licKey = licKey;
    }

    public int getMaxUsage() {
        return this.maxUsage;
    }

    public void setMaxUsage(int maxUsage) {
        this.maxUsage = maxUsage;
    }

    public int getMissingUsage() {
        return this.missingUsage;
    }

    public void setMissingUsage(int missingUsage) {
        this.missingUsage = missingUsage;
    }
}

