/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.jaxws.san.wo;

import com.cisco.dcbu.jaxws.san.wo.WwnDO;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.common.model.SwitchLicenseDetails;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="Switch")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SwitchDO
implements Serializable,
Comparator,
Comparable {
    private static final long serialVersionUID = 1L;
    protected String name;
    protected int domainID;
    protected WwnDO wwn;
    protected short[] membership;
    protected int ports;
    protected String model;
    protected String version;
    protected long upTime;
    protected String ipAddress = "";
    protected String[] mgmtAddress;
    protected String vendor;
    protected String[] displayHdrs = null;
    protected String[] displayValues = null;
    public long colDBId;
    public long fid;
    protected boolean isLan = false;
    protected boolean present;
    protected boolean licenseViolation;
    protected boolean managable;
    protected boolean mds;
    protected int connUnitStatus;
    protected int standbySupState;
    protected int activeSupSlot;
    protected String unmanagableCause;
    protected long lastScanTime;
    protected String fabricName;
    protected int modelType;
    protected String logicalName;
    protected long switchDbID;
    protected String release;
    protected String location;
    protected String contact;
    protected String upTimeStr;
    protected int upTimeNumber;
    protected String network;
    protected String nonMdsModel;
    protected int numberOfPorts;
    protected int availPorts;
    protected int usedPorts;
    protected WwnDO vsanWwn;
    protected String vsanWwnName;
    protected WwnDO swWwn;
    protected String swWwnName;
    protected String serialNumber;
    protected String domain;
    protected String principal;
    protected String status;
    protected int index;
    protected String licenseDetail;
    protected boolean isPmCollect;
    protected int vdcId;
    protected String vdcName = "";
    protected String vdcMac;
    protected boolean fcoeEnabled;
    protected int cpuUsage;
    protected int memoryUsage;
    protected String scope;
    protected boolean fex = false;
    protected int health = -1;
    protected boolean npvEnabled;
    protected String linkName = null;
    protected String username = null;
    protected String primaryIP = "";

    public SwitchDO() {
    }

    public SwitchDO(SwitchImpl sw) {
        this((SwitchBase)sw.getBaseObject());
    }

    public SwitchDO(SwitchBase sw) {
        this.wwn = new WwnDO(sw.getWwn().getValue());
        this.domainID = sw.getDomainId((short)0);
        this.name = sw.getSysName();
        this.model = sw.getModel();
        this.ports = sw.getNumFcPorts();
        this.upTime = sw.getSwitchUpTime();
        this.version = sw.getVersion();
        this.setVsanMembership(sw.getVsanMembership());
        this.wwn = new WwnDO(sw.getWwn().getValue());
        this.ipAddress = sw.getIpAddress();
        this.vendor = sw.getVendor();
        InetAddress[] mgmtAddrs = sw.getManagementAddresses();
        if (mgmtAddrs != null) {
            this.mgmtAddress = new String[mgmtAddrs.length];
            for (int i = 0; i < mgmtAddrs.length; ++i) {
                if (mgmtAddrs[i] == null) continue;
                this.mgmtAddress[i] = mgmtAddrs[i].toString();
            }
        }
        this.present = sw.isPresent();
        SwitchLicenseDetails licDetails = sw.getLicenseDetails();
        if (licDetails != null) {
            this.licenseDetail = licDetails.isEval() ? licDetails.getLicenseState() + " - " + licDetails.getExpireDateStr() : licDetails.getLicenseState();
        }
        this.npvEnabled = sw.isNpvEnabled();
    }

    private void setVsanMembership(Collection<Short> membership) {
        Iterator<Short> itr = membership.iterator();
        this.membership = new short[membership.size()];
        int i = 0;
        while (itr.hasNext()) {
            short id;
            this.membership[i] = id = itr.next().shortValue();
            ++i;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getDomainID() {
        return this.domainID;
    }

    public void setDomainID(int domainID) {
        this.domainID = domainID;
    }

    public boolean isLan() {
        return this.isLan;
    }

    public void setLan(boolean isLan) {
        this.isLan = isLan;
    }

    public WwnDO getWwn() {
        return this.wwn;
    }

    public void setWwn(WwnDO wwn) {
        this.wwn = wwn;
    }

    public short[] getMembership() {
        return this.membership;
    }

    public void setMembership(short[] membership) {
        this.membership = membership;
    }

    public int getPorts() {
        return this.ports;
    }

    public void setPorts(int ports) {
        this.ports = ports;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public long getUpTime() {
        return this.upTime;
    }

    public void setUpTime(long upTime) {
        this.upTime = upTime;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String[] getMgmtAddress() {
        return this.mgmtAddress;
    }

    public void setMgmtAddress(String[] mgmtAddress) {
        this.mgmtAddress = mgmtAddress;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public String[] getDisplayHdrs() {
        return this.displayHdrs;
    }

    public void setDisplayHdrs(String[] displayHdrs) {
        this.displayHdrs = displayHdrs;
    }

    public String[] getDisplayValues() {
        return this.displayValues;
    }

    public void setDisplayValues(String[] displayValues) {
        this.displayValues = displayValues;
    }

    public static SwitchDO[] clone(SwitchImpl[] switches) {
        SwitchDO[] list = new SwitchDO[switches.length];
        for (int i = 0; i < switches.length; ++i) {
            list[i] = new SwitchDO(switches[i]);
            ++i;
        }
        return list;
    }

    public boolean isPresent() {
        return this.present;
    }

    public void setPresent(boolean present) {
        this.present = present;
    }

    public boolean isLicenseViolation() {
        return this.licenseViolation;
    }

    public void setLicenseViolation(boolean licenseViolation) {
        this.licenseViolation = licenseViolation;
    }

    public boolean isManagable() {
        return this.managable;
    }

    public void setManagable(boolean managable) {
        this.managable = managable;
    }

    public boolean isMds() {
        return this.mds;
    }

    public void setMds(boolean mds) {
        this.mds = mds;
    }

    public int getConnUnitStatus() {
        return this.connUnitStatus;
    }

    public void setConnUnitStatus(int connUnitStatus) {
        this.connUnitStatus = connUnitStatus;
    }

    public int getStandbySupState() {
        return this.standbySupState;
    }

    public void setStandbySupState(int standbySupState) {
        this.standbySupState = standbySupState;
    }

    public int getActiveSupSlot() {
        return this.activeSupSlot;
    }

    public void setActiveSupSlot(int activeSupSlot) {
        this.activeSupSlot = activeSupSlot;
    }

    public String getUnmanagableCause() {
        return this.unmanagableCause;
    }

    public void setUnmanagableCause(String unmanagableCause) {
        this.unmanagableCause = unmanagableCause;
    }

    public long getLastScanTime() {
        return this.lastScanTime;
    }

    public void setLastScanTime(long lastScanTime) {
        this.lastScanTime = lastScanTime;
    }

    public String getFabricName() {
        return this.fabricName;
    }

    public void setFabricName(String fabricName) {
        this.fabricName = fabricName;
    }

    public int getModelType() {
        return this.modelType;
    }

    public void setModelType(int modelType) {
        this.modelType = modelType;
    }

    public String getLogicalName() {
        return this.logicalName;
    }

    public String getLinkName() {
        return this.linkName;
    }

    public void setLinkName(String name) {
        this.linkName = name;
    }

    public void setLogicalName(String logicalName) {
        this.logicalName = logicalName;
    }

    public long getSwitchDbID() {
        return this.switchDbID;
    }

    public void setSwitchDbID(long switchDbID) {
        this.switchDbID = switchDbID;
    }

    public String getRelease() {
        return this.release;
    }

    public void setRelease(String release) {
        this.release = release;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getContact() {
        return this.contact;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    public String getUpTimeStr() {
        return this.upTimeStr;
    }

    public void setUpTimeStr(String upTimeStr) {
        this.upTimeStr = upTimeStr;
    }

    public int getUpTimeNumber() {
        return this.upTimeNumber;
    }

    public void setUpTimeNumber(int upTimeNumber) {
        this.upTimeNumber = upTimeNumber;
    }

    public String getNetwork() {
        return this.network;
    }

    public void setNetwork(String network) {
        this.network = network;
    }

    public String getNonMdsModel() {
        return this.nonMdsModel;
    }

    public void setNonMdsModel(String nonMdsModel) {
        this.nonMdsModel = nonMdsModel;
    }

    public int getNumberOfPorts() {
        return this.numberOfPorts;
    }

    public String getNumberOfPortsStr() {
        if (this.numberOfPorts < 1) {
            return "";
        }
        return Integer.toString(this.numberOfPorts);
    }

    public void setNumberOfPorts(int numberOfPorts) {
        this.numberOfPorts = numberOfPorts;
    }

    public int getUsedPorts() {
        return this.usedPorts;
    }

    public String getUsedPortsStr() {
        if (this.numberOfPorts < 1) {
            return "";
        }
        return Integer.toString(this.usedPorts);
    }

    public void setUsedPorts(int usedPorts) {
        this.usedPorts = usedPorts;
    }

    public int getAvailPorts() {
        return this.availPorts;
    }

    public String getAvailPortsStr() {
        if (this.numberOfPorts < 1) {
            return "";
        }
        return Integer.toString(this.availPorts);
    }

    public void setAvailPorts(int availPorts) {
        this.availPorts = availPorts;
    }

    public WwnDO getVsanWwn() {
        return this.vsanWwn;
    }

    public void setVsanWwn(WwnDO vsanWwn) {
        this.vsanWwn = vsanWwn;
    }

    public String getVsanWwnName() {
        return this.vsanWwnName;
    }

    public void setVsanWwnName(String vsanWwnName) {
        this.vsanWwnName = vsanWwnName;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public WwnDO getSwWwn() {
        return this.swWwn;
    }

    public void setSwWwn(WwnDO swWwn) {
        this.swWwn = swWwn;
    }

    public String getSwWwnName() {
        return this.swWwnName;
    }

    public void setSerialNumber(String serial) {
        this.serialNumber = serial;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSwWwnName(String swWwnName) {
        this.swWwnName = swWwnName;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setupMapping() {
        this.displayHdrs = new String[]{"Name", "IP Address", "Fabric", "WWN", "FC Ports", "Vendor", "Model", "Release", "UpTime"};
        this.displayValues = new String[]{this.logicalName, this.ipAddress, this.fabricName, this.swWwnName, this.numberOfPorts + "", this.vendor, this.model, this.release, this.upTimeStr};
    }

    public String getLicenseDetail() {
        return this.licenseDetail;
    }

    public void setLicenseDetail(String licenseDetail) {
        this.licenseDetail = licenseDetail;
    }

    public boolean isPmCollect() {
        return this.isPmCollect;
    }

    public void setPmCollect(boolean isPmCollect) {
        this.isPmCollect = isPmCollect;
    }

    public int getVdcId() {
        return this.vdcId;
    }

    public void setVdcId(int id) {
        this.vdcId = id;
    }

    public String getVdcName() {
        return this.vdcName;
    }

    public void setVdcName(String name) {
        this.vdcName = name;
    }

    public String getVdcMac() {
        return this.vdcMac;
    }

    public void setVdcMac(String mac) {
        this.vdcMac = mac;
    }

    public boolean isFcoeEnabled() {
        return this.fcoeEnabled;
    }

    public void setFcoeEnabled(boolean fcoeEnabled) {
        this.fcoeEnabled = fcoeEnabled;
    }

    public int getCpuUsage() {
        return this.cpuUsage;
    }

    public void setCpuUsage(int cpu) {
        this.cpuUsage = cpu;
    }

    public int getMemoryUsage() {
        return this.memoryUsage;
    }

    public void setMemoryUsage(int memory) {
        this.memoryUsage = memory;
    }

    public String getScope() {
        if (this.network != null && this.network.equalsIgnoreCase("SAN")) {
            return this.fabricName;
        }
        return this.network;
    }

    public int getHealth() {
        return this.health;
    }

    public void setHealth(int health) {
        this.health = health;
    }

    public String getHealthStr() {
        if (this.health == -1) {
            return "";
        }
        return Integer.toString(this.health) + "%";
    }

    public String toString() {
        return this.name != null ? this.name : "";
    }

    public int compare(Object o1, Object o2) {
        if (o1 == o2) {
            return 0;
        }
        return ((SwitchDO)o1).toString().compareTo(((SwitchDO)o2).toString());
    }

    public int compareTo(Object o) {
        return this.compare(this, o);
    }

    public long getColDBId() {
        return this.colDBId;
    }

    public void setColDBId(long colDBId) {
        this.colDBId = colDBId;
    }

    public long getFid() {
        return this.fid;
    }

    public void setFid(long fid) {
        this.fid = fid;
    }

    public boolean isNpvEnabled() {
        return this.npvEnabled;
    }

    public void setNpvEnabled(boolean npvEnabled) {
        this.npvEnabled = npvEnabled;
    }

    public boolean isFex() {
        return this.fex;
    }

    public void setFex(boolean isFex) {
        this.fex = isFex;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPrimaryIP() {
        return this.primaryIP;
    }

    public void setPrimaryIP(String primary) {
        this.primaryIP = primary;
    }
}

