/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.jaxws.san.wo;

import com.cisco.dcbu.lib.mds.FRUConstants;
import java.io.Serializable;
import java.util.Comparator;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="SwitchName")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SwitchNameDO
implements Serializable,
Comparator,
Comparable {
    public String name;
    public String ipAddress;
    public long colId;
    public long swDbId;
    public int type;
    public boolean isManageble;
    public byte[] wwn;
    public boolean isLanSwitch = false;
    public boolean isMds;
    public boolean isN2K;
    public boolean isOtherLanSwitch;
    public boolean isUcs;
    public boolean isV3;
    public boolean isLicensed;
    public long colDBId;
    public String groupName;
    public boolean isFex;
    public static final int N5K_LAN_SWITCH = 1;
    public static final int N7K_LAN_SWITCH = 2;
    public static final int CAT_LAN_SWITCH = 3;
    public int switchType;
    public boolean isN5KLan = false;
    public boolean isN7KLan = false;
    public boolean isCat = false;

    public boolean isLicensed() {
        return this.isLicensed;
    }

    public void setLicensed(boolean isLicensed) {
        this.isLicensed = isLicensed;
    }

    public SwitchNameDO() {
    }

    public SwitchNameDO(String name, String ipAddress) {
        this.name = name;
        this.ipAddress = ipAddress;
    }

    public SwitchNameDO(String name, String ipAddress, int tpe) {
        this(name, ipAddress, tpe, 0);
    }

    public SwitchNameDO(String name, String ipAddress, int tpe, int swTp) {
        this(name, ipAddress);
        this.type = tpe;
        this.switchType = swTp;
        this.isUcs = FRUConstants.isUCS(this.type);
        this.isMds = FRUConstants.isMdsFamilyType(this.type);
        this.isN5KLan = swTp == 1;
        this.isN7KLan = swTp == 2;
        this.isCat = swTp == 3;
    }

    public int compare(Object o1, Object o2) {
        if (o1 == o2) {
            return 0;
        }
        SwitchNameDO z1 = (SwitchNameDO)o1;
        SwitchNameDO z2 = (SwitchNameDO)o2;
        String nameOrIPAddress1 = z1.name == null ? z1.ipAddress : z1.name;
        String nameOrIPAddress2 = z2.name == null ? z2.ipAddress : z2.name;
        return nameOrIPAddress1.compareToIgnoreCase(nameOrIPAddress2);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        SwitchNameDO z = (SwitchNameDO)obj;
        if (this.ipAddress == null || z.ipAddress == null) {
            return this.ipAddress == z.ipAddress;
        }
        return this.ipAddress.equalsIgnoreCase(z.ipAddress);
    }

    public int compareTo(Object o) {
        return this.compare(this, o);
    }

    public boolean isMds() {
        return this.isMds;
    }

    public void setMds(boolean isMds) {
        this.isMds = isMds;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public boolean isManageble() {
        return this.isManageble;
    }

    public void setManageble(boolean isManageble) {
        this.isManageble = isManageble;
    }

    public boolean isUcs() {
        return this.isUcs;
    }

    public void setUcs(boolean isUcs) {
        this.isUcs = isUcs;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public byte[] getWwn() {
        return this.wwn;
    }

    public void setWwn(byte[] wwn) {
        this.wwn = wwn;
    }

    public boolean isV3() {
        return this.isV3;
    }

    public void setV3(boolean isV3) {
        this.isV3 = isV3;
    }

    public int getSwitchType() {
        return this.switchType;
    }

    public void setSwitchType(int switchType) {
        this.switchType = switchType;
    }

    public long getSwDbId() {
        return this.swDbId;
    }

    public void setSwDbId(long swDbId) {
        this.swDbId = swDbId;
    }

    public long getColId() {
        return this.colId;
    }

    public void setColId(long cId) {
        this.colId = cId;
    }

    public long getColDBId() {
        return this.colDBId;
    }

    public void setColDBId(long fabDBId) {
        this.colDBId = fabDBId;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }
}

