/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.jaxws.san.wo;

import com.cisco.dcbu.jaxws.san.wo.FabricKeyDO;
import com.cisco.dcbu.jaxws.san.wo.VsanKeyDO;
import com.cisco.dcbu.jaxws.san.wo.ZoneDO;
import com.cisco.dcbu.sm.common.model.VsanBase;
import com.cisco.dcbu.sm.common.model.ZoneBase;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="Vsan")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class VsanDO
implements Serializable {
    protected String[] displayHdrs = null;
    protected String[] displayValues = null;
    protected VsanKeyDO key;
    protected FabricKeyDO fkey;
    protected String name;
    protected byte adminState;
    protected byte operState;
    protected byte interopMode;
    protected boolean segmented;
    protected byte loadBalancingType;
    protected String enfZoneSetName;
    @XmlElementWrapper(name="enfZoneSet")
    protected List<ZoneDO> enfZoneSet;
    protected String fabricName;
    protected int vsanId;
    protected String status;
    protected String actZset;
    protected String network;
    protected int index;
    protected String memSwitches;
    protected String scope;

    public VsanDO() {
    }

    public VsanDO(VsanBase vsan) {
        this.key = new VsanKeyDO(vsan.getVsanPK());
        this.fkey = new FabricKeyDO(vsan.getFabricPK());
        this.name = vsan.getName();
        this.adminState = vsan.getAdminState();
        this.operState = vsan.getOperState();
        this.interopMode = vsan.getInterOperMode();
        this.segmented = vsan.isSegmented();
        this.loadBalancingType = vsan.getLoadBalancingType();
        this.enfZoneSetName = vsan.getEnforcedZoneSetName();
        this.enfZoneSet = new ArrayList<ZoneDO>();
        ZoneBase[] zones = vsan.getEnforcedZones();
        if (zones != null) {
            for (ZoneBase zone : zones) {
                this.enfZoneSet.add(new ZoneDO(zone));
            }
        }
        this.displayHdrs = new String[]{"Name", "Vsan Id", "Fabric", "Status", "Activated Zoneset"};
        this.displayValues = new String[]{this.name, this.key.getVsanID() + "", this.fkey.getName(), this.getStatus(), this.enfZoneSetName == null ? "none" : this.enfZoneSetName};
    }

    public String getStatus() {
        if (this.status != null && this.status.length() > 0) {
            return this.status;
        }
        String status = "";
        if (this.operState == 1) {
            status = "up";
        } else if (this.operState == 2) {
            status = "down";
        }
        if (this.segmented) {
            return status + ", segmented.";
        }
        return status;
    }

    public String getVsanStatus() {
        return this.status;
    }

    public byte getAdminState() {
        return this.adminState;
    }

    public void setAdminState(byte adminState) {
        this.adminState = adminState;
    }

    public List<ZoneDO> getEnfZoneSet() {
        return this.enfZoneSet;
    }

    public void setEnfZoneSet(List<ZoneDO> enfZones) {
        this.enfZoneSet = enfZones;
    }

    public String getEnfZoneSetName() {
        return this.enfZoneSetName;
    }

    public void setEnfZoneSetName(String enfZoneSetName) {
        this.enfZoneSetName = enfZoneSetName;
    }

    public FabricKeyDO getFkey() {
        return this.fkey;
    }

    public void setFkey(FabricKeyDO fkey) {
        this.fkey = fkey;
    }

    public byte getInteropMode() {
        return this.interopMode;
    }

    public void setInteropMode(byte interopMode) {
        this.interopMode = interopMode;
    }

    public VsanKeyDO getKey() {
        return this.key;
    }

    public void setKey(VsanKeyDO key) {
        this.key = key;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public byte getOperState() {
        return this.operState;
    }

    public void setOperState(byte operState) {
        this.operState = operState;
    }

    public boolean isSegmented() {
        return this.segmented;
    }

    public void setSegmented(boolean segmented) {
        this.segmented = segmented;
    }

    public String[] getDisplayHdrs() {
        return this.displayHdrs;
    }

    public void setDisplayHdrs(String[] displayHdrs) {
        this.displayHdrs = displayHdrs;
    }

    public String[] getDisplayValues() {
        return this.displayValues;
    }

    public void setDisplayValues(String[] displayValues) {
        this.displayValues = displayValues;
    }

    public void setupMapping() {
        this.displayHdrs = new String[]{"Name", "Vsan Id", "Fabric", "Status", "Activated Zoneset"};
        this.displayValues = new String[]{this.name, this.vsanId + "", this.fabricName, this.status, this.actZset};
    }

    public String getFabricName() {
        return this.fabricName;
    }

    public void setFabricName(String fabricName) {
        this.fabricName = fabricName;
    }

    public int getVsanId() {
        return this.vsanId;
    }

    public void setVsanId(int vsanId) {
        this.vsanId = vsanId;
    }

    public String getActZset() {
        return this.actZset;
    }

    public void setActZset(String actZset) {
        this.actZset = actZset;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String getNetwork() {
        return this.network;
    }

    public void setNetwork(String network) {
        this.network = network;
    }

    public String getMemSwitches() {
        return this.memSwitches;
    }

    public void setMemSwitches(String memSwitches) {
        this.memSwitches = memSwitches;
    }

    public String getScope() {
        if (this.network != null && this.network.equalsIgnoreCase("SAN")) {
            return this.fabricName;
        }
        return this.network;
    }

    public static enum AdminState implements Serializable
    {
        ADMIN_ACTIVE;

    }
}

