/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lan.webservice.client;

import com.cisco.dcbu.jaxws.ep.IdentityManager;
import com.cisco.dcbu.jaxws.lan.ep.util.LanReferenceFactory;
import com.cisco.dcbu.jaxws.san.wo.SnmpCredentialDO;
import com.cisco.dcbu.lan.webservice.client.generated.deepdiscv.DiscTaskKey;
import com.cisco.dcbu.lan.webservice.client.generated.deepdiscv.LanObject;
import com.cisco.dcbu.sm.common.util.TraceLogger;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class LanWSDelegator {
    public static final TraceLogger _Tracer = new TraceLogger(Logger.getLogger((String)"fms"), false, false, false, false);
    private static LanWSDelegator _Instance = null;

    public static LanWSDelegator getInstance() {
        if (_Instance == null) {
            _Instance = new LanWSDelegator();
        }
        return _Instance;
    }

    private LanWSDelegator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyLanLicensedState(String chassisSerialNumber, boolean state) throws Exception {
        String token = null;
        token = this.getToken(IdentityManager.getInstance().getCurrentUsername());
        LanReferenceFactory.getInstance().getLicenseWS(token).modifyLicensedStatusForSingleChassis(chassisSerialNumber, state);
    }

    public DiscTaskKey deepDiscoverLAN(String dcnmUser, String user, String pwd, String enablePwd, String[] swList, boolean[] licensed, DiscTaskKey parentLanTask) throws Exception {
        if (_Tracer.isTraceable()) {
            _Tracer.log(Level.INFO, "Inside LanWSDelegator -> deepDiscoverLAN()");
            _Tracer.log(Level.INFO, "User ==> " + user);
            _Tracer.log(Level.INFO, "Taks Id ==> " + parentLanTask.getTaskId());
        }
        String token = this.getToken(dcnmUser);
        DiscTaskKey discTaskKey = LanReferenceFactory.getInstance().getDeepDiscvWS(token).deepDiscoverLAN(user, pwd, enablePwd, swList, licensed, parentLanTask);
        return discTaskKey;
    }

    public void removeDeepLAN(String dcnmUser, DiscTaskKey deepTaskKey) throws Exception {
        if (_Tracer.isTraceable()) {
            _Tracer.log(Level.INFO, "Inside LanWSDelegator -> removeDeepLAN()");
            _Tracer.log(Level.INFO, "deepTaskKey ==> " + deepTaskKey);
        }
        String token = this.getToken(dcnmUser);
        LanReferenceFactory.getInstance().getDeepDiscvWS(token).removeDeepLAN(deepTaskKey);
    }

    public void removeDeepLANDevices(String dcnmUser, String[] ethSwitches) throws Exception {
        if (_Tracer.isTraceable()) {
            _Tracer.log(Level.INFO, "Inside LanWSDelegator -> removeDeepLAN() -> ethSwitch: " + ethSwitches[0]);
        }
        String token = this.getToken(dcnmUser);
        LanReferenceFactory.getInstance().getDeepDiscvWS(token).removeDeepLANDevices(ethSwitches);
    }

    public void changeDeepLANCredentials(String dcnmUser, DiscTaskKey deepTaskKey, SnmpCredentialDO userCredential, String enablePwd) throws Exception {
        if (_Tracer.isTraceable()) {
            _Tracer.log(Level.INFO, "Inside LanWSDelegator -> changeDeepLANCredentials()");
            _Tracer.log(Level.INFO, "deepTaskKey ==> " + deepTaskKey);
            _Tracer.log(Level.INFO, "Username ==> " + userCredential.getUsername());
        }
        String token = this.getToken(dcnmUser);
        LanReferenceFactory.getInstance().getDeepDiscvWS(token).changeDeepLANCredentials(deepTaskKey, userCredential.getUsername(), userCredential.getV3Password(), enablePwd);
    }

    public void notifyLANMemberChanged(String dcnmUser, DiscTaskKey deepTaskKey, LanObject lanObeject, String attributeName, String oldValue, String newValue) throws Exception {
        if (_Tracer.isTraceable()) {
            _Tracer.log(Level.INFO, "Inside LanWSDelegator -> notifyLANMemberChanged()");
            _Tracer.log(Level.INFO, "deepTaskKey ==> " + deepTaskKey);
            _Tracer.log(Level.INFO, "memberDO ==> " + lanObeject);
            _Tracer.log(Level.INFO, "memberDO ==> " + attributeName);
            _Tracer.log(Level.INFO, "oldValue ==> " + oldValue);
            _Tracer.log(Level.INFO, "newValue ==> " + newValue);
        }
        String token = this.getToken(dcnmUser);
        LanReferenceFactory.getInstance().getDeepDiscvWS(token).notifyLANMemberChanged(deepTaskKey, lanObeject, attributeName, oldValue, newValue);
    }

    public void deepRediscoverForSelectedLanMembers(String dcnmUser, DiscTaskKey deepTaskKey, LanObject[] ethSwitches) throws Exception {
        if (_Tracer.isTraceable()) {
            _Tracer.log(Level.INFO, "Inside LanWSDelegator -> deepRediscoverForSelectedLanMembers()");
            _Tracer.log(Level.INFO, "deepTaskKey ==> " + deepTaskKey);
        }
        String token = this.getToken(dcnmUser);
        LanReferenceFactory.getInstance().getDeepDiscvWS(token).deepRediscoverForSelectedLanMembers(deepTaskKey, ethSwitches);
    }

    public void notifyDataCenterGroupDeletion(String dcnmUser, long[] lanDomains) throws Exception {
        _Tracer.log(Level.INFO, "Inside LanWSDelegator -> notifyDataCenterGroupDeletion()");
        _Tracer.log(Level.INFO, "dcnmUser ==> " + dcnmUser);
        long[] arr$ = lanDomains;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Long lanDomain = arr$[i$];
            _Tracer.log(Level.INFO, "lanDomain ==> " + lanDomain);
        }
        String token = this.getToken(dcnmUser);
        LanReferenceFactory.getInstance().getDataCenterGrpWS(token).notifyDataCenterGroupDeletion(lanDomains);
    }

    public void notifyMemberRemovedFromGroup(String dcnmUser, long parentGrpId, long[] lanSwList) throws Exception {
        _Tracer.log(Level.INFO, "Inside LanWSDelegator -> notifyMemberRemovedFromGroup()");
        _Tracer.log(Level.INFO, "dcnmUser ==> " + dcnmUser);
        _Tracer.log(Level.INFO, "parentGrpId ==> " + parentGrpId);
        long[] arr$ = lanSwList;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Long lanSw = arr$[i$];
            _Tracer.log(Level.INFO, "lanSw ==> " + lanSw);
        }
        String token = this.getToken(dcnmUser);
        LanReferenceFactory.getInstance().getDataCenterGrpWS(token).notifyMemberRemovedFromGroup(parentGrpId, lanSwList);
    }

    public void notifyGroupNameChanged(String dcnmUser, long lanDomain) throws Exception {
        _Tracer.log(Level.INFO, "Inside LanWSDelegator -> notifyGroupNameChanged()");
        _Tracer.log(Level.INFO, "dcnmUser ==> " + dcnmUser);
        _Tracer.log(Level.INFO, "lanDomain ==> " + lanDomain);
        String token = this.getToken(dcnmUser);
        LanReferenceFactory.getInstance().getDataCenterGrpWS(token).notifyGroupNameChanged(lanDomain);
    }

    public void notifyMemberAddedToGroup(String dcnmUser, long newParentDbId, long[] aneIds) throws Exception {
        _Tracer.log(Level.INFO, "Inside LanWSDelegator -> notifyMemberAddedToGroup()");
        _Tracer.log(Level.INFO, "dcnmUser ==> " + dcnmUser);
        _Tracer.log(Level.INFO, "newParentDbId ==> " + newParentDbId);
        long[] arr$ = aneIds;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Long aneId = arr$[i$];
            _Tracer.log(Level.INFO, "aneId ==> " + aneId);
        }
        String token = this.getToken(dcnmUser);
        LanReferenceFactory.getInstance().getDataCenterGrpWS(token).notifyMemberAddedToGroup(newParentDbId, aneIds);
    }

    public void notifyDataCenterGroupCreation(String dcnmUser, long[] newGroupDbids) throws Exception {
        _Tracer.log(Level.INFO, "Inside LanWSDelegator -> notifyDataCenterGroupCreation()");
        _Tracer.log(Level.INFO, "dcnmUser ==> " + dcnmUser);
        long[] arr$ = newGroupDbids;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Long newGroupDbid = arr$[i$];
            _Tracer.log(Level.INFO, "newGroupDbid ==> " + newGroupDbid);
        }
        String token = this.getToken(dcnmUser);
        LanReferenceFactory.getInstance().getDataCenterGrpWS(token).notifyDataCenterGroupCreation(newGroupDbids);
    }

    private String getToken(String dcnmUser) {
        _Tracer.log(Level.INFO, "Inside LanWSDelegator -> getToken()");
        _Tracer.log(Level.INFO, "dcnmuser ==> " + dcnmUser);
        String token = IdentityManager.getInstance().createToken(dcnmUser, null, 3000000L);
        _Tracer.log(Level.INFO, "token ==> " + token);
        return token;
    }

    private String removeToken(String token) {
        _Tracer.log(Level.INFO, "Inside LanWSDelegator -> removeToken()");
        _Tracer.log(Level.INFO, "token ==> " + token);
        IdentityManager.getInstance().removeServerToServerToken(token);
        return token;
    }
}

