/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.icmp;

import com.cisco.dcbu.lib.icmp.Pinger;
import com.cisco.dcbu.lib.util.ClientCache;
import java.io.File;
import java.io.IOException;
import javax.swing.Timer;

public class Ping {
    private static String _LibName;
    private static IOException _LdError;
    private static int _Counter;
    public static int DEFAULT_TIMEOUT;

    public static int doPing(String host) throws IOException {
        return Ping.doPing(host, DEFAULT_TIMEOUT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int doPing(String host, int timeout) throws IOException {
        if (_LdError != null) {
            throw _LdError;
        }
        if (_LibName.endsWith("dll")) {
            Pinger p = new Pinger(host);
            Timer timer = new Timer(timeout, p);
            Pinger pinger = p;
            synchronized (pinger) {
                p.start();
                timer.start();
                try {
                    p.wait();
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            return p.getRtt();
        }
        return Ping.unixPing(host, timeout / 1000);
    }

    static int unixPing(String host, int timeout) throws IOException {
        long curr = System.currentTimeMillis();
        int ret = Ping.icmp_send(host, _Counter, "");
        ++_Counter;
        if (ret < 0) {
            throw new IOException("Error (" + ret + ") sending ICMP packet");
        }
        String res = Ping.icmp_recv(timeout);
        if (res == null) {
            throw new IOException("Timeout waiting for ICMP packet");
        }
        long end = System.currentTimeMillis();
        return (int)(end - curr);
    }

    static native int winPing(String var0) throws IOException;

    static native int icmp_send(String var0, int var1, String var2) throws IOException;

    static native String icmp_recv(int var0) throws IOException;

    public static void main(String[] args) {
        try {
            System.out.println(args[0] + " rtt = " + Ping.doPing(args[0]));
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
            ex.printStackTrace(System.err);
        }
    }

    static {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows")) {
            _LibName = "ping.dll";
        } else if (osName.indexOf("Linux") != -1) {
            _LibName = "libping-linux.so";
        } else {
            throw new RuntimeException("Ping - Unsupported platform");
        }
        String libPath = ClientCache.getInstallLocation() + "lib" + File.separator + _LibName;
        try {
            if (!new File(libPath).exists()) {
                System.loadLibrary(_LibName);
            } else {
                System.out.println("Loading " + libPath);
                System.load(libPath);
            }
        }
        catch (Throwable th) {
            _LdError = new IOException(th.getMessage());
            System.err.println(th.getMessage());
            th.printStackTrace(System.err);
        }
        DEFAULT_TIMEOUT = 5000;
    }
}

