/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.jnm;

import com.cisco.dcbu.lib.jnm.DefaultSnmpNumberRenderer;
import com.cisco.dcbu.lib.snmp.SnmpCounter64;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpUnsignedInt;
import java.math.BigInteger;
import java.text.DecimalFormat;

public class FlowCounterRenderer
extends DefaultSnmpNumberRenderer {
    private static final DecimalFormat NUM_FORMAT = new DecimalFormat("0.000");

    public FlowCounterRenderer() {
        this.setHorizontalAlignment(4);
    }

    public static String formatLong(long l) {
        if (l == Long.MAX_VALUE) {
            return "inaccurate";
        }
        return DefaultSnmpNumberRenderer.formatLong(l);
    }

    public static String formatBigInt(BigInteger l) {
        if (l.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) == 0) {
            return "inaccurate";
        }
        return DefaultSnmpNumberRenderer.formatBigInt(l);
    }

    @Override
    protected void setValue(Object value) {
        if (value == null) {
            this.setText("");
        } else if (value instanceof SnmpUnsignedInt) {
            this.setText(FlowCounterRenderer.formatLong(((SnmpUnsignedInt)value).getValue()));
        } else if (value instanceof SnmpInt) {
            this.setText(FlowCounterRenderer.formatLong(((SnmpInt)value).getValue()));
        } else if (value instanceof SnmpCounter64) {
            this.setText(FlowCounterRenderer.formatBigInt(((SnmpCounter64)value).getBigValue()));
        } else if (value instanceof Number) {
            this.setText(FlowCounterRenderer.formatLong(((Number)value).longValue()));
        }
    }
}

