/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.jnm;

import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.util.StringUtil;

public final class SnmpFiconPort
extends SnmpInt {
    public SnmpFiconPort(int ficonPort) throws NumberFormatException {
        super(ficonPort);
    }

    public SnmpFiconPort(String ficonPort) throws NumberFormatException {
        this(ficonPort, true);
    }

    public SnmpFiconPort(String ficonPort, boolean isHex) throws NumberFormatException {
        super(SnmpFiconPort.parse(ficonPort.trim(), isHex));
    }

    @Override
    public String toString() {
        return SnmpFiconPort.toString(this._value);
    }

    public static String toString(int ficonPort) {
        if (ficonPort == -1) {
            return "";
        }
        return StringUtil.leftPad(Integer.toHexString(ficonPort).toUpperCase(), 2);
    }

    public static int parse(String ficonPort, boolean isHex) throws NumberFormatException {
        if (isHex) {
            if (ficonPort.equals("")) {
                return -1;
            }
            if (ficonPort.startsWith("0x") && ficonPort.length() > 2) {
                ficonPort = ficonPort.substring(2, ficonPort.length());
            }
            if (ficonPort.length() == 1) {
                ficonPort = "0" + ficonPort;
            } else if (ficonPort.length() > 2) {
                if (ficonPort.indexOf(47) != -1 && ficonPort.indexOf(40) != -1 && ficonPort.indexOf(41) != -1) {
                    ficonPort = ficonPort.substring(ficonPort.indexOf(40) + 1, ficonPort.indexOf(41));
                } else {
                    throw new NumberFormatException("bad Hex format");
                }
            }
            char a = ficonPort.charAt(0);
            char b = ficonPort.charAt(1);
            if (a == ':' || b == ':') {
                throw new NumberFormatException("bad Hex format");
            }
            int v1 = Character.digit(a, 16);
            int v2 = Character.digit(b, 16);
            if (v1 < 0 || v2 < 0) {
                throw new NumberFormatException("bad Hex format");
            }
            return v1 * 16 + v2;
        }
        return Integer.parseInt(ficonPort);
    }
}

