/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.jnm;

import com.cisco.dcbu.lib.snmp.SnmpString;
import java.util.StringTokenizer;

public final class SnmpIdList
extends SnmpString {
    public SnmpIdList(byte[] byteValue) {
        super(byteValue);
    }

    public SnmpIdList(SnmpString s) {
        super(s.getValue());
    }

    public SnmpIdList(String idList) {
        super(SnmpIdList.parse(idList));
    }

    @Override
    public String toString() {
        if (this._value == null) {
            this._value = SnmpIdList.toString(this._byteValue);
        }
        return this._value;
    }

    public static String toString(byte[] b) {
        if (b == null || b.length == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < b.length; i += 2) {
            if (i > 0) {
                sb.append(',');
            }
            int id = ((b[i] & 0xFF) << 8) + (b[i + 1] & 0xFF);
            sb.append(id);
        }
        return sb.toString();
    }

    public static byte[] parse(String idList) throws NumberFormatException {
        StringTokenizer st = new StringTokenizer(idList, ",");
        int[] ids = new int[st.countTokens()];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = Integer.parseInt(st.nextToken());
        }
        return SnmpIdList.valueOf(ids);
    }

    public static byte[] valueOf(int[] ids) {
        byte[] b = new byte[ids.length * 2];
        int bCount = 0;
        for (int i = 0; i < ids.length; ++i) {
            int id = ids[i];
            b[bCount++] = (byte)(id >> 8);
            b[bCount++] = (byte)id;
        }
        return b;
    }
}

