/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.map.client;

import com.cisco.dcbu.lib.map.client.RealHitTestWorker;
import com.cisco.dcbu.lib.map.common.TopologyGraph;
import com.cisco.dcbu.lib.map.common.TopologyNode;
import com.cisco.nm.esper.HitTestWorker;
import com.cisco.nm.esper.model.Edge;
import com.cisco.nm.esper.model.Graph;
import com.cisco.nm.esper.model.GraphMember;
import com.cisco.nm.esper.model.Node;
import com.cisco.nm.esper.model.NodeLabel;
import com.cisco.nm.esper.model.Transform;
import java.awt.Rectangle;
import java.util.ListIterator;
import org.apache.log4j.Logger;

public class TopologyHitTestWorker
extends HitTestWorker {
    public static Logger _Logger = Logger.getLogger(TopologyHitTestWorker.class);
    RealHitTestWorker _realHitTestWorker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GraphMember getTopObjectAt2(Graph graph, int x, int y) {
        int i;
        this._realHitTestWorker.interrupt();
        Object object = this._realHitTestWorker._syncObj;
        synchronized (object) {
            this._realHitTestWorker._graph = graph;
            this._realHitTestWorker._x = x;
            this._realHitTestWorker._y = y;
        }
        for (i = 0; i < 20 && this._realHitTestWorker.isDoing(); ++i) {
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException ex) {
                _Logger.trace((Object)"logEmptyCatch - sleep 100", (Throwable)ex);
            }
        }
        if (i == 20) {
            this._realHitTestWorker.interrupt();
            Object object2 = this._realHitTestWorker._syncObj;
            synchronized (object2) {
                this._realHitTestWorker._graph = null;
            }
            return null;
        }
        return this._realHitTestWorker._result;
    }

    public GraphMember getTopObjectAt(Graph graph, int x, int y) {
        Graph member = null;
        try {
            member = this.getTopGraphAt(graph, x, y);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (member == null || !member.isVisible()) {
            try {
                member = this.getTopNodeAt(graph, x, y);
            }
            catch (Exception ex) {
                _Logger.trace((Object)"logEmptyCatch - getTopNodeAt", (Throwable)ex);
            }
            if (member == null || !member.isVisible()) {
                try {
                    member = this.getTopNodeLabelAt(graph, x, y);
                }
                catch (Exception ex) {
                    _Logger.trace((Object)"logEmptyCatch - getTopNodeLabelAt", (Throwable)ex);
                }
                if (member == null || !member.isVisible()) {
                    try {
                        member = this.getTopEdgeLabelAt(graph, x, y);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    if (member == null || !member.isVisible()) {
                        try {
                            member = this.getTopEdgeAt(graph, x, y);
                        }
                        catch (Exception ex) {
                            _Logger.trace((Object)"logEmptyCatch - getTopEdgeAt", (Throwable)ex);
                        }
                    }
                }
            }
        }
        if (member != null && !member.isVisible()) {
            member = null;
        }
        return member;
    }

    public NodeLabel getTopNodeLabelAt(Graph graph, int x, int y) {
        NodeLabel label = this.getTopNodeLabelAt2(graph, x, y);
        TopologyNode n = (TopologyNode)(label == null ? null : label.getOwner());
        TopologyGraph g = (TopologyGraph)(n == null ? null : n.getOwner());
        if (n == null || !n.isNodeLabelDisplayed() || g == null || !g.isNodeLabelDisplayed()) {
            label = null;
        }
        return label;
    }

    public NodeLabel getTopNodeLabelAt2(Graph graph, int x, int y) {
        if (graph == null || this.getTransform() == null) {
            return null;
        }
        int ht = this.getHitTolerance();
        Rectangle rect = new Rectangle(x - ht / 2, y - ht / 2, ht, ht);
        Transform transform = this.getTransform();
        NodeLabel topLabel = null;
        for (Node node : graph.nodes()) {
            for (NodeLabel label : node.labels()) {
                if (!label.intersects(rect, transform)) continue;
                topLabel = label;
                return topLabel;
            }
        }
        return null;
    }

    public Node getTopNodeAt2(Graph graph, int x, int y) {
        if (graph == null || this.getTransform() == null) {
            return null;
        }
        Transform transform = this.getTransform();
        int ht = this.getHitTolerance();
        Rectangle rect = new Rectangle(x - ht / 2, y - ht / 2, ht, ht);
        ListIterator iter = graph.nodes().listIterator(graph.nodes().size());
        while (iter.hasPrevious()) {
            Node node = (Node)iter.previous();
            if (!node.intersects(rect, transform)) continue;
            return node;
        }
        return null;
    }

    public Node getTopNodeAt(Graph graph, int x, int y) {
        TopologyNode n = (TopologyNode)this.getTopNodeAt2(graph, x, y);
        TopologyGraph g = (TopologyGraph)(n == null ? null : n.getOwner());
        if (n == null || !n.isVisible() || g == null) {
            n = null;
        }
        return n;
    }

    public boolean isOverNode(Graph graph, int x, int y) {
        if (graph == null || this.getTransform() == null) {
            return false;
        }
        int ht = this.getHitTolerance();
        Rectangle rect = new Rectangle(x - ht / 2, y - ht / 2, ht, ht);
        Transform transform = this.getTransform();
        for (Node node : graph.nodes()) {
            if (!node.intersects(rect, transform)) continue;
            return true;
        }
        return false;
    }

    public boolean isOverNodeLabel(Graph graph, int x, int y) {
        if (graph == null || this.getTransform() == null) {
            return false;
        }
        int ht = this.getHitTolerance();
        Rectangle rect = new Rectangle(x - ht / 2, y - ht / 2, ht, ht);
        Transform transform = this.getTransform();
        for (Node node : graph.nodes()) {
            for (NodeLabel label : node.labels()) {
                if (!label.intersects(rect, transform)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isOverEdge(Graph graph, int x, int y) {
        if (graph == null || this.getTransform() == null) {
            return false;
        }
        int ht = this.getHitTolerance();
        Rectangle rect = new Rectangle(x - ht / 2, y - ht / 2, ht, ht);
        Transform transform = this.getTransform();
        for (Edge edge : graph.edges(2)) {
            if (!this.edgeIsVisible(edge)) continue;
            try {
                if (!edge.intersects(rect, transform)) continue;
                return true;
            }
            catch (Exception ex) {
                _Logger.trace((Object)"logEmptyCatch - intersects 1", (Throwable)ex);
            }
        }
        for (Edge edge : graph.edges(1)) {
            if (!this.edgeIsVisible(edge)) continue;
            try {
                if (!edge.intersects(rect, transform)) continue;
                return true;
            }
            catch (Exception ex) {
            }
        }
        return false;
    }

    public Edge getTopEdgeAt(Graph graph, int x, int y) {
        Edge edge;
        if (graph == null || this.getTransform() == null) {
            return null;
        }
        int ht = this.getHitTolerance();
        Rectangle rect = new Rectangle(x - ht / 2, y - ht / 2, ht, ht);
        Transform transform = this.getTransform();
        ListIterator iter = graph.edges(2).listIterator(graph.edges(2).size());
        while (iter.hasPrevious()) {
            edge = (Edge)iter.previous();
            if (edge == null || !this.edgeIsVisible(edge)) continue;
            try {
                if (!edge.intersects(rect, transform)) continue;
                this.returnHitRect(rect);
                return edge;
            }
            catch (Exception ex) {
                _Logger.trace((Object)"logEmptyCatch - returnHitRect 1", (Throwable)ex);
            }
        }
        iter = graph.edges(1).listIterator(graph.edges(1).size());
        while (iter.hasPrevious()) {
            edge = (Edge)iter.previous();
            if (edge == null || !this.edgeIsVisible(edge)) continue;
            try {
                if (!edge.intersects(rect, transform)) continue;
                this.returnHitRect(rect);
                return edge;
            }
            catch (Exception ex) {
            }
        }
        try {
            this.returnHitRect(rect);
        }
        catch (Exception ex) {
            _Logger.trace((Object)"logEmptyCatch - returnHitRect 3", (Throwable)ex);
        }
        return null;
    }

    private boolean edgeIsVisible(Edge edge) {
        Node source = edge.getSourceNode();
        Node target = edge.getTargetNode();
        if (!(source == null || target == null || edge.isVisible() && source.isVisible() && target.isVisible())) {
            return false;
        }
        return edge.isVisible();
    }
}

