/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.map.client;

import com.cisco.dcbu.lib.map.client.PopupHandler;
import com.cisco.dcbu.lib.map.client.TopologyDragTool;
import com.cisco.dcbu.lib.map.client.TopologyHitTestWorker;
import com.cisco.dcbu.lib.map.client.TopologyScrollPane;
import com.cisco.dcbu.lib.map.client.TopologySelectorTool;
import com.cisco.dcbu.lib.map.common.HtmlToolTipMaker;
import com.cisco.dcbu.lib.map.common.TopologyGraph;
import com.cisco.dcbu.lib.map.common.TopologyLink;
import com.cisco.dcbu.lib.map.common.TopologyNode;
import com.cisco.nm.esper.GraphComponent;
import com.cisco.nm.esper.HitTestWorker;
import com.cisco.nm.esper.ToolTipMaker;
import com.cisco.nm.esper.action.JOverviewAction;
import com.cisco.nm.esper.model.BaseObject;
import com.cisco.nm.esper.model.palette.GridPalette;
import com.cisco.nm.esper.tool.Tool;
import com.cisco.nm.esper.tool.event.ExtraMouseListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import org.apache.log4j.Logger;

public class TopologyWindow
extends JPanel {
    public static final Class _Class = TopologyWindow.class;
    public static Logger _Logger = Logger.getLogger(TopologyWindow.class);
    public static final int FIT_DO_NOTHING = 0;
    public static final int FIT_IN_WINDOW = 1;
    public static final int CENTER_IN_WINDOW = 2;
    int _preX = 0;
    int _preY = 0;
    private GraphComponent _graphComp = null;
    private TopologyScrollPane _graphPanel = null;
    private JPanel _tRootPanel = null;
    private boolean _inited = false;
    private JPanel _toolPanel;
    private TopologySelectorTool _selectorTool = null;
    Expander _expander = null;
    static boolean _GridEnabled = false;
    private static ArrayList _Instances = new ArrayList();
    private JOverviewAction _overviewAction;
    private boolean _setForRepaint = false;

    public TopologyWindow() {
        this.init();
        _Instances.add(this);
    }

    public static ArrayList getInstances() {
        return _Instances;
    }

    public static void remove(TopologyWindow win) {
        if (_Instances.contains(win)) {
            _Instances.remove(win);
        }
    }

    public void reset() {
        TopologyDragTool.getInstance().reset();
        this.repaintGraph();
    }

    void setTools(boolean setNull) {
        if (setNull) {
            this._graphComp.setTool(null);
            if (this._expander != null) {
                this._graphComp.asContainer().removeMouseListener(this._expander);
            }
            this._expander = null;
            this._graphComp.setExtraMouseListener(null);
            this._graphComp.setToolTipMaker(null);
        } else {
            this._expander = new Expander(this);
            this._graphComp.asContainer().addMouseListener(this._expander);
            this._selectorTool = new TopologySelectorTool();
            this._graphComp.setTool((Tool)this._selectorTool);
            this._graphComp.setExtraMouseListener((ExtraMouseListener)new PopupHandler());
            this._graphComp.setToolTipMaker((ToolTipMaker)new HtmlToolTipMaker());
        }
    }

    public void repaintGraph(int fit) {
        switch (fit) {
            case 2: {
                this.getGraphComponent().centerInWindow(true);
                break;
            }
            case 1: {
                this.getGraphComponent().fitInWindow(true);
            }
        }
        if (this._setForRepaint) {
            this._setForRepaint = false;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TopologyWindow.this._setForRepaint = false;
                if (TopologyWindow.this.getGraphComponent() == null) {
                    return;
                }
                TopologyWindow.this.getGraphComponent().markCompletelyDirty();
                TopologyWindow.this.getGraphComponent().asContainer().repaint();
            }
        });
        this._setForRepaint = true;
    }

    public void repaintGraph() {
        if (this._setForRepaint) {
            this._setForRepaint = false;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    TopologyWindow.this._setForRepaint = false;
                    if (TopologyWindow.this.getGraphComponent() == null) {
                        return;
                    }
                    TopologyWindow.this.getGraphComponent().markCompletelyDirty();
                    TopologyWindow.this.getGraphComponent().asContainer().repaint();
                }
                catch (Exception ex) {
                    _Logger.trace((Object)"logEmptyCatch - TopologyWindow.repaintGraph()", (Throwable)ex);
                }
            }
        });
        this._setForRepaint = true;
    }

    public void repaintGraph(final double x, final double y) {
        this.getGraphComponent().markCompletelyDirty();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TopologyWindow.this.getGraphComponent().makeVisible(x, y, true);
            }
        });
        this.getGraphComponent().asContainer().repaint();
    }

    protected void init() {
        if (!this._inited) {
            this.initUI();
        }
        this._inited = true;
    }

    public void destroy() {
        TopologyWindow.remove(this);
        if (this._graphComp != null) {
            this._graphComp.setGraph(null, false);
        }
        this._graphComp = null;
        this._graphPanel = null;
        this._tRootPanel = null;
        this._inited = false;
    }

    protected void initUI() {
        this.createUIComponents();
    }

    public static boolean isGridEnabled() {
        return _GridEnabled;
    }

    public static void setGridEnabled(boolean enabled) {
        _GridEnabled = enabled;
    }

    public TopologyGraph getGraph() {
        return this._graphComp == null ? null : (TopologyGraph)this._graphComp.getGraph();
    }

    public GraphComponent getGraphComponent() {
        return this._graphComp;
    }

    public GraphComponent getActiveGraphComponent() {
        return this._graphComp;
    }

    static final JPopupMenu getPopup(GraphComponent gc, BaseObject obj) {
        if (obj == null) {
            return (JPopupMenu)TopologyGraph.getClassResource((String)"JPopupMenu");
        }
        if (obj instanceof TopologyNode) {
            return ((TopologyNode)obj).getPopup();
        }
        if (obj instanceof TopologyLink) {
            return ((TopologyLink)obj).getPopup();
        }
        return (JPopupMenu)obj.getResource("JPopupMenu");
    }

    protected void createUIComponents() {
        if (this._graphPanel != null) {
            return;
        }
        this._graphPanel = new TopologyScrollPane();
        this._graphPanel.setBorder(LineBorder.createBlackLineBorder());
        this._graphComp = this._graphPanel.getGraphComponent();
        this._graphComp.setBlitEnabled(false);
        GridPalette palette = this._graphComp.getTransform().getGridPalette();
        palette.setEnabled(_GridEnabled);
        TopologyHitTestWorker htw = new TopologyHitTestWorker();
        htw.setHitTolerance(5);
        this._graphComp.setHitTestWorker((HitTestWorker)htw);
        this._tRootPanel = new JPanel();
        this._tRootPanel.setLayout(new BorderLayout());
        this._overviewAction = new JOverviewAction();
        this._overviewAction.setGraphComponent(this._graphComp);
        JPanel tb = (JPanel)TopologyGraph.getClassResource((String)"ToolPanel");
        if (tb != null && tb.getParent() == null) {
            this._toolPanel = tb;
            this._tRootPanel.add((Component)this._toolPanel, "West");
        }
        this._tRootPanel.add((Component)((Object)this._graphPanel), "Center");
        this.setupKeyActions(this._graphComp);
        this.setLayout(new BorderLayout());
        this.add((Component)this._tRootPanel, "Center");
        this.setTools(false);
    }

    private void setupKeyActions(GraphComponent comp) {
        if (comp == null) {
            return;
        }
    }

    public void setPreferredMapSize(Dimension dim) {
        this._graphPanel.setSize(dim);
        this._graphPanel.validate();
    }

    public TopologyGraph getActiveGraph() {
        this._selectorTool.updateContainerGraph(this._preX, this._preY);
        return (TopologyGraph)this._selectorTool.getContainerGraph();
    }

    public TopologyScrollPane getGraphPanel() {
        return this._graphPanel;
    }

    public void setToolPanel(JPanel tb) {
        this._toolPanel = tb;
        this._tRootPanel.add((Component)tb, "West");
    }

    public JPanel getToolPanel() {
        return this._toolPanel;
    }

    public JOverviewAction getOverviewAction() {
        return this._overviewAction;
    }

    public class Expander
    extends MouseAdapter
    implements MouseMotionListener {
        TopologyWindow _app;

        public Expander(TopologyWindow app) {
            this._app = app;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent event) {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            GraphComponent comp = (GraphComponent)event.getSource();
            Tool tool = comp.getActiveTool();
            this._app._preX = event.getX();
            this._app._preY = event.getY();
            try {
                this._app.requestFocus();
            }
            catch (Exception e) {
                System.err.println("TopologyWindow: " + e.getMessage());
            }
            if (event.getClickCount() > 1 && tool instanceof TopologySelectorTool) {
                TopologySelectorTool selector = (TopologySelectorTool)tool;
                selector.updateContainerGraph(event.getX(), event.getY());
                if (selector.getHitObject() instanceof TopologyGraph) {
                    TopologyGraph graph;
                    graph.setExpanded(!(graph = (TopologyGraph)selector.getHitObject()).isExpanded());
                    graph.compactBounds();
                    TopologyWindow.this.repaintGraph();
                    return;
                }
                if (selector.getHitObject() instanceof TopologyNode) {
                    TopologyNode node = (TopologyNode)selector.getHitObject();
                    node.actionDoubleClick();
                } else if (selector.getHitObject() instanceof TopologyLink) {
                    TopologyLink link = (TopologyLink)selector.getHitObject();
                    link.actionDoubleClick();
                }
            }
        }
    }
}

