/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.map.common;

import com.cisco.dcbu.lib.util.HashedArrayList;
import com.cisco.nm.esper.model.Bend;
import com.cisco.nm.esper.model.Edge;
import com.cisco.nm.esper.model.Node;
import java.util.ArrayList;
import java.util.Iterator;

public class MultipleLinkHandler {
    public static final double DEFAULT_SPACE = 7.0;
    public static double _ClassSpace = 7.0;
    private static MultipleLinkHandler _Instance = null;
    private double _spacing = _ClassSpace;

    protected MultipleLinkHandler() {
        this(_ClassSpace);
    }

    protected MultipleLinkHandler(double space) {
        this.setSpacing(space);
    }

    public static MultipleLinkHandler getInstance() {
        if (_Instance == null) {
            _Instance = new MultipleLinkHandler(_ClassSpace);
        }
        return _Instance;
    }

    public static void setClassSpacing(double space) {
        _ClassSpace = Math.max(3.0, space);
        if (_Instance != null) {
            _Instance.setSpacing(_ClassSpace);
        }
    }

    public static double getClassSpacing() {
        return _ClassSpace;
    }

    public void setSpacing(double space) {
        this._spacing = Math.max(3.0, space);
    }

    public double getSpacing() {
        return this._spacing;
    }

    public void handle(Node source, Node target) {
        double y2;
        Edge edge;
        HashedArrayList<Edge> edges = new HashedArrayList<Edge>();
        Iterator iter = source.outedges();
        while (iter.hasNext()) {
            edge = (Edge)iter.next();
            if (edge.getTargetNode() != target) continue;
            if (edge != null && edge.bends() != null) {
                edge.bends().clear();
            }
            if (!source.isVisible() || !target.isVisible() || !edge.isVisible() || ((ArrayList)edges).contains(edge)) continue;
            ((ArrayList)edges).add(edge);
        }
        iter = target.outedges();
        while (iter.hasNext()) {
            edge = (Edge)iter.next();
            if (edge.getTargetNode() != source) continue;
            if (edge != null && edge.bends() != null) {
                edge.bends().clear();
            }
            if (!source.isVisible() || !target.isVisible() || !edge.isVisible() || ((ArrayList)edges).contains(edge)) continue;
            ((ArrayList)edges).add(edge);
        }
        if (!source.isVisible() || !target.isVisible()) {
            return;
        }
        if (edges.size() <= 1) {
            return;
        }
        double spacing = this.getSpacing();
        if (edges.size() >= 12) {
            spacing /= 2.0;
        } else if (edges.size() > 8) {
            spacing /= 1.5;
        } else if (edges.size() > 4) {
            spacing /= 1.2;
        }
        if (spacing < 5.0) {
            spacing = 5.0;
        }
        double x1 = source.getCenterX();
        double x2 = target.getCenterX();
        double y1 = source.getCenterY();
        if (y1 == (y2 = target.getCenterY())) {
            double dx = (x2 - x1) / 10.0;
            double sx = x1 + dx;
            double tx = x2 - dx;
            if ((edges.size() & 1) == 1) {
                double y = y1 - (double)(edges.size() / 2) * spacing;
                for (int i = 0; i < edges.size(); ++i) {
                    Edge edge2 = (Edge)edges.get(i);
                    if (edge2.getSourceNode() == source) {
                        edge2.insert(0, new Bend(sx, y));
                        edge2.insert(new Bend(tx, y));
                    } else {
                        edge2.insert(0, new Bend(tx, y));
                        edge2.insert(new Bend(sx, y));
                    }
                    y += spacing;
                }
            } else {
                double y = y1 - (double)(edges.size() / 2) * spacing + spacing / 2.0;
                for (int i = 0; i < edges.size(); ++i) {
                    Edge edge3 = (Edge)edges.get(i);
                    if (edge3.getSourceNode() == source) {
                        edge3.insert(0, new Bend(sx, y));
                        edge3.insert(new Bend(tx, y));
                    } else {
                        edge3.insert(0, new Bend(tx, y));
                        edge3.insert(new Bend(sx, y));
                    }
                    y += spacing;
                }
            }
        } else if (x1 == x2) {
            double dy = (y2 - y1) / 10.0;
            double sy = y1 + dy;
            double ty = y2 - dy;
            if ((edges.size() & 1) == 1) {
                double x = x1 - (double)(edges.size() / 2) * spacing;
                for (int i = 0; i < edges.size(); ++i) {
                    Edge edge4 = (Edge)edges.get(i);
                    if (edge4.getSourceNode() == source) {
                        edge4.insert(0, new Bend(x, sy));
                        edge4.insert(new Bend(x, ty));
                    } else {
                        edge4.insert(0, new Bend(x, ty));
                        edge4.insert(new Bend(x, sy));
                    }
                    x += spacing;
                }
            } else {
                double x = x1 - (double)(edges.size() / 2) * spacing + spacing / 2.0;
                for (int i = 0; i < edges.size(); ++i) {
                    Edge edge5 = (Edge)edges.get(i);
                    if (edge5.getSourceNode() == source) {
                        edge5.insert(0, new Bend(x, sy));
                        edge5.insert(new Bend(x, ty));
                    } else {
                        edge5.insert(0, new Bend(x, ty));
                        edge5.insert(new Bend(x, sy));
                    }
                    x += spacing;
                }
            }
        } else {
            double a = (y2 - y1) / (x2 - x1);
            double b = y1 - a * x1;
            double dx = x2 - x1;
            double dy = y2 - y1;
            double length = Math.sqrt(dx * dx + dy * dy);
            double adv = length / 10.0;
            double sx = x1 + dx / length * adv;
            double sy = a * sx + b;
            double tx = x2 - dx / length * adv;
            double ty = a * tx + b;
            double ap = -1.0 / a;
            double b1 = sy - ap * sx;
            double b2 = ty - ap * tx;
            double xspc = (y2 - y1) / length * spacing;
            if ((edges.size() & 1) == 1) {
                double xf = sx - xspc * (double)(edges.size() / 2);
                double xr = tx - xspc * (double)(edges.size() / 2);
                for (int i = 0; i < edges.size(); ++i) {
                    Edge edge6 = (Edge)edges.get(i);
                    if (edge6.getSourceNode() == source) {
                        edge6.insert(0, new Bend(xf, ap * xf + b1));
                        edge6.insert(new Bend(xr, ap * xr + b2));
                    } else {
                        edge6.insert(0, new Bend(xr, ap * xr + b2));
                        edge6.insert(new Bend(xf, ap * xf + b1));
                    }
                    xf += xspc;
                    xr += xspc;
                }
            } else {
                double xf = sx - xspc * (double)(edges.size() / 2) + xspc / 2.0;
                double xr = tx - xspc * (double)(edges.size() / 2) + xspc / 2.0;
                for (int i = 0; i < edges.size(); ++i) {
                    Edge edge7 = (Edge)edges.get(i);
                    if (edge7.getSourceNode() == source) {
                        edge7.insert(0, new Bend(xf, ap * xf + b1));
                        edge7.insert(new Bend(xr, ap * xr + b2));
                    } else {
                        edge7.insert(0, new Bend(xr, ap * xr + b2));
                        edge7.insert(new Bend(xf, ap * xf + b1));
                    }
                    xf += xspc;
                    xr += xspc;
                }
            }
        }
    }
}

