/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.map.common;

import com.cisco.nm.esper.lib.FontRepository;
import com.cisco.nm.esper.lib.graphics.RectPool;
import com.cisco.nm.esper.model.Edge;
import com.cisco.nm.esper.model.EdgeLabel;
import com.cisco.nm.esper.model.Graph;
import com.cisco.nm.esper.model.GraphMember;
import com.cisco.nm.esper.model.Node;
import com.cisco.nm.esper.model.Transform;
import com.cisco.nm.esper.model.ui.ExpandedGraphPainter;
import com.cisco.nm.esper.model.ui.GraphMemberFilter;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class TopologyGraphPainter
extends ExpandedGraphPainter {
    public static Logger _Logger = Logger.getLogger(TopologyGraphPainter.class);
    public static final TopologyGraphPainter _Instance = new TopologyGraphPainter();
    private static final FontRepository FONT_REPOSITORY = FontRepository.INSTANCE;

    public TopologyGraphPainter() {
        super("TopologyGraphPainter");
        this.setGraphMemberFilter((GraphMemberFilter)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintDetail(Graphics2D graphics, Graph graph, Transform transform) {
        Rectangle clip = RectPool.INSTANCE.checkRectOut();
        if (clip == null) {
            return;
        }
        graphics.getClipBounds(clip);
        if (clip != null && !clip.isEmpty()) {
            Rectangle rect = RectPool.INSTANCE.checkRectOut();
            rect = this.getBounds(graph, transform, rect);
            Object object = graph.getGraphLock();
            synchronized (object) {
                Font font;
                Edge edge;
                if (this.getBorder() != null) {
                    this.getBorder().paint(graph, (Graphics)graphics, rect);
                }
                double scale = transform.getScaleX();
                Iterator edgeIter = graph.edges(1).iterator();
                while (edgeIter.hasNext()) {
                    try {
                        edge = (Edge)edgeIter.next();
                        if (!this.getGraphMemberFilter().accept((GraphMember)edge)) continue;
                        if (edge.intersects(clip, transform)) {
                            edge.paint((Graphics)graphics, transform);
                        }
                        for (EdgeLabel label : edge.labels()) {
                            font = label.getFont();
                            if (transform.isForegroundScaled()) {
                                font = FONT_REPOSITORY.getScaleFont(font, scale);
                            }
                            label.updateTextMetrics(font == null ? null : graphics.getFontMetrics(font), scale);
                            if (!this.getGraphMemberFilter().accept((GraphMember)label) || !label.intersects(clip, transform)) continue;
                            label.paint((Graphics)graphics, transform);
                        }
                    }
                    catch (Exception ex) {
                        if (!_Logger.isTraceEnabled()) continue;
                        _Logger.trace((Object)"logEmptyCatch - inner-graph edges", (Throwable)ex);
                    }
                }
                Iterator nodeIter = graph.nodes().iterator();
                while (nodeIter.hasNext()) {
                    try {
                        Node node = (Node)nodeIter.next();
                        if (this.getGraphMemberFilter().accept((GraphMember)node) && node.intersects(clip, transform)) {
                            node.paint((Graphics)graphics, transform);
                        }
                        for (EdgeLabel label : node.labels()) {
                            font = label.getFont();
                            if (transform.isForegroundScaled()) {
                                font = FONT_REPOSITORY.getScaleFont(font, scale);
                            }
                            label.updateTextMetrics(font == null ? null : graphics.getFontMetrics(font), scale);
                            if (!this.getGraphMemberFilter().accept((GraphMember)label) || !label.intersects(clip, transform)) continue;
                            label.paint((Graphics)graphics, transform);
                        }
                    }
                    catch (Exception ex) {
                        if (!_Logger.isTraceEnabled()) continue;
                        _Logger.trace((Object)"logEmptyCatch - draw nodes & labels", (Throwable)ex);
                    }
                }
                Iterator graphIter = graph.graphs().iterator();
                while (graphIter.hasNext()) {
                    try {
                        Graph subnet = (Graph)graphIter.next();
                        if (!subnet.isExpanded()) {
                            for (Edge edge2 : subnet.edges()) {
                                if (!edge2.isIntergraph() || !this.getGraphMemberFilter().accept((GraphMember)edge2)) continue;
                                edge2.paint((Graphics)graphics, transform);
                            }
                        }
                        if (!this.getGraphMemberFilter().accept((GraphMember)subnet)) continue;
                        subnet.paint((Graphics)graphics, transform);
                    }
                    catch (Exception ex) {
                        if (!_Logger.isTraceEnabled()) continue;
                        _Logger.trace((Object)"logEmptyCatch - collapsed graphs", (Throwable)ex);
                    }
                }
                edgeIter = graph.edges(2).iterator();
                while (edgeIter.hasNext()) {
                    try {
                        edge = (Edge)edgeIter.next();
                        if (!this.getGraphMemberFilter().accept((GraphMember)edge)) continue;
                        if (edge.intersects(clip, transform)) {
                            edge.paint((Graphics)graphics, transform);
                        }
                        for (EdgeLabel label : edge.labels()) {
                            font = label.getFont();
                            if (transform.isForegroundScaled()) {
                                font = FONT_REPOSITORY.getScaleFont(font, scale);
                            }
                            label.updateTextMetrics(font == null ? null : graphics.getFontMetrics(font), scale);
                            if (!this.getGraphMemberFilter().accept((GraphMember)label) || !label.intersects(clip, transform)) continue;
                            label.paint((Graphics)graphics, transform);
                        }
                    }
                    catch (Exception ex) {
                        if (!_Logger.isTraceEnabled()) continue;
                        _Logger.trace((Object)"logEmptyCatch - inter-graph edges", (Throwable)ex);
                    }
                }
            }
            RectPool.INSTANCE.checkRectIn(rect);
        }
        RectPool.INSTANCE.checkRectIn(clip);
    }
}

