/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.map.common;

import com.cisco.dcbu.lib.map.common.TopologyGraph;
import com.cisco.dcbu.lib.ui.IconManager;
import com.cisco.nm.esper.lib.graphics.RectPool;
import com.cisco.nm.esper.model.Graph;
import com.cisco.nm.esper.model.Transform;
import com.cisco.nm.esper.model.palette.NodeLabelPalette;
import com.cisco.nm.esper.model.ui.CollapsedGraphPainter;
import com.cisco.nm.esper.model.ui.PageGraphBorder;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import javax.swing.ImageIcon;

public class TopologyIconGraphPainter
extends CollapsedGraphPainter
implements ImageObserver {
    public static final String ICON_NAME = "Cloud.gif";
    private static final int NULL_WIDTH = 32;
    private static final int NULL_HEIGHT = 32;
    private ImageIcon _image;

    public TopologyIconGraphPainter() {
        this.load();
    }

    public ImageIcon getIcon() {
        return this._image;
    }

    protected void paintDetail(Graphics2D graphics, Graph g, Transform transform) {
        ImageIcon img = this.getIcon();
        TopologyGraph graph = (TopologyGraph)g;
        int cx = transform.xToDevice(graph.getCenterX());
        int cy = transform.yToDevice(graph.getCenterY());
        if (img == null) {
            graphics.setColor(Color.red);
            graphics.drawRect(cx - 16, cy - 16, 32, 32);
            graphics.drawLine(cx - 16, cy - 16, cx + 16, cy + 16);
            graphics.drawLine(cx - 16, cy + 16, cx + 16, cy - 16);
        } else {
            int imgWdth = img.getIconWidth();
            int imgHght = img.getIconHeight();
            if (transform.isForegroundScaled()) {
                imgWdth = transform.widthToDevice((double)imgWdth);
                imgHght = transform.heightToDevice((double)imgHght);
            }
            Rectangle rect = RectPool.INSTANCE.checkRectOut();
            this.getBounds(graph, transform, rect);
            PageGraphBorder.INSTANCE.paint((Graph)graph, (Graphics)graphics, rect);
            RectPool.INSTANCE.checkRectIn(rect);
            graphics.drawImage(img.getImage(), cx - imgWdth / 2, cy - imgHght / 2, imgWdth, imgHght, this);
            String name = graph.getText();
            if (name == null || name.equals("")) {
                return;
            }
            graphics.setColor(NodeLabelPalette.INSTANCE.getPlainStrokeColor());
            FontMetrics fm = graphics.getFontMetrics();
            if (fm != null) {
                graphics.drawString(name, cx - fm.stringWidth(name) / 2, cy + imgHght / 2 + fm.getMaxAscent() + 2);
            } else {
                graphics.drawString(name, cx - 20, cy + imgHght / 2 + 10);
            }
        }
    }

    private void load() {
        this._image = IconManager.getIcon(ICON_NAME);
    }

    @Override
    public boolean imageUpdate(Image img, int flags, int x, int y, int width, int height) {
        return (flags & 0x20) == 0;
    }

    public Rectangle getBounds(Graph graph, Transform transform, Rectangle rect) {
        Rectangle r = super.getBounds(graph, transform, rect);
        r.height += 20;
        return r;
    }
}

