/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.map.common;

import com.cisco.dcbu.lib.map.common.TopologyGraph;
import com.cisco.dcbu.lib.map.common.TopologyLink;
import com.cisco.nm.esper.lib.graphics.Geometry;
import com.cisco.nm.esper.lib.graphics.Line;
import com.cisco.nm.esper.lib.graphics.Polygon;
import com.cisco.nm.esper.lib.graphics.StrokePool;
import com.cisco.nm.esper.model.Bend;
import com.cisco.nm.esper.model.Edge;
import com.cisco.nm.esper.model.Transform;
import com.cisco.nm.esper.model.ui.AbstractEdgePainter;
import com.cisco.nm.esper.shape.FixedPoint2D;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.util.Iterator;

public class TopologyLinkPainter
extends AbstractEdgePainter {
    public static final TopologyLinkPainter INSTANCE = new TopologyLinkPainter();
    private GeneralPath _path = new GeneralPath(0, 6);

    public static TopologyLinkPainter getInstance() {
        return INSTANCE;
    }

    public void paint(Graphics graphics, Edge edge, Transform transform) {
        if (!(edge.isVisible() && edge.getSourceNode().isVisible() && edge.getTargetNode().isVisible())) {
            return;
        }
        super.paint(graphics, edge, transform);
    }

    public void paintLabels(Graphics graphics, Edge edge, Transform transform) {
        TopologyLink link = (TopologyLink)edge;
        if (!link.isVisible()) {
            return;
        }
        if (link.isDimmed()) {
            graphics.setColor(Color.lightGray);
        } else {
            graphics.setColor(edge.getStrokeColor());
        }
        super.paintLabels(graphics, edge, transform);
    }

    public boolean intersects(Edge edge, Rectangle rect, Transform transform) {
        int size;
        boolean isects = false;
        Line line = new Line();
        Iterator pointIter = edge.points();
        FixedPoint2D point = (FixedPoint2D)pointIter.next();
        line.setLastPoint(transform.xToDevice(point.getX()), transform.yToDevice(point.getY()));
        int n = size = transform.isForegroundScaled() ? Math.max(1, transform.widthToDevice((double)edge.getStrokeWidth())) : edge.getStrokeWidth();
        if (size == 1) {
            while (pointIter.hasNext()) {
                point = (FixedPoint2D)pointIter.next();
                line.setFirstPoint(line.getX2(), line.getY2());
                line.setLastPoint(transform.xToDevice(point.getX()), transform.yToDevice(point.getY()));
                if (!Geometry.intersects((Line)line, (Rectangle)rect)) continue;
                isects = true;
                break;
            }
        } else {
            Polygon polygon = new Polygon(new int[4], new int[4], 4);
            while (pointIter.hasNext()) {
                point = (FixedPoint2D)pointIter.next();
                line.setFirstPoint(line.getX2(), line.getY2());
                line.setLastPoint(transform.xToDevice(point.getX()), transform.yToDevice(point.getY()));
                if (line.isPoint()) continue;
                int dx = line.getX2() - line.getX1();
                int dy = line.getY2() - line.getY1();
                double theta = (double)size / 2.0 / Math.sqrt(dx * dx + dy * dy);
                int offX = (int)Math.round(theta * (double)dy);
                int offY = (int)Math.round(theta * (double)dx);
                polygon.xpoints[0] = line.getX2() + offX;
                polygon.ypoints[0] = line.getY2() - offY;
                polygon.xpoints[1] = line.getX2() - offX;
                polygon.ypoints[1] = line.getY2() + offY;
                polygon.xpoints[2] = line.getX1() - offX;
                polygon.ypoints[2] = line.getY1() + offY;
                polygon.xpoints[3] = line.getX1() + offX;
                polygon.ypoints[3] = line.getY1() - offY;
                polygon.updateBounds();
                if (!Geometry.intersects((Rectangle)rect, (java.awt.Polygon)polygon)) continue;
                isects = true;
                break;
            }
        }
        return isects;
    }

    protected void paintPath(Graphics2D graphics, Edge edge, Transform transform, Point[] path, int size) {
        Stroke stroke;
        int width;
        TopologyLink link;
        block50: {
            double cX;
            double frac;
            double toSkip;
            BasicStroke bs;
            float[] pattern;
            block49: {
                double ly;
                double lx;
                double hf;
                double lgth;
                double dy;
                double dx;
                int y2;
                float f4;
                float f3;
                float f2;
                float f1;
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                link = (TopologyLink)edge;
                pattern = null;
                if (link.isDashed()) {
                    pattern = new float[2];
                    if (transform.getScaleX() == 1.0) {
                        pattern[0] = 5.0f;
                        pattern[1] = 5.0f;
                    } else {
                        float f;
                        pattern[0] = f = Math.max(2.0f, (float)transform.widthToDevice(5.0));
                        pattern[1] = f;
                    }
                } else if (link.isDotDashed()) {
                    pattern = new float[4];
                    if (transform.getScaleX() == 1.0) {
                        pattern[0] = 6.0f;
                        pattern[1] = 3.0f;
                        pattern[2] = 1.0f;
                        pattern[3] = 3.0f;
                    } else {
                        f1 = Math.max(2.0f, (float)transform.widthToDevice(6.0));
                        f2 = Math.max(3.0f, (float)transform.widthToDevice(3.0));
                        f3 = Math.max(1.0f, (float)transform.widthToDevice(1.0));
                        f4 = Math.max(3.0f, (float)transform.widthToDevice(3.0));
                        pattern[0] = f1;
                        pattern[1] = f2;
                        pattern[2] = f3;
                        pattern[3] = f4;
                    }
                } else if (link.isDotDotDashed()) {
                    pattern = new float[6];
                    if (transform.getScaleX() == 1.0) {
                        pattern[0] = 6.0f;
                        pattern[1] = 6.0f;
                        pattern[2] = 1.0f;
                        pattern[3] = 6.0f;
                        pattern[4] = 1.0f;
                        pattern[5] = 6.0f;
                    } else {
                        pattern[0] = Math.max(2.0f, (float)transform.widthToDevice(6.0));
                        pattern[1] = Math.max(3.0f, (float)transform.widthToDevice(6.0));
                        pattern[2] = Math.max(1.0f, (float)transform.widthToDevice(1.0));
                        pattern[3] = Math.max(3.0f, (float)transform.widthToDevice(6.0));
                        pattern[4] = Math.max(1.0f, (float)transform.widthToDevice(1.0));
                        pattern[5] = Math.max(3.0f, (float)transform.widthToDevice(6.0));
                    }
                } else if (link.isDotted()) {
                    pattern = new float[4];
                    if (transform.getScaleX() == 1.0) {
                        pattern[0] = 1.0f;
                        pattern[1] = 3.0f;
                        pattern[2] = 1.0f;
                        pattern[3] = 3.0f;
                    } else {
                        f1 = Math.max(2.0f, (float)transform.widthToDevice(1.0));
                        f2 = Math.max(3.0f, (float)transform.widthToDevice(3.0));
                        f3 = Math.max(1.0f, (float)transform.widthToDevice(1.0));
                        f4 = Math.max(3.0f, (float)transform.widthToDevice(3.0));
                        pattern[0] = f1;
                        pattern[1] = f2;
                        pattern[2] = f3;
                        pattern[3] = f4;
                    }
                }
                width = edge.getStrokeWidth();
                if (link.isDummyLink()) {
                    width <<= 1;
                }
                if (!link.isSelected() && link.isDimmed()) {
                    graphics.setColor(Color.lightGray);
                } else {
                    Color backgroundColor = TopologyGraph.getBackgroundColor();
                    if (edge.isSelected() && backgroundColor != null && backgroundColor.equals(Color.BLACK)) {
                        graphics.setColor(Color.MAGENTA);
                    } else {
                        graphics.setColor(edge.getStrokeColor());
                    }
                }
                this._path.reset();
                double ah = 4.0 * (double)width;
                if ((edge.getArrowType() & 1) == 0) {
                    this._path.moveTo(path[0].x, path[0].y);
                } else {
                    int x2 = path[0].x;
                    y2 = path[0].y;
                    dx = x2 - path[1].x;
                    dy = y2 - path[1].y;
                    lgth = Math.sqrt(dx * dx + dy * dy);
                    hf = ah / lgth;
                    lx = hf * dx;
                    ly = hf * dy;
                    this._path.moveTo(path[0].x - (int)lx, path[0].y - (int)ly);
                }
                for (int index = 1; index < size - 1; ++index) {
                    this._path.lineTo(path[index].x, path[index].y);
                }
                if ((edge.getArrowType() & 2) == 0) {
                    this._path.lineTo(path[size - 1].x, path[size - 1].y);
                } else {
                    int x2 = path[size - 1].x;
                    y2 = path[size - 1].y;
                    dx = x2 - path[size - 2].x;
                    dy = y2 - path[size - 2].y;
                    lgth = Math.sqrt(dx * dx + dy * dy);
                    hf = ah / lgth;
                    lx = hf * dx;
                    ly = hf * dy;
                    this._path.lineTo(path[size - 1].x - (int)lx, path[size - 1].y - (int)ly);
                }
                stroke = graphics.getStroke();
                BasicStroke edgeStroke = pattern == null ? StrokePool.INSTANCE.getStroke(width) : new BasicStroke(width, 0, link.getLineJoins(), 1.0f, pattern, 0.0f);
                int nHL = link.isHighlighted() ? 1 : 0;
                Color clr = null;
                float[] point = new float[6];
                float mx = 0.0f;
                float my = 0.0f;
                bs = null;
                if (nHL > 0) {
                    clr = graphics.getColor();
                }
                if (link.isHighlighted()) {
                    graphics.setColor(link.getHighlightColor());
                    bs = new BasicStroke(width + (nHL + 1) * (2 + (link.isDummyLink() ? 1 : 0)));
                    graphics.setStroke(bs);
                    PathIterator pi = this._path.getPathIterator(null);
                    while (!pi.isDone()) {
                        int type = pi.currentSegment(point);
                        switch (type) {
                            case 0: {
                                mx = point[0];
                                my = point[1];
                                break;
                            }
                            case 1: {
                                graphics.drawLine((int)mx, (int)my, (int)point[0], (int)point[1]);
                                mx = point[0];
                                my = point[1];
                            }
                        }
                        pi.next();
                    }
                }
                if (clr != null) {
                    graphics.setColor(clr);
                }
                if (link.isDummyLink()) {
                    width = 3;
                    bs = pattern != null ? new BasicStroke(width, 0, link.getLineJoins(), 1.0f, pattern, 0.0f) : new BasicStroke(width);
                    graphics.setStroke(bs);
                    int x2 = path[0].x;
                    int y22 = path[0].y;
                    double dx2 = x2 - path[1].x;
                    double dy2 = y22 - path[1].y;
                    double lgth2 = Math.sqrt(dx2 * dx2 + dy2 * dy2);
                    double d = Math.abs(dx2) < 4.0 ? 4.0 : Math.max(0.0, 4.0 * Math.abs(dy2) / lgth2);
                    dy2 = Math.abs(dy2) < 4.0 ? 4.0 : Math.max(0.0, 4.0 * Math.abs(dx2) / lgth2);
                    dx2 = d;
                    GeneralPath pt = new GeneralPath(0, 6);
                    pt.moveTo((int)((double)path[0].x + dx2), (int)((double)path[0].y + dy2));
                    for (int index = 1; index < size - 1; ++index) {
                        pt.lineTo((int)((double)path[index].x + dx2), (int)((double)path[index].y + dy2));
                    }
                    graphics.draw(pt);
                } else {
                    graphics.setStroke(edgeStroke);
                }
                graphics.draw(this._path);
                if (link.hasMajorFault()) break block49;
                if (!link.hasMinorFault()) break block50;
                if (!link.showMinorFaultOnLinks()) break block50;
            }
            double x2 = edge.getSourceX();
            double y2 = edge.getSourceY();
            double x1 = x2;
            double y1 = y2;
            double lgth = 0.0;
            Iterator iter = edge.bends().iterator();
            for (toSkip = edge.length() * 0.5; iter.hasNext() && toSkip > 0.0; toSkip -= lgth) {
                x1 = x2;
                y1 = y2;
                Bend bend = (Bend)iter.next();
                x2 = bend.getCenterX();
                y2 = bend.getCenterY();
                lgth = Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
            }
            if (toSkip <= 0.0) {
                toSkip += lgth;
            } else {
                x1 = x2;
                y1 = y2;
                x2 = edge.getTargetX();
                y2 = edge.getTargetY();
                lgth = Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
            }
            double d = frac = lgth > 0.0 ? toSkip / lgth : 0.0;
            double d2 = frac <= 0.0 ? x1 : (cX = frac >= 1.0 ? x2 : x1 + frac * (x2 - x1));
            double cY = frac <= 0.0 ? y1 : (frac >= 1.0 ? y2 : y1 + frac * (y2 - y1));
            cX = transform.xToDevice(cX);
            cY = transform.yToDevice(cY);
            int n = width = width == 1 ? 4 : 6;
            if (transform.isForegroundScaled()) {
                width = Math.max(3, transform.widthToDevice((double)width));
            }
            bs = null;
            if (link.isDimmed()) {
                graphics.setColor(Color.lightGray);
            } else if (link.hasMajorFault()) {
                graphics.setColor(Color.red);
                bs = new BasicStroke(width == 1 ? 1.0f : 2.0f);
            } else {
                graphics.setColor(TopologyLink._MinorFaultColor);
                pattern = new float[]{5.0f, 3.0f};
                bs = new BasicStroke(width == 4 ? 1.0f : 2.0f, 0, link.getLineJoins(), 1.0f, pattern, 0.0f);
            }
            if (bs != null) {
                graphics.setStroke(bs);
            }
            graphics.drawLine((int)cX - width, (int)cY - width, (int)cX + width, (int)cY + width);
            graphics.drawLine((int)cX + width, (int)cY - width, (int)cX - width, (int)cY + width);
        }
        if (link.isSecuredEncrypted() && link.showSecuredOnLinks()) {
            this.paintSecured(graphics, edge, transform, path, size, width, link);
        }
        graphics.setStroke(stroke);
    }

    protected void paintSecured(Graphics2D graphics, Edge edge, Transform transform, Point[] path, int size, int widthRect, TopologyLink link) {
        if (link.isSecuredEncrypted() && link.showSecuredOnLinks()) {
            double xOval;
            double cX;
            double frac;
            double toSkip;
            double x2 = edge.getSourceX();
            double y2 = edge.getSourceY();
            double x1 = x2;
            double y1 = y2;
            double lgth = 0.0;
            Iterator iter = edge.bends().iterator();
            for (toSkip = edge.length() * 0.42; iter.hasNext() && toSkip > 0.0; toSkip -= lgth) {
                x1 = x2;
                y1 = y2;
                Bend bend = (Bend)iter.next();
                x2 = bend.getCenterX();
                y2 = bend.getCenterY();
                lgth = Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
            }
            if (toSkip <= 0.0) {
                toSkip += lgth;
            } else {
                x1 = x2;
                y1 = y2;
                x2 = edge.getTargetX();
                y2 = edge.getTargetY();
                lgth = Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
            }
            double d = frac = lgth > 0.0 ? toSkip / lgth : 0.0;
            double d2 = frac <= 0.0 ? x1 : (cX = frac >= 1.0 ? x2 : x1 + frac * (x2 - x1));
            double cY = frac <= 0.0 ? y1 : (frac >= 1.0 ? y2 : y1 + frac * (y2 - y1));
            cX = transform.xToDevice(cX);
            cY = transform.yToDevice(cY);
            widthRect = 3;
            if (transform.isForegroundScaled()) {
                widthRect = Math.max(3, transform.widthToDevice((double)widthRect));
            }
            int heightRect = Math.max(2, widthRect * 3 / 4);
            int widthOval = widthRect * 3 / 2;
            int heightOval = widthRect * 3 / 2;
            double d3 = frac <= 0.0 ? x1 : (xOval = frac >= 1.0 ? x2 : x1 + frac * (x2 - x1));
            double yOval = frac <= 0.0 ? y1 : (frac >= 1.0 ? y2 : y1 + frac * (y2 - y1));
            xOval = transform.xToDevice(xOval) - widthOval / 2;
            yOval = transform.yToDevice(yOval) - heightRect * 15 / 6;
            if (link.isDimmed()) {
                graphics.setStroke(new BasicStroke());
                graphics.setColor(Color.white);
                graphics.fillOval((int)xOval, (int)yOval, widthOval, heightOval);
                graphics.setColor(Color.lightGray);
                graphics.setStroke(new BasicStroke(2.0f));
                graphics.drawOval((int)xOval, (int)yOval, widthOval, heightOval);
                graphics.setStroke(new BasicStroke());
                graphics.setColor(Color.lightGray);
                graphics.fillRect((int)(cX - (double)widthRect), (int)(cY - (double)heightRect), widthRect * 2, heightRect * 2);
                graphics.setColor(Color.lightGray);
                graphics.drawRect((int)(cX - (double)widthRect), (int)(cY - (double)heightRect), widthRect * 2, heightRect * 2);
            } else {
                graphics.setStroke(new BasicStroke());
                graphics.setColor(Color.white);
                graphics.fillOval((int)xOval, (int)yOval, widthOval, heightOval);
                graphics.setColor(Color.darkGray);
                graphics.setStroke(new BasicStroke(2.0f));
                graphics.drawOval((int)xOval, (int)yOval, widthOval, heightOval);
                graphics.setStroke(new BasicStroke());
                if (link.isSecuredEncrypted()) {
                    graphics.setColor(Color.black);
                } else {
                    graphics.setColor(Color.lightGray);
                }
                graphics.fillRect((int)(cX - (double)widthRect), (int)(cY - (double)heightRect), widthRect * 2, heightRect * 2);
                graphics.setColor(Color.black);
                graphics.drawRect((int)(cX - (double)widthRect), (int)(cY - (double)heightRect), widthRect * 2, heightRect * 2);
            }
        }
    }

    public Rectangle getBounds(Edge edge, Transform transform, Rectangle rect) {
        TopologyLink link;
        if (rect == null) {
            rect = new Rectangle();
        }
        if ((link = (TopologyLink)edge) == null || link.isDestroyed() || !link.isVisible()) {
            rect.height = 0;
            rect.width = 0;
            rect.y = 0;
            rect.x = 0;
            return rect;
        }
        int nHL = 1;
        int d = 0;
        if (link.isDummyLink()) {
            d = 5;
        }
        rect.x = transform.xToDevice(edge.getLeft() - (double)d) - 2 * nHL;
        rect.y = transform.yToDevice(edge.getTop() - (double)d) - 2 * nHL;
        rect.width = transform.xToDevice(edge.getRight() + (double)d) + 4 * nHL - rect.x;
        rect.height = transform.yToDevice(edge.getBottom() + (double)d) + 4 * nHL - rect.y;
        int arrSpc = Math.max(edge.getArrowHeight(), edge.getArrowWidth());
        int arrowWidth = transform.isForegroundScaled() ? transform.widthToDevice((double)arrSpc) : arrSpc;
        rect.grow(arrowWidth, arrowWidth);
        return rect;
    }
}

