/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.mds;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.SnmpFiconPort;
import com.cisco.dcbu.lib.mds.InterfaceChooserIf;
import com.cisco.dcbu.lib.mds.ficon.FiconPortByIfIndexCache;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.ui.CheckBoxListPanel;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.util.Array;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class InterfaceEditor
extends JDialog
implements ActionListener {
    static final String[] _BtnLabel = new String[]{"OK", "Close"};
    int[] _interfaceList;
    protected Object _context;
    InterfaceChooserIf _target;
    String[] _ifNames;
    boolean _isFICON;
    SnmpPeer _peer;
    CheckBoxListPanel _listPanel;

    public InterfaceEditor(JFrame parent, int[] interfaceList) {
        super(parent);
        this.setDefaultCloseOperation(2);
        this._interfaceList = interfaceList;
        JPanel box = new JPanel(new BorderLayout());
        box.setBorder(DialogUtil._Margin);
        if (interfaceList != null) {
            Object[] names = new String[interfaceList.length];
            for (int i = 0; i < names.length; ++i) {
                names[i] = IfIndexUtil.ifIndexToName(interfaceList[i]);
            }
            this._listPanel = new CheckBoxListPanel(names);
            this._listPanel.clearSelection();
        }
        JScrollPane sp = new JScrollPane(this._listPanel);
        if (interfaceList != null && interfaceList.length > 0) {
            this._listPanel.setUnitIncrement(sp);
        }
        sp.setPreferredSize(new Dimension(170, 100));
        box.add(sp);
        DialogUtil.buildDialog((JDialog)this, (Container)parent, (Container)box, (AbstractButton[])DialogUtil.buildButtons(_BtnLabel, (ActionListener)this));
        this.setResizable(true);
    }

    public final void setContext(Object context) {
        this._context = context;
    }

    public void setChoices(int[] interfaceList) {
        this._interfaceList = interfaceList;
        Object[] names = new String[interfaceList.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = IfIndexUtil.ifIndexToName(interfaceList[i]);
        }
        this._listPanel.clearChoices();
        this._listPanel.setChoices(names);
    }

    public final void setTarget(InterfaceChooserIf target) {
        this._target = target;
    }

    public void setIfNames(String[] ifNames) {
        this._ifNames = ifNames;
    }

    public void setIsFICON(boolean isFICON, SnmpPeer peer) {
        this._isFICON = isFICON;
        this._peer = peer;
    }

    public void setChoicesText() {
        Array<String> nameList = new Array<String>();
        for (int i = 0; i < this._interfaceList.length; ++i) {
            if (this._isFICON && this._peer != null) {
                int ficonPort = FiconPortByIfIndexCache.getInstance(this._peer).getFiconPort(this._interfaceList[i]);
                if (ficonPort == -1) continue;
                nameList.addElement(IfIndexUtil.ifIndexToName(this._interfaceList[i]) + " (" + SnmpFiconPort.toString(ficonPort) + ")");
                continue;
            }
            nameList.addElement(IfIndexUtil.ifIndexToName(this._interfaceList[i]));
        }
        Object[] names = new String[nameList.size()];
        for (int i = 0; i < nameList.size(); ++i) {
            names[i] = (String)nameList.elementAt(i);
        }
        this._listPanel.clearChoices();
        this._listPanel.setChoices(names);
        this._listPanel.clearSelection();
    }

    public JComponent getRowTitle(int row) {
        return new JLabel(row + 1 + "/ ");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        char ch = ((JButton)e.getSource()).getText().charAt(0);
        if (ch == 'O') {
            StringBuffer sb = null;
            Object[] selected = this._listPanel.getSelectedValues();
            for (int i = 0; i < selected.length; ++i) {
                if (sb == null) {
                    sb = new StringBuffer();
                } else {
                    sb.append(',');
                }
                String selectedString = selected[i].toString();
                int ficonPos = selectedString.indexOf("(");
                String appendString = this._isFICON && ficonPos != -1 ? selectedString.substring(ficonPos + 1, selectedString.length() - 1) : selectedString.substring(0, ficonPos == -1 ? selectedString.length() : ficonPos - 1);
                sb.append(appendString);
            }
            if (sb != null) {
                this._target.InterfaceChooserCB(sb.toString(), this._context);
            }
        }
        this.dispose();
    }
}

