/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.mds;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.mds.PortEditor;
import com.cisco.dcbu.lib.mds.PortEditorFilter;
import com.cisco.dcbu.lib.mds.PortSet;
import com.cisco.dcbu.lib.mds.PortSetEditorIf;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.Util;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.JToggleButton;

public class PortSetEditor
extends PortEditor {
    boolean _showIfPrefix = true;
    PortSetEditorIf _target = null;
    PortSet _cardPortSelected = null;
    int[] _logicalIfSelected = null;
    private static PortSetEditor _Instance = null;

    public static PortSetEditor getInstance(JFrame parent) {
        if (_Instance == null) {
            _Instance = new PortSetEditor(parent);
        }
        return _Instance;
    }

    public PortSetEditor(JFrame parent) {
        super(parent, true);
    }

    public final void setTarget(PortSetEditorIf target) {
        this._target = target;
    }

    public void setShowIfPrefix(boolean showIfPrefix) {
        this._showIfPrefix = showIfPrefix;
    }

    public String getCardStr(int row) {
        String cardStr = this._slotMembers[row].getCardStr();
        return cardStr != null ? cardStr : String.valueOf(row + 1);
    }

    @Override
    public JComponent getRowTitle(int row) {
        JButton rowTitle = new JButton(this.getCardStr(row) + "/ ");
        rowTitle.putClientProperty("row", row);
        rowTitle.setMargin(Util.getNoBorder());
        rowTitle.addActionListener(this);
        return rowTitle;
    }

    @Override
    public void setFilter(PortEditorFilter filter) {
        this._filter = filter;
    }

    @Override
    public void setCellSelected(int r, int c) {
        if (this._b[r][c] != null) {
            boolean isSelected = false;
            if (this._cardPortSelected != null) {
                isSelected = PortSet.getBit(this._cardPortSelected.getValue(), r, c);
            }
            boolean isEnabled = this._b[r][c].isEnabled();
            this._b[r][c].setSelected(isEnabled && isSelected);
        }
    }

    @Override
    public void setCellSelected(int[] logicalInterfaces) {
        if (this._listPanel != null) {
            this._listPanel.clearSelection();
            if (this._logicalIfSelected != null && this._logicalIfSelected.length > 0) {
                block0: for (int i = 0; i < this._logicalIfSelected.length; ++i) {
                    for (int j = 0; j < logicalInterfaces.length; ++j) {
                        int ifIndex = logicalInterfaces[j];
                        if (ifIndex == this._logicalIfSelected[i]) {
                            this._listPanel.setSelected(j);
                            continue block0;
                        }
                        this._listPanel.setSelected(j, false);
                    }
                }
            }
        }
    }

    public void setSelected(PortSet cardPortSelected) {
        this._cardPortSelected = cardPortSelected;
    }

    public void setLogicalSelected(int[] ifSelected) {
        int i;
        ArrayList<Integer> logicalIf = new ArrayList<Integer>();
        for (i = 0; i < ifSelected.length; ++i) {
            if (IfIndexUtil.getType(ifSelected[i]) == 1 || IfIndexUtil.getType(ifSelected[i]) == 2 || IfIndexUtil.getType(ifSelected[i]) == 31 || IfIndexUtil.getType(ifSelected[i]) == 26) continue;
            logicalIf.add(new Integer(ifSelected[i]));
        }
        this._logicalIfSelected = new int[logicalIf.size()];
        for (i = 0; i < logicalIf.size(); ++i) {
            this._logicalIfSelected[i] = (Integer)logicalIf.get(i);
        }
    }

    boolean checkIfType(int r, int c) {
        boolean match = true;
        if (this._filter._ifFilter != null) {
            match = false;
            for (int i = 0; i < this._filter._ifFilter.length; ++i) {
                if (this._slotMembers[r] == null || this._slotMembers[r]._ifTypes[c] != this._filter._ifFilter[i]) continue;
                match = true;
                break;
            }
        }
        return match;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String label = ((JButton)e.getSource()).getText();
        if (label.equals(PortEditor._BtnLabel[0])) {
            byte[] byteValue = new byte[128];
            PortSet sel = new PortSet(byteValue);
            sel.setIfIndexIf(this._ifIndexIf);
            for (int r = 0; r < 30; ++r) {
                for (int c = 0; c < 64; ++c) {
                    JToggleButton b = this._b[r][c];
                    if (b == null || !b.isSelected() || !b.isEnabled() || !b.isVisible()) continue;
                    PortSet.setBit(byteValue, r, c);
                }
            }
            StringBuffer buf = new StringBuffer();
            String ports = sel.toString(this._slotMembers);
            if (ports != null && !ports.equals("")) {
                buf.append(ports);
            }
            if (this._box.isVisible()) {
                Object[] selected = this._listPanel.getSelectedValues();
                for (int i = 0; i < selected.length; ++i) {
                    if (buf.length() > 0) {
                        buf.append(',');
                    }
                    String selectedString = selected[i].toString();
                    String selectedS = selectedString.substring(0, selectedString.length());
                    String appendString = this._showIfPrefix ? selectedS : this.trimIfType(selectedS);
                    buf.append(appendString);
                }
            }
            if (buf != null) {
                this._target.portSetEditorCB(buf.toString(), this._context);
            }
            super.setVisible(false);
        } else if (label.equals(PortEditor._BtnLabel[1])) {
            super.setVisible(false);
        } else {
            if (!this._exclusive) {
                int r = (Integer)((JComponent)e.getSource()).getClientProperty("row");
                boolean selected = !this._b[r][0].isSelected();
                for (int c = 0; c < 64; ++c) {
                    JToggleButton b = this._b[r][c];
                    if (b == null || !b.isEnabled() || !b.isVisible()) continue;
                    b.setSelected(selected);
                }
            }
            return;
        }
    }

    public void showDlg(JComponent c) {
        this.setLocation(DialogUtil.getPointOnScreen(new Point(c.getWidth(), 0), c, this.getSize()));
        this.setVisible(true);
        this.toFront();
    }

    public void displayDlg(JTable table, int row, int column) {
        Rectangle rect = table.getCellRect(row, column, false);
        this.pack();
        this.setLocation(DialogUtil.getPointOnScreen(new Point(rect.x, rect.y), table, this.getSize()));
        this.setVisible(true);
        this.toFront();
    }

    public void hideDlg() {
        this.setVisible(false);
    }

    public JToggleButton getButton(int row, int col) {
        return this._b[row][col];
    }
}

