/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.mds.ficon;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;

public class FICONUtil {
    public static final int TYPE_DEFAULT = 1;
    public static final int TYPE_9100 = 2;
    public static final int TYPE_9500 = 3;
    static FICONUtil _instance;
    static int _numOfPortPerSlot;
    static int _type;

    public static FICONUtil getInstance(int type) {
        if (_instance == null) {
            _instance = new FICONUtil();
        }
        switch (type) {
            case 2: {
                _numOfPortPerSlot = 40;
                break;
            }
            default: {
                _numOfPortPerSlot = 32;
            }
        }
        _type = type;
        return _instance;
    }

    public int getPhysicalIfIndex(int FICONPortNum) {
        int card = FICONPortNum / _numOfPortPerSlot + 1;
        if (_type == 3 && card > 4) {
            card += 2;
        }
        int port = FICONPortNum % _numOfPortPerSlot;
        return IfIndexUtil.nameToIfIndex(card, port, 1);
    }

    public int getFICONPortNum(int ifIndex) {
        int card = IfIndexUtil.ifIndex2Card(ifIndex) + 1;
        if (_type == 3 && card > 4) {
            card -= 2;
        }
        int port = IfIndexUtil.ifIndex2Port(ifIndex) + 1;
        return (card - 1) * _numOfPortPerSlot + port;
    }
}

