/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.mds.ficon;

import com.cisco.dcbu.lib.jnm.SnmpIntList;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.lib.util.IntHashMap;
import java.lang.reflect.Method;

public class FiconPortByIfIndexCache {
    static FiconPortByIfIndexCache _instance;
    static boolean _isFiconEnabled;
    IntHashMap _ficonPortByIfIndexMap;
    IntHashMap _ficonIfIndexByPortMap;
    IntHashMap _ficonPortNumByPortAddrMap;
    IntHashMap _ficonPortAddrByPortNumMap;
    public static final int[] _cficonPortIfIndexOid;
    public static final int[] _cficonPortAddrPortNumberOid;
    static SnmpPeer _peer;
    static boolean _isSupportDynmicPortAdr;
    public static Class _updateTypeClass;
    public static String _updateTypeMethods;

    public static FiconPortByIfIndexCache getInstance(SnmpPeer peer) {
        if (_instance == null) {
            _instance = new FiconPortByIfIndexCache();
        }
        _peer = peer;
        return _instance;
    }

    public void init(boolean isSupportDynmicPortAdr) {
        _isSupportDynmicPortAdr = isSupportDynmicPortAdr;
        this.clearCache();
        this.getFiconPortTable();
    }

    public void buildCache(boolean isSupportDynmicPortAdr) {
        if (this._ficonPortNumByPortAddrMap == null || this._ficonPortAddrByPortNumMap == null || this._ficonPortByIfIndexMap == null || this._ficonIfIndexByPortMap == null) {
            _isSupportDynmicPortAdr = isSupportDynmicPortAdr;
            this.getFiconPortTable();
        }
    }

    public boolean getIsFiconEnabled() {
        return _isFiconEnabled;
    }

    public void setIsFiconEnabled(boolean enable, boolean isSupportDynmicPortAdr) {
        _isFiconEnabled = enable;
        if (!enable) {
            this.clearCache();
        } else {
            this.buildCache(isSupportDynmicPortAdr);
        }
    }

    public IntHashMap getPortByIfIndexHashMap() {
        return this._ficonPortByIfIndexMap;
    }

    public IntHashMap getIfIndexByPortHashMap() {
        return this._ficonIfIndexByPortMap;
    }

    public IntHashMap getPortByAddrHashMap() {
        return this._ficonPortNumByPortAddrMap;
    }

    public void clearCache() {
        this._ficonPortByIfIndexMap = null;
        this._ficonIfIndexByPortMap = null;
        this._ficonPortNumByPortAddrMap = null;
        this._ficonPortAddrByPortNumMap = null;
    }

    public int getFiconPort(int ifIndex) {
        if (!this.getIsFiconEnabled()) {
            return -1;
        }
        if (this._ficonPortByIfIndexMap == null) {
            this.getFiconPortTable();
        }
        return this._ficonPortByIfIndexMap == null || this._ficonPortByIfIndexMap.get(ifIndex) == null ? -1 : (Integer)this._ficonPortByIfIndexMap.get(ifIndex);
    }

    public void setFiconPort(int ifIndex, int ficonPort) {
        Array<Integer> list;
        if (this._ficonPortByIfIndexMap == null || this._ficonIfIndexByPortMap == null) {
            this.getFiconPortTable();
        }
        if (!this.getIsFiconEnabled()) {
            return;
        }
        if (ifIndex == 0 && this._ficonIfIndexByPortMap.get(ficonPort) != null && (list = (Array<Integer>)this._ficonIfIndexByPortMap.get(ficonPort)) != null) {
            for (int i = 0; i < list.size(); ++i) {
                int oldIfIndex = (Integer)list.elementAt(i);
                if (oldIfIndex == 0) continue;
                this._ficonPortByIfIndexMap.put(oldIfIndex, null);
            }
        }
        if (ficonPort == -1) {
            int oldFiconPort;
            if (this._ficonPortByIfIndexMap.get(ifIndex) != null && (oldFiconPort = ((Integer)this._ficonPortByIfIndexMap.get(ifIndex)).intValue()) != 0) {
                Array list2 = (Array)this._ficonIfIndexByPortMap.get(oldFiconPort);
                for (int i = list2.size() - 1; i >= 0; --i) {
                    if ((Integer)list2.elementAt(i) != ifIndex) continue;
                    list2.removeElementAt(i);
                }
                if (list2.size() == 0) {
                    this._ficonIfIndexByPortMap.put(oldFiconPort, null);
                }
            }
            this._ficonPortByIfIndexMap.put(ifIndex, new Integer(ficonPort));
        } else {
            if (ifIndex != 0) {
                this._ficonPortByIfIndexMap.put(ifIndex, new Integer(ficonPort));
            }
            if ((list = (Array)this._ficonIfIndexByPortMap.get(ficonPort)) == null) {
                list = new Array<Integer>();
            }
            if (this.isNewIfIndex(list, ifIndex)) {
                list.addElement(new Integer(ifIndex));
                this._ficonIfIndexByPortMap.put(ficonPort, list);
            }
        }
    }

    public int getFiconPortNumByIfIndex(int ifIndex) {
        if (this._ficonPortByIfIndexMap == null) {
            this.getFiconPortTable();
        }
        if (!this.getIsFiconEnabled()) {
            return -1;
        }
        return this._ficonPortByIfIndexMap == null || this._ficonPortByIfIndexMap.get(ifIndex) == null ? -1 : this.getFiconPortNum((Integer)this._ficonPortByIfIndexMap.get(ifIndex));
    }

    public Array getFiconIfIndexByPortAddr(int portAddr) {
        if (this._ficonIfIndexByPortMap == null) {
            this.getFiconPortTable();
        }
        if (!this.getIsFiconEnabled()) {
            return null;
        }
        return this._ficonIfIndexByPortMap == null || this._ficonIfIndexByPortMap.get(portAddr) == null ? null : (Array)this._ficonIfIndexByPortMap.get(portAddr);
    }

    public int getFiconPortNum(int portAddr) {
        if (this._ficonPortNumByPortAddrMap == null) {
            this.getFiconPortTable();
        }
        if (!this.getIsFiconEnabled()) {
            return -1;
        }
        return this._ficonPortNumByPortAddrMap == null || this._ficonPortNumByPortAddrMap.get(portAddr) == null ? -1 : (Integer)this._ficonPortNumByPortAddrMap.get(portAddr);
    }

    public int getFiconPortAddr(int portNum) {
        if (this._ficonPortAddrByPortNumMap == null) {
            this.getFiconPortTable();
        }
        if (!this.getIsFiconEnabled()) {
            return -1;
        }
        return this._ficonPortAddrByPortNumMap == null || this._ficonPortAddrByPortNumMap.get(portNum) == null ? -1 : (Integer)this._ficonPortAddrByPortNumMap.get(portNum);
    }

    public void setFiconPortNumAddr(int portAddr, int portNum) {
        if (this._ficonPortNumByPortAddrMap == null || this._ficonPortAddrByPortNumMap == null) {
            this.getFiconPortTable();
        }
        if (!this.getIsFiconEnabled()) {
            return;
        }
        this._ficonPortNumByPortAddrMap.put(portAddr, new Integer(portNum));
        this._ficonPortAddrByPortNumMap.put(portNum, new Integer(portAddr));
    }

    boolean isNewIfIndex(Array list, int ifIndex) {
        if (list == null) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            if ((Integer)list.elementAt(i) != ifIndex) continue;
            return false;
        }
        return true;
    }

    void getFiconPortTable_pre3_0() {
        int[] index = new int[]{0};
        SnmpPDU pdu = new SnmpPDU(-96, new VarBindList(6));
        pdu.addVar(new SnmpOID(MibNode.get("cficonPortMap1").getOid(), index));
        pdu.addVar(new SnmpOID(MibNode.get("cficonPortMap2").getOid(), index));
        pdu.addVar(new SnmpOID(MibNode.get("cficonPortMap3").getOid(), index));
        pdu.addVar(new SnmpOID(MibNode.get("cficonPortMap4").getOid(), index));
        pdu.addVar(new SnmpOID(MibNode.get("cficonPortMap5").getOid(), index));
        pdu.addVar(new SnmpOID(MibNode.get("cficonPortMap6").getOid(), index));
        try {
            byte[] b;
            int i;
            if (this._ficonPortByIfIndexMap == null || this._ficonIfIndexByPortMap == null || this._ficonPortNumByPortAddrMap == null || this._ficonPortAddrByPortNumMap == null) {
                this._ficonPortByIfIndexMap = new IntHashMap();
                this._ficonIfIndexByPortMap = new IntHashMap();
                this._ficonPortNumByPortAddrMap = new IntHashMap();
                this._ficonPortAddrByPortNumMap = new IntHashMap();
            } else {
                this._ficonPortByIfIndexMap.clear();
                this._ficonIfIndexByPortMap.clear();
                this._ficonPortNumByPortAddrMap.clear();
                this._ficonPortAddrByPortNumMap.clear();
            }
            SnmpPDU resp = _peer.send(pdu);
            if (resp.getVariables().get(0).getVar().getType() == 5) {
                this.setIsFiconEnabled(false, false);
                return;
            }
            this.setIsFiconEnabled(true, false);
            Array<Integer> ch_cu_Ports = new Array<Integer>();
            byte[] portMap = new byte[1512];
            for (i = 0; i < 6; ++i) {
                System.arraycopy(b, 0, portMap, i * 252, (b = resp.getVariables().byteValue(i)).length > 252 ? 252 : b.length);
            }
            for (i = 0; i < portMap.length; i += 6) {
                b = new byte[6];
                System.arraycopy(portMap, i, b, 0, 6);
                int ifIndex = ((b[5] & 0xFF) << 24) + ((b[4] & 0xFF) << 16) + ((b[3] & 0xFF) << 8) + (b[2] & 0xFF);
                if (ifIndex == 0) continue;
                int portNum = i / 6;
                int portAddr = b[1] & 0xFF;
                int type = b[0] & 0xFF;
                if (type == 1 || type == 2) {
                    ch_cu_Ports.addElement(new Integer(ifIndex));
                    ch_cu_Ports.addElement(new Integer(type));
                }
                this._ficonPortByIfIndexMap.put(ifIndex, new Integer(portAddr));
                Array<Integer> list = (Array<Integer>)this._ficonIfIndexByPortMap.get(portAddr);
                if (list == null) {
                    list = new Array<Integer>();
                }
                if (this.isNewIfIndex(list, ifIndex)) {
                    list.addElement(new Integer(ifIndex));
                    this._ficonIfIndexByPortMap.put(portAddr, list);
                }
                this._ficonPortNumByPortAddrMap.put(portAddr, new Integer(portNum));
                this._ficonPortAddrByPortNumMap.put(portNum, new Integer(portAddr));
            }
            if (ch_cu_Ports.size() > 0 && _updateTypeClass != null && _updateTypeMethods != null) {
                try {
                    Class[] types = new Class[]{Array.class};
                    Object[] args = new Object[]{ch_cu_Ports};
                    Method m = _updateTypeClass.getMethod(_updateTypeMethods, types);
                    m.invoke((Object)_updateTypeClass, args);
                }
                catch (Exception ex) {}
            }
        }
        catch (SnmpException ex) {
            System.err.println("FICON build cache failed: " + ex.getMessage());
        }
    }

    void getFiconPortTable() {
        SnmpPDU resp;
        if (!_isSupportDynmicPortAdr) {
            this.getFiconPortTable_pre3_0();
            return;
        }
        int[] index = new int[]{0};
        int max = 0;
        SnmpPDU pdu = new SnmpPDU(-96, new VarBindList(6));
        pdu.addVar(new SnmpOID(MibNode.get("cficonPortMapMax").getOid(), index));
        try {
            resp = _peer.send(pdu);
            if (resp.getVariables().get(0).getVar().getType() == 5) {
                this.setIsFiconEnabled(false, true);
            }
            max = resp.getVariables().intValue(0);
        }
        catch (SnmpException ex) {
            this.setIsFiconEnabled(false, true);
            return;
        }
        if (max <= 0) {
            return;
        }
        pdu = new SnmpPDU(-91, new VarBindList(6));
        pdu.addVar(new SnmpOID(MibNode.get("cficonPortMapObj").getOid()));
        pdu.setMaxRptr(max);
        try {
            byte[] b;
            int i;
            if (this._ficonPortByIfIndexMap == null || this._ficonIfIndexByPortMap == null || this._ficonPortNumByPortAddrMap == null || this._ficonPortAddrByPortNumMap == null) {
                this._ficonPortByIfIndexMap = new IntHashMap();
                this._ficonIfIndexByPortMap = new IntHashMap();
                this._ficonPortNumByPortAddrMap = new IntHashMap();
                this._ficonPortAddrByPortNumMap = new IntHashMap();
            } else {
                this._ficonPortByIfIndexMap.clear();
                this._ficonIfIndexByPortMap.clear();
                this._ficonPortNumByPortAddrMap.clear();
                this._ficonPortAddrByPortNumMap.clear();
            }
            resp = SnmpFetch.getBulk(_peer, pdu.getVariables());
            if (resp.getVariables().get(0).getVar().getType() == 5) {
                this.setIsFiconEnabled(false, true);
                return;
            }
            this.setIsFiconEnabled(true, true);
            Array<Integer> ch_cu_Ports = new Array<Integer>();
            byte[] portMap = new byte[252 * resp.getVariables().size()];
            for (i = 0; i < resp.getVariables().size(); ++i) {
                System.arraycopy(b, 0, portMap, i * 252, (b = resp.getVariables().byteValue(i)).length > 252 ? 252 : b.length);
            }
            for (i = 0; i < portMap.length; i += 7) {
                b = new byte[7];
                System.arraycopy(portMap, i, b, 0, 7);
                int ifIndex = SnmpIntList.bytesToInt(b, 2);
                if (ifIndex == 0) continue;
                int portNum = b[6] & 0xFF;
                int portAddr = b[1] & 0xFF;
                int type = b[0] & 0xFF;
                ch_cu_Ports.addElement(new Integer(ifIndex));
                ch_cu_Ports.addElement(new Integer(type == 1 || type == 2 ? type : 0));
                this._ficonPortByIfIndexMap.put(ifIndex, new Integer(portAddr));
                Array<Integer> list = (Array<Integer>)this._ficonIfIndexByPortMap.get(portAddr);
                if (list == null) {
                    list = new Array<Integer>();
                }
                if (this.isNewIfIndex(list, ifIndex)) {
                    list.addElement(new Integer(ifIndex));
                    this._ficonIfIndexByPortMap.put(portAddr, list);
                }
                this._ficonPortNumByPortAddrMap.put(portAddr, new Integer(portNum));
                this._ficonPortAddrByPortNumMap.put(portNum, new Integer(portAddr));
            }
            if (ch_cu_Ports.size() > 0 && _updateTypeClass != null && _updateTypeMethods != null) {
                try {
                    Class[] types = new Class[]{Array.class};
                    Object[] args = new Object[]{ch_cu_Ports};
                    Method m = _updateTypeClass.getMethod(_updateTypeMethods, types);
                    m.invoke((Object)_updateTypeClass, args);
                }
                catch (Exception ex) {}
            }
        }
        catch (SnmpException ex) {
            System.err.println("FICON build cache failed: " + ex.getMessage());
        }
    }

    static {
        _isFiconEnabled = false;
        _cficonPortIfIndexOid = MibNode.get("cficonPortIfIndex").getOid();
        _cficonPortAddrPortNumberOid = MibNode.get("cficonPortAddrPortNumber").getOid();
        _isSupportDynmicPortAdr = true;
    }
}

