/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.mds.flash;

import com.cisco.dcbu.lib.jnm.DefaultSnmpNumberRenderer;
import com.cisco.dcbu.lib.jnm.ExternalTools;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.mds.flash.FileSystemModel;
import com.cisco.dcbu.lib.mds.flash.FlashFileRow;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpCounter64;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpUnsignedInt;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.util.Array;
import com.jidesoft.grid.ExpandableRow;
import com.jidesoft.grid.TreeTable;
import com.jidesoft.grid.TreeTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class FlashFileDialog
extends JDialog
implements ActionListener {
    private static final int SHOW_DIRECTORY_FILTER = 1;
    private static final int HIDE_DIRECTORY_FILTER = 2;
    protected final HashMap _fileSystemMap = new HashMap();
    protected JPanel panel = new JPanel(new FlowLayout(0, 1, 2));
    protected JPanel _buttonAndStatusPanel = new JPanel(new BorderLayout());
    protected JComboBox _deviceCombo;
    protected Array _buttonArray = new Array();
    private static final String[] _buttonText = new String[]{"Delete", "Refresh", "Ok", "Close"};
    final int[] dOid = MibNode.get("ciscoFlashDeviceName").getOid();
    final int[] pOid = MibNode.get("ciscoFlashPartitionName").getOid();
    protected JComboBox _partitionsCombo;
    protected JScrollPane _treePane;
    protected String _switchIp;
    protected FlashTreeTable _treeTable;
    protected boolean _isBuilt = false;
    protected JLabel _status;
    protected FilterFileSystemModel _model;
    protected String _fileSystem;
    protected String _volume;
    protected Vector[] _partitions = new Vector[7];
    protected ArrayList _devices = new ArrayList();
    protected Object _lockObject = new Object();
    protected boolean _isWaiting;
    protected FlashFileRow _selected;
    protected JFrame _frame;
    protected SnmpPeer _peer;
    protected String _filter;
    protected boolean _showOKButton = true;
    protected int _deviceComboIndex;
    protected int _partitionComboIndex;
    protected boolean _isFileDelNeedConfirm;
    protected boolean _isDirDelDoubleConfirm;
    static final String ACTIVE = "active";
    protected String _supType = "active";
    Logger _log;

    protected FlashFileDialog(SnmpPeer peer, JFrame frame, Logger log, boolean isFileDelNeedConfirm, boolean isDirDelDoubleConfirm) throws SnmpException {
        super(frame);
        this._peer = peer;
        this._isFileDelNeedConfirm = isFileDelNeedConfirm;
        this._isDirDelDoubleConfirm = isDirDelDoubleConfirm;
        this.setPreferredSize(new Dimension(500, 600));
        try {
            this._frame = frame;
            this.populateDevicePartitions();
            this._switchIp = peer.getAddress().getHostAddress();
        }
        catch (SnmpException sse) {
            Util.errorMessage((Component)this._frame, sse.getMessage());
            if (SnmpSession.isTrace()) {
                System.err.println(sse.getMessage());
                DefaultLogger._ExLogger.warn((Object)sse.getMessage(), (Throwable)sse);
            }
            throw sse;
        }
    }

    private void populateDevicePartitions() throws SnmpException {
        int i;
        VarBindList vbl = new VarBindList();
        vbl.add(new SnmpVarBind(new SnmpOID(this.dOid)));
        SnmpPDU pdu = SnmpFetch.getBulk(this._peer, vbl, 10, this._log);
        if (pdu.getVariables().size() == 0) {
            return;
        }
        int[] first_oid = pdu.getVariables().get(0).getOid().getValue();
        if (SnmpOID.startsWith(first_oid, this.dOid)) {
            vbl = pdu.getVariables();
            for (i = 0; i < vbl.size(); ++i) {
                this._devices.add(vbl.stringValue(i) + ":");
            }
        }
        this._partitions = new Vector[7];
        vbl = new VarBindList();
        vbl.add(new SnmpVarBind(new SnmpOID(this.pOid)));
        pdu = SnmpFetch.getBulk(this._peer, vbl, 15, this._log);
        first_oid = pdu.getVariables().get(0).getOid().getValue();
        if (SnmpOID.startsWith(first_oid, this.pOid)) {
            vbl = pdu.getVariables();
            for (i = 0; i < vbl.size(); ++i) {
                int device;
                SnmpVarBind vb = vbl.getVb(i);
                int[] oid = vb.getOid().getValue();
                String name = vbl.stringValue(i);
                if (!SnmpOID.startsWith(oid, this.pOid)) continue;
                if (name.equals("sup-remote")) {
                    name = "sup-standby";
                }
                if (this._partitions[(device = oid[oid.length - 2]) - 1] == null) {
                    this._partitions[device - 1] = new Vector();
                }
                this._partitions[device - 1].add(name);
            }
        }
    }

    protected FlashFileDialog(String switchIpIn, String volume, String fileSystem, JFrame frame) {
        super(frame);
        this._frame = frame;
        this.setPreferredSize(new Dimension(500, 600));
        this._switchIp = switchIpIn;
        if (this._switchIp == null) {
            this._switchIp = JOptionPane.showInputDialog(this._frame, (Object)"Enter the switch IP Address.");
        }
        if (this._switchIp == null) {
            return;
        }
        this._fileSystem = fileSystem == null ? "bootflash:" : fileSystem;
        this._volume = volume;
    }

    protected FlashFileDialog(SnmpPeer peer, JFrame frame, String supType, Logger log, boolean isFileDelNeedConfirm, boolean isDirDelDoubleConfirm) throws SnmpException {
        this(peer, frame, log, isFileDelNeedConfirm, isDirDelDoubleConfirm);
        this._supType = supType;
    }

    public ArrayList getDevices() {
        return this._devices;
    }

    public ArrayList getPartitions(int deviceIndex) {
        if (deviceIndex < 0 || deviceIndex > this._partitions.length) {
            return null;
        }
        Vector v = this._partitions[deviceIndex];
        if (v == null) {
            return null;
        }
        return new ArrayList(v);
    }

    public void refresh() {
        this.refresh(true);
    }

    public void setShowOKButton(boolean show) {
        this._showOKButton = show;
    }

    public boolean isShowOKButton() {
        return this._showOKButton;
    }

    public boolean getShowOKButton() {
        return this._showOKButton;
    }

    public void refresh(boolean force) {
        block4: {
            if (this._volume == null || this._fileSystem == null) {
                return;
            }
            try {
                this.populateDevicePartitions();
            }
            catch (SnmpException sse) {
                Util.errorMessage((Component)this._frame, sse.getMessage());
                if (!SnmpSession.isTrace()) break block4;
                System.err.println(sse.getMessage());
                DefaultLogger._ExLogger.warn((Object)sse.getMessage(), (Throwable)sse);
            }
        }
        if (this._fileSystemMap.get(this._switchIp + "::" + this._volume + "::" + this._fileSystem) != null && force) {
            this._fileSystemMap.remove(this._switchIp + "::" + this._volume + "::" + this._fileSystem);
        }
        this.get();
    }

    public static FlashFileDialog get(SnmpPeer peer, JFrame frame, Logger log, boolean isFileDelNeedConfirm, boolean isDirDelDoubleConfirm) throws SnmpException {
        return new FlashFileDialog(peer, frame, log, isFileDelNeedConfirm, isDirDelDoubleConfirm);
    }

    public static FlashFileDialog get(String switchIpIn, String volume, String fileSystem, JFrame frame, boolean isFileDelNeedConfirm, boolean isDirDelDoubleConfirm) {
        return new FlashFileDialog(switchIpIn, volume, fileSystem, frame);
    }

    public void setFilter(String filter) {
        this._filter = filter;
    }

    public String getFilter() {
        return this._filter;
    }

    protected Array getButtons() {
        if (this._buttonArray.size() > 0) {
            return this._buttonArray;
        }
        for (int i = 0; i < _buttonText.length; ++i) {
            this._buttonArray.addElement(_buttonText[i]);
        }
        return this._buttonArray;
    }

    protected void setPreferredSizes() {
        this._treeTable.getColumn("Name").setPreferredWidth(250);
        this._treeTable.getColumn("Modified").setPreferredWidth(100);
        this._treeTable.getColumn("Size").setPreferredWidth(50);
        this._treePane.setPreferredSize(new Dimension((int)this._treeTable.getPreferredSize().getWidth(), (int)this._treeTable.getPreferredSize().getHeight() + 30));
        this.setPreferredSize(new Dimension(500, Math.min((int)this._treePane.getPreferredSize().getHeight() + 120, 600)));
    }

    protected void setupTable() {
        ((DefaultTableCellRenderer)this._treeTable.getDefaultRenderer(this._treeTable.getColumnClass(1))).setHorizontalAlignment(4);
        FileSizeRenderer sizeRenderer = new FileSizeRenderer();
        sizeRenderer.setHorizontalAlignment(2);
        this._treeTable.getColumnModel().getColumn(1).setCellRenderer(sizeRenderer);
        DateRenderer dateRenderer = new DateRenderer();
        this._treeTable.getColumnModel().getColumn(2).setCellRenderer(dateRenderer);
    }

    public Logger getLogger() {
        return this._log;
    }

    public void setLogger(Logger log) {
        this._log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FlashFileRow getSelected() {
        block8: {
            if (this._log != null) {
                this._log.log((Priority)Level.INFO, (Object)"FlashFileDialog::getSelected() calling setVisible true");
            }
            this.setVisible(true);
            try {
                this._isWaiting = true;
                while (this._isWaiting) {
                    Object object = this._lockObject;
                    synchronized (object) {
                        this._lockObject.wait();
                    }
                }
            }
            catch (InterruptedException ite) {
                if (!SnmpSession.isTrace()) break block8;
                System.err.println(ite.getMessage());
                DefaultLogger._ExLogger.warn((Object)ite.getMessage(), (Throwable)ite);
            }
        }
        if (this._log != null) {
            this._log.log((Priority)Level.INFO, (Object)"FlashFileDialog::getSelected() calling setVisible false");
        }
        this.setVisible(false);
        if (SnmpSession.isTrace()) {
            System.out.println("Selected File is " + (Object)((Object)this._selected));
        }
        return this._selected;
    }

    public String mkdir(String newDirName, FlashFileRow parentNode) throws IOException {
        StringBuffer path = new StringBuffer();
        if (!parentNode.getFile().isFile()) {
            if (parentNode.getFile().getPath() != null) {
                path.append((parentNode.getFile().getPath().endsWith("/") ? parentNode.getFile().getPath() : parentNode.getFile().getPath() + "/") + parentNode.getFile().getName());
            } else {
                path.append(parentNode.getFile().getName() + "//" + parentNode.getFile().getVolume() + "/");
            }
        } else {
            path.append(parentNode.getFile().getPath());
            String[] pathArray = path.toString().split("/");
            if (pathArray.length <= 3) {
                path.append(pathArray[0] + "//");
            } else {
                for (int i = 0; i < pathArray.length - 2; ++i) {
                    if (i == 0) {
                        path.append(pathArray[0] + "//");
                        continue;
                    }
                    path.append(pathArray[i] + "/");
                }
            }
        }
        FlashFileRow.Result retString = this._model.mkdir(newDirName, path.toString());
        if (retString.hasWarning) {
            throw new IOException(retString.resultString);
        }
        this.refresh(true);
        return retString.resultString;
    }

    public String mkdir(String newDirName, String parentPath) throws IOException {
        FlashFileRow.Result retString = this._model.mkdir(newDirName, parentPath);
        if (retString.hasWarning) {
            throw new IOException(retString.resultString);
        }
        this.refresh(true);
        return retString.resultString;
    }

    public ArrayList copy(String sourceFullPath, String destFullPath) throws IOException {
        FlashFileRow.Result result = this._model.copy(sourceFullPath, destFullPath);
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(result.hasWarning ? Boolean.TRUE : Boolean.FALSE);
        list.add(result.resultString);
        return list;
    }

    public ArrayList delete(String deletePath, boolean isDir) throws IOException {
        FlashFileRow.Result result = this._model.delete(deletePath, isDir);
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(result.hasWarning ? Boolean.TRUE : Boolean.FALSE);
        list.add(result.resultString);
        return list;
    }

    protected void deleteAction() throws IOException {
        if (this._treeTable.getSelectedRow() == -1) {
            return;
        }
        int[] selectedRows = this._treeTable.getSelectedRows();
        if (selectedRows.length > 1) {
            int i;
            int optionInt;
            StringBuffer sb = new StringBuffer();
            for (int i2 = 0; i2 < selectedRows.length && i2 < 3; ++i2) {
                FlashFileRow flashFile = (FlashFileRow)((Object)this._treeTable.getFileNodeForRow(selectedRows[i2]));
                if (i2 > 0) {
                    sb.append(", ");
                }
                sb.append(flashFile.getFile().getDisplayName());
            }
            if (selectedRows.length > 3) {
                sb.append("...");
            }
            if ((optionInt = JOptionPane.showConfirmDialog(this, "Really delete " + sb.toString() + "?", this.getTitle(), 0)) == 1 || optionInt == -1) {
                return;
            }
            FlashFileRow[] selectedFlashFiles = new FlashFileRow[selectedRows.length];
            for (i = 0; i < selectedRows.length; ++i) {
                int selectedRow = selectedRows[i];
                selectedFlashFiles[i] = (FlashFileRow)((Object)this._treeTable.getFileNodeForRow(selectedRow));
            }
            for (i = 0; i < selectedFlashFiles.length; ++i) {
                this._selected = selectedFlashFiles[i];
                this.delete(this._selected, this._isFileDelNeedConfirm, this._isDirDelDoubleConfirm);
            }
        } else {
            FlashFileRow flashFileRow = (FlashFileRow)((Object)this._treeTable.getFileNodeForRow(this._treeTable.getSelectedRow()));
            int optionInt = JOptionPane.showConfirmDialog(this, "Really delete " + flashFileRow.getFile().getDisplayName() + "?", this.getTitle(), 0);
            if (optionInt == 1 || optionInt == -1) {
                return;
            }
            this.delete(flashFileRow, this._isFileDelNeedConfirm, this._isDirDelDoubleConfirm);
        }
        this.refresh();
    }

    public ArrayList delete(FlashFileRow node, boolean isFileDelNeedConfirm, boolean isDirDelDoubleConfirm) throws IOException {
        FlashFileRow.Result result;
        if (node.getFile().getPath() == null || node.getFile().getPath().trim().length() == 0) {
            throw new IOException("Cannot delete root directory");
        }
        if (node.getFile().isFile()) {
            FlashFileRow.Result result2 = this._model.delete((node.getFile().getPath().endsWith("/") ? node.getFile().getPath() : node.getFile().getPath() + "/") + node.getFile().getName(), false, isFileDelNeedConfirm, isDirDelDoubleConfirm);
            if (result2.hasWarning) {
                throw new IOException(result2.resultString);
            }
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(result2.hasWarning ? Boolean.TRUE : Boolean.FALSE);
            list.add(result2.resultString);
            return list;
        }
        List<?> children = node.getChildren();
        if (children == null || children.size() == 0) {
            result = this._model.delete((node.getFile().getPath().endsWith("/") ? node.getFile().getPath() : node.getFile().getPath() + "/") + node.getFile().getName(), true, isFileDelNeedConfirm, isDirDelDoubleConfirm);
        } else {
            result = new FlashFileRow.Result(this._model._rootNode);
            FlashFileRow.Result deleteResult = this._model.delete((node.getFile().getPath().endsWith("/") ? node.getFile().getPath() : node.getFile().getPath() + "/") + node.getFile().getName(), true, isFileDelNeedConfirm, isDirDelDoubleConfirm);
            result.hasWarning = deleteResult.hasWarning ? Boolean.TRUE : Boolean.FALSE;
            result.resultString = deleteResult.resultString;
        }
        if (result.hasWarning) {
            throw new IOException(result.resultString);
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(result.hasWarning ? Boolean.TRUE : Boolean.FALSE);
        list.add(result.resultString);
        return list;
    }

    @Override
    public void setVisible(boolean isShow) {
        if (this._log != null) {
            this._log.log((Priority)Level.INFO, (Object)("FlashFileDialog::setVisible  isShow " + isShow));
        }
        if (isShow) {
            if (this._log != null) {
                this._log.log((Priority)Level.INFO, (Object)("FlashFileDialog::setVisible  isBuilt " + this._isBuilt));
            }
            if (!this._isBuilt) {
                this.build();
            }
            this.pack();
            super.setVisible(true);
        } else {
            super.setVisible(isShow);
        }
    }

    protected ArrayList deleteWithChildren(FlashFileRow node, boolean isFileDelNeedConfirm, boolean isDirDelDoubleConfirm) throws IOException {
        FlashFileRow.Result result;
        ArrayList<Object> list = new ArrayList<Object>();
        if (node == null) {
            return list;
        }
        if (node.getChildren() != null && node.getChildren().size() > 0) {
            for (int i = 0; i < node.getChildren().size(); ++i) {
                list = this.deleteWithChildren((FlashFileRow)((Object)node.getChildren().get(i)), isFileDelNeedConfirm, isDirDelDoubleConfirm);
                if (list.size() <= 0 || !((Boolean)list.get(0)).booleanValue()) continue;
                return list;
            }
        }
        if (node.getFile().isFile()) {
            result = this._model.delete((node.getFile().getPath().endsWith("/") ? node.getFile().getPath() : node.getFile().getPath() + "/") + node.getFile().getName(), false, isFileDelNeedConfirm, isDirDelDoubleConfirm);
            if (result.hasWarning) {
                list = new ArrayList<Object>();
                list.add(result.hasWarning ? Boolean.TRUE : Boolean.FALSE);
                list.add(result.resultString);
                return list;
            }
        } else {
            result = this._model.delete((node.getFile().getPath().endsWith("/") ? node.getFile().getPath() : node.getFile().getPath() + "/") + node.getFile().getName(), true, isFileDelNeedConfirm, isDirDelDoubleConfirm);
            if (result.hasWarning) {
                list = new ArrayList();
                list.add(result.hasWarning ? Boolean.TRUE : Boolean.FALSE);
                list.add(result.resultString);
                return list;
            }
        }
        list = new ArrayList();
        list.add(result.hasWarning ? Boolean.TRUE : Boolean.FALSE);
        list.add(result.resultString);
        return list;
    }

    protected void build() {
        if (this._log != null) {
            this._log.log((Priority)Level.INFO, (Object)"FlashFileDialog::build...");
        }
        this._deviceCombo = new JComboBox();
        for (int dC = 0; dC < this._devices.size(); ++dC) {
            this._deviceCombo.addItem(this._devices.get(dC));
        }
        this._deviceCombo.addActionListener(this);
        this.panel.add(new JLabel("Device:"));
        this.panel.add(this._deviceCombo);
        this._partitionsCombo = new JComboBox();
        this.panel.add(new JLabel(" Partition:"));
        int selectedIndex = this._deviceCombo.getSelectedIndex();
        if (selectedIndex == -1) {
            selectedIndex = 0;
        }
        if (this._partitions[selectedIndex] != null) {
            for (int pC = 0; pC < this._partitions[selectedIndex].size(); ++pC) {
                this._partitionsCombo.addItem(this._partitions[selectedIndex].elementAt(pC));
            }
            this._partitionsCombo.addActionListener(this);
        }
        this.panel.add(this._partitionsCombo);
        JButton newDirButton = Util.createButton("icons/newfolder.gif", "Create Directory...", "k", this);
        this.panel.add(newDirButton);
        Container cont = this.getContentPane();
        this._fileSystem = (String)this._deviceCombo.getSelectedItem();
        if (this._supType.equals(ACTIVE)) {
            this._partitionComboIndex = 0;
            this._volume = (String)this._partitionsCombo.getItemAt(0);
        } else {
            this._partitionComboIndex = 1;
            this._volume = (String)this._partitionsCombo.getItemAt(1);
        }
        this.getContentPane().setLayout(new BorderLayout(4, 4));
        cont.add((Component)this.panel, "North");
        if (this._fileSystem == null) {
            this._fileSystem = "bootflash:";
            if (this._volume == null) {
                this._volume = "";
            }
        }
        this._model = this._peer == null ? new FilterFileSystemModel(this._frame, this._switchIp, ExternalTools.isUseSSH(), this._volume, this._fileSystem, this._log) : new FilterFileSystemModel(this._frame, this._peer, ExternalTools.isUseSSH(), this._volume, this._fileSystem, this._log);
        if (this._filter != null) {
            this._model.setFilter(this._filter);
        }
        this._treeTable = new FlashTreeTable(this._model);
        this._treeTable.getColumn("Modified").setPreferredWidth(100);
        this._treeTable.getColumn("Size").setPreferredWidth(50);
        this._treeTable.getColumn("Name").setPreferredWidth(250);
        this.setupTable();
        this._fileSystemMap.put(this._switchIp + "::" + this._volume + "::" + this._fileSystem, this._model);
        this._treePane = new JScrollPane((Component)((Object)this._treeTable));
        cont.add((Component)this._treePane, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(2, 6, 3));
        Array bArray = this.getButtons();
        for (int i = 0; i < bArray.size(); ++i) {
            String text;
            int indexOfAnd = bArray.elementAt(i).toString().indexOf("&");
            String origText = text = (String)bArray.elementAt(i);
            if (indexOfAnd > -1) {
                text = origText.substring(0, indexOfAnd > 0 ? indexOfAnd : 0) + origText.substring(indexOfAnd + 1);
            }
            if (text.equalsIgnoreCase("Ok") && !this.isShowOKButton()) continue;
            JButton toAddButton = new JButton(text);
            buttonPanel.add(toAddButton);
            toAddButton.setActionCommand(Character.toString(origText.charAt(indexOfAnd + 1)));
            toAddButton.addActionListener(this);
        }
        this._treePane.setPreferredSize(new Dimension((int)this._treeTable.getPreferredSize().getWidth(), (int)this._treeTable.getPreferredSize().getHeight() + 30));
        this.setPreferredSize(new Dimension(500, Math.min((int)this._treePane.getPreferredSize().getHeight() + 120, 600)));
        this._buttonAndStatusPanel.add("Center", buttonPanel);
        this._status = new JLabel(" ");
        this._status.setFont((Font)UIManager.getDefaults().get("Table.font"));
        this._status.setBorder(null);
        this.updateStatus(this._treeTable.getRowCount() - 1, this._model.getUsed(), this._model.getFree());
        this._buttonAndStatusPanel.add("South", this._status);
        cont.add("South", this._buttonAndStatusPanel);
        if (this._deviceComboIndex > 0 || this._partitionComboIndex > 0) {
            if (this._log != null) {
                this._log.log((Priority)Level.INFO, (Object)"FlashFileDialog::build  calling get()...");
            }
            this._partitionsCombo.setSelectedIndex(this._partitionComboIndex);
            if (this._log != null) {
                this._log.log((Priority)Level.INFO, (Object)"FlashFileDialog::build  calling get()...");
            }
        }
        this._isBuilt = true;
        if (this._log != null) {
            this._log.log((Priority)Level.INFO, (Object)("FlashFileDialog::build finish isBuilt " + this._isBuilt));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doIt(ActionEvent aEvent) {
        if (aEvent.getSource() == this._deviceCombo) {
            this._partitionsCombo.removeActionListener(this);
            this._partitionsCombo.removeAllItems();
            int dIndx = this._deviceCombo.getSelectedIndex();
            if (this._partitions[dIndx] != null) {
                for (int i = 0; i < this._partitions[dIndx].size(); ++i) {
                    this._partitionsCombo.addItem(this._partitions[dIndx].elementAt(i));
                }
            } else {
                this._model = null;
                this._treeTable.setModel(null);
                this._status.setText(" ");
                return;
            }
            this._partitionsCombo.addActionListener(this);
            this.get();
        } else if (aEvent.getSource() == this._partitionsCombo) {
            this.refresh(false);
        } else if (aEvent.getSource() instanceof JButton) {
            switch (aEvent.getActionCommand().charAt(0)) {
                case 'O': {
                    this.selectAction();
                    break;
                }
                case 'D': {
                    try {
                        this.deleteAction();
                    }
                    catch (IOException ioe) {
                        this._selected = null;
                        Util.errorMessage((Component)this, ioe.getMessage());
                        this.refresh();
                        if (!SnmpSession.isTrace()) break;
                        System.err.println(ioe.getMessage());
                        DefaultLogger._ExLogger.warn((Object)ioe.getMessage(), (Throwable)ioe);
                    }
                    break;
                }
                case 'k': {
                    try {
                        this.mkdirAction();
                    }
                    catch (IOException ioe) {
                        this._selected = null;
                        Util.errorMessage((Component)this, ioe.getMessage());
                        if (!SnmpSession.isTrace()) break;
                        System.err.println(ioe.getMessage());
                        DefaultLogger._ExLogger.warn((Object)ioe.getMessage(), (Throwable)ioe);
                    }
                    break;
                }
                case 'R': {
                    this.refresh(true);
                    break;
                }
                case 'C': {
                    Object object = this._lockObject;
                    synchronized (object) {
                        this._lockObject.notifyAll();
                        this._isWaiting = false;
                    }
                    this.closeAction();
                    break;
                }
                case 'E': {
                    Object object = this._lockObject;
                    synchronized (object) {
                        this._lockObject.notifyAll();
                        this._isWaiting = false;
                    }
                    this.dispatchEvent(new WindowEvent(this, 201));
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent aEvent) {
        this.doIt(aEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectAction() {
        if (this._treeTable.getSelectedRow() == -1) {
            Object object = this._lockObject;
            synchronized (object) {
                this._lockObject.notifyAll();
                this._isWaiting = false;
            }
            if (this._log != null) {
                this._log.log((Priority)Level.INFO, (Object)"FlashFileDialog::selectAction() calling setVisible false");
            }
            this.setVisible(false);
            return;
        }
        int selectedRow = this._treeTable.getSelectedRow();
        this._selected = (FlashFileRow)((Object)this._treeTable.getFileNodeForRow(selectedRow));
        Object object = this._lockObject;
        synchronized (object) {
            this._lockObject.notifyAll();
            this._isWaiting = false;
        }
        if (this._log != null) {
            this._log.log((Priority)Level.INFO, (Object)"FlashFileDialog::selectAction() calling setVisible false");
        }
        this.setVisible(false);
    }

    protected void closeAction() {
        this.setVisible(false);
    }

    protected void mkdirAction() throws IOException {
        if (this._treeTable.getSelectedRows().length > 1) {
            throw new IOException("Please select one parent directory");
        }
        int selectedRow = 0;
        if (this._treeTable.getSelectedRow() != -1) {
            selectedRow = this._treeTable.getSelectedRow();
        }
        if (this._treeTable.getRowCount() == 0) {
            throw new IOException("Device/Partition not found");
        }
        this._selected = (FlashFileRow)((Object)this._treeTable.getFileNodeForRow(selectedRow));
        String newDirName = JOptionPane.showInputDialog(this, (Object)"New Directory Name:");
        if (newDirName == null) {
            return;
        }
        if (newDirName.trim().length() == 0) {
            throw new IOException("Bad Name");
        }
        this.mkdir(newDirName, this._selected);
    }

    private void get() {
        block9: {
            if (this._log != null) {
                this._log.log((Priority)Level.INFO, (Object)"FlashFileDialog::get()");
            }
            try {
                this._status.setText(" ");
                this._volume = (String)this._partitionsCombo.getSelectedItem();
                this._fileSystem = (String)this._deviceCombo.getSelectedItem();
                this._treeTable.removeAll();
                if (this._volume == null || this._fileSystem == null) {
                    this._model = null;
                    this._treeTable.removeAll();
                    this._treeTable.setModel(null);
                    return;
                }
                if (this._fileSystemMap.get(this._switchIp + "::" + this._volume + "::" + this._fileSystem) == null) {
                    if (this._log != null) {
                        this._log.log((Priority)Level.INFO, (Object)"FlashFileDialog::get()   fileSystemMap.get null new FilterFileSystemModel...");
                    }
                    this._model = this._peer == null ? new FilterFileSystemModel(this._frame, this._switchIp, ExternalTools.isUseSSH(), this._volume, this._fileSystem, this._log) : new FilterFileSystemModel(this._frame, this._peer, ExternalTools.isUseSSH(), this._volume, this._fileSystem, this._log);
                    if (this._filter != null) {
                        this._model.setFilter(this._filter);
                    }
                    this._treeTable.setModel((TableModel)((Object)this._model));
                    this.setupTable();
                    this._treeTable.expandFirstLevel();
                    this._fileSystemMap.put(this._switchIp + "::" + this._volume + "::" + this._fileSystem, this._model);
                } else {
                    if (this._log != null) {
                        this._log.log((Priority)Level.INFO, (Object)"FlashFileDialog::get()   fileSystemMap.get not null...");
                    }
                    this._model = (FilterFileSystemModel)((Object)this._fileSystemMap.get(this._switchIp + "::" + this._volume + "::" + this._fileSystem));
                    this._treeTable.setModel((TableModel)((Object)this._model));
                    this.setupTable();
                    this._treeTable.expandFirstLevel();
                }
                this.setPreferredSizes();
                this.updateStatus(this._treeTable.getRowCount() - 1, this._model.getUsed(), this._model.getFree());
            }
            catch (Exception e) {
                Util.errorMessage((Component)this, e.getMessage());
                if (!SnmpSession.isTrace()) break block9;
                System.err.println(e.getMessage());
                DefaultLogger._ExLogger.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void updateStatus(int count, long used, long free) {
        this._status.setText(count + " Entries (Used: " + DefaultSnmpNumberRenderer.formatLong(used) + ", Free: " + DefaultSnmpNumberRenderer.formatLong(free) + ")");
    }

    class DateRenderer
    extends DefaultTableCellRenderer {
        DateRenderer() {
        }

        @Override
        protected void setValue(Object value) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM dd HH:mm:ss yyyy");
            if (value == null) {
                this.setText(simpleDateFormat.format(GregorianCalendar.getInstance().getTime()));
            } else if (value instanceof Date) {
                this.setText(simpleDateFormat.format(value));
            } else {
                this.setText("");
            }
        }
    }

    class FileSizeRenderer
    extends DefaultSnmpNumberRenderer {
        FileSizeRenderer() {
        }

        @Override
        protected void setValue(Object value) {
            if (value != null && value instanceof Number && ((Number)value).longValue() == 0L) {
                this.setText(" ");
            } else if (value == null) {
                this.setText("");
            } else if (value instanceof SnmpUnsignedInt) {
                this.setText(((SnmpUnsignedInt)value).getValue() + "");
            } else if (value instanceof SnmpInt) {
                this.setText((long)((SnmpInt)value).getValue() + "");
            } else if (value instanceof SnmpCounter64) {
                this.setText(((SnmpCounter64)value).getBigValue().toString());
            } else if (value instanceof Number) {
                this.setText(((Number)value).longValue() + "");
            }
        }
    }

    protected class FilterFileSystemModel
    extends FileSystemModel {
        String _filter;
        int _directory_filter;
        Pattern p;
        protected final String[] COLUMN_NAMES;

        public FilterFileSystemModel(JFrame frame, String hostName, boolean useSSH, String volumeName, String rootDirName, Logger log) {
            super(frame, hostName, useSSH, volumeName, rootDirName, log);
            this._filter = ".*";
            this._directory_filter = 1;
            this.COLUMN_NAMES = new String[]{"Name", "Size", "Modified"};
        }

        public FilterFileSystemModel(JFrame frame, SnmpPeer peer, boolean useSSH, String volumeName, String rootDirName, Logger log) {
            super(frame, peer, useSSH, volumeName, rootDirName, log);
            this._filter = ".*";
            this._directory_filter = 1;
            this.COLUMN_NAMES = new String[]{"Name", "Size", "Modified"};
        }

        public void setFilter(String filter) {
            this._filter = filter;
        }

        public String getFilter() {
            return this._filter;
        }

        @Override
        protected List<FlashFileRow> getChildren(Object node) {
            List children = ((ExpandableRow)node).getChildren();
            ArrayList<FlashFileRow> returnArrayList = new ArrayList<FlashFileRow>();
            this.p = Pattern.compile(this._filter);
            for (Object child : children) {
                FlashFileRow row = (FlashFileRow)((Object)child);
                Matcher m = this.p.matcher(row.getFile().getName());
                if (row.getFile().isFile()) {
                    if (!m.matches()) continue;
                    returnArrayList.add(row);
                    continue;
                }
                if (this._directory_filter != 1) continue;
                returnArrayList.add(row);
            }
            return returnArrayList;
        }
    }

    protected class FlashTreeTable
    extends TreeTable
    implements TreeExpansionListener {
        public FlashTreeTable(TreeTableModel treeTableModel) {
            super((TableModel)treeTableModel);
            this.expandFirstLevel();
        }

        public Object getFileNodeForRow(int selectedRow) {
            FlashFileRow row = (FlashFileRow)this.getRowAt(selectedRow);
            return row;
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
            FlashFileDialog.this.setPreferredSizes();
            if (event.getPath().getPath().length > 2) {
                FlashFileDialog.this._treeTable.getColumn("Name").setPreferredWidth(30 * event.getPath().getPath().length);
                FlashFileDialog.this._treePane.setPreferredSize(new Dimension((int)FlashFileDialog.this._treeTable.getPreferredSize().getWidth(), (int)FlashFileDialog.this._treeTable.getPreferredSize().getHeight() + 30));
                this.setPreferredSize(new Dimension(500, Math.min((int)FlashFileDialog.this._treePane.getPreferredSize().getHeight() + 120, 600)));
            }
            FlashFileDialog.this.pack();
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
            FlashFileDialog.this.setPreferredSizes();
            FlashFileDialog.this.pack();
        }
    }
}

