/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.mds.zm;

import com.cisco.dcbu.lib.mds.zm.AbstractZone;
import com.cisco.dcbu.lib.mds.zm.CommandHandler;
import com.cisco.dcbu.lib.mds.zm.ZoneAlias;
import com.cisco.dcbu.lib.mds.zm.ZoneCapability;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import java.util.ArrayList;

public class Zone
extends AbstractZone {
    public static final String[] ZONE_VARS_NUMBER = new String[]{"zoneEnforcedZoneNumber", "zoneNumber"};
    public static final String[] IVR_ZONE_VARS_NUMBER = new String[]{"civrZoneEnforcedZoneNumber", "civrZoneNumber"};
    public static final String[] ZONE_VARS = new String[]{"zoneName", "zoneAliasList", "zoneLastChange", "zoneReadOnly", "zoneQos", "zoneQosPriority", "zoneBroadcast", "zoneSmartZoning"};
    public static final String[] IVR_ZONE_VARS = new String[]{"civrZoneName", "civrZoneReadOnly", "civrZoneQosPriority", "civrZoneLastChange"};
    public static final String[] ENF_ZONE_VARS = new String[]{"zoneEnforcedZoneName", "zoneEnforcedZoneAliasList", "zoneEnforcedZoneActivateTime", "zoneEnforcedZoneReadOnly", "zoneEnforcedZoneQos", "zoneEnforcedZoneQosPriority", "zoneEnforcedZoneBroadcast", "zoneEnforcedZoneSmartZoning"};
    public static final String[] IVR_ENF_ZONE_VARS = new String[]{"civrZoneEnforcedZoneName", "civrZoneEnforcedZoneReadOnly", "civrZoneEnforcedZoneQosPriority"};
    public static final int[] ZONE_ROW_STATUS_OID = MibNode.get("zoneRowStatus").getOid();
    public static final int[] IVR_ZONE_ROW_STATUS_OID = MibNode.get("civrZoneRowStatus").getOid();
    public static final int NAME = 0;
    public static final int ALIAS = 1;
    public static final int READ_ONLY = 3;
    public static final int QOS = 4;
    public static final int QOS_PRIORITY = 5;
    public static final int BROADCAST = 6;
    public static final int SMARTZONE = 7;
    public static final int LAST_MOD = 2;
    public static final int IVR_READ_ONLY = 1;
    public static final int IVR_QOS_PRIORITY = 2;
    private byte[] zoneAliases;
    private boolean readOnly;
    private boolean qos;
    private int qosPriority;
    private boolean broadcast;
    private boolean smartzone;

    public Zone(int vsan, int index, String name, byte[] aliases, long lastChange, boolean rdOnly, boolean theQos, int qosPrty, boolean brdcast, boolean smtzone) {
        this.zoneVsanId = vsan;
        this.zoneIndex = index;
        this.zoneName = name;
        this.zoneAliases = aliases;
        this.zoneLastModtime = lastChange;
        this.readOnly = rdOnly;
        this.type = 1;
        this.qos = theQos;
        this.qosPriority = qosPrty;
        this.broadcast = brdcast;
        this.smartzone = smtzone;
    }

    public Zone(int vsan, int index, String name, byte[] aliases, long lastChange, boolean rdOnly, boolean theQos, int qosPrty, boolean brdcast) {
        this(vsan, index, name, aliases, lastChange, rdOnly, theQos, qosPrty, brdcast, false);
    }

    public byte[] getZoneAliases() {
        return this.zoneAliases;
    }

    public void setZoneAliases(byte[] aliases) {
        this.zoneAliases = aliases;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isQos() {
        return this.qos;
    }

    public int getQosPriority() {
        return this.qosPriority;
    }

    public boolean isBroadcast() {
        return this.broadcast;
    }

    public boolean isSmartZone() {
        return this.smartzone;
    }

    @Override
    public int[] getRowStatusOid(boolean isIvr) {
        return isIvr ? IVR_ZONE_ROW_STATUS_OID : ZONE_ROW_STATUS_OID;
    }

    public boolean equalsbitarr(byte[] bt) {
        boolean bstatus = true;
        if (bt.length == this.zoneAliases.length) {
            for (int nbits = 0; nbits < bt.length; ++nbits) {
                if ((bt[nbits] ^ this.zoneAliases[nbits]) == 0) continue;
                bstatus = false;
                break;
            }
        } else {
            bstatus = false;
        }
        return bstatus;
    }

    @Override
    public int[] getSnmpIndex() {
        return Zone.getSnmpIndex(this.zoneVsanId, this.zoneIndex);
    }

    public static int[] getSnmpIndex(int vsan, int index) {
        int[] nArray;
        if (vsan == -1) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = index;
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = vsan;
            nArray = nArray3;
            nArray3[1] = index;
        }
        return nArray;
    }

    @Override
    public String getZoneName() {
        return this.toString();
    }

    public String toString() {
        return this.zoneName;
    }

    @Override
    public void buildLinkRemovePDU(VarBindList vbLst, Array list, ZoneCapability cap) {
        String[] vars = this.zoneVsanId != -1 ? ZONE_VARS : IVR_ZONE_VARS;
        byte[] memClone = new byte[this.zoneAliases.length];
        System.arraycopy(this.zoneAliases, 0, memClone, 0, this.zoneAliases.length);
        for (int i = 0; i < list.size(); ++i) {
            AbstractZone member = (AbstractZone)list.elementAt(i);
            if (!(member instanceof ZoneAlias)) continue;
            memClone = Zone.testBit(memClone, member.zoneIndex, false);
            SnmpString.clearBit(memClone, member.zoneIndex);
        }
        vbLst.add(MibNode.get(vars[1]).getOid(), this.getSnmpIndex(), (SnmpVar)new SnmpString(memClone));
    }

    @Override
    public void buildTimeStampVarBind(VarBindList tmstmpVBL) {
        String[] vars = this.zoneVsanId != -1 ? ZONE_VARS : IVR_ZONE_VARS;
        tmstmpVBL.add(MibNode.get(vars[2 + (this.zoneVsanId != -1 ? 0 : 1)]).getOid(), this.getSnmpIndex());
    }

    @Override
    public void removeLink(AbstractZone member) {
        this.zoneAliases = Zone.testBit(this.zoneAliases, member.zoneIndex, false);
        SnmpString.clearBit(this.zoneAliases, member.zoneIndex);
    }

    @Override
    public void addMembers(CommandHandler handler, AbstractZone[] az) throws SnmpException {
        handler.addMembers(this, az);
    }

    public static ArrayList discoverEnforced(CommandHandler handler, ArrayList members, ArrayList aliases) throws SnmpException {
        return handler.discoverZones(true, members, aliases);
    }

    public static Zone createNewZone(int vsan, int index, boolean readOnly, byte[] aliases, ArrayList aliasMembers, ArrayList members, String name, boolean qos, int qospriority, boolean broadcast, boolean smtzone, CommandHandler handler, long sysUpTime) throws SnmpException {
        Zone zn = new Zone(vsan, index, name, aliases, sysUpTime, readOnly, qos, qospriority, broadcast, smtzone);
        handler.createNewZone(zn, members, aliasMembers);
        return zn;
    }

    public static Zone buildNewZoneVbList(int vsan, int index, boolean readOnly, byte[] aliases, ArrayList members, String name, VarBindList vbLst, boolean qos, int qospriority, boolean broadcast, boolean smtzone, CommandHandler handler, long sysUpTime) throws SnmpException {
        Zone zn = new Zone(vsan, index, name, aliases, sysUpTime, readOnly, qos, qospriority, broadcast, smtzone);
        handler.buildNewZoneVbList(vsan, index, readOnly, aliases, members, name, qos, qospriority, broadcast, smtzone, vbLst);
        return zn;
    }

    public static void modifyZone(CommandHandler handler, ArrayList zoneList, long sysUpTime) throws SnmpException {
        handler.modifyZone(zoneList, sysUpTime);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Zone) {
            return this.toString().equals(obj.toString()) && ((Zone)obj).readOnly == this.readOnly;
        }
        return false;
    }

    public boolean isAliasMember(int aliasId) {
        if (this.zoneAliases != null && this.zoneAliases.length >= aliasId) {
            return SnmpString.getBit(this.zoneAliases, aliasId);
        }
        return false;
    }

    public byte[] duplicateAliasesArray() {
        String[] vars = this.zoneVsanId != -1 ? ZONE_VARS : IVR_ZONE_VARS;
        byte[] memClone = new byte[]{};
        if (this.zoneAliases != null && this.zoneAliases.length > 0) {
            memClone = new byte[this.zoneAliases.length];
            System.arraycopy(this.zoneAliases, 0, memClone, 0, this.zoneAliases.length);
        }
        return memClone;
    }

    @Override
    public int[] getNameOID() {
        String[] vars = this.zoneVsanId == -1 ? IVR_ZONE_VARS : ZONE_VARS;
        return MibNode.get(vars[0]).getOid();
    }

    public static void clearAllZoneMembers(CommandHandler handler, int vsanId, String[] zones) throws SnmpException {
        handler.clearAllZoneMembers(vsanId, zones);
    }

    public void setQosPriority(int priority) {
        this.qosPriority = priority;
    }

    public void setQos(boolean b) {
        this.qos = b;
    }

    public void setReadOnly(boolean b) {
        this.readOnly = b;
    }

    public void setBroadcast(boolean b) {
        this.broadcast = b;
    }

    public void setSmartzone(boolean b) {
        this.smartzone = b;
    }
}

