/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.mds.zm;

import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpString;
import java.io.Serializable;

public class ZoneMode
implements Serializable {
    private int mode;
    public static final int OWNER_TYPE_SNMP_USER = 5;
    public static final int OWNER_TYPE_SNMP = 4;
    public static final String[] USER_TYPE_NAME = new String[]{"other", "cli", "gs4client", "snmp", "snmpUser"};
    private int ownerType = -1;
    private byte[] owner;
    private byte[] lockingSwitch;
    private int vsan;
    private boolean readFromPending;
    private boolean autoTopology;

    public static String getSnmpUserTypeName(int type) {
        if (type < 6 && type > 1) {
            return USER_TYPE_NAME[type - 1];
        }
        return null;
    }

    public ZoneMode(int md, int ownType, byte[] own, int v, boolean readPending, byte[] lockSw, boolean autoTopo) {
        this.mode = md;
        this.ownerType = ownType;
        this.owner = own;
        this.vsan = v;
        this.readFromPending = readPending;
        this.lockingSwitch = lockSw;
        this.autoTopology = autoTopo;
    }

    public boolean isEnhanced() {
        return this.mode == 2;
    }

    public boolean isReadFromPending() {
        return this.readFromPending;
    }

    public void setReadFromPending(boolean b) {
        this.readFromPending = b;
    }

    public boolean isCommitPending() {
        return this.ownerType != -1;
    }

    public String getOwner() {
        String ownerName = new String(this.owner);
        if (this.isCommitPending()) {
            if (this.vsan != -1) {
                switch (this.ownerType) {
                    case 3: {
                        ownerName = SnmpString.toHexString(this.owner);
                        break;
                    }
                    case 4: {
                        ownerName = SnmpIpAddress.toString(this.owner);
                        break;
                    }
                    default: {
                        ownerName = new String(this.owner);
                        break;
                    }
                }
            } else {
                ownerName = new String(this.owner);
            }
        }
        return ownerName;
    }

    public byte[] getLockingSwitch() {
        return this.lockingSwitch;
    }

    public int getOwnerType() {
        return this.ownerType;
    }

    public int getVsan() {
        return this.vsan;
    }

    public int getMode() {
        return this.mode;
    }

    public boolean isAutoTopology() {
        return this.autoTopology;
    }
}

