/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.serviceconf;

import com.cisco.dcbu.lib.serviceconf.ServiceIf;
import java.util.Properties;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public abstract class AbstractService
implements ServiceIf {
    protected String _name = null;
    protected Semaphore _stateLock = new Semaphore(1);
    protected AtomicInteger _state = new AtomicInteger(0);
    protected Properties _configuration = new Properties();
    protected Logger _log = Logger.getLogger(this.getClass());

    protected AbstractService() {
    }

    protected AbstractService(String name) {
        this._name = name;
    }

    @Override
    public String getName() {
        return this._name == null ? this.getClass().getName() : this._name;
    }

    @Override
    public void setName(String name) {
        this._name = name;
    }

    public void setConfiguration(String key, String value) {
        if (value != null) {
            this._configuration.setProperty(key, value);
        } else {
            this._configuration.remove(key);
        }
    }

    @Override
    public Logger getLogger() {
        return this._log;
    }

    @Override
    public void setLogger(Logger logger) {
        this._log = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean init(Object[] params) throws Exception {
        if (this._state.get() == 2) {
            return true;
        }
        if (this._state.get() != 0) {
            throw new UnsupportedOperationException(this + " already initialized");
        }
        try {
            if (this._stateLock.tryAcquire(5L, TimeUnit.SECONDS)) {
                this.initImpl(params);
                this.setState(2);
            } else {
                this._log.error((Object)(this._name + " acquiring lock timed out, init failed"));
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this._stateLock.release();
        }
        return true;
    }

    protected void initImpl(Object[] params) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean start() throws Exception {
        if (this._state.get() == 4) {
            return true;
        }
        if (this._state.get() != 2) {
            throw new UnsupportedOperationException(this + " not initialized");
        }
        try {
            if (this._stateLock.tryAcquire(5L, TimeUnit.SECONDS)) {
                this.startImpl();
                this.setState(4);
            } else {
                this._log.error((Object)(this._name + " acquiring lock timed out, init failed"));
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this._stateLock.release();
        }
        return true;
    }

    protected void startImpl() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean stop() {
        if (this._state.get() == 1) {
            return true;
        }
        try {
            if (this._stateLock.tryAcquire(5L, TimeUnit.SECONDS)) {
                this.setState(1);
                this.stopImpl();
            } else {
                this._log.error((Object)(this._name + " acquiring lock timed out, fini failed"));
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this._stateLock.release();
        }
        return true;
    }

    protected void stopImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean suspend() {
        if (this._state.get() == 3) {
            return true;
        }
        if (this._state.get() != 4) {
            throw new UnsupportedOperationException(this + " not running");
        }
        try {
            if (this._stateLock.tryAcquire(5L, TimeUnit.SECONDS)) {
                this.suspendImpl();
                this.setState(3);
            } else {
                this._log.error((Object)(this._name + " acquiring lock timed out, suspend failed"));
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this._stateLock.release();
        }
        return true;
    }

    protected void suspendImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean resume() {
        if (this._state.get() == 4) {
            return true;
        }
        if (this._state.get() != 3) {
            throw new UnsupportedOperationException(this + " not suspended");
        }
        try {
            if (this._stateLock.tryAcquire(5L, TimeUnit.SECONDS)) {
                this.resumeImpl();
                this.setState(4);
            } else {
                this._log.error((Object)(this._name + " acquiring lock timed out, resume failed"));
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this._stateLock.release();
        }
        return true;
    }

    protected void resumeImpl() {
    }

    @Override
    public int getState() {
        return this._state.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(int state) {
        this._state.set(state);
        AtomicInteger atomicInteger = this._state;
        synchronized (atomicInteger) {
            this._state.notifyAll();
        }
    }

    @Override
    public String info() {
        return this._name + " state=" + this._state.get() + " log=" + this._log.getName();
    }
}

