/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.serviceconf;

import java.util.Hashtable;
import java.util.StringTokenizer;

public class GetOpt {
    private String[] _args;
    private boolean _hasArg;
    private int _index;
    private Hashtable<Character, Character> _argTable;
    private boolean _returnAllArgs;

    public GetOpt(String[] args, String optstring) {
        this(args, optstring, false);
    }

    public GetOpt(String[] args, String optstring, boolean returnAllArgs) {
        this._returnAllArgs = returnAllArgs;
        this._args = args;
        this._hasArg = false;
        this.buildArgTable(optstring);
    }

    public int next() {
        if (this._args == null) {
            return -1;
        }
        if (this._index < this._args.length) {
            String arg;
            if (!(arg = this._args[this._index++]).startsWith("-")) {
                return -1;
            }
            if (arg.length() > 2) {
                return -1;
            }
            Character c = this._argTable.get(new Character(arg.charAt(1)));
            if (c == null) {
                if (this._returnAllArgs) {
                    return arg.charAt(1);
                }
                return -1;
            }
            if (c.charValue() == '#') {
                this._hasArg = false;
                return arg.charAt(1);
            }
            if (c.charValue() == ':') {
                this._hasArg = true;
                return arg.charAt(1);
            }
            return -1;
        }
        return -1;
    }

    public String optarg() {
        if (this._hasArg) {
            return this._args[this._index++];
        }
        return null;
    }

    private void buildArgTable(String s) {
        this._argTable = new Hashtable();
        StringTokenizer tokens = new StringTokenizer(s, ":");
        while (tokens.hasMoreTokens()) {
            String t = tokens.nextToken();
            for (int i = 0; i < t.length() - 1; ++i) {
                this._argTable.put(new Character(t.charAt(i)), new Character('#'));
            }
            this._argTable.put(new Character(t.charAt(t.length() - 1)), new Character(':'));
        }
    }
}

