/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.serviceconf;

import com.cisco.dcbu.lib.serviceconf.GetOpt;
import com.cisco.dcbu.lib.serviceconf.ServiceIf;
import com.cisco.dcbu.lib.serviceconf.ServiceLoader;
import com.cisco.dcbu.lib.serviceconf.ServiceRepository;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class ServiceConfig {
    private static boolean _IsDaemon = false;
    private static String _ServiceConfigFile = "svc.conf";
    private static ServiceRepository _SvcRep = new ServiceRepository();
    private static ServiceLoader _Loader = new ServiceLoader();
    private static final int COMMAND_NAME = 0;
    private static final int SERVICE_NAME = 1;
    private static final int CLASS_NAME = 2;
    private static final int SERVICE_TYPE = 3;
    private static final int ARGS = 4;
    private static final int CODE_BASE = 5;
    protected static Logger _Log = LogManager.getLogger(ServiceConfig.class);

    public static int open(String[] args) throws FileNotFoundException, IOException, ClassNotFoundException, IllegalAccessException, InstantiationException, Exception {
        return ServiceConfig.processDirectives();
    }

    protected static void printUsage() {
        _Log.error((Object)"Valid options:\n");
        _Log.error((Object)"-f <filename >    Specify name of the service config file");
        _Log.error((Object)"-d                Enable debugging");
        _Log.error((Object)"-p <URL path>     If not found locally, search this URL path");
        _Log.error((Object)"                  for classes (multiple -p options allowed");
    }

    protected static int parseArgs(String[] args) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        int c;
        GetOpt getopt = new GetOpt(args, "df:p:", true);
        block7: while ((c = getopt.next()) != -1) {
            switch (c) {
                case 112: {
                    try {
                        _Loader.addURLPath(getopt.optarg());
                    }
                    catch (MalformedURLException e) {
                        _Log.error((Object)("Invalid URL: " + getopt.optarg()));
                    }
                    continue block7;
                }
                case 100: {
                    _Log.setLevel(Level.DEBUG);
                    _Log.debug((Object)"Debugging is enabled");
                    continue block7;
                }
                case 102: {
                    _ServiceConfigFile = getopt.optarg();
                    continue block7;
                }
            }
            _Log.error((Object)((char)c + " is not a ServiceConfig option"));
            return -1;
        }
        return 0;
    }

    public Logger getLogger(String name) {
        return _SvcRep.getLogger(name);
    }

    public static boolean suspend(String name) {
        return _SvcRep.suspend(name);
    }

    public static boolean resume(String name) {
        return _SvcRep.resume(name);
    }

    public static boolean remove(String name) {
        return _SvcRep.remove(name);
    }

    public static String info(String name) {
        return _SvcRep.info(name);
    }

    public static boolean stop(String name) throws Exception {
        return _SvcRep.stop(name);
    }

    public static boolean init(String name, Object[] args) throws Exception {
        return _SvcRep.init(name, args);
    }

    public static void insert(ServiceIf service) {
        _SvcRep.insert(service);
    }

    public static int getState(String name) {
        return _SvcRep.getState(name);
    }

    public static ServiceIf findService(String name) {
        return _SvcRep.findService(name);
    }

    public static boolean contains(String name) {
        return _SvcRep.find(name) != null;
    }

    public static Enumeration serviceNames() {
        return _SvcRep.serviceNames();
    }

    public static Enumeration services() {
        return _SvcRep.services();
    }

    public static boolean load(String serviceName, String className, Object[] args) throws ClassNotFoundException, IllegalAccessException, InstantiationException, IOException, Exception {
        Class<?> svcClass = Class.forName(className);
        ServiceIf svc = (ServiceIf)svcClass.newInstance();
        svc.setName(serviceName);
        if (!svc.init(args)) {
            return false;
        }
        if (!svc.start()) {
            return false;
        }
        _SvcRep.insert(svc);
        return true;
    }

    public static boolean load(String serviceName, String className, String args) throws ClassNotFoundException, IllegalAccessException, InstantiationException, IOException, Exception {
        return ServiceConfig.load(serviceName, className, (Object[])null);
    }

    protected static int processDirectives() throws FileNotFoundException, IOException, ClassNotFoundException, IllegalAccessException, InstantiationException, Exception {
        _Log.debug((Object)("Processing directives in file " + _ServiceConfigFile));
        File configFile = new File(_ServiceConfigFile);
        if (!configFile.exists() || !configFile.isFile()) {
            throw new FileNotFoundException("File " + _ServiceConfigFile + " not found");
        }
        if (!configFile.canRead()) {
            throw new IOException("File " + _ServiceConfigFile + " not readable");
        }
        FileInputStream fileIn = new FileInputStream(configFile);
        BufferedReader r = new BufferedReader(new InputStreamReader(fileIn));
        StreamTokenizer in = new StreamTokenizer(r);
        in.wordChars(46, 47);
        in.wordChars(58, 64);
        in.wordChars(91, 96);
        in.wordChars(123, 126);
        in.quoteChar(34);
        in.commentChar(35);
        in.eolIsSignificant(true);
        in.lowerCaseMode(false);
        Vector<String> strs = new Vector<String>();
        int lineNumber = 1;
        while (in.nextToken() != -1) {
            if (in.ttype == 10) {
                String command = ((String)strs.elementAt(0)).toLowerCase();
                String name = (String)strs.elementAt(1);
                if (strs.size() == 2) {
                    if (command.equals("remove")) {
                        ServiceConfig.remove(name);
                    } else if (command.equals("suspend")) {
                        ServiceConfig.suspend(name);
                    } else if (command.equals("resume")) {
                        ServiceConfig.resume(name);
                    }
                } else {
                    if (!command.equals("load")) {
                        throw new IOException("Unknown command: " + command + " at line " + lineNumber);
                    }
                    if (strs.size() < 5) {
                        throw new IOException("Line " + lineNumber + " requires 5 values, not " + strs.size());
                    }
                    String className = (String)strs.elementAt(2);
                    if (strs.size() > 5) {
                        try {
                            String url = (String)strs.elementAt(5);
                            _Loader.addURLPath(url);
                        }
                        catch (MalformedURLException e) {
                            _Log.error((Object)("Bad code base on line " + lineNumber));
                        }
                    }
                    ServiceConfig.load(name, className, (String)strs.elementAt(4));
                }
                ++lineNumber;
                strs.removeAllElements();
                continue;
            }
            if (in.ttype == -3 || in.ttype == 34) {
                strs.addElement(new String(in.sval));
                continue;
            }
            _Log.debug((Object)("Invalid string on line " + lineNumber + " element " + strs.size() + " type " + in.ttype));
        }
        return 0;
    }

    public static void close() {
        _SvcRep.close();
    }

    public static ServiceLoader loader() {
        return _Loader;
    }

    public static void loader(ServiceLoader loader) {
        _Loader = loader;
    }
}

