/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.serviceconf;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ServiceLoader
extends ClassLoader {
    static Logger _Log = Logger.getLogger(ServiceLoader.class);
    protected Vector<URL> _urlSearchPaths = new Vector();

    public ServiceLoader() {
    }

    public ServiceLoader(URL[] remotePaths) {
        this();
        int max;
        int n = max = remotePaths == null ? 0 : remotePaths.length;
        for (int i = 0; i < max; ++i) {
            this.addURLPath(remotePaths[i]);
        }
    }

    public void addURLPath(URL url) {
        if (!this._urlSearchPaths.contains(url)) {
            this._urlSearchPaths.addElement(url);
        }
    }

    public void addURLPath(String url) throws MalformedURLException {
        this.addURLPath(new URL(url));
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = null;
        c = this.findLoadedClass(name);
        if (c != null) {
            return c;
        }
        try {
            c = this.findSystemClass(name);
            return c;
        }
        catch (ClassNotFoundException e2) {
            return this.findClass(name);
        }
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        byte[] b = this.loadClassData(name);
        return this.defineClass(name, b, 0, b.length);
    }

    private byte[] loadClassData(String className) throws ClassNotFoundException {
        byte[] data = null;
        for (URL path : this._urlSearchPaths) {
            try {
                URL classFileURL;
                try {
                    classFileURL = new URL(path.toExternalForm() + className + ".class");
                }
                catch (MalformedURLException ex) {
                    _Log.error((Object)("Bad URL: " + ex.getMessage()));
                    continue;
                }
                _Log.debug((Object)("Looking for " + classFileURL.toExternalForm()));
                URLConnection urlConnection = classFileURL.openConnection();
                DataInputStream i = new DataInputStream(urlConnection.getInputStream());
                data = new byte[urlConnection.getContentLength()];
                i.readFully(data);
            }
            catch (IOException ex) {}
        }
        if (data == null) {
            throw new ClassNotFoundException("Can't obtain " + className);
        }
        return data;
    }

    public Class loadClass(URL url) throws ClassNotFoundException {
        String URLPath = url.getFile();
        int idx = URLPath.lastIndexOf("/");
        if (idx == -1) {
            throw new ClassNotFoundException("Can't find " + URLPath);
        }
        String className = URLPath.substring(idx + 1);
        URLPath = URLPath.substring(0, idx + 1);
        idx = className.lastIndexOf(".class");
        if (idx != -1) {
            className = className.substring(0, idx);
        }
        _Log.debug((Object)("The name of the class about to load is " + className));
        try {
            this.addURLPath(new URL(URLPath));
        }
        catch (MalformedURLException e) {
            throw new ClassNotFoundException("Can't find " + URLPath);
        }
        return this.loadClass(className);
    }
}

