/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.snmp;

public final class SnmpInputStream {
    byte[] _buf;
    int _pos;
    int _max;

    public SnmpInputStream(byte[] buf) {
        this._buf = buf;
    }

    public SnmpInputStream(byte[] buf, int max) {
        this._buf = buf;
        this._max = max;
    }

    public void setPos(int pos) {
        this._pos = pos;
    }

    byte read() {
        return this._buf[this._pos++];
    }

    byte poke() {
        return this._buf[this._pos];
    }

    int available() {
        return this._max - this._pos;
    }

    public void setMax(int max) {
        this._max = max;
        this._pos = 0;
    }

    public String dump(int offset, int len) {
        StringBuilder sb = new StringBuilder(this._buf.length * 3);
        for (int i = 0; i < len; ++i) {
            if (i % 16 == 0) {
                sb.append("\n");
            } else if (i % 8 == 0) {
                sb.append(" ");
            }
            String s = Integer.toHexString(this._buf[offset + i] & 0xFF);
            if (s.length() == 1) {
                sb.append("0");
            }
            sb.append(s).append(" ");
        }
        return sb.toString();
    }

    public String dump() {
        return this.dump(0, this._max);
    }
}

