/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.snmp;

import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpASN1;
import com.cisco.dcbu.lib.snmp.SnmpCallbackIf;
import com.cisco.dcbu.lib.snmp.SnmpCrypto;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInputStream;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpOutputStream;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpTimeticks;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public final class SnmpPDU {
    public static final int NOT_SET = -1;
    public static final int NO_RETRY = 0;
    static final int ASN_CONTEXT = -128;
    static final int ASN_CONSTRUCTOR = 32;
    static final int CISCO_CONSTRUCTOR = 16;
    public static final byte GET_REQ_MSG = -96;
    public static final byte GETNEXT_REQ_MSG = -95;
    public static final byte GET_RSP_MSG = -94;
    public static final byte SET_REQ_MSG = -93;
    public static final byte TRP_REQ_MSG = -92;
    public static final byte GETBULK_REQ_MSG = -91;
    public static final byte INFORM_REQ_MSG = -90;
    public static final byte TRP2_REQ_MSG = -89;
    public static final byte REPORT_MSG = -88;
    public static final byte GETLIMITEDBULK_REQ_MSG = -76;
    public static final int VERSION_1 = 0;
    public static final int VERSION_2C = 1;
    public static final int VERSION_2 = 2;
    public static final int VERSION_3 = 3;
    public static final int ROWSTATUS_ACTIVE = 1;
    public static final int ROWSTATUS_NOTINSERVICE = 2;
    public static final int ROWSTATUS_CREATEANDGO = 4;
    public static final int ROWSTATUS_DESTROY = 6;
    public static final int USM_TIME_WINDOW = 150;
    static final byte AUTH_FLAG = 1;
    static final byte PRIV_FLAG = 2;
    static final byte REPORT_FLAG = 4;
    public static final byte TRAP_COLDSTART = 1;
    public static final byte TRAP_WARMSTART = 2;
    public static final byte TRAP_LINKDOWN = 3;
    public static final byte TRAP_LINKUP = 4;
    public static final byte TRAP_AUTHFAIL = 5;
    public static final byte TRAP_EGPNEIGHBORLOSS = 6;
    public static final byte TRAP_ENTERPRISESPECIFIC = 7;
    static final int[] _TrapPrefix = new int[]{1, 3, 6, 1, 6, 3, 1, 1, 5};
    static final int[] _SysUpTime = new int[]{1, 3, 6, 1, 2, 1, 1, 3, 0};
    static final int[] _SnmpTrapOID = new int[]{1, 3, 6, 1, 6, 3, 1, 1, 4, 1, 0};
    static final long _StartTime = System.currentTimeMillis();
    int[] _enterpriseTrapOid;
    byte[] _agentAddr;
    int _specificTrapType;
    public static SimpleDateFormat _TimeFormat = new SimpleDateFormat("HH:mm:ss");
    private static boolean _IsTclPrint;
    InetAddress _address;
    int _version = -1;
    int _reqid;
    int _msgId;
    byte[] _engineId;
    int _engineBoots;
    int _engineTime;
    String _community;
    String _userName;
    boolean _notInTimeWindowResend;
    boolean _aaaAuthenticated;
    boolean _ignoreSetCount;
    byte _command;
    short _cmdPosition;
    short _remainingRetries;
    short _remainingRuaRetries;
    int _error;
    int _errorIndex;
    VarBindList _variables;
    SnmpCallbackIf _target;
    SnmpException _sendException;
    SnmpSession _session;
    SnmpPDU _response;
    SnmpPeer _peer;
    int[] _varBindMaskNo;
    long _timeQueued;
    long _timeSent;
    long _timeExpires;
    long _timeReceived;
    long _rountTripTime;
    int _port;
    short _retries = (short)-1;
    short _ruaRetries = (short)-1;
    int _timeout = -1;
    int _authProtocol = 0;
    int _privProtocol = -1;
    byte[] _authKey1;
    byte[] _authKey2;
    byte[] _privKey;
    String _contextEngineID;
    String _contextName;
    Logger _log;

    public SnmpPDU() {
    }

    public SnmpPDU(byte command) {
        this._command = command;
    }

    public SnmpPDU(VarBindList variables) {
        this._variables = variables;
    }

    public SnmpPDU(byte command, VarBindList variables) {
        this._command = command;
        this._variables = variables;
    }

    public static int[] getTrapPrefix() {
        return _TrapPrefix;
    }

    public static void setIsTclPrint(boolean enable) {
        _IsTclPrint = enable;
    }

    public VarBindList getVariables() {
        return this._variables;
    }

    public void setUserName(String userName) {
        this._userName = userName;
    }

    public String getUserName() {
        return this._userName;
    }

    public void setContextEngineID(String contextEngineID) {
        this._contextEngineID = contextEngineID;
    }

    public void setContextName(String contextName) {
        this._contextName = contextName;
    }

    public int getAuthProtocol() {
        return this._authProtocol;
    }

    public void setAuthProtocol(int authProtocol) {
        this._authProtocol = authProtocol;
    }

    public void setAuthKey(byte[] key1, byte[] key2) {
        this._authKey1 = key1;
        this._authKey2 = key2;
    }

    public int getPrivacyProtocol() {
        return this._privProtocol;
    }

    public void setPrivacyProtocol(int privProtocol) {
        this._privProtocol = privProtocol;
    }

    public byte[] getPrivacyKey() {
        return this._privKey;
    }

    public void setPrivacyKey(byte[] key) {
        this._privKey = key;
    }

    public boolean isAaaAuthenticated() {
        return this._aaaAuthenticated;
    }

    public void setAaaAuthenticated(boolean aaaAuthenticated) {
        this._aaaAuthenticated = aaaAuthenticated;
    }

    public SnmpPDU getResponse() {
        return this._response;
    }

    public void setResponse(SnmpPDU response) {
        this._response = response;
    }

    public int getRetries() {
        return this._retries;
    }

    public void setRetries(int retries) {
        this._retries = (short)retries;
    }

    public int getResourceUnavailableRetries() {
        return this._ruaRetries;
    }

    public void setResourceUnavailableRetries(int retries) {
        this._ruaRetries = (short)retries;
    }

    public int getTimeout() {
        return this._timeout;
    }

    public void setTimeout(int timeout) {
        this._timeout = timeout;
    }

    public short getRemainingRetries() {
        return this._remainingRetries;
    }

    public void setRemainingRetries(short remainingRetries) {
        this._remainingRetries = remainingRetries;
    }

    public short getRemainingRuaRetries() {
        return this._remainingRuaRetries;
    }

    public void setRemainingRuaRetries(short remainingRuaRetries) {
        this._remainingRuaRetries = remainingRuaRetries;
    }

    public SnmpSession getSession() {
        return this._session;
    }

    public void setSession(SnmpSession session) {
        this._session = session;
    }

    public void setPeer(SnmpPeer peer) {
        this._peer = peer;
    }

    public SnmpCallbackIf getTarget() {
        return this._target;
    }

    public void setTarget(SnmpCallbackIf target) {
        this._target = target;
    }

    public int getCommand() {
        return this._command;
    }

    public void setCommand(byte command) {
        this._command = command;
    }

    public int getReqid() {
        return this._reqid;
    }

    public void setReqid(int reqid) {
        this._reqid = reqid;
    }

    public int getMsgId() {
        return this._msgId;
    }

    public int getError() {
        return this._error;
    }

    public void setError(int error) {
        this._error = error;
    }

    public void setNonRptr(int nonrptr) {
        this._error = nonrptr;
    }

    public int getNonRptr() {
        return this._error;
    }

    public int getErrorIndex() {
        return this._errorIndex;
    }

    public void setErrorIndex(int errorIndex) {
        this._errorIndex = errorIndex;
    }

    public void setMaxRptr(int maxrept) {
        this._errorIndex = maxrept;
    }

    public int getMaxRptr() {
        return this._errorIndex;
    }

    public long getTimeReceived() {
        return this._timeReceived;
    }

    public void setTimeReceived(long timeReceived) {
        this._timeReceived = timeReceived;
    }

    public void setTimeQueued(long timeQueued) {
        this._timeQueued = timeQueued;
    }

    public long getTimeQueued() {
        return this._timeQueued;
    }

    public SnmpException getSendException() {
        return this._sendException;
    }

    public void setSendException(SnmpException sendException) {
        this._sendException = sendException;
    }

    public long getTimeSent() {
        return this._timeSent;
    }

    public void setTimeSent(long timeSent) {
        this._timeSent = timeSent;
    }

    public boolean isNotInTimeWindowResend() {
        return this._notInTimeWindowResend;
    }

    public void setNotInTimeWindowResend(boolean notInTimeWindowResend) {
        this._notInTimeWindowResend = notInTimeWindowResend;
    }

    public long getTimeExpires() {
        return this._timeExpires;
    }

    public void setTimeExpires(long timeExpires) {
        this._timeExpires = timeExpires;
    }

    public void setVariables(VarBindList variables) {
        this._variables = variables;
    }

    public InetAddress getAddress() {
        return this._address;
    }

    public void setAddress(InetAddress address) {
        this._address = address;
    }

    public String getHostAddress() {
        return this._address.getHostAddress();
    }

    public int getPort() {
        return this._port;
    }

    public void setPort(int port) {
        this._port = port;
    }

    public int getVersion() {
        return this._version;
    }

    public void setVersion(int version) {
        this._version = version;
    }

    public int[] getVarBindMask() {
        return this._varBindMaskNo;
    }

    public void setVarBindMask(int[] vbNo) {
        this._varBindMaskNo = vbNo;
    }

    public String getCommunity() {
        return this._community;
    }

    public void setCommunity(String community) {
        this._community = community;
    }

    public SnmpPeer getPeer() {
        return this._peer;
    }

    public byte[] getEngineId() {
        return this._engineId;
    }

    public void setEngineId(byte[] engineId) {
        this._engineId = engineId;
    }

    public int getEngineBoots() {
        return this._engineBoots;
    }

    public void setEngineBoots(int engineBoots) {
        this._engineBoots = engineBoots;
    }

    public int getEngineTime() {
        return this._engineTime;
    }

    public void setEngineTime(int engineTime) {
        this._engineTime = engineTime;
    }

    public void addNull(SnmpOID oid) {
        this.addVar(oid, null);
    }

    public void addVar(SnmpOID oid, SnmpVar value) {
        this._variables.add(new SnmpVarBind(oid, value));
    }

    public void addVar(SnmpOID oid) {
        this._variables.add(new SnmpVarBind(oid));
    }

    public void addVar(SnmpVarBind varBind) {
        this._variables.add(varBind);
    }

    public void removeVarAt(int index) {
        this._variables.remove(index);
    }

    public SnmpOID getOid(int index) {
        return this._variables.getOid(index);
    }

    public SnmpVar getVar(int index) {
        return this._variables.getVb(index).getVar();
    }

    public int getError(int index) {
        if (this._error == 0) {
            return this._variables.getVb(index).getError();
        }
        return this._error;
    }

    public boolean isIgnoreSetCount() {
        return this._ignoreSetCount;
    }

    public void setIgnoreSetCount(boolean ignoreSetCount) {
        this._ignoreSetCount = ignoreSetCount;
    }

    public void setEnterpriseOid(int[] entoid) {
        this._enterpriseTrapOid = entoid;
    }

    public void setSpecificTrapType(int stt) {
        this._specificTrapType = stt;
    }

    public void setAgentAddress(InetAddress aa) {
        this._agentAddr = aa.getAddress();
    }

    public void addTrapOid(int[] trapoid) {
        this.addVar(new SnmpOID(_SnmpTrapOID), new SnmpOID(trapoid));
    }

    public void addSysUpTime(long timestamp) {
        SnmpTimeticks timeticks = new SnmpTimeticks(timestamp / 10L);
        this.addVar(new SnmpVarBind(new SnmpOID(_SysUpTime), timeticks));
    }

    public void reset() {
        this._variables.clear();
        this._reqid = 0;
        this._timeout = -1;
        this._timeQueued = 0L;
        this._timeSent = 0L;
        this._timeExpires = 0L;
        this._timeReceived = 0L;
        this._retries = (short)-1;
        this._ruaRetries = (short)-1;
        this._community = null;
        this._ignoreSetCount = false;
    }

    public static int decodeReqId(SnmpInputStream is) throws SnmpException {
        int pos = is._pos;
        int max = is._max;
        int reqId = 0;
        try {
            SnmpASN1.parseHeader(is);
            int version = SnmpPDU.parseInt(is, "version");
            if (version == 0 || version == 1) {
                SnmpPDU.skipString(is, "community");
                if (SnmpASN1.parseHeader(is) != -92) {
                    reqId = SnmpPDU.parseInt(is, "reqid");
                }
            } else if (version == 3) {
                SnmpASN1.parseHeader(is);
                reqId = SnmpPDU.parseInt(is, "msgId");
            }
        }
        catch (SnmpException ex) {
            ex.printStackTrace();
            throw new SnmpException("decodeReqId exception " + ex.getMessage());
        }
        finally {
            is._pos = pos;
            is._max = max;
        }
        return reqId;
    }

    public void decode(SnmpInputStream is) throws SnmpException {
        block4: {
            try {
                SnmpASN1.parseHeader(is);
                this._version = SnmpPDU.parseInt(is, "version");
                if (this._version == 0 || this._version == 1) {
                    this._community = new String(SnmpPDU.parseBytes(is, "community"));
                    this.decodePayload(is);
                    break block4;
                }
                if (this._version == 3) {
                    this.decodeV3(is);
                    break block4;
                }
                throw new SnmpException("unsupported SNMP version: " + this._version);
            }
            catch (SnmpException ex) {
                if (this._peer == null && SnmpPeer.findPeer(this._address) == null) break block4;
                ex.printStackTrace();
                throw new SnmpException("decode pdu exception : " + ex.getMessage());
            }
        }
    }

    private void decodeV3(SnmpInputStream is) throws SnmpException {
        SnmpASN1.parseHeader(is);
        this._msgId = SnmpPDU.parseInt(is, "msgId");
        SnmpPDU.parseInt(is, "maxSize");
        if ((is.read() & 0xFF) != 4) {
            throw new SnmpException("PDU decode expected msgFlags");
        }
        int len = SnmpASN1.parseLength(is);
        boolean isEncrypted = (is.poke() & 2) > 0;
        is._pos += len;
        SnmpPDU.parseInt(is, "usmModel");
        SnmpASN1.parseHeader(is);
        SnmpASN1.parseHeader(is);
        this._engineId = SnmpPDU.parseBytes(is, "engineID");
        this._engineBoots = SnmpPDU.parseInt(is, "engineBoots");
        this._engineTime = SnmpPDU.parseInt(is, "engineTime");
        this._userName = new String(SnmpPDU.parseBytes(is, "userName"));
        SnmpPDU.skipString(is, "authParam");
        if (isEncrypted) {
            if (this._privKey == null) {
                throw new SnmpException("No privacy key");
            }
            byte[] salt = SnmpPDU.parseBytes(is, "privParam");
            byte[] cryptText = SnmpPDU.parseBytes(is, "crypt");
            byte[] plainText = SnmpCrypto.decrypt(cryptText, 0, cryptText.length, this._engineBoots, this._engineTime, salt, this._privKey, this._privProtocol);
            System.arraycopy(plainText, 0, is._buf, 0, plainText.length);
            is._pos = 1;
            is._max = SnmpASN1.parseLength(is) + 2;
        } else {
            SnmpPDU.skipString(is, "salt");
            SnmpASN1.parseHeader(is);
        }
        SnmpPDU.skipString(is, "contextEngineId");
        SnmpPDU.skipString(is, "contextName");
        try {
            this.decodePayload(is);
            if (this._reqid == 0) {
                this._reqid = this._msgId;
            }
        }
        catch (SnmpException ex) {
            if (isEncrypted) {
                this._error = 29;
                this._variables = new VarBindList();
            }
            throw ex;
        }
    }

    private void decodePayload(SnmpInputStream is) throws SnmpException {
        this._cmdPosition = (short)is._pos;
        this._command = (byte)SnmpASN1.parseHeader(is);
        if (this._command == -92) {
            int[] id;
            this._command = (byte)-89;
            SnmpOID enterprise = (SnmpOID)SnmpASN1.decodeVar(is);
            SnmpIpAddress agentAddr = (SnmpIpAddress)SnmpASN1.decodeVar(is);
            try {
                InetAddress ipAddress = InetAddress.getByAddress(agentAddr.getValue());
                if (ipAddress.hashCode() != 0) {
                    this._address = ipAddress;
                }
            }
            catch (UnknownHostException ex) {
                this.getLogger().log((Priority)Level.ERROR, (Object)("SnmpPDU.decodePayload() error: " + agentAddr + ":\n" + is.dump()), (Throwable)ex);
            }
            int trapType = SnmpPDU.parseInt(is, "trapType");
            int specificType = SnmpPDU.parseInt(is, "specificType");
            SnmpTimeticks timeticks = (SnmpTimeticks)SnmpASN1.decodeVar(is);
            this._variables.add(new SnmpVarBind(new SnmpOID(_SysUpTime), timeticks));
            if (trapType == 7) {
                id = new int[enterprise.getValue().length + 2];
                System.arraycopy(enterprise.getValue(), 0, id, 0, id.length - 2);
                id[id.length - 2] = 0;
            } else {
                id = new int[_TrapPrefix.length + 1];
                System.arraycopy(_TrapPrefix, 0, id, 0, id.length - 1);
                specificType = trapType + 1;
            }
            id[id.length - 1] = specificType;
            this.addVar(new SnmpOID(_SnmpTrapOID), new SnmpOID(id));
        } else {
            this._reqid = SnmpPDU.parseInt(is, "reqid");
            this._error = SnmpPDU.parseInt(is, "error");
            this._errorIndex = SnmpPDU.parseInt(is, "errorIndex");
        }
        SnmpASN1.parseHeader(is);
        try {
            while (is.available() > 0) {
                SnmpVarBind vb = new SnmpVarBind();
                vb.decode(is);
                this._variables.add(vb);
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this._session._log.error((Object)(this._reqid + ": decode buffer overflow\n" + is.dump()));
        }
    }

    private static int parseInt(SnmpInputStream is, String msg) throws SnmpException {
        if ((is.read() & 0xFF) != 2) {
            throw new SnmpException("PDU decode expected " + msg);
        }
        return SnmpASN1.parseInteger(is, SnmpASN1.parseLength(is));
    }

    private static byte[] parseBytes(SnmpInputStream is, String msg) throws SnmpException {
        if ((is.read() & 0xFF) != 4) {
            throw new SnmpException("PDU decode expected " + msg);
        }
        int len = SnmpASN1.parseLength(is);
        byte[] b = new byte[len];
        System.arraycopy(is._buf, is._pos, b, 0, len);
        is._pos += len;
        return b;
    }

    private static void skipString(SnmpInputStream is, String msg) throws SnmpException {
        if ((is.read() & 0xFF) != 4) {
            throw new SnmpException("PDU decode expected " + msg);
        }
        int len = SnmpASN1.parseLength(is);
        is._pos += len;
    }

    public void encode(SnmpOutputStream os) throws SnmpException {
        if (this._version == 3) {
            this.encodeV3(os);
        } else {
            int pos1 = os._pos;
            SnmpASN1.buildSequence(os, 0);
            int mark1 = os._pos;
            SnmpASN1.buildInteger(os, this._version);
            if (this._community != null) {
                SnmpASN1.buildOctet(os, (byte)4, this._community.getBytes());
            } else {
                SnmpASN1.buildHeader(os, (byte)4, 0);
            }
            this.encodePayload(os);
            int totalPktSize = os._pos;
            os._pos = pos1;
            SnmpASN1.buildSequence(os, totalPktSize - mark1);
            os._pos = totalPktSize;
        }
    }

    private void encodeV3(SnmpOutputStream os) throws SnmpException {
        SnmpASN1.buildSequence(os, 0);
        int markAll = os._pos;
        SnmpASN1.buildInteger(os, 3);
        int posGlob = os._pos;
        SnmpASN1.buildSequence(os, 0);
        int markGlob = os._pos;
        SnmpASN1.buildInteger(os, this._reqid);
        SnmpASN1.buildInteger(os, 6000);
        SnmpASN1.buildByte(os, this.getMsgType());
        SnmpASN1.buildInteger(os, 3);
        int posUSM = os._pos;
        SnmpASN1.buildHeader(os, (byte)4, 0);
        int markUSM = os._pos;
        int posUSM1 = os._pos;
        SnmpASN1.buildSequence(os, 0);
        int markUSM1 = os._pos;
        if (this._engineId != null) {
            SnmpASN1.buildOctet(os, (byte)4, this._engineId);
        } else {
            SnmpASN1.buildHeader(os, (byte)4, 0);
        }
        SnmpASN1.buildInteger(os, this._engineBoots);
        SnmpASN1.buildInteger(os, this._engineTime);
        SnmpASN1.buildString(os, this._userName);
        int posAuth = os._pos;
        if (this._authKey1 != null) {
            SnmpASN1.buildHeader(os, (byte)4, 12);
            System.arraycopy(SnmpCrypto._EmptyAuth, 0, os._buf, os._pos, 12);
            os._pos += 12;
        } else {
            SnmpASN1.buildHeader(os, (byte)4, 0);
        }
        byte[] salt = null;
        if (this._privKey != null) {
            if (this._privProtocol == 0) {
                salt = SnmpCrypto.getDesSalt(this._engineBoots);
                SnmpASN1.buildOctet(os, (byte)4, salt);
            } else {
                salt = SnmpCrypto.getAesSalt(this._engineBoots, this._engineTime);
                SnmpASN1.buildHeader(os, (byte)4, 8);
                System.arraycopy(salt, 8, os._buf, os._pos, 8);
                os._pos += 8;
            }
        } else {
            SnmpASN1.buildHeader(os, (byte)4, 0);
        }
        int posCrypt = os._pos;
        if (this._privKey != null) {
            SnmpASN1.encodeSequence(os, (byte)4, 0);
        }
        int markCrypt = os._pos;
        int posScoped = os._pos;
        SnmpASN1.buildSequence(os, 0);
        int markScoped = os._pos;
        if (this._engineId == null) {
            SnmpASN1.buildString(os, this._contextEngineID);
        } else {
            SnmpASN1.buildOctet(os, (byte)4, this._engineId);
        }
        SnmpASN1.buildString(os, this._contextName);
        this.encodePayload(os);
        int totalPktSize = os._pos;
        this.recordLen(os, markAll, posGlob, markGlob, posUSM, markUSM, posUSM1, markUSM1, posScoped);
        os._pos = posScoped;
        SnmpASN1.buildSequence(os, totalPktSize - markScoped);
        if (this._privKey != null) {
            byte[] encryptedText = SnmpCrypto.encrypt(os._buf, markCrypt, totalPktSize - markCrypt, this._privKey, salt, this._privProtocol);
            System.arraycopy(encryptedText, 0, os._buf, markCrypt, encryptedText.length);
            if (totalPktSize != markCrypt + encryptedText.length) {
                totalPktSize = markCrypt + encryptedText.length;
                os._pos = 0;
                SnmpASN1.buildSequence(os, totalPktSize - markAll);
            }
            os._pos = posCrypt;
            SnmpASN1.encodeSequence(os, (byte)4, totalPktSize - markCrypt);
        }
        os._pos = totalPktSize;
        if (this._authKey1 != null) {
            byte[] calcFingerPrint = SnmpCrypto.getFingerPrint(this._authKey1, this._authKey2, os._buf, os._pos, this._authProtocol);
            System.arraycopy(calcFingerPrint, 0, os._buf, posAuth + 2, 12);
        }
    }

    private void recordLen(SnmpOutputStream os, int markAll, int posGlob, int markGlob, int posUSM, int markUSM, int posUSM1, int markUSM1, int posScoped) throws SnmpException {
        int totalPktSize = os._pos;
        os._pos = 0;
        SnmpASN1.buildSequence(os, totalPktSize - markAll);
        os._pos = posGlob;
        SnmpASN1.buildSequence(os, markUSM - markGlob);
        os._pos = posUSM;
        SnmpASN1.buildHeader(os, (byte)4, (byte)(posScoped - markUSM));
        os._pos = posUSM1;
        SnmpASN1.buildSequence(os, posScoped - markUSM1);
        os._pos = totalPktSize;
    }

    private byte getMsgType() {
        byte mt = 4;
        if (this._authKey1 != null) {
            mt = (byte)(mt | 1);
        }
        if (this._privKey != null) {
            mt = (byte)(mt | 2);
        }
        return mt;
    }

    private void encodePayload(SnmpOutputStream os) throws SnmpException {
        int pos2 = os._pos;
        SnmpASN1.encodeSequence(os, this._command, 0);
        int mark2 = os._pos;
        if (this._command == -92) {
            SnmpASN1.buildObjectId(os, this._enterpriseTrapOid, this._enterpriseTrapOid.length);
            SnmpASN1.buildOctet(os, (byte)64, this._agentAddr);
            SnmpASN1.buildInteger(os, 6);
            SnmpASN1.buildInteger(os, this._specificTrapType);
            SnmpASN1.buildLong(os, (System.currentTimeMillis() - _StartTime) / 10L, (byte)67);
        } else {
            SnmpASN1.buildInteger(os, this._reqid);
            SnmpASN1.buildInteger(os, this._error);
            SnmpASN1.buildInteger(os, this._errorIndex);
        }
        int pos3 = os._pos;
        SnmpASN1.buildSequence(os, 0);
        int mark3 = os._pos;
        int osSize = os._pos;
        try {
            int max = this._variables.size();
            for (int i = 0; i < max; ++i) {
                osSize = os._pos;
                this._variables.getVb(i).encode(os);
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            os._pos = osSize;
        }
        int totalPktSize = os._pos;
        os._pos = pos2;
        SnmpASN1.encodeSequence(os, this._command, totalPktSize - mark2);
        os._pos = pos3;
        SnmpASN1.buildSequence(os, totalPktSize - mark3);
        os._pos = totalPktSize;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(40 + this._variables.size() * 24);
        if (_IsTclPrint) {
            return this.tclPrint(sb);
        }
        if (this._command == -94 || this._command >= -90) {
            sb.append(_TimeFormat.format(new Date(this._timeReceived)));
        } else {
            sb.append(_TimeFormat.format(new Date(this._timeSent)));
        }
        sb.append(' ' + (this._address != null ? this._address.getHostAddress() : "") + ", " + this._reqid);
        sb.append(' ' + this.getCmd(this._command));
        if (this._version == 3) {
            sb.append(" u=" + this._userName);
        } else {
            sb.append(" c=" + this._community);
        }
        if (this._error > 0) {
            sb.append(this._command == -91 || this._command == -76 ? " nonRptr=" : " error=");
            sb.append(this._error);
        }
        if (this._errorIndex > 0) {
            sb.append(this._command == -91 || this._command == -76 ? " maxRptr=" : " errorIndex=");
            sb.append(this._errorIndex);
        }
        sb.append(' ');
        int max = this._variables.size();
        for (int i = 0; i < max; ++i) {
            SnmpVarBind vb = this._variables.getVb(i);
            String varName = MibNode.oidToName(vb.getOid().getValue());
            boolean isTrapOid = varName.equals("snmpTrapOID.0");
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(varName);
            if (this._command != -93 && this._command != -94 && (this._command < -90 || this._command == -76)) continue;
            if (isTrapOid && vb.getVar().getType() == 6) {
                sb.append("=" + MibNode.oidToName(((SnmpOID)vb.getVar()).getValue()));
                continue;
            }
            if (this._varBindMaskNo == null || this._varBindMaskNo.length == 0) {
                sb.append("=" + vb.getVar());
                continue;
            }
            boolean found = false;
            for (int j = 0; j < this._varBindMaskNo.length; ++j) {
                if (this._varBindMaskNo[j] != i) continue;
                found = true;
                break;
            }
            if (found) {
                sb.append("=***");
                continue;
            }
            sb.append("=" + vb.getVar());
        }
        if (this._target != null) {
            sb.append(", callback=").append(this._target.getClass().getName());
        }
        return sb.toString();
    }

    private String tclPrint(StringBuffer sb) {
        boolean isReq;
        boolean bl = isReq = this._command == -96 || this._command == -95 || this._command == -91 || this._command == -76 || this._command == -93;
        if (isReq) {
            sb.append("snmp " + this.getCmd(this._command) + ' ');
        }
        int max = this._variables.size();
        for (int i = 0; i < max; ++i) {
            SnmpVarBind vb = this._variables.getVb(i);
            if (isReq) {
                sb.append(MibNode.oidToName(vb.getOid().getValue()));
            } else {
                String resp = vb.getVar().toString();
                if (resp.indexOf(32) != -1) {
                    sb.append('\"' + resp + '\"');
                } else {
                    sb.append(resp);
                }
            }
            sb.append(' ');
        }
        return sb.toString();
    }

    private String getCmd(byte command) {
        switch (command) {
            case -96: {
                return "GET";
            }
            case -95: {
                return "NEXT";
            }
            case -94: {
                return "RESP";
            }
            case -93: {
                return "SET";
            }
            case -92: 
            case -89: {
                return "TRAP";
            }
            case -91: {
                return "BULK";
            }
            case -76: {
                return "BULKLIMIT";
            }
            case -90: {
                return "INFM";
            }
            case -88: {
                return "REPT";
            }
        }
        return Integer.toString(command & 0xFF);
    }

    public Logger getLogger() {
        if (this._log != null) {
            return this._log;
        }
        if (this._peer != null) {
            return this._peer.getLogger();
        }
        if (this._session != null) {
            return this._session.getLogger();
        }
        return LogManager.getLogger((String)"snmp");
    }

    public void setLogger(Logger log) {
        this._log = log;
    }

    public long getRountTripTime() {
        return this._rountTripTime;
    }

    public void setRountTripTime(long roundTripTime) {
        this._rountTripTime = roundTripTime;
    }
}

