/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.snmp;

import com.cisco.dcbu.lib.snmp.SnmpSession;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.LogManager;

public final class SnmpTimeout
extends Thread {
    private static SnmpTimeout _Instance;
    private List<SnmpSession> _sessionList = new ArrayList<SnmpSession>(2);
    private long _monitorSleep = 2000L;

    private SnmpTimeout() {
        super("SnmpTimeout");
    }

    public static SnmpTimeout getInstance() {
        if (_Instance == null) {
            _Instance = new SnmpTimeout();
            _Instance.start();
        }
        return _Instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            List<SnmpSession> list = this._sessionList;
            synchronized (list) {
                for (SnmpSession session : this._sessionList) {
                    try {
                        session.monitorRequests();
                    }
                    catch (Throwable ex) {
                        LogManager.getLogger((String)"snmp").error((Object)"SnmpTimeout monitorRequests() error", ex);
                    }
                }
            }
            try {
                Thread.sleep(this._monitorSleep);
                continue;
            }
            catch (InterruptedException ex) {
                LogManager.getLogger((String)"snmp").error((Object)("SnmpTimeout.sleep(): " + ex));
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(SnmpSession session) {
        List<SnmpSession> list = this._sessionList;
        synchronized (list) {
            this._sessionList.add(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(SnmpSession session) {
        List<SnmpSession> list = this._sessionList;
        synchronized (list) {
            this._sessionList.remove(session);
        }
    }
}

