/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.snmp;

import com.cisco.dcbu.lib.jnm.JschConnectionException;
import com.cisco.dcbu.lib.jnm.Vsh;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.VshCredentials;
import com.cisco.dcbu.lib.snmp.VshUtil;
import com.cisco.dcbu.lib.util.NetUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public enum VshManager {
    INSTANCE;

    public static final int TIMEOUT;
    public static final int TCP_TIMEOUT;
    private final Map<String, VshCredentials> _shells = Collections.synchronizedMap(new HashMap());
    Logger _log = LogManager.getLogger((String)"snmp.vsh");

    public static VshManager getInstance() {
        return INSTANCE;
    }

    public void closeVsh(String host) {
        if (host == null || host.length() == 0) {
            return;
        }
        VshCredentials vc = this._shells.remove(host);
        if (vc != null && vc._vsh != null) {
            vc._users.clear();
            vc._passwords.clear();
            try {
                vc._vsh.disconnect();
            }
            catch (Exception ex) {
                this._log.error((Object)("disconnecting vsh " + host + " error: " + ex), (Throwable)ex);
            }
        }
    }

    public void addUser(String host, String userName, String authPassword, String localHost, boolean createVsh) throws Exception {
        if (host == null) {
            throw new IllegalArgumentException("host unspecified");
        }
        if (localHost == null || localHost.length() == 0 || localHost.startsWith("0.0.0.0")) {
            localHost = NetUtil.getLocalAddr(InetAddress.getByName("0.0.0.0")).getHostAddress();
        }
        VshCredentials vc = this._shells.get(host);
        Vsh vsh = null;
        try {
            int max;
            VshCredentials nvc;
            vsh = this.newVsh(host, userName, authPassword);
            if (vsh != null) {
                nvc = new VshCredentials(vsh);
                nvc.put(userName, authPassword);
                if (vc != null) {
                    for (int i = 0; i < vc._users.size(); ++i) {
                        if (userName.equals(vc._users.get(i))) continue;
                        nvc.put(vc._users.get(i), vc._passwords.get(i));
                    }
                }
            } else {
                throw new SnmpException("Invalid Credentials");
            }
            this._shells.put(host, nvc);
            vc = nvc;
            int n = max = vc == null ? 0 : vc.count();
            for (int i = 0; i < max; ++i) {
                String usr = vc._users.get(i);
                String pwd = vc._passwords.get(i);
                try {
                    this._log.info((Object)(new Date() + " attempting sync-snmp-password on " + host + " for user " + userName));
                    vsh.sendAndReply("sync-snmp-password \"" + pwd + "\" " + this.getQualUsername(usr) + " " + localHost + "\n");
                    continue;
                }
                catch (Exception ex4) {
                    try {
                        this._log.warn((Object)(new Date() + " attempting sync-snmp-password on " + host + " for user " + userName), (Throwable)ex4);
                        vsh.sendAndReply("sync-snmp-password \"" + pwd + "\"\n");
                        continue;
                    }
                    catch (IOException ex5) {
                        this._log.warn((Object)("Exception " + host), (Throwable)ex5);
                    }
                }
            }
        }
        catch (Exception ee) {
            throw ee;
        }
        finally {
            if (vsh != null) {
                vsh.disconnect();
                vsh = null;
            }
        }
    }

    public void synchUser(String host, String userName, String authPassword, String localHost) throws Exception {
        block14: {
            boolean useSsh;
            if (localHost == null || localHost.length() == 0 || localHost.startsWith("0.0.0.0")) {
                localHost = NetUtil.getLocalAddr(InetAddress.getByName("0.0.0.0")).getHostAddress();
            }
            if (useSsh = Boolean.parseBoolean(System.getProperty("vshmanager.asyncUser.useSshExec", "false"))) {
                VshUtil.syncUserSsh(host, userName, authPassword, localHost);
            } else {
                System.out.println("syncUserVsh: host=" + host + ", userName=" + userName + ", localHost=" + localHost);
                Vsh vsh = null;
                try {
                    vsh = this.newVsh(host, userName, authPassword);
                    if (vsh == null) break block14;
                    try {
                        this._log.info((Object)(new Date() + " attempting sync-snmp-password on " + host + " for user " + userName));
                        vsh.sendAndReply("sync-snmp-password \"" + authPassword + "\" " + userName + " " + localHost + "\n");
                        System.out.println(new Date() + " attempting sync-snmp-password on " + host + " for user " + userName);
                        vsh.sendAndReply("sync-snmp-password \"" + authPassword + "\" " + userName + " " + localHost + "\n");
                        if (userName.indexOf(92) != -1 && vsh.getReply().toLowerCase().contains("auhentication failure")) {
                            vsh.sendAndReply("sync-snmp-password \"" + authPassword + "\" " + this.getQualUsername(userName) + " " + localHost + "\n");
                        }
                    }
                    catch (Exception ex4) {
                        try {
                            this._log.warn((Object)(new Date() + " attempting sync-snmp-password on " + host + " for user " + userName), (Throwable)ex4);
                            System.out.println(new Date() + " attempting sync-snmp-password on " + host + " for user " + userName + " failed: " + ex4.getMessage());
                            vsh.sendAndReply("sync-snmp-password \"" + authPassword + "\"\n");
                        }
                        catch (IOException ex5) {
                            this._log.warn((Object)("Exception " + host), (Throwable)ex5);
                            System.out.println("Exception " + host + ", " + ex5);
                        }
                    }
                }
                catch (Exception ee) {
                    throw ee;
                }
                finally {
                    if (vsh != null) {
                        vsh.disconnect();
                        vsh = null;
                    }
                }
            }
        }
    }

    public void getSnmpUser(String host, String userName, String authPassword) throws Exception {
        Vsh vsh = null;
        try {
            vsh = this.newVsh(host, userName, authPassword);
            if (vsh != null) {
                try {
                    this._log.info((Object)(new Date() + " attempting show snmp on " + host + " for user " + userName));
                    vsh.sendAndReply("show snmp\n");
                }
                catch (Exception ex4) {
                    this._log.warn((Object)(new Date() + " attempting show snmp on " + host + " for user " + userName), (Throwable)ex4);
                }
            }
        }
        catch (Exception ee) {
            throw ee;
        }
        finally {
            if (vsh != null) {
                vsh.disconnect();
                vsh = null;
            }
        }
    }

    private String getQualUsername(String userName) {
        if (userName.indexOf(92) != -1) {
            return userName.replaceAll(Pattern.quote("\\"), Matcher.quoteReplacement("\\\\"));
        }
        return userName;
    }

    public Vsh newVsh(String host, String userName, String authPassword) throws Exception {
        Vsh vsh = new Vsh(host, userName, authPassword, true, null);
        vsh.setTcpTimeout(TCP_TIMEOUT);
        Vsh.setTimeout(TIMEOUT);
        boolean connected = false;
        try {
            connected = vsh.connect();
        }
        catch (Exception ex2) {
            if (ex2 instanceof JschConnectionException) {
                try {
                    vsh.setUseSsh(false);
                    connected = vsh.connect();
                }
                catch (Exception e) {
                    throw new Exception("Authentication failed : Ssh/Telnet failed to connect with the switch");
                }
            }
            throw new Exception("Invalid Credentials");
        }
        if (connected) {
            return vsh;
        }
        return null;
    }

    public String info() {
        StringBuilder sb = new StringBuilder("VSH sessions: ").append(this._shells.size());
        for (Map.Entry<String, VshCredentials> obEntry : this._shells.entrySet()) {
            VshCredentials vc = obEntry.getValue();
            sb.append("\n\tHost: ").append(obEntry.getKey()).append("; telnet handle Id: ").append(vc._vsh.getTelnetHandleInfo());
            if (vc._users.size() > 0) {
                sb.append("; Users: ");
            }
            for (int i = 0; i < vc._users.size(); ++i) {
                sb.append(vc._users.get(i));
                if (i == vc._users.size() - 1) continue;
                sb.append(", ");
            }
        }
        return sb.toString();
    }

    public static void main(String[] strArgs) {
        try {
            VshManager.getInstance().synchUser("172.22.46.182", "test\\test", "test", "localhost");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        TIMEOUT = Integer.parseInt(System.getProperty("vshmanager.session-timeout", "60"));
        TCP_TIMEOUT = Integer.parseInt(System.getProperty("vshmanager.tcp-timeout", "60000"));
    }
}

