/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.snmp.security;

import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpTcpConnectionException;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.snmp.security.CommunityUser;
import com.cisco.dcbu.lib.snmp.security.SnmpUser;
import com.cisco.dcbu.lib.snmp.security.Target;
import com.cisco.dcbu.lib.snmp.security.UserEntry;
import java.net.InetAddress;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class CommunityUserEntry
extends UserEntry {
    static final int[][] _CommunityOid = new int[][]{{1, 3, 6, 1, 6, 3, 18, 1, 1, 1, 2}, {1, 3, 6, 1, 6, 3, 18, 1, 1, 1, 3}};
    static Logger _log = LogManager.getLogger((String)"snmp");
    CommunityUser _commUser;
    Target _target;

    public CommunityUserEntry(CommunityUser user, Target target) {
        this._commUser = user;
        this._target = target;
    }

    @Override
    public SnmpUser getUser() {
        return this._commUser;
    }

    @Override
    public Target getTarget() {
        return this._target;
    }

    @Override
    public int getSecurityModel() {
        return this._commUser.getSecurityModel();
    }

    @Override
    public SnmpPDU createPDU(int vbsize) {
        SnmpPDU pdu = this._target.createPDU(vbsize);
        pdu.setVersion(this._commUser.getVersion());
        pdu.setCommunity(this._commUser.getCommunity());
        return pdu;
    }

    @Override
    public void querySecurityName(SnmpSession session) throws SnmpException {
        SnmpPDU pdu;
        block6: {
            pdu = this.createPDU(1);
            pdu.setCommand((byte)-91);
            pdu.addNull(new SnmpOID(_CommunityOid[0]));
            pdu.addNull(new SnmpOID(_CommunityOid[1]));
            pdu.setMaxRptr(16);
            try {
                pdu = session.send(pdu);
            }
            catch (SnmpException e) {
                Throwable th = e.getCause();
                if (th == null || !(th instanceof SnmpTcpConnectionException) || !session.getTransportProvider().equalsIgnoreCase("tcp")) break block6;
                _log.info((Object)"In CommunityUserEntry querySecurityName: fail to connect via TCP, falling back to UDP");
                this._session = SnmpSession.getInstance("udp");
                if (this._session.getTransportProviderObject() == null) {
                    try {
                        this._session.open(InetAddress.getLocalHost(), Integer.parseInt(System.getProperty("snmp.localport", "0")), "udp");
                    }
                    catch (Exception se) {
                        _log.warn((Object)se);
                    }
                }
                pdu = this._session.send(pdu);
            }
        }
        VarBindList vbl = pdu.getVariables();
        String community = this._commUser.getCommunity();
        for (int i = 0; i < vbl.size(); i += 2) {
            String retCmmStr;
            if (vbl.get(i).getVar() == null || (retCmmStr = vbl.stringValue(i)) == null || !retCmmStr.equals(community)) continue;
            this._commUser.setSecurityName(vbl.stringValue(i + 1));
            break;
        }
    }

    public static CommunityUser authenticate(String community, InetAddress targetAddr) throws SnmpException {
        if (community == null) {
            throw new IllegalArgumentException("invalid community: " + community);
        }
        if (targetAddr == null) {
            throw new IllegalArgumentException("invalid target address: " + targetAddr);
        }
        CommunityUser user = new CommunityUser(community);
        CommunityUserEntry entry = new CommunityUserEntry(user, new Target(targetAddr));
        SnmpPeer peer = SnmpPeer.findPeer(targetAddr);
        SnmpSession session = peer == null ? SnmpSession.getInstance() : peer.getSession();
        entry.querySecurityName(session);
        if (entry.getSession() != null) {
            session = entry.getSession();
        }
        if (user.getSecurityName() == null) {
            entry.queryV2cRoleName(session);
        } else {
            entry.queryRoleName(session);
        }
        if (user.getRoleName() == null) {
            throw new SnmpException("Invalid user community: " + community);
        }
        return user;
    }
}

