/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.snmp.security;

import com.cisco.dcbu.lib.snmp.SnmpCrypto;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VshManager;
import com.cisco.dcbu.lib.snmp.security.SnmpUser;
import com.cisco.dcbu.lib.snmp.security.Target;
import com.cisco.dcbu.lib.snmp.security.UserEntry;
import com.cisco.dcbu.lib.snmp.security.UsmUser;
import com.cisco.dcbu.lib.snmp.security.V3Target;
import com.cisco.dcbu.lib.util.NetUtil;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;

public class UsmUserEntry
extends UserEntry {
    static final int[] _UserStatus = new int[]{1, 3, 6, 1, 6, 3, 15, 1, 2, 2, 1, 13};
    UsmUser _usmUser;
    V3Target _target;
    byte[] _authKey1;
    byte[] _authKey2;
    byte[] _privKey;

    public UsmUserEntry(UsmUser usmUser, V3Target target) {
        this._usmUser = usmUser;
        this._target = target;
    }

    @Override
    public SnmpUser getUser() {
        return this._usmUser;
    }

    @Override
    public Target getTarget() {
        return this._target;
    }

    @Override
    public int getSecurityModel() {
        return this._usmUser.getSecurityModel();
    }

    @Override
    public SnmpPDU createPDU(int vbsize) {
        SnmpPDU pdu = this._target.createPDU(vbsize);
        pdu.setVersion(3);
        pdu.setEngineId(this._target.getEngineId());
        pdu.setEngineBoots(this._target.getEngineBoots());
        pdu.setEngineTime(this._target.getEngineTime());
        pdu.setUserName(this._usmUser.getUserName());
        pdu.setAuthProtocol(this._usmUser.getAuthProtocol());
        pdu.setAuthKey(this._authKey1, this._authKey2);
        pdu.setPrivacyProtocol(this._usmUser.getPrivacyProtocol());
        pdu.setPrivacyKey(this._privKey);
        return pdu;
    }

    public void discoverEngine(SnmpSession session) throws SnmpException {
        InetAddress src = null;
        InetAddress addr = this._target.getAddress();
        try {
            src = session.getSnmpSourceAddress();
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (src != null && src instanceof Inet6Address && !src.isLoopbackAddress() && !src.isLinkLocalAddress() && !(addr instanceof Inet6Address)) {
            throw new SnmpException("Server has Snmp Local set to IPv6, the Switch IP is IPv4. Should be set to IPv6\nSnmp Local address " + NetUtil.getHostAddress(src) + " is " + (src instanceof Inet4Address ? "IPv4" : "IPv6") + "\nSwitch address " + NetUtil.getHostAddress(addr) + " is " + (addr instanceof Inet4Address ? "IPv4" : "IPv6"));
        }
        SnmpPDU pdu = this.createPDU(1);
        int timeout = pdu.getTimeout() * 3 / 2;
        pdu.setTimeout(timeout);
        try {
            pdu = session.send(pdu);
        }
        catch (SnmpException ex) {
            ex.printStackTrace();
            String err = "SNMP engine ID discovery timed out. It could be\n-- busy network;\n-- no route from " + NetUtil.getLocalNIC(session.getLocalInetAddress()) + "/" + session.getLocalHostAddress() + ";\n-- " + this._target._remoteHost + " snmpd is unresponsive.";
            throw new SnmpException(err);
        }
        this._target.setEngineID(pdu.getEngineId());
        if (this._usmUser.getAuthPassword() != null) {
            this.localizeKeys();
            pdu.setAuthKey(this._authKey1, this._authKey2);
        }
        try {
            pdu.setTimeout(timeout);
            pdu.setUserName(this._usmUser.getUserName());
            pdu.setAuthProtocol(this._usmUser.getAuthProtocol());
            pdu.setCommand((byte)-96);
            pdu.removeVarAt(0);
            pdu.setReqid(0);
            pdu = session.send(pdu);
            this._target.setEngineBoots(pdu.getEngineBoots());
            this._target.setEngineTime(pdu.getEngineTime());
        }
        catch (SnmpException ex) {
            throw new SnmpException("SNMP engine time and boots discovery timed out.");
        }
    }

    @Override
    public void querySecurityName(SnmpSession session) throws SnmpException {
        int i;
        byte[] engineId = this._target.getEngineId();
        String userName = this._usmUser.getUserName();
        int[] oid = new int[_UserStatus.length + engineId.length + userName.length() + 2];
        System.arraycopy(_UserStatus, 0, oid, 0, _UserStatus.length);
        oid[UsmUserEntry._UserStatus.length] = engineId.length;
        int max = engineId.length;
        for (i = 0; i < max; ++i) {
            oid[UsmUserEntry._UserStatus.length + i + 1] = engineId[i] & 0xFF;
        }
        oid[UsmUserEntry._UserStatus.length + engineId.length + 1] = userName.length();
        max = userName.length();
        for (i = 0; i < max; ++i) {
            oid[UsmUserEntry._UserStatus.length + engineId.length + i + 2] = userName.charAt(i) & 0xFF;
        }
        SnmpPDU pdu = this.createPDU(1);
        pdu.addNull(new SnmpOID(oid));
        try {
            pdu = session.send(pdu);
        }
        catch (SnmpException se) {
            if (se.getMessage().indexOf(SnmpException.toError(26)) != -1 || se.getMessage().indexOf(SnmpException.toError(28)) != -1) {
                try {
                    VshManager.getInstance().synchUser(this._target.getAddress().getHostAddress(), this._usmUser.getUserName(), this._usmUser.getAuthPassword(), session.getLocalHostAddress());
                }
                catch (Exception ex) {
                    throw se;
                }
                pdu = session.send(pdu);
            }
            throw se;
        }
        SnmpVar var = pdu.getVariables().getVb(0).getVar();
        if (var.getType() != 5 && ((SnmpInt)var).getValue() != 1) {
            throw new SnmpException("user " + userName + " is not active");
        }
        this._usmUser.setSecurityName(userName);
    }

    void localizeKeys() {
        byte[] passwKey = SnmpCrypto.passwordToKey(this._usmUser.getAuthPassword(), this._usmUser.getAuthProtocol());
        byte[] authkey = SnmpCrypto.getLocalizedKey(passwKey, this._target.getEngineId(), this._usmUser.getAuthProtocol());
        this._authKey1 = new byte[64];
        this._authKey2 = new byte[64];
        SnmpCrypto.calcLocalizedKeys(authkey, this._authKey1, this._authKey2);
        if (this._usmUser.getPrivacyPassword() != null) {
            byte[] privKey = SnmpCrypto.passwordToKey(this._usmUser.getPrivacyPassword(), this._usmUser.getAuthProtocol());
            this._privKey = SnmpCrypto.getLocalizedKey(privKey, this._target.getEngineId(), this._usmUser.getAuthProtocol());
        }
    }

    public static UsmUser authenticate(String userName, int authProtocol, String authPassword, int privProtocol, String privPassword, InetAddress targetAddr) throws SnmpException {
        if (userName == null) {
            throw new IllegalArgumentException("invalid user name: " + userName);
        }
        if (targetAddr == null) {
            throw new IllegalArgumentException("invalid target address: " + targetAddr);
        }
        UsmUser user = new UsmUser(userName, authProtocol, authPassword, privProtocol, privPassword);
        UsmUserEntry entry = new UsmUserEntry(user, new V3Target(targetAddr));
        entry.discoverEngine(SnmpSession.getInstance());
        entry.querySecurityName(SnmpSession.getInstance());
        entry.queryRoleName(SnmpSession.getInstance());
        if (user.getRoleName() == null) {
            throw new SnmpException("Invalid user name or password: " + userName);
        }
        return user;
    }
}

