/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.snmp.transport;

import com.cisco.dcbu.lib.snmp.CallbackHandler;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpTcpConnectionException;
import com.cisco.dcbu.lib.snmp.transport.SessionCallbackIf;
import com.cisco.dcbu.lib.snmp.transport.SnmpTransportProviderIf;
import com.cisco.dcbu.lib.snmp.transport.TcpSession;
import com.cisco.dcbu.lib.snmp.transport.TcpTransportOptions;
import com.cisco.dcbu.lib.snmp.transport.TransportCallbackIf;
import com.cisco.dcbu.lib.snmp.transport.TransportOptionsIf;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class TcpTransportProvider
implements SnmpTransportProviderIf,
SessionCallbackIf {
    private static ThreadGroup _ThreadGrp = null;
    static long _HashSleepInterval = 300000L;
    private int _sockBufferSize = Integer.parseInt(System.getProperty("snmp.tcp.recvbuf", "32768"));
    private Hashtable<String, TcpSession> _sessionById;
    private Hashtable<String, TcpTarget> _failedTargets;
    private TransportCallbackIf _callback;
    private int _remotePort;
    private boolean _close = false;
    private boolean _opened = false;
    private boolean _rqst_queue_full = false;
    Logger _log = LogManager.getLogger((String)"snmp.tcp");
    private ThreadLocal<String> pduUserName = new ThreadLocal();

    public TcpTransportProvider() {
        this._sessionById = new Hashtable();
        this._failedTargets = new Hashtable();
    }

    @Override
    public void setPduUserName(String username) {
        this.pduUserName.set(username);
    }

    @Override
    public void setCallback(TransportCallbackIf callback) {
        this._callback = callback;
    }

    @Override
    public Logger getLogger() {
        return this._log;
    }

    @Override
    public void setLogger(Logger logger) {
        this._log = logger;
    }

    @Override
    public InetAddress getLocalAddress() {
        InetAddress addr = null;
        for (TcpSession ses : this._sessionById.values()) {
            addr = ses.getLocalInetAddress();
            if (addr == null) continue;
            return addr;
        }
        try {
            return InetAddress.getLocalHost();
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public InetAddress getSnmpSourceAddress() {
        return this.getLocalAddress();
    }

    @Override
    public String getSnmpSourceAddress(InetAddress host) {
        InetAddress addr = null;
        for (TcpSession session : this._sessionById.values()) {
            if (session.getInetAddress() == null || !session.getInetAddress().equals(host)) continue;
            addr = session.getLocalInetAddress();
            break;
        }
        if (addr == null) {
            addr = this.getLocalAddress();
        }
        return addr != null ? addr.getHostAddress() : null;
    }

    @Override
    public boolean open(TransportOptionsIf options) throws IOException {
        if (options == null || !(options instanceof TcpTransportOptions)) {
            throw new IOException("Invalid TcpProtocolOptions");
        }
        if (!this._opened || this._sessionById.size() < 1) {
            TcpTransportOptions tcpOptions = (TcpTransportOptions)options;
            if (tcpOptions.getRemoteAddress() != null && tcpOptions.getRemotePort() > 0) {
                this.createSession(tcpOptions.getRemoteAddress(), tcpOptions.getRemotePort());
            }
            this._remotePort = tcpOptions.getRemotePort();
            this._opened = true;
        }
        new Thread("TcpTargetPollingThread"){

            @Override
            public void run() {
                Iterator itr = null;
                TcpTarget tgt = null;
                while (TcpTransportProvider.this._opened) {
                    do {
                        try {
                            Thread.sleep(_HashSleepInterval);
                        }
                        catch (InterruptedException ex) {
                            TcpTransportProvider.this._log.warn((Object)"TcpTargetPolling: exception during thread sleep in target polling!");
                        }
                        TcpTransportProvider.this._rqst_queue_full = Boolean.parseBoolean(System.getProperty("rqst_queue_full"));
                    } while (!TcpTransportProvider.this._rqst_queue_full);
                    itr = TcpTransportProvider.this._failedTargets.keySet().iterator();
                    while (itr.hasNext()) {
                        String key = (String)itr.next();
                        tgt = (TcpTarget)TcpTransportProvider.this._failedTargets.get(key);
                        try {
                            Socket socket = TcpTransportProvider.this.getSocket(tgt.getAddr(), tgt.getPort(), key);
                            if (socket.isConnected()) {
                                itr.remove();
                            }
                            if (socket.isClosed()) continue;
                            socket.close();
                        }
                        catch (SocketException e) {
                            TcpTransportProvider.this._log.debug((Object)("Testing tcp target: " + tgt.getAddr() + " failed!" + e.getMessage()));
                        }
                        catch (IOException e) {
                            TcpTransportProvider.this._log.debug((Object)("Testing tcp target: " + tgt.getAddr() + " failed!" + e.getMessage()));
                        }
                    }
                }
            }
        }.start();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this._opened = false;
        this._close = true;
        Hashtable<String, TcpSession> hashtable = this._sessionById;
        synchronized (hashtable) {
            Iterator<Map.Entry<String, TcpSession>> it = this._sessionById.entrySet().iterator();
            while (it.hasNext()) {
                try {
                    TcpSession tcpSession = it.next().getValue();
                    it.remove();
                    tcpSession.close();
                }
                catch (Exception ex) {
                    this._log.log((Priority)Level.WARN, (Object)"closeSocket", (Throwable)ex);
                }
            }
        }
        this._sessionById = null;
        this._failedTargets.clear();
        CallbackHandler.getInstance().finish();
    }

    @Override
    public void write(SnmpPDU pdu) throws SnmpException {
        if (pdu == null) {
            throw new SnmpException("SnmpPDU passed is null.");
        }
        try {
            this.createSession(pdu.getAddress(), pdu.getPort(), pdu.getUserName()).writePdu(pdu);
        }
        catch (IOException ioe) {
            throw new SnmpException(ioe.getMessage(), ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void monitorRequests() {
        Hashtable<String, TcpSession> hashtable = this._sessionById;
        synchronized (hashtable) {
            Iterator<Map.Entry<String, TcpSession>> it = this._sessionById.entrySet().iterator();
            while (it.hasNext()) {
                try {
                    TcpSession tcpSession = it.next().getValue();
                    tcpSession.monitorRequests();
                }
                catch (Exception ex) {
                    this._log.log((Priority)Level.WARN, (Object)"MonitorRequests in TcpTransportProvider", (Throwable)ex);
                }
            }
        }
    }

    public String getStatsInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nTCP provider");
        sb.append("\n\t================= TCP Open Sessions  =================================: ");
        sb.append(this.getOpenSessions());
        Iterator<Map.Entry<String, TcpSession>> it = this._sessionById.entrySet().iterator();
        while (it.hasNext()) {
            TcpSession tcpSession = it.next().getValue();
            sb.append(tcpSession.getStatsInfo());
        }
        sb.append("\n\t========= TCP Provider Failed Targets  ============== ");
        sb.append(this.getFailedTargets());
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSession(InetAddress addr, int port) {
        String sessionId = addr.getHostAddress() + "/" + port;
        Hashtable<String, TcpSession> hashtable = this._sessionById;
        synchronized (hashtable) {
            Iterator<Map.Entry<String, TcpSession>> it = this._sessionById.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, TcpSession> me = it.next();
                if (me.getKey().indexOf(sessionId) == -1) continue;
                try {
                    if (this._log.isDebugEnabled()) {
                        this._log.debug((Object)(me.getKey() + " close its tcp session"), (Throwable)new Exception("TraceLogger"));
                    }
                    it.remove();
                    me.getValue().close(false);
                }
                catch (Exception e) {
                    this._log.log((Priority)Level.WARN, (Object)(sessionId + " failed to close tcp socket"), (Throwable)e);
                }
            }
            this._failedTargets.remove(sessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSession(InetAddress addr, int port, String username) {
        TcpSession tcpSession = null;
        String sessionId = addr.getHostAddress() + "/" + port + "/" + username;
        Hashtable<String, TcpSession> hashtable = this._sessionById;
        synchronized (hashtable) {
            tcpSession = this._sessionById.get(sessionId);
            if (tcpSession == null) {
                return;
            }
            try {
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)(sessionId + " close its tcp session"), (Throwable)new Exception("TraceLogger"));
                }
                this._sessionById.remove(sessionId);
                tcpSession.close(false);
            }
            catch (IOException ex) {
                this._log.warn((Object)(sessionId + " failed to close socket"), (Throwable)ex);
            }
        }
        this._failedTargets.remove(sessionId);
    }

    TcpSession createSession(InetAddress addr, int port) throws IOException {
        return this.createSession(addr, port, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TcpSession createSession(InetAddress addr, int port, String userName) throws IOException {
        String localUserName;
        TcpSession session = null;
        String sessionId = null;
        String failedTargetId = null;
        failedTargetId = addr.getHostAddress() + "/" + port;
        sessionId = userName == null ? ((localUserName = this.pduUserName.get()) == null ? failedTargetId : failedTargetId + "/" + localUserName) : failedTargetId + "/" + userName;
        Hashtable<String, TcpSession> hashtable = this._sessionById;
        synchronized (hashtable) {
            session = this._sessionById.get(sessionId);
            if (session == null || !session.isConnected()) {
                Socket socket;
                TcpTarget target = this._failedTargets.get(failedTargetId);
                if (target != null) {
                    throw new IOException(target.getExceptionMsg());
                }
                try {
                    socket = this.getSocket(addr, port, sessionId);
                }
                catch (IOException e1) {
                    if (this._rqst_queue_full) {
                        this._log.warn((Object)(addr + " socket connection failed, put " + sessionId + " into failed targets list. "));
                        this._failedTargets.put(failedTargetId, new TcpTarget(addr, port, e1.getMessage()));
                    }
                    String cmdstr = e1 instanceof ConnectException ? addr.getHostAddress() + " connection failed" + " " + e1.getMessage() : (e1 instanceof SocketTimeoutException ? addr + " no SNMP/TCP support. " + e1.getMessage() : addr + " getSocket failed: " + e1.getMessage());
                    if (this._log.isDebugEnabled()) {
                        this._log.debug((Object)(addr + " getSocket caught exception: " + e1.getMessage()), (Throwable)e1);
                    } else {
                        this._log.warn((Object)(addr + " getSocket caught exception: " + e1.getMessage()));
                    }
                    throw new SnmpTcpConnectionException(cmdstr, e1);
                }
                session = new TcpSession(_ThreadGrp, sessionId, socket, userName, this);
                this._sessionById.put(sessionId, session);
                session.start();
                this._log.info((Object)(sessionId + " started"));
                if (this._log.isTraceEnabled()) {
                    this._log.trace((Object)(sessionId + " create its tcp session, socket and thread"), (Throwable)new Exception("TraceLogger"));
                }
            }
        }
        return session;
    }

    private Socket getSocket(InetAddress addr, int port, String sessionId) throws SocketException, IOException {
        Socket socket = new Socket();
        socket.setReceiveBufferSize(this._sockBufferSize);
        socket.setTcpNoDelay(true);
        socket.setSoLinger(false, 0);
        socket.setKeepAlive(true);
        socket.setSoTimeout(0);
        socket.connect(new InetSocketAddress(addr, port), 5000);
        return socket;
    }

    @Override
    public void update(TcpSession session, byte type) {
        if (type != 3 && type == 4) {
            this._sessionById.remove(session.getSessionId());
            session.destroy();
        }
    }

    public String getOpenSessions() {
        TcpSession session = null;
        StringBuffer sb = new StringBuffer();
        Iterator<TcpSession> e = this._sessionById.values().iterator();
        while (e.hasNext()) {
            try {
                session = e.next();
                sb.append("\n\t" + session.getSessionId());
            }
            catch (Exception ex) {
                this._log.log((Priority)Level.WARN, (Object)ex);
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopSession(String str) {
        String sessionId = null;
        TcpSession tcpSession = null;
        int ch = 47;
        Hashtable<String, TcpSession> hashtable = this._sessionById;
        synchronized (hashtable) {
            Iterator<Map.Entry<String, TcpSession>> it = this._sessionById.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, TcpSession> me = it.next();
                if (me.getKey().indexOf(str) == -1) continue;
                try {
                    sessionId = me.getKey();
                    if (sessionId.lastIndexOf(ch) != sessionId.indexOf(ch)) {
                        sessionId = sessionId.substring(0, sessionId.lastIndexOf(ch));
                    }
                    tcpSession = me.getValue();
                    it.remove();
                    this._failedTargets.remove(sessionId);
                    tcpSession.close(false);
                }
                catch (IOException e) {
                    this._log.warn((Object)e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopSession() throws IOException {
        TcpSession tcpSession = null;
        Hashtable<String, TcpSession> hashtable = this._sessionById;
        synchronized (hashtable) {
            Iterator<Map.Entry<String, TcpSession>> it = this._sessionById.entrySet().iterator();
            while (it.hasNext()) {
                try {
                    tcpSession = it.next().getValue();
                    it.remove();
                    tcpSession.close(false);
                }
                catch (Exception ex) {
                    this._log.warn((Object)ex.getMessage());
                }
            }
        }
        this._failedTargets.clear();
    }

    public String getFailedTargets() {
        TcpTarget target = null;
        StringBuffer sb = new StringBuffer();
        Iterator<TcpTarget> e = this._failedTargets.values().iterator();
        while (e.hasNext()) {
            try {
                target = e.next();
                sb.append("\n\t" + target.toString());
            }
            catch (Exception ex) {
                this._log.log((Priority)Level.WARN, (Object)ex);
            }
        }
        return sb.toString();
    }

    public int getRemotePort() {
        return this._remotePort;
    }

    static {
        if (_ThreadGrp == null) {
            _ThreadGrp = new ThreadGroup("TcpTransportProvider");
        }
    }

    class TcpTarget {
        InetAddress addr = null;
        int port;
        String exceptionMsg;

        public TcpTarget(InetAddress addr, int port) {
            this.addr = addr;
            this.port = port;
        }

        public TcpTarget(InetAddress addr, int port, String msg) {
            this(addr, port);
            this.exceptionMsg = msg;
        }

        public String getExceptionMsg() {
            return this.exceptionMsg;
        }

        public InetAddress getAddr() {
            return this.addr;
        }

        public int getPort() {
            return this.port;
        }

        public String toString() {
            return this.addr + " \\ " + this.port + " Exceptin msg: " + this.exceptionMsg;
        }
    }
}

