/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.sshexec.impl;

import com.cisco.dcbu.lib.snmp.security.SnmpUser;
import com.cisco.dcbu.lib.snmp.security.UsmUser;
import com.cisco.dcbu.lib.sshexec.ICliAdapter;
import com.cisco.dcbu.lib.sshexec.ISshTransport;
import com.cisco.dcbu.lib.sshexec.impl.SshExecTransport;
import com.cisco.dcbu.lib.sshexec.impl.SshShellTransport;
import com.cisco.dcbu.lib.sshexec.impl.SshTransport;
import com.cisco.dcbu.sm.server.model.EthSwitchImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.NotSupportedException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class CliAdapter
implements ICliAdapter {
    protected static Logger logger = LogManager.getLogger((String)"fms.cli");
    protected static String NETCONF_TERMINATOR = "]]>]]>";
    protected static String XML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    protected static String SHOW_HELP = "?";
    protected static int TIMEOUT = 0;
    protected static String ACCOUNTING_LOGGING = "configure terminal ; terminal log-all ; exit";
    protected static String NO_ACCOUNTING_LOGGING = "configure terminal ; no terminal log-all ; exit";
    protected static String SESSION_TIMEOUT = "terminal session-timeout ";
    protected static String SHOW_TERMINAL = "show terminal";
    protected static String TERMINAL_LENGTH = "terminal length ";
    static final String CHANNEL_EXEC = "exec";
    private static Map<String, ISshTransport> transports = Collections.synchronizedMap(new HashMap());
    protected ISshTransport transport = null;
    protected EthSwitchImpl ethSw = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CliAdapter(EthSwitchImpl ethSw) throws Exception {
        if (ethSw == null) {
            throw new IllegalArgumentException("Invalid switch object");
        }
        this.ethSw = ethSw;
        EthSwitchImpl ethSwitchImpl = ethSw;
        synchronized (ethSwitchImpl) {
            SnmpUser user = ethSw.getCredential();
            this.transport = transports.get(ethSw.getIpAddress());
            try {
                if (this.transport == null) {
                    if (user == null || user.getSecurityModel() != 3) throw new NotSupportedException("Invalid credential for switch '" + ethSw.getName());
                    UsmUser usmUser = (UsmUser)user;
                    this.transport = new SshTransport();
                    this.transport.openShell(ethSw.getIpAddress(), usmUser.getUserName(), usmUser.getAuthPassword());
                    transports.put(ethSw.getIpAddress(), this.transport);
                    logger.info((Object)("CliAdapter(): open ssh connection to switch '" + this.transport.getCredential().getHost() + "'"));
                } else {
                    if (this.transport.getOrionSession() != null) return;
                    this.transport.close();
                    UsmUser usmUser = (UsmUser)user;
                    this.transport.openShell(ethSw.getIpAddress(), usmUser.getUserName(), usmUser.getAuthPassword());
                    logger.info((Object)("CliAdapter(): reopen ssh connection to switch '" + this.transport.getCredential().getHost() + "'"));
                }
            }
            catch (Exception e) {
                if (this.transport == null) throw e;
                this.transport.close();
                transports.remove(ethSw.getIpAddress());
                this.transport = null;
                throw e;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CliAdapter(EthSwitchImpl ethSw, boolean shell) throws Exception {
        this.ethSw = ethSw;
        EthSwitchImpl ethSwitchImpl = ethSw;
        synchronized (ethSwitchImpl) {
            SnmpUser user = ethSw.getCredential();
            UsmUser usmUser = (UsmUser)user;
            if (user != null && user.getSecurityModel() == 3) {
                if (!shell) {
                    this.transport = new SshExecTransport();
                    this.transport.open(ethSw.getIpAddress(), usmUser.getUserName(), usmUser.getAuthPassword());
                } else {
                    this.transport = new SshTransport();
                    this.transport.openShell(ethSw.getIpAddress(), usmUser.getUserName(), usmUser.getAuthPassword());
                }
            }
        }
    }

    public CliAdapter(String host, String userName, String password) throws Exception {
        if (host == null || host.trim().equals("")) {
            return;
        }
        this.transport = transports.get(host);
        try {
            if (this.transport == null) {
                this.transport = new SshTransport();
                this.transport.openShell(host, userName, password);
                transports.put(host, this.transport);
                logger.info((Object)("CliAdapter(): open ssh connection to host '" + host + "'"));
            } else if (this.transport.getOrionSession() == null) {
                this.transport.close();
                this.transport.openShell(host, userName, password);
                logger.info((Object)("CliAdapter(): reopen ssh connection to host '" + host + "'"));
            }
        }
        catch (Exception e) {
            if (this.transport != null) {
                this.transport.close();
                this.transport = null;
            }
            throw e;
        }
    }

    public CliAdapter(String host, String userName, String password, boolean shell) throws Exception {
        if (!shell) {
            this.transport = new SshExecTransport();
            this.transport.open(host, userName, password);
        } else {
            this.transport = new SshTransport();
            this.transport.openShell(host, userName, password);
        }
    }

    public CliAdapter(String host, String userName, String password, int sessionTimeout) throws Exception {
        if (host == null || host.trim().equals("")) {
            return;
        }
        String channelType = System.getProperty("cli.channel.type", CHANNEL_EXEC);
        this.transport = channelType.equalsIgnoreCase(CHANNEL_EXEC) ? new SshExecTransport() : new SshShellTransport();
        this.transport.setSessionTimeout(sessionTimeout);
        this.transport.open(host, userName, password);
        this.turnOffLogging();
        this.setSessionTimeout(TIMEOUT);
        this.setTerminalLength(0);
    }

    @Override
    public void close() throws Exception {
        if (this.transport.getCredential() != null) {
            transports.remove(this.transport.getCredential().getHost());
        }
        if (this.transport != null) {
            this.transport.close();
            this.transport = null;
        }
    }

    public static void close(String host) {
        if (host == null || host.trim().equals("")) {
            return;
        }
        ISshTransport transport = transports.remove(host);
        if (transport != null) {
            transport.close();
            transport = null;
        }
    }

    public static void closeAll() {
        Collection<ISshTransport> values = transports.values();
        for (ISshTransport t : values) {
            if (t == null) continue;
            t.close();
        }
        transports.clear();
    }

    protected String removeTerminator(String xml) {
        String result = null;
        if (xml == null || xml.length() == 0) {
            return result;
        }
        result = xml.indexOf(NETCONF_TERMINATOR) >= 0 ? xml.substring(0, xml.indexOf(NETCONF_TERMINATOR)) : xml;
        return result;
    }

    protected String removeCliHeader(String str, String terminator) {
        String result = null;
        int index = str.indexOf(terminator);
        index = str.indexOf("\n", index) + 1;
        result = str.substring(index);
        return result;
    }

    protected boolean isSessionValid() {
        boolean result = false;
        if (this.transport != null) {
            try {
                long startTime = System.currentTimeMillis();
                this.transport.send(SHOW_HELP);
                long endTime = System.currentTimeMillis();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(this.transport.getCredential().getHost() + ": show help command took " + (endTime - startTime) + "ms"));
                }
            }
            catch (Exception e) {
                logger.warn((Object)(this.transport.getCredential().getHost() + ": ssh session is invalid. " + e));
            }
        }
        return result;
    }

    protected void turnOffLogging() throws Exception {
        if (this.transport != null) {
            try {
                long startTime = System.currentTimeMillis();
                String resp = this.transport.send(NO_ACCOUNTING_LOGGING);
                logger.debug((Object)("configure: " + resp));
                long endTime = System.currentTimeMillis();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(this.transport.getCredential().getHost() + ": turnOffLogging command took " + (endTime - startTime) + "ms"));
                }
            }
            catch (Exception e) {
                logger.warn((Object)(this.transport.getCredential().getHost() + ": failed to turn off accounting logging. " + e));
                throw e;
            }
        }
    }

    protected void setSessionTimeout(int timeout) throws Exception {
        if (this.transport != null) {
            try {
                long startTime = System.currentTimeMillis();
                this.transport.send(SESSION_TIMEOUT + timeout);
                long endTime = System.currentTimeMillis();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(this.transport.getCredential().getHost() + ": setSessionTimeout command took " + (endTime - startTime) + "ms"));
                }
            }
            catch (Exception e) {
                logger.warn((Object)(this.transport.getCredential().getHost() + ": failed to set session timeout. " + e));
                throw e;
            }
        }
    }

    protected void setTerminalLength(int len) throws Exception {
        if (this.transport != null) {
            try {
                long startTime = System.currentTimeMillis();
                this.transport.send(TERMINAL_LENGTH + len);
                long endTime = System.currentTimeMillis();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(this.transport.getCredential().getHost() + ": setTerminalLength command took " + (endTime - startTime) + "ms"));
                }
            }
            catch (Exception e) {
                logger.warn((Object)(this.transport.getCredential().getHost() + ": failed to set terminal length. " + e));
                throw e;
            }
        }
    }
}

