/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.sshexec.impl;

import com.cisco.dcbu.lib.sshexec.CliCommands;
import com.cisco.dcbu.lib.sshexec.IEthPortAdapter;
import com.cisco.dcbu.lib.sshexec.impl.CliAdapter;
import com.cisco.dcbu.lib.util.CliUtil;
import com.cisco.dcbu.sm.common.util.TraceLogger;
import com.cisco.dcbu.sm.server.model.EthPortImpl;
import com.cisco.dcbu.sm.server.model.EthSwitchImpl;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class EthPortAdapter
extends CliAdapter
implements IEthPortAdapter {
    private static final String INTERFACE_ROW = "ROW_interface";
    private static final String INTERFACE_NAME = "interface";
    private static final String IF_INDEX_DEC = "ifindex-dec";
    private static final String PORT_MODE = "portmode";
    private static final String STATUS = "state";
    private static final String STATUS_REASON = "state_rsn_desc";
    private HashMap<String, Integer> _ifIndexMap = new HashMap();
    static final TraceLogger _Tracer = new TraceLogger(Logger.getLogger((String)"fms.disc"), false, false, false, false);

    public EthPortAdapter(EthSwitchImpl ethSw) throws Exception {
        super(ethSw);
    }

    public EthPortAdapter(String host, String userName, String password) throws Exception {
        super(host, userName, password);
    }

    @Override
    public String showInterfaceBriefXml() throws Exception {
        long startTime = System.currentTimeMillis();
        String resp = this.transport.send(CliCommands.SHOW_INTERFACE_BRIEF_XML);
        long sendTime = System.currentTimeMillis();
        _Tracer.log(Level.DEBUG, this.ethSw.getIpAddress() + "-->show interface brief | xml command took " + (sendTime - startTime) + " ms");
        if (resp == null || resp.startsWith("Syntax error") || resp.contains("Invalid command at")) {
            _Tracer.log(Level.INFO, "Intf Brief XML response from the device: " + resp);
            _Tracer.log(Level.TRACE, this.ethSw.getIpAddress() + "-->Unable to get show interface brief information.");
            return null;
        }
        return resp;
    }

    @Override
    public String showInterfaceSnmpIfIndexXml() throws Exception {
        long startTime = System.currentTimeMillis();
        String resp = this.transport.send(CliCommands.SHOW_INTERFACE_SNMP_IFINDEX_XML);
        long sendTime = System.currentTimeMillis();
        _Tracer.log(Level.DEBUG, this.ethSw.getIpAddress() + "-->show interface snmp-ifindex | xml command took " + (sendTime - startTime) + " ms");
        if (resp == null || resp.startsWith("Syntax error") || resp.contains("Invalid command at")) {
            _Tracer.log(Level.INFO, "Intf snmp-ifindex XML response from the device: " + resp);
            _Tracer.log(Level.TRACE, this.ethSw.getIpAddress() + "-->Unable to get show interface snmp-ifindex information.");
            return null;
        }
        return resp;
    }

    @Override
    public void updateEthPortImplByShowIntfBriefXml() throws Exception {
        String resp = this.showInterfaceBriefXml();
        _Tracer.log(Level.TRACE, "IntfBrief XML response from the device: " + resp);
        String respIfIndex = this.showInterfaceSnmpIfIndexXml();
        _Tracer.log(Level.TRACE, "IfIndex XML response from the device: " + respIfIndex);
        if (respIfIndex != null) {
            this.updateIfIndexMap(respIfIndex);
        }
        if (resp != null) {
            long startTime = System.currentTimeMillis();
            List<String> rows = CliUtil.getXmlRecords(resp, INTERFACE_ROW);
            for (String row : rows) {
                String ifName = CliUtil.getTagValue(row, INTERFACE_NAME);
                if (ifName == null || ifName.startsWith("mgmt") || ifName.startsWith("control")) continue;
                int ifIndex = -1;
                if (this._ifIndexMap.get(ifName) != null) {
                    ifIndex = this._ifIndexMap.get(ifName);
                } else {
                    if (ifName.startsWith("port-channel")) {
                        ifName = "eth-channel" + ifName.substring(12);
                    }
                    ifIndex = this.ethSw.getBase().nameToIfIndex(ifName);
                }
                EthPortImpl ethPortImpl = this.ethSw.findEthPort(ifIndex);
                if (ethPortImpl != null) {
                    String statusReason;
                    if (row.indexOf(PORT_MODE) >= 0) {
                        ethPortImpl.getBase().setPortMode(CliUtil.getTagValue(row, PORT_MODE));
                    }
                    if (row.indexOf(STATUS_REASON) >= 0 && (statusReason = CliUtil.getTagValue(row, STATUS_REASON)) != null) {
                        if (statusReason.length() > 2000) {
                            statusReason = statusReason.substring(0, 2000);
                            _Tracer.log(Level.WARN, this.ethSw.getIpAddress() + "-->statusReason > 2000.  Truncating!!!!");
                        }
                        ethPortImpl.getBase().setIfStatusReason(statusReason);
                    }
                    _Tracer.log(Level.TRACE, this.ethSw.getIpAddress() + "-->ifName: " + ifName + " portmode: " + ethPortImpl.getBase().getPortMode() + " state_rsn_desc: " + ethPortImpl.getBase().getIfStatusReason());
                    continue;
                }
                _Tracer.log(Level.INFO, this.ethSw.getIpAddress() + "-->Unable to get EthportImpl for the ifName: " + ifName + " ifIndex: " + ifIndex);
            }
            long endTime = System.currentTimeMillis();
            _Tracer.log(Level.DEBUG, this.ethSw.getIpAddress() + "-->show interface brief response processing took " + (endTime - startTime) + " ms");
        }
    }

    private void updateIfIndexMap(String respIfIndex) {
        this._ifIndexMap.clear();
        long startTime = System.currentTimeMillis();
        List<String> rows = CliUtil.getXmlRecords(respIfIndex, INTERFACE_ROW);
        for (String row : rows) {
            String ifName = CliUtil.getTagValue(row, INTERFACE_NAME);
            String ifIndex = CliUtil.getTagValue(row, IF_INDEX_DEC);
            try {
                this._ifIndexMap.put(ifName, Integer.parseInt(ifIndex));
            }
            catch (NumberFormatException nfe) {
                _Tracer.log(Level.DEBUG, this.ethSw.getIpAddress() + "-->updateIfIndexMap error '" + nfe.getMessage() + "'. " + row);
            }
        }
        long endTime = System.currentTimeMillis();
        _Tracer.log(Level.DEBUG, this.ethSw.getIpAddress() + "-->show interface snmp-ifindex response processing took " + (endTime - startTime) + " ms");
    }

    private int getIfIndex(String respIfIndex, String ifName) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        EthPortAdapter adapter = null;
        try {
            adapter = new EthPortAdapter("172.22.31.14", "admin", "democonf_2008");
            String rs = adapter.showInterfaceBriefXml();
            adapter.close();
            List<String> rows = CliUtil.getXmlRecords(rs, INTERFACE_ROW);
            for (String row : rows) {
                System.out.println("interface: " + CliUtil.getTagValue(row, INTERFACE_NAME));
                System.out.println("portmode: " + CliUtil.getTagValue(row, PORT_MODE));
                System.out.println("state: " + CliUtil.getTagValue(row, STATUS));
                System.out.println("state_rsn_desc: " + CliUtil.getTagValue(row, STATUS_REASON));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (adapter != null) {
                try {
                    adapter.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

