/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.sshexec.impl;

import com.cisco.dcbu.lib.protocol.SSHWrapper;
import com.cisco.dcbu.lib.protocol.Util;
import com.cisco.dcbu.lib.sshexec.impl.SshTransportAdapter;
import com.cisco.dcbu.lib.sshexec.model.SshCredential;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class SshShellTransport
extends SshTransportAdapter {
    private final Logger log = LogManager.getLogger((String)"fms.disc");
    static final String DEFAULT_PROMPT = "#";
    private static int SSH_PORT = 22;
    private static long SLEEP = 50L;
    private long _waitTime = Integer.parseInt(System.getProperty("ssh.read-wait-time", "15000"));
    private int _sessionTimeout = Integer.parseInt(System.getProperty("ssh.session-timeout", "0"));
    private SshCredential _credential = null;
    private JSch _jsch = null;
    private Session _session = null;
    private Channel _channel = null;
    private InputStream _in = null;
    private OutputStream _out = null;

    @Override
    public void close() {
        this.closeChannel();
        if (this._session != null && this._session.isConnected()) {
            try {
                this._session.disconnect();
            }
            catch (Exception e) {
                this.log.info((Object)("SshExecTransport.close(): " + e.getMessage()));
            }
            this._session = null;
        }
    }

    public void closeChannel() {
        this.closeStreams();
        if (this._channel != null && this._channel.isConnected()) {
            try {
                this._channel.disconnect();
            }
            catch (Exception e) {
                this.log.info((Object)("SshExecTransport.closeChannel(): " + e.getMessage()));
            }
            this._channel = null;
        }
    }

    public void closeStreams() {
        if (this._in != null) {
            try {
                this._in.close();
            }
            catch (IOException e) {
                this.log.info((Object)("SshExecTransport.closeStreams(): failed to close input stream. " + e.getMessage()));
            }
            this._in = null;
        }
        if (this._out != null) {
            try {
                this._out.close();
            }
            catch (IOException e) {
                this.log.info((Object)("SshExecTransport.closeStreams(): failed to close output stream. " + e.getMessage()));
            }
            this._out = null;
        }
    }

    @Override
    public synchronized void open(String ip, String userName, String password) throws Exception {
        if (!Util.isServiceRunning(ip, SSH_PORT)) {
            throw new Exception("Not able to reach : " + ip + ":" + SSH_PORT);
        }
        try {
            this._jsch = new JSch();
            this._session = this._jsch.getSession(userName, ip);
            this._session.setUserInfo(new SSHWrapper.MyUserInfo(password));
            this._session.connect(this._sessionTimeout, new String[]{Session.PASSWORD});
            this._credential = new SshCredential(ip, userName, password);
        }
        catch (JSchException e) {
            this.log.error((Object)("SshExecTransport.open(): " + e.getMessage()));
            throw new Exception("SSH failed to connect to '" + ip + "', please check credential or connection using ssh terminal.");
        }
        this.openChannel();
    }

    public void openChannel() throws Exception {
        try {
            if (this._session == null || !this._session.isConnected()) {
                throw new Exception("Invalid session");
            }
            this._channel = this._session.openChannel("shell");
            this._in = this._channel.getInputStream();
            this._out = this._channel.getOutputStream();
            this._channel.connect();
            this.getResponse();
            this.send("terminal session-timeout " + this._sessionTimeout);
            this.send("terminal length 0");
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.getResponse();
        }
        catch (Exception e) {
            this.log.error((Object)("Channel connect exception : " + e.getMessage()));
            this.close();
            throw e;
        }
    }

    @Override
    public synchronized String send(String cmd) {
        return this.send(cmd, true);
    }

    @Override
    public synchronized String send(String cmd, boolean trim) {
        if (this._session == null || cmd == null) {
            return null;
        }
        if (this.log.isDebugEnabled() && this._credential != null) {
            this.log.debug((Object)(this._credential.getHost() + ": sending command '" + cmd + "'"));
        }
        if (!cmd.endsWith("\n")) {
            cmd = cmd + "\n";
        }
        String result = null;
        try {
            byte[] b = cmd.getBytes();
            this._out.write(b, 0, b.length);
            this._out.flush();
            result = trim ? this.trim(this.getResponse()) : this.getResponse();
        }
        catch (Exception ex) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Failed to send command '" + cmd + "' to " + this._credential.getHost() + ". " + ex.getMessage()));
            }
            this.close();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("'" + cmd.substring(0, cmd.length() - 1) + "': " + result));
        }
        return result;
    }

    public String getResponse() throws IOException, Exception {
        StringBuffer buff = new StringBuffer();
        byte[] b = new byte[40000];
        int len = 0;
        long time = 0L;
        while (time < this._waitTime) {
            if (this._in == null) {
                throw new Exception("InputStream is null");
            }
            if (this._in != null && this._in.available() != 0) {
                len = this._in.read(b, 0, this._in.available());
                buff.append(new String(b, 0, len));
                if (buff.length() > 0 && buff.indexOf(DEFAULT_PROMPT) >= 0) break;
                if (len > 0) {
                    time = 0L;
                }
            }
            if (this._in == null || this._in.available() != 0) continue;
            try {
                Thread.sleep(SLEEP);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            time += SLEEP;
        }
        if (time >= this._waitTime && this._in != null && this._in.available() > 0) {
            this._in.read(b, 0, this._in.available());
        }
        return buff.toString();
    }

    private String trim(String in) {
        if (in == null || in.trim().equals("")) {
            return in;
        }
        String b = null;
        int firstLineIdx = in.indexOf(10);
        int lastLineIdx = in.lastIndexOf(10);
        if (lastLineIdx != -1 && lastLineIdx == in.length() - 1) {
            in = in.substring(0, in.length() - 1);
            lastLineIdx = in.lastIndexOf(10);
        }
        b = firstLineIdx != -1 && lastLineIdx != -1 && lastLineIdx > firstLineIdx ? in.substring(firstLineIdx + 1, lastLineIdx) : (firstLineIdx != -1 && lastLineIdx != -1 && lastLineIdx == firstLineIdx ? "" : in);
        return b;
    }

    @Override
    public Session getJschSession() {
        return this._session;
    }

    @Override
    public SshCredential getCredential() {
        return this._credential;
    }

    @Override
    public void setSessionTimeout(int timeout) {
        this._sessionTimeout = timeout;
    }
}

