/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.sshexec.impl.nxos611;

import com.cisco.dcbu.lib.sshexec.CliCommands;
import com.cisco.dcbu.lib.sshexec.impl.LldpAdapter;
import com.cisco.dcbu.lib.sshexec.model.nxos611.lldp.ROWNbor;
import com.cisco.dcbu.lib.sshexec.model.nxos611.lldp.ROWNborDetail;
import com.cisco.dcbu.lib.sshexec.model.nxos611.lldp.RpcReply;
import com.cisco.dcbu.lib.util.XmlUtil;
import com.cisco.dcbu.sm.common.model.LanHostBase;
import com.cisco.dcbu.sm.common.util.TraceLogger;
import com.cisco.dcbu.sm.server.model.EthSwitchImpl;
import com.cisco.dcbu.sm.server.model.HostManager;
import com.cisco.dcbu.sm.server.model.LanHostImpl;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class LldpAdapter_6_1
extends LldpAdapter {
    static final TraceLogger logger = new TraceLogger(Logger.getLogger((String)"fms.adapter"), false, false, false, false);

    public LldpAdapter_6_1(EthSwitchImpl sw) throws Exception {
        super(sw);
    }

    public LldpAdapter_6_1(String host, String userName, String password) throws Exception {
        super(host, userName, password);
    }

    @Override
    public List<LanHostImpl> showLldpNeighborsXml() throws Exception {
        ArrayList<LanHostImpl> result = new ArrayList<LanHostImpl>();
        if (this.transport == null) {
            return result;
        }
        long startTime = System.currentTimeMillis();
        String resp = this.transport.send(CliCommands.SHOW_LLDP_NEIGHTBORS_XML);
        long sendTime = System.currentTimeMillis();
        logger.debug("showLldpNeighborsXml command took " + (sendTime - startTime) + "ms");
        resp = this.removeTerminator(resp);
        if (resp == null || resp.trim().equals("")) {
            return result;
        }
        RpcReply reply = (RpcReply)XmlUtil.generateObject(RpcReply.class, resp);
        if (reply != null && reply.getData() != null) {
            if (reply.getData().getShow() != null && reply.getData().getShow().getLldp() != null && reply.getData().getShow().getLldp().getNeighbors() != null && reply.getData().getShow().getLldp().getNeighbors().getXMLOPTCmdLldpShowNeighborsInterface() != null && reply.getData().getShow().getLldp().getNeighbors().getXMLOPTCmdLldpShowNeighborsInterface().getXMLOPTCmdLldpShowNeighborsReadonly() != null && reply.getData().getShow().getLldp().getNeighbors().getXMLOPTCmdLldpShowNeighborsInterface().getXMLOPTCmdLldpShowNeighborsReadonly().getReadonly() != null && reply.getData().getShow().getLldp().getNeighbors().getXMLOPTCmdLldpShowNeighborsInterface().getXMLOPTCmdLldpShowNeighborsReadonly().getReadonly().getTABLENbor() != null && reply.getData().getShow().getLldp().getNeighbors().getXMLOPTCmdLldpShowNeighborsInterface().getXMLOPTCmdLldpShowNeighborsReadonly().getReadonly().getTABLENbor().getROWNbor() != null) {
                List<ROWNbor> details = reply.getData().getShow().getLldp().getNeighbors().getXMLOPTCmdLldpShowNeighborsInterface().getXMLOPTCmdLldpShowNeighborsReadonly().getReadonly().getTABLENbor().getROWNbor();
                for (ROWNbor d : details) {
                    LanHostBase base = new LanHostBase(d.getChassisId());
                    String ifName = d.getLPortId();
                    if (ifName.startsWith("Eth") && !ifName.startsWith("Ethernet")) {
                        ifName = "Ethernet" + ifName.substring(ifName.indexOf("Eth") + "eth".length());
                    } else if (ifName.startsWith("Veth")) {
                        ifName = ifName.toLowerCase();
                    }
                    base.setEthIfName(ifName);
                    base.setEthSwitchId(this.ethSw.getDBID());
                    result.add(new LanHostImpl(base));
                }
            }
            long parseTime = System.currentTimeMillis();
            logger.debug("showLldpNeighborsXml processing took " + (parseTime - sendTime) + "ms");
        } else if (reply != null && reply.getRpcError() != null) {
            throw new Exception(reply.getRpcError().getErrorMessage());
        }
        return result;
    }

    @Override
    public List<LanHostImpl> showLldpNeighborsDetailXml() throws Exception {
        List<LanHostImpl> result = new ArrayList<LanHostImpl>();
        if (this.transport == null) {
            return result;
        }
        try {
            long startTime = System.currentTimeMillis();
            String resp = this.transport.send(CliCommands.SHOW_LLDP_NEIGHTBORS_DETAIL_XML);
            long sendTime = System.currentTimeMillis();
            logger.debug("showLldpNeighborsDetailXml command took " + (sendTime - startTime) + "ms");
            resp = this.removeTerminator(resp);
            if (resp == null || resp.trim().equals("")) {
                result = super.showLldpNeighborsDetail();
                return result;
            }
            RpcReply reply = (RpcReply)XmlUtil.generateObject(RpcReply.class, resp);
            if (reply != null && reply.getData() != null) {
                if (reply.getData().getShow() != null && reply.getData().getShow().getLldp() != null && reply.getData().getShow().getLldp().getNeighbors() != null && reply.getData().getShow().getLldp().getNeighbors().getXMLOPTCmdLldpShowNeighborsDetailReadonly() != null && reply.getData().getShow().getLldp().getNeighbors().getXMLOPTCmdLldpShowNeighborsDetailReadonly().getReadonly().getTABLENborDetail() != null && reply.getData().getShow().getLldp().getNeighbors().getXMLOPTCmdLldpShowNeighborsDetailReadonly().getReadonly().getTABLENborDetail().getROWNborDetail() != null) {
                    List<ROWNborDetail> details = reply.getData().getShow().getLldp().getNeighbors().getXMLOPTCmdLldpShowNeighborsDetailReadonly().getReadonly().getTABLENborDetail().getROWNborDetail();
                    for (ROWNborDetail d : details) {
                        if (d.getChassisId().indexOf(46) <= 0) continue;
                        LanHostBase base = new LanHostBase(d.getChassisId());
                        base.setDescription(d.getSysDesc());
                        String ifName = d.getLPortId();
                        if (ifName.startsWith("Eth") && !ifName.startsWith("Ethernet")) {
                            ifName = "Ethernet" + ifName.substring(ifName.indexOf("Eth") + "eth".length());
                        } else if (ifName.startsWith("Veth")) {
                            ifName = ifName.toLowerCase();
                        }
                        base.setEthIfName(ifName);
                        String mac = HostManager.formatIPV4MacAddr(d.getChassisId());
                        base.setMac(mac.toUpperCase());
                        base.setName(d.getSysName());
                        base.setEthSwitchId(this.ethSw.getDBID());
                        result.add(new LanHostImpl(base));
                    }
                }
                long parseTime = System.currentTimeMillis();
                logger.debug("showLldpNeighborsDetailXml processing took " + (parseTime - sendTime) + "ms");
            } else if (reply != null && reply.getRpcError() != null) {
                throw new Exception(reply.getRpcError().getErrorMessage());
            }
        }
        catch (Exception e) {
            return super.showLldpNeighborsDetail();
        }
        return result;
    }

    @Override
    public List<LanHostImpl> showMacAddressTableXml() throws Exception {
        return super.showMacAddressTableXml();
    }
}

