/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.ui;

import com.cisco.dcbu.lib.ui.CheckBoxPanel;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import com.cisco.dcbu.lib.ui.table.KTable;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public final class FindDialog
extends JDialog
implements ItemListener,
ActionListener,
KeyListener {
    static final int IGNORECASE = 0;
    static final int EXACTMATCH = 1;
    static final int BYROW = 2;
    static final int FROM = 1;
    static final int PREVIOUS = 1;
    static final String[] _Labels = new String[]{"Find:", "From:", null};
    static final String[] _FromOptions = new String[]{"Selection", "Start"};
    static final String[] _Options = new String[]{"Ignore Case", "Exact Match", "By Row"};
    static final String[] _Buttons = new String[]{"Next", "Previous", "Cancel"};
    JComponent[] _value;
    JButton[] _b;
    JTree _tree;
    KTable _table;
    String _prev_Start_Candidate = "";

    public FindDialog(JDialog parent, JTree tree, KTable table) {
        super(parent);
        this._tree = tree;
        this._table = table;
        this._value = new JComponent[_Labels.length];
        this._value[0] = new JTextField();
        this._value[1] = new RadioButtonPanel(_FromOptions);
        ((RadioButtonPanel)this._value[1]).setSelected(0);
        CheckBoxPanel options = new CheckBoxPanel(_Options);
        options.setSelected(0);
        options.getButton(2).setVisible(false);
        this._value[2] = options;
        this._b = DialogUtil.buildButtons(_Buttons, (ActionListener)this);
        if (this._table == null) {
            this._b[1].setVisible(false);
        }
        DialogUtil.buildDialog((JDialog)this, (Container)parent, (Container)DialogUtil.buildPanel(DialogUtil.buildLabels(_Labels), this._value), (AbstractButton[])this._b);
        DialogUtil.addKeyListener(this.getContentPane(), this);
    }

    public FindDialog(JFrame parent, JTree tree, KTable table) {
        super(parent);
        this._tree = tree;
        this._table = table;
        this._value = new JComponent[_Labels.length];
        this._value[0] = new JTextField();
        this._value[1] = new RadioButtonPanel(_FromOptions);
        ((RadioButtonPanel)this._value[1]).setSelected(0);
        CheckBoxPanel options = new CheckBoxPanel(_Options);
        options.setSelected(0);
        options.getButton(2).setVisible(false);
        this._value[2] = options;
        this._b = DialogUtil.buildButtons(_Buttons, (ActionListener)this);
        if (this._table == null) {
            this._b[1].setVisible(false);
        }
        DialogUtil.buildDialog((JDialog)this, (Container)parent, (Container)DialogUtil.buildPanel(DialogUtil.buildLabels(_Labels), this._value), (AbstractButton[])this._b);
        DialogUtil.addKeyListener(this.getContentPane(), this);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.isVisible()) {
            char ch = ((JToggleButton)e.getSource()).getText().charAt(1);
            ((CheckBoxPanel)this._value[3]).getButton(2).setEnabled(ch == 'a');
            this._b[1].setEnabled(ch == 'a');
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        char ch = ((JButton)e.getSource()).getText().charAt(0);
        if (ch == 'N') {
            this.find(true);
        } else if (ch == 'P') {
            this.find(false);
        } else if (ch == 'C') {
            super.setVisible(false);
        }
    }

    void find(boolean next) {
        boolean inTable;
        boolean fromStart;
        String candidate = ((JTextField)this._value[0]).getText();
        CheckBoxPanel options = (CheckBoxPanel)this._value[2];
        boolean ignoreCase = options.getButton(0).isSelected();
        boolean exactMatch = options.getButton(1).isSelected();
        boolean byRow = options.getButton(2).isSelected();
        boolean bl = fromStart = ((RadioButtonPanel)this._value[1]).getSelected() == 1;
        if (!fromStart) {
            this._prev_Start_Candidate = "";
        }
        boolean bl2 = inTable = this._table != null;
        if (ignoreCase) {
            candidate = candidate.toLowerCase();
        }
        if (inTable) {
            if (fromStart && !this._prev_Start_Candidate.equals(candidate)) {
                this._table.clearSelection();
            }
            this._table.find(next, candidate, ignoreCase, exactMatch, byRow);
        } else {
            TreePath selPath;
            boolean found = false;
            DefaultMutableTreeNode selNode = null;
            if (!fromStart && (selPath = this._tree.getSelectionPath()) != null) {
                selNode = (DefaultMutableTreeNode)selPath.getLastPathComponent();
            }
            Enumeration<TreeNode> e = ((DefaultMutableTreeNode)this._tree.getModel().getRoot()).breadthFirstEnumeration();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
                if (selNode != null) {
                    if (node != selNode) continue;
                    selNode = null;
                    continue;
                }
                String match = node.toString();
                if (ignoreCase) {
                    match = match.toLowerCase();
                }
                if ((!exactMatch || !match.equals(candidate)) && (exactMatch || match.indexOf(candidate, 0) < 0)) continue;
                TreePath path = new TreePath(node.getPath());
                this._tree.setSelectionPath(path);
                this._tree.scrollPathToVisible(path);
                found = true;
                ((RadioButtonPanel)this._value[1]).setSelected(0);
                break;
            }
            if (!found) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
        if (fromStart) {
            this._prev_Start_Candidate = candidate;
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.setVisible(false);
        }
    }
}

