/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.ui;

import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;

public class KTextField
extends JTextField {
    public KTextField() {
    }

    public KTextField(String text) {
        super(text);
    }

    public KTextField(int columns) {
        super(columns);
    }

    public KTextField(String text, int columns) {
        super(text, columns);
    }

    public KTextField(Document doc, String text, int columns) {
        super(doc, text, columns);
    }

    public void setMaxLength(int maxLen) {
        ((AbstractDocument)this.getDocument()).setDocumentFilter(new MaxLenDocumentFilter(maxLen));
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (!enabled) {
            this.setBackground(UIManager.getColor("Table.background"));
        } else {
            this.setBackground(UIManager.getColor("TextField.background"));
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    class MaxLenDocumentFilter
    extends DocumentFilter {
        int _maxLength = 100;

        public MaxLenDocumentFilter(int length) {
            this._maxLength = length;
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            if (fb.getDocument().getLength() + text.length() - length <= this._maxLength) {
                super.replace(fb, offset, length, text, attrs);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
            if (fb.getDocument().getLength() + string.length() <= this._maxLength) {
                super.insertString(fb, offset, string, attr);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }
}

