/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.ui.fcoe;

import com.cisco.dcbu.lib.ui.CheckBoxListPanel;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.fcoe.VsanVlanCellEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

class VsanVlanPicker
extends JDialog
implements ActionListener {
    static final String[] _BtnLabel = new String[]{"OK", "Close"};
    CheckBoxListPanel _listPanel;
    JScrollPane _sp;
    Object[] _data;
    VsanVlanCellEditor _editor;

    public VsanVlanPicker(JFrame parent, Object[] data, VsanVlanCellEditor editor, boolean isVfcTrunkingSupported) {
        super((Frame)parent, true);
        this._data = data;
        this._editor = editor;
        JPanel main = new JPanel(new BorderLayout());
        main.setBorder(DialogUtil._Margin);
        this._sp = new JScrollPane();
        this._listPanel = new CheckBoxListPanel(data, !isVfcTrunkingSupported);
        this._sp = new JScrollPane(this._listPanel);
        this._listPanel.setUnitIncrement(this._sp);
        if (data.length > 10) {
            this._sp.setPreferredSize(new Dimension(this._sp.getPreferredSize().width, 200));
        }
        main.add("Center", this._sp);
        JPanel buttons = new JPanel(new FlowLayout(2, 6, 3));
        for (int i = 0; i < _BtnLabel.length; ++i) {
            JButton b = new JButton(_BtnLabel[i]);
            b.addActionListener(this);
            buttons.add(b);
        }
        main.add("South", buttons);
        this.getContentPane().add(main);
        this.setPreferredSize(new Dimension(200, 200));
        this.pack();
    }

    public void setCellSelected(Object[] selectedVsans) {
        if (this._listPanel != null) {
            this._listPanel.clearSelection();
            block0: for (Object next : selectedVsans) {
                for (int index = 0; index < this._data.length; ++index) {
                    Object nextData = this._data[index];
                    if (!next.equals(nextData)) continue;
                    this._listPanel.setSelected(index);
                    continue block0;
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        char ch = ((JButton)e.getSource()).getText().charAt(0);
        if (ch == 'O') {
            if (this._listPanel != null) {
                Object[] selected = this._listPanel.getSelectedValues();
                if (selected == null || selected.length <= 0) {
                    Util.errorMessage((Component)super.getParent(), "Please select at least one VLAN(VSAN) mapping.");
                    return;
                }
                this._editor.setUserSelectedData(selected);
                super.setVisible(false);
            }
        } else if (ch == 'C') {
            super.setVisible(false);
        }
    }

    public void showDialog(JComponent c) {
        this.setLocation(DialogUtil.getPointOnScreen(new Point(c.getWidth(), 0), c, this.getSize()));
        this.setVisible(true);
        this.toFront();
    }
}

