/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.ui.table;

import com.cisco.dcbu.lib.util.Array;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public final class ColumnGroup {
    protected TableCellRenderer _renderer;
    protected Array _list;
    protected String _text;

    public ColumnGroup(String text) {
        this(null, text);
    }

    public ColumnGroup(TableCellRenderer renderer, String text) {
        this._renderer = renderer == null ? new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JTableHeader header = table.getTableHeader();
                if (header != null) {
                    this.setForeground(header.getForeground());
                    this.setBackground(header.getBackground());
                    this.setFont(header.getFont());
                }
                this.setHorizontalAlignment(0);
                this.setText(value == null ? "" : value.toString());
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                return this;
            }
        } : renderer;
        this._text = text;
        this._list = new Array();
    }

    public void add(Object obj) {
        if (obj != null) {
            this._list.addElement(obj);
        }
    }

    public Object get(int index) {
        if (index < 0 || index >= this._list.size()) {
            return null;
        }
        return this._list.elementAt(index);
    }

    public int size() {
        return this._list.size();
    }

    public Array getColumnGroups(TableColumn c, Array g) {
        g.addElement(this);
        if (this._list.find(c) != -1) {
            return g;
        }
        for (int i = 0; i < this._list.size(); ++i) {
            Array groups;
            Object o = this._list.elementAt(i);
            if (!(o instanceof ColumnGroup) || (groups = ((ColumnGroup)o).getColumnGroups(c, (Array)g.clone())) == null) continue;
            return groups;
        }
        return null;
    }

    public final TableCellRenderer getHeaderRenderer() {
        return this._renderer;
    }

    public void setHeaderRenderer(TableCellRenderer renderer) {
        if (renderer != null) {
            this._renderer = renderer;
        }
    }

    public final Object getHeaderValue() {
        return this._text;
    }

    public Dimension getSize(JTable table) {
        Component comp = this._renderer.getTableCellRendererComponent(table, this.getHeaderValue(), false, false, -1, -1);
        int height = comp.getPreferredSize().height;
        int width = 0;
        for (int i = 0; i < this._list.size(); ++i) {
            Object o = this._list.elementAt(i);
            if (o instanceof TableColumn) {
                width += ((TableColumn)o).getWidth();
                continue;
            }
            width += ((ColumnGroup)o).getSize((JTable)table).width;
        }
        return new Dimension(width, height);
    }
}

