/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.ui.table;

import com.cisco.dcbu.lib.ui.table.ColumnGroup;
import com.cisco.dcbu.lib.ui.table.GroupableTableHeaderUI;
import com.cisco.dcbu.lib.ui.table.KTableColumnModel;
import com.cisco.dcbu.lib.util.Array;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public final class GroupableTableHeader
extends JTableHeader {
    protected Array _columnGroups;

    public GroupableTableHeader(TableColumnModel model) {
        super(model);
        this.setUI(new GroupableTableHeaderUI());
    }

    @Override
    public void setColumnModel(TableColumnModel model) {
        if (model instanceof KTableColumnModel) {
            ((KTableColumnModel)model).setGroupableTableHeader(this);
        }
        super.setColumnModel(model);
    }

    @Override
    public TableColumn getDraggedColumn() {
        if (this.draggedColumn != null && this.getColumnGroups(this.draggedColumn) == null) {
            return this.draggedColumn;
        }
        return null;
    }

    public void clearColumnGroups() {
        if (this._columnGroups != null) {
            this._columnGroups.clear();
        }
    }

    public void addColumnGroup(ColumnGroup g) {
        if (this._columnGroups == null) {
            this._columnGroups = new Array();
        }
        this._columnGroups.addElement(g);
    }

    public Array getColumnGroups(TableColumn col) {
        if (this._columnGroups == null) {
            return null;
        }
        for (int i = 0; i < this._columnGroups.size(); ++i) {
            ColumnGroup cGroup = (ColumnGroup)this._columnGroups.elementAt(i);
            Array v_ret = cGroup.getColumnGroups(col, new Array());
            if (v_ret == null) continue;
            return v_ret;
        }
        return null;
    }
}

