/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public final class ClientCache {
    static String _InstallDir;
    static String _DcmRoot;
    static String _Cache;
    static String _CachePath;
    static String _CommonPath;
    static String _LogsDir;
    static String _TrapsDir;
    static String _DMInstallDir;

    private static void readDcmRoot() {
        String conf;
        File confFile;
        if (_DcmRoot == null && (confFile = new File(conf = _InstallDir + File.separator + "install.conf")).exists()) {
            Properties props = ClientCache.loadProps(confFile);
            _DcmRoot = props.getProperty("mds.dcmRoot");
        }
    }

    public static void resetDMInstallDir() {
        String mdsRoot = System.getProperty("mds.nmsRoot");
        if (mdsRoot != null) {
            _DMInstallDir = mdsRoot;
        }
        if (_DMInstallDir == null) {
            String conf = _CommonPath + "install.conf";
            File confFile = new File(conf);
            if (!confFile.exists()) {
                conf = _CachePath + "install.conf";
                confFile = new File(conf);
            }
            if (confFile.exists()) {
                Properties props = ClientCache.loadProps(confFile);
                _DMInstallDir = props.getProperty("mds.nmsRoot");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProps(File confFile) {
        Properties props = new Properties();
        FileInputStream is = null;
        try {
            is = new FileInputStream(confFile);
            props.load(is);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return props;
    }

    public static String getDMInstallLocation() {
        return (_DMInstallDir != null ? _DMInstallDir : _Cache) + File.separator;
    }

    public static String getDir() {
        return _Cache;
    }

    public static String getLocation() {
        return _CachePath;
    }

    public static String getInstallDir() {
        return _InstallDir != null ? _InstallDir : _Cache;
    }

    public static String getDcmDir() {
        if (_DcmRoot == null) {
            ClientCache.readDcmRoot();
        }
        return _DcmRoot + File.separator;
    }

    public static String getInstallLocation() {
        return ClientCache.getInstallDir() + File.separator;
    }

    public static String getCommonDir() {
        return _CommonPath;
    }

    public static String getConfDir() {
        return ClientCache.getInstallLocation() + File.separator + "conf" + File.separator;
    }

    public static void setInstallDir(String installDir) throws IOException {
        _InstallDir = installDir;
    }

    public static String getLogsDir() {
        return ClientCache.getInstallLocation() + "logs";
    }

    public static String getReportsDir() {
        return ClientCache.getInstallLocation() + "reports";
    }

    public static String getTrapsDir() {
        return ClientCache.getInstallLocation() + "traps";
    }

    public static String getJBossHome() {
        return ClientCache.getDcmDir() + "jboss-as-7.2.0.Final";
    }

    public static String getSMISHome() {
        return ClientCache.getDcmDir() + "smis";
    }

    static {
        String fs = File.separator;
        String mdsRoot = System.getProperty("mds.nmsRoot");
        if (mdsRoot != null) {
            _InstallDir = mdsRoot;
        }
        _Cache = System.getProperty("user.home");
        File dir = new File(_Cache = _Cache + (_Cache.equals(fs) ? ".cisco_mds9000" : fs + ".cisco_mds9000"));
        if (!dir.exists()) {
            dir.mkdir();
        }
        _CachePath = _Cache + fs;
        boolean isWin = System.getProperty("os.name").startsWith("Windows");
        _CommonPath = isWin ? System.getenv("CommonProgramFiles") + fs + ".cisco_mds9000" + fs : fs + "var" + fs + ".cisco_mds9000" + fs;
        if (_InstallDir == null) {
            String conf = _CommonPath + "install.conf";
            File confFile = new File(conf);
            if (!confFile.exists()) {
                conf = _CachePath + "install.conf";
                confFile = new File(conf);
            }
            if (confFile.exists()) {
                Properties props = ClientCache.loadProps(confFile);
                _InstallDir = props.getProperty("mds.nmsRoot");
            }
        }
        ClientCache.readDcmRoot();
    }
}

